/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import de.vdheide.mp3.MP3File;
import de.vdheide.mp3.TagContent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.MP3;
import photoorganizer.renderer.Connector;
import rogatkin.GranulatedLayout;

public final class Id3TagEditor
extends JPanel
implements ActionListener {
    static final String[] TAG_FIELDS = new String[]{"Artist", "Album", "Title", "Comments", "Composer", "Conductor", "Lyricist", "FileOwner", "ArtistWebpage", "AudioFileWebpage", "AudioSourceWebpage", "Band", "Remixer", "Subtitle", "Track", "Year"};
    protected Controller controller;
    protected AbstractFormat format;
    protected JTextField[] tf_tagFields;
    protected JComboBox cb_genre;
    protected JCheckBox cb_id3v2;

    public Id3TagEditor(Controller controller, AbstractFormat abstractFormat) {
        this.controller = controller;
        this.format = abstractFormat;
        AbstractInfo abstractInfo = abstractFormat.getInfo();
        this.setLayout((LayoutManager)new GranulatedLayout(3, TAG_FIELDS.length + 4, 20, 4, 8, 8));
        this.tf_tagFields = new JTextField[TAG_FIELDS.length];
        int n = 0;
        while (n < TAG_FIELDS.length) {
            this.add((Component)new JLabel(TAG_FIELDS[n]), "0," + n);
            this.tf_tagFields[n] = new JTextField();
            this.add((Component)this.tf_tagFields[n], "1," + n + ",2");
            try {
                this.tf_tagFields[n].setText(abstractInfo.getAttribute(TAG_FIELDS[n]).toString());
            }
            catch (Exception exception) {
                System.err.println(TAG_FIELDS[n] + " has not been set, " + exception);
            }
            ++n;
        }
        this.add((Component)new JLabel("Genre"), "0," + TAG_FIELDS.length);
        this.cb_genre = new JComboBox<String>(MP3.GENRES);
        this.add(this.cb_genre, "1," + TAG_FIELDS.length + ",2");
        try {
            this.cb_genre.setSelectedItem(MP3.GENRES[abstractInfo.getIntAttribute("Genre")]);
        }
        catch (Exception exception) {
            try {
                this.cb_genre.setSelectedItem(abstractInfo.getAttribute("Genre").toString());
            }
            catch (Exception exception2) {
                System.err.println("Genre has not been set, " + exception2 + '/' + exception);
            }
        }
        this.cb_id3v2 = new JCheckBox("Id3 version 2 tag");
        this.add((Component)this.cb_id3v2, "0," + (TAG_FIELDS.length + 1) + ",2");
        this.cb_id3v2.setBorderPaintedFlat(true);
        this.add((Component)Controller.createButtonPanel(this, 1 + 4 + 8, 2), "0," + (TAG_FIELDS.length + 2) + ",3,2");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            AbstractInfo abstractInfo = this.format.getInfo();
            int n = 0;
            while (n < TAG_FIELDS.length) {
                try {
                    if ("Comments".equals(TAG_FIELDS[n])) {
                        TagContent tagContent = new TagContent();
                        tagContent.setContent(this.tf_tagFields[n].getText());
                        tagContent.setType("Eng");
                        tagContent.setDescription(TAG_FIELDS[n]);
                        abstractInfo.setAttribute(TAG_FIELDS[n], tagContent);
                    } else {
                        abstractInfo.setAttribute(TAG_FIELDS[n], this.tf_tagFields[n].getText());
                    }
                }
                catch (Exception exception) {
                    System.err.println("Attribute " + TAG_FIELDS[n] + " could not be set because " + exception);
                }
                ++n;
            }
            boolean bl = this.cb_id3v2.isSelected();
            ((MP3File)abstractInfo).setWriteID3v2(bl);
            if (bl) {
                abstractInfo.setAttribute("Genre", this.cb_genre.getSelectedItem());
            } else {
                abstractInfo.setAttribute("Genre", "(" + this.cb_genre.getSelectedIndex() + ')');
            }
            try {
                ((MP3File)abstractInfo).update();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public static synchronized void editTag(Controller controller, AbstractFormat abstractFormat) {
        Id3TagEditor id3TagEditor = new Id3TagEditor(controller, abstractFormat);
        JDialog jDialog = new JDialog(controller.getMainFrame(), "Id3 tag editor", true);
        jDialog.setContentPane(id3TagEditor);
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new Connector(id3TagEditor, jDialog));
        jDialog.pack();
        jDialog.setVisible(true);
    }
}

