/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.renderer.PlaybackProperties;
import photoorganizer.renderer.RadioButtonsGroup;
import rogatkin.GranulatedLayout;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class MediaOptionsTab
extends JPanel
implements Persistable,
ChangeListener {
    public static final String SECNAME = "MediaOptions";
    public static final String REUSEPLAYER = "ReusePlayer";
    public static final String SONGS_PAUSE = "PauseDuration";
    public static final String PLAYLIST_LIMIT = "ListLimitValue";
    public static final String PLAYLIST_TYPE = "ListLimitType";
    public static final String RECURSIVE_PLAYBACK = "RecursivePlayback";
    public static final String REQUEST_COPYFILTER = "RequestCopyFilter";
    public static final String REQUEST_PLAYMODE = "RequestPlayMode";
    public static final String PLAYMODE_SCHEMA = "PlayModeSchema";
    public static final String INTRO_FRAMES = "IntorductoryFramesNumber";
    public static final String RIPPER_FOLDER = "RipperFolder";
    protected static final int MP3_MEDIA = 0;
    protected static final int AUDIO_MEDIA = 1;
    protected static final int SIZE_LOW = 0;
    protected static final int SIZE_HIGH = 1;
    protected static final int SIZE_CUSTOM = 2;
    protected Controller controller;
    protected JCheckBox cb_reuse_player;
    protected JCheckBox cb_recursive;
    protected JCheckBox cb_request_playmode;
    protected JCheckBox cb_filterOnCopy;
    protected JTextField tf_customSize;
    protected JTextField tf_numberFrames;
    protected JTextField tf_ripperLocation;
    protected RadioButtonsGroup destMediaTypeSel;
    protected RadioButtonsGroup mediaSize;
    protected JComboBox cb_playbackSchema;
    protected JSpinner sp_pauseDuration;

    public MediaOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout((LayoutManager)new GranulatedLayout(7, 7, 20, 4, 8, 8));
        this.cb_reuse_player = new JCheckBox("Open player in new window");
        this.add((Component)this.cb_reuse_player, "0,0,2");
        this.cb_filterOnCopy = new JCheckBox("Use query for copy");
        this.add((Component)this.cb_filterOnCopy, "2,0,2");
        this.add((Component)new JLabel("Play list pause duration (s)"), "0,1,2");
        this.sp_pauseDuration = new JSpinner(new SpinnerNumberModel(5, 0, 30, 1));
        this.add((Component)this.sp_pauseDuration, "2,1");
        this.add((Component)new JLabel("Introductory frames number"), "3,1,2");
        this.tf_numberFrames = new JTextField();
        this.add((Component)this.tf_numberFrames, "5,1");
        ((JSpinner.NumberEditor)this.sp_pauseDuration.getEditor()).getTextField().setHorizontalAlignment(4);
        this.destMediaTypeSel = new RadioButtonsGroup(this);
        JRadioButton jRadioButton = new JRadioButton("MP3 disc");
        this.add((Component)jRadioButton, "0,2");
        this.destMediaTypeSel.add(jRadioButton, 0);
        jRadioButton = new JRadioButton("Audio CD");
        this.add((Component)jRadioButton, "0,3");
        this.destMediaTypeSel.add(jRadioButton, 1);
        this.mediaSize = new RadioButtonsGroup();
        jRadioButton = new JRadioButton();
        this.add((Component)jRadioButton, "1,2");
        this.mediaSize.add(jRadioButton, 0);
        jRadioButton = new JRadioButton();
        this.add((Component)jRadioButton, "1,3");
        this.mediaSize.add(jRadioButton, 1);
        jRadioButton = new JRadioButton("Custom (MB)");
        this.add((Component)jRadioButton, "1,4,2");
        this.mediaSize.add(jRadioButton, 2);
        this.tf_customSize = new JTextField();
        this.add((Component)this.tf_customSize, "3,4");
        this.tf_customSize.setHorizontalAlignment(4);
        this.cb_recursive = new JCheckBox("Play recursively");
        this.add((Component)this.cb_recursive, "0,5,2");
        this.cb_request_playmode = new JCheckBox("Ask for play mode");
        this.add((Component)this.cb_request_playmode, "2,5,2");
        this.cb_playbackSchema = new JComboBox();
        this.add(this.cb_playbackSchema, "4,0,2");
        this.cb_playbackSchema.setEditable(true);
        JButton jButton = new JButton("Edit");
        this.add((Component)jButton, "6,0");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlaybackProperties.doPropertiesDialog(MediaOptionsTab.this.controller, (JFrame)MediaOptionsTab.this.getTopLevelAncestor());
            }
        });
        this.tf_numberFrames.setHorizontalAlignment(4);
        this.add((Component)new JLabel("Ripper folder"), "0,6");
        this.tf_ripperLocation = new JTextField();
        this.add((Component)this.tf_ripperLocation, "1,6,5");
        jButton = new JButton("Browse");
        this.add((Component)jButton, "6,6");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDirectoryChooser jDirectoryChooser = new JDirectoryChooser(new JFrame(), MediaOptionsTab.this.tf_ripperLocation.getText(), null);
                if (jDirectoryChooser.getDirectory() != null) {
                    MediaOptionsTab.this.tf_ripperLocation.setText(jDirectoryChooser.getDirectory());
                }
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.destMediaTypeSel.getSelectedIndex() == 0) {
            this.mediaSize.get(0).setText("650MB");
            this.mediaSize.get(1).setText("700MB");
        } else {
            this.mediaSize.get(0).setText("74Min");
            this.mediaSize.get(1).setText("80Min");
        }
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        this.cb_reuse_player.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)REUSEPLAYER), (int)0) == 0);
        Integer n = (Integer)serializer.getProperty((Object)SECNAME, (Object)PLAYLIST_TYPE);
        this.destMediaTypeSel.setSelectedIndex(n != null ? n : 1);
        this.stateChanged(null);
        n = (Integer)serializer.getProperty((Object)SECNAME, (Object)PLAYLIST_LIMIT);
        if (n != null && n <= 1 && n >= 0) {
            this.mediaSize.setSelectedIndex(n);
        } else {
            this.mediaSize.setSelectedIndex(2);
            this.tf_customSize.setText(n == null ? "0" : n.toString());
        }
        n = (Integer)serializer.getProperty((Object)SECNAME, (Object)SONGS_PAUSE);
        this.sp_pauseDuration.setValue(n == null ? Resources.I_NO : n);
        n = (Integer)serializer.getProperty((Object)SECNAME, (Object)INTRO_FRAMES);
        this.tf_numberFrames.setText(n == null ? "0" : n.toString());
        this.cb_recursive.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)RECURSIVE_PLAYBACK), (int)0) == 1);
        this.cb_request_playmode.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)REQUEST_PLAYMODE), (int)0) == 1);
        this.cb_filterOnCopy.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)REQUEST_COPYFILTER), (int)0) == 1);
        String string = (String)serializer.getProperty((Object)SECNAME, (Object)RIPPER_FOLDER);
        if (string != null) {
            this.tf_ripperLocation.setText(string);
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        serializer.setProperty((Object)SECNAME, (Object)REUSEPLAYER, (Object)(this.cb_reuse_player.isSelected() ? Resources.I_NO : Resources.I_YES));
        serializer.setProperty((Object)SECNAME, (Object)PLAYLIST_TYPE, (Object)new Integer(this.destMediaTypeSel.getSelectedIndex()));
        if (this.destMediaTypeSel.getSelectedIndex() == 2) {
            try {
                serializer.setProperty((Object)SECNAME, (Object)PLAYLIST_LIMIT, (Object)new Integer(this.tf_customSize.getText()));
            }
            catch (Exception exception) {
                serializer.setProperty((Object)SECNAME, (Object)PLAYLIST_LIMIT, (Object)new Integer(100));
            }
        } else {
            serializer.setProperty((Object)SECNAME, (Object)PLAYLIST_LIMIT, (Object)new Integer(this.mediaSize.getSelectedIndex()));
        }
        try {
            serializer.setProperty((Object)SECNAME, (Object)SONGS_PAUSE, this.sp_pauseDuration.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            serializer.setProperty((Object)SECNAME, (Object)INTRO_FRAMES, (Object)new Integer(this.tf_numberFrames.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializer.setProperty((Object)SECNAME, (Object)RECURSIVE_PLAYBACK, (Object)(this.cb_recursive.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)REQUEST_PLAYMODE, (Object)(this.cb_request_playmode.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)REQUEST_COPYFILTER, (Object)(this.cb_filterOnCopy.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)RIPPER_FOLDER, (Object)this.tf_ripperLocation.getText());
    }
}

