/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import photoorganizer.Resources;

public final class PopupCombo
extends JComboBox
implements ActionListener {
    JButton button;
    JComponent populTarget;

    public PopupCombo(Object[] objectArray, String string, JPanel jPanel, String string2, JComponent jComponent) {
        super(objectArray);
        this.populTarget = jComponent;
        this.setUI(new MyComboboxUi());
        this.setLightWeightPopupEnabled(false);
        this.button = new JButton(string);
        this.button.addActionListener(this);
        jPanel.add((Component)this.button, string2);
        this.setSelectedIndex(-1);
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("comboBoxChanged".equals(actionEvent.getActionCommand())) {
            return;
        }
        ((JComponent)actionEvent.getSource()).setVisible(false);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PopupCombo.this.grabFocus();
                PopupCombo.this.showPopup();
            }
        });
    }

    class MyPopup
    extends BasicComboPopup {
        private boolean notfirsttime;

        public MyPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void show() {
            try {
                super.show();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }

        public void hide() {
            super.hide();
            if (!this.notfirsttime) {
                return;
            }
            this.notfirsttime = !this.notfirsttime;
            int n = PopupCombo.this.getSelectedIndex();
            if (n >= 0) {
                JTextField jTextField = null;
                if (PopupCombo.this.populTarget instanceof JTextField) {
                    jTextField = (JTextField)PopupCombo.this.populTarget;
                } else if (PopupCombo.this.populTarget instanceof JComboBox && ((JComboBox)PopupCombo.this.populTarget).getEditor().getEditorComponent() instanceof JTextField) {
                    jTextField = (JTextField)((JComboBox)PopupCombo.this.populTarget).getEditor().getEditorComponent();
                }
                if (jTextField != null) {
                    jTextField.replaceSelection(Resources.MASKS[0][n]);
                }
            }
            PopupCombo.this.setSelectedIndex(-1);
        }

        public void removeNotify() {
            super.removeNotify();
            this.notfirsttime = true;
            PopupCombo.this.setVisible(false);
            PopupCombo.this.button.setVisible(true);
        }
    }

    class MyComboboxUi
    extends MetalComboBoxUI {
        MyComboboxUi() {
        }

        protected ComboPopup createPopup() {
            MyPopup myPopup = new MyPopup(this.comboBox);
            myPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return myPopup;
        }
    }
}

