/* PhotoOrganizer - WebPublishOptionsTab 
 * Copyright (C) 1999-2001 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 *  $Id: WebPublishOptionsTab.java,v 1.8 2001/08/16 07:34:16 rogatkin Exp $
 *  Visit http://drogatkin.openestate.net to get the latest infromation
 *  about Rogatkin's products.
 */
package photoorganizer.renderer;

import java.awt.event.*;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.*;

import javax.swing.*;
import javax.swing.filechooser.FileSystemView;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.ftp.*;
import photoorganizer.directory.JDirectoryChooser;

public class WebPublishOptionsTab extends JPanel implements ActionListener, Persistable, Helpable {
    public final static String SECNAME     = "WebPublishOptions";
    public final static String HOSTNAME    = "HostName";
    public final static String FTPLOGIN    = "FtpLogin";
    public final static String FTPPASSWORD = "FtpPassword";
    public final static String TIMEOUT     = "FtpTimeout";
    public final static String PROXYHOST   = "ProxyHost";
    public final static String PROXYPORT   = "ProxyPort";
    public final static String USEPROXY    = "UseProxy";
    public final static String ASKPSWD     = "SavePassword";
    public final static String PASSIVEMODE = "PassiveMode";
    public final static String PUBMODE     = "PublishingMode";
    public final static String HTMLTEMPL   = "HTMLTemplate";
    public final static String WEBROOT     = "WebRoot";
    public final static String IMAGEPATH   = "ImagePath";
    public final static String TNWEBPATH   = "ThumbnailPath";
    public final static String IMAGEURL    = "ImageURL";
    public final static String USEURLPATH  = "UseURL";
    public final static String CPYPICS     = "CopyPictures";
    public final static String CPYPICSONLY = "CopyWebContent";

    public final static String SMTPSERVER   = "SMTPServer";
    public final static String SMTPUSER     = "SMTPUser";
    public final static String ORGANIZATION = "Organization";
    public final static String REPLYADDR    = "Reply";
    public final static String EMAILADDR    = "E-MailAddress";
    public final static String SMTPPORT     = "SMTPPort";
    public final static String USESSL       = "UseSSL";
    public final static String SRVTIMEOUT   = "SMTPTimeout";
    
    public final static String UPL_SERVLET_URL   = "UploadServletURL";
    public final static String UPL_DEST_NAME     = "UploadDestName";
    public final static String UPL_DATA_NAME     = "UploadDataName";
    public final static String HTTPLOGIN         = "HttpLogin";
    public final static String HTTPPASSWORD      = "HttpPassword";
    public final static String HTTPLOGIN_NAME    = "HttpLoginName";
    public final static String HTTPPASSWORD_NAME = "HttpPasswordName";
    public final static String HTTP_AUTH_SHC     = "HttpAuthentication";
    public final static String HTTP_MANUAL_MODE  = "HttpManualMode";
    public final static String HTTPKEEPPSWD      = "HttpKeepPswd";
    public final static String HTTPLOGINURL      = "HttpLoginURL";
    public final static String HTTPLOGINMETHOD   = "HttpLoginMethod";
    public final static String HTTPSTATICQUERY   = "HttpStaticQuery";
	public final static String HTTPALBUMNAME     = "HttpAlbumName";
	public final static String HTTPALBUMID       = "HttpAlbumId";

    public final static int LOCAL = 0;
    public final static int FTP = 1;
    public final static int HTTP = 2;
    public final static int EMAIL = 3;
    public final static int XML_SVG = 4;

    final static int DEFTIMEOUT = 20;

	public WebPublishOptionsTab(Controller controller) {
		this.controller = controller;
		setLayout(new GranulatedLayout(8, Resources.CTRL_VERT_PREF_SIZE, Resources.CTRL_VERT_SIZE, Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET, Resources.CTRL_HORIZ_GAP));
		add(new JLabel(Resources.LABEL_HTML_TEMPLATE), "0,0,2");
		add(tf_htmltmpl = new JTextField(), "2,0,4");
		add(bt_brws_htmltmpl = new JButton(Resources.CMD_BROWSE), "6,0,2");
		bt_brws_htmltmpl.addActionListener(this);
		add(new JLabel(Resources.LABEL_WEB_ROOT), "0,1,2");
		add(tf_webroot = new JTextField(), "2,1,4");
		add(bt_brws_wroot = new JButton(Resources.CMD_BROWSE), "6,1,2");
		bt_brws_wroot.addActionListener(this);
		add(new JLabel(Resources.LABEL_USE), "0,2");
		publishModeSel = new RadioButtonsGroup();
		JRadioButton rb;
		add(rb = new JRadioButton(Resources.LABEL_USE_LOCAL), "5,2");
		publishModeSel.add(rb, LOCAL);
		add(rb = new JRadioButton(Resources.LABEL_USE_FTP), "1,2");
		publishModeSel.add(rb, FTP);
		add(rb = new JRadioButton(Resources.LABEL_USE_HTTP), "2,2");
		publishModeSel.add(rb, HTTP);
		add(rb = new JRadioButton(Resources.LABEL_USE_SMTP), "3,2");
		publishModeSel.add(rb, EMAIL);
		add(rb = new JRadioButton(Resources.LABEL_USE_XML), "4,2");
		publishModeSel.add(rb, XML_SVG);
		JButton btn;
		add(btn = new JButton(Resources.CMD_SETUP), "6,2,2");
		btn.addActionListener(this); // set action listener the dialog itself
		add(new JLabel(Resources.LABEL_TN_LOC), "0,3,2");
		add(tf_tnwebpath = new JTextField(), "2,3,4");
		add(new JLabel(Resources.LABEL_PIC_LOC), "0,4,2");
		add(tf_webpath = new JTextField(), "2,4,4");
		add(cb_notCpyImgs = new JCheckBox(Resources.LABEL_CPY_PIC), "1,5,2");
		add(cb_notCpyThmbHtml = new JCheckBox(Resources.LABEL_NOTCOPY_THUMBS), "3,5,3");
		add(cb_webpic = new JCheckBox(Resources.LABEL_USE_WEB_PIC), "6,5,2");

		add(new JLabel(Resources.LABEL_PIC_URL), "0,6,2");
		add(tf_pic_url = new JTextField(), "2,6,4");
		cb_webpic.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
			tf_pic_url.setEnabled(((AbstractButton)e.getSource()).isSelected());
			}
			});
		cb_notCpyImgs.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
			boolean selected = ((AbstractButton)e.getSource()).isSelected();
			tf_webpath.setEnabled(!selected);
			if (selected && cb_notCpyThmbHtml.isSelected())
			cb_notCpyThmbHtml.setSelected(false);
			}
			});
		cb_notCpyThmbHtml.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				if (cb_notCpyImgs.isSelected() && cb_notCpyThmbHtml.isSelected())
					cb_notCpyImgs.setSelected(false);
			}
			});
	}

	public String getHelp() {
		return "No help";
	}
	
	public void actionPerformed(ActionEvent a) {
		if (a.getSource() == bt_brws_wroot) {
			FileSystemView fv = null;
			if (publishModeSel.getSelectedIndex() == FTP) {
				controller.setWaitCursor(getTopLevelAncestor()/*specific case*/, true);
				Ftp ftp = new Ftp(getConnectionInfo(controller.getSerializer()), false);
				if (!ftp.isConnected) {
					controller.setWaitCursor(getTopLevelAncestor(), false);
					JOptionPane.showMessageDialog(this, Resources.LABEL_ERR_FTP_CONNECT,
												  Resources.TITLE_ERROR, JOptionPane.ERROR_MESSAGE);
					return ;
				}
				try {
					ftp.login();
					fv = new FtpFileSystemView(ftp);
				} catch (IOException e) {
					controller.setWaitCursor(getTopLevelAncestor(), false);
					JOptionPane.showMessageDialog(this, Resources.LABEL_ERR_FTP_LOGIN+e,
												  Resources.TITLE_ERROR, JOptionPane.ERROR_MESSAGE);
					return ;
				}
			}
			JDirectoryChooser dc = new JDirectoryChooser(new JFrame(), tf_webroot.getText(), fv);
			controller.setWaitCursor(getTopLevelAncestor(), false);
			if (dc.getDirectory() != null)
				tf_webroot.setText(dc.getDirectory());
		} else if (a.getSource() == bt_brws_htmltmpl) {
			String d = tf_htmltmpl.getText();
			if (d.length() == 0)
				d = controller.getSerializer().getHomeDirectory();
			JFileChooser fc = new JFileChooser(d);
			fc.addChoosableFileFilter(controller.getHtmlFilter());
			fc.setFileFilter(controller.getHtmlFilter());
			fc.setDialogTitle(Resources.TITLE_HTML_TEMPL);
			if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
				tf_htmltmpl.setText(fc.getSelectedFile().getAbsolutePath());
		} else if (a.getActionCommand().equals(Resources.CMD_SETUP)) {
			switch(publishModeSel.getSelectedIndex()) {
			case FTP:
				if (ftpdialog == null)
					ftpdialog = new FtpDialog();
				ftpdialog.setVisible(true);
				break;
			case HTTP: // http
				new HttpSettingsDialog().setVisible(true);
				break;
			case EMAIL:
				new MailSettingsDialog().setVisible(true);
				break;
			case XML_SVG: // SVG
				break;
			}
		}
	}

	public static FtpConnectionInfo getConnectionInfo(Serializer s) {
		connectioninfo.startDirectory = (String)s.getProperty(SECNAME, WEBROOT);
		connectioninfo.host = (String)s.getProperty(SECNAME, HOSTNAME);
		connectioninfo.user = (String)s.getProperty(SECNAME, FTPLOGIN);
		String ps = (String)s.getProperty(SECNAME, FTPPASSWORD);
		if (ps != null) {
			try {
				connectioninfo.setPassword(Controller.encryptXor(
				 new String(BaseController.hexToBytes(ps), BaseController.ISO_8859_1)));
			} catch(UnsupportedEncodingException uee) {
			}
		}
		connectioninfo.proxyHost = (String)s.getProperty(SECNAME, PROXYHOST);
		try {
			connectioninfo.proxyPort = ((Integer)s.getProperty(SECNAME, PROXYPORT)).intValue();
		} catch(Throwable e) {
			connectioninfo.proxyPort = 27;
		}
		try {
			connectioninfo.timeout = ((Integer)s.getProperty(SECNAME, TIMEOUT)).intValue();
		} catch(Throwable e) {
			connectioninfo.timeout = DEFTIMEOUT*1000;
		}
		try {
			connectioninfo.useProxy = ((Integer)s.getProperty(SECNAME, USEPROXY)).intValue() == 1;
		} catch(Throwable e) {
			connectioninfo.useProxy = false;
		}
		try {
			connectioninfo.active = ((Integer)s.getProperty(SECNAME, PASSIVEMODE)).intValue() == 0;
		} catch(Throwable e) {
			connectioninfo.active = true;
		}
		try {
			connectioninfo.askPassword = ((Integer)s.getProperty(SECNAME, ASKPSWD)).intValue() == 1;
		} catch(Throwable e) {
			connectioninfo.askPassword = true;
		}
		return connectioninfo;
	}

	public void load() {
		Serializer s = controller.getSerializer();
		Integer i = (Integer)s.getProperty(SECNAME, PUBMODE);
		if (i != null)
			publishModeSel.setSelectedIndex(i.intValue());
		getConnectionInfo(s);
		if (connectioninfo.startDirectory != null)
			tf_webroot.setText(connectioninfo.startDirectory);
		String f = (String)s.getProperty(SECNAME, HTMLTEMPL);
		if (f != null)
			tf_htmltmpl.setText(f);
		f = (String)s.getProperty(SECNAME, IMAGEPATH);
		if (f != null)
			tf_webpath.setText(f);
		f = (String)s.getProperty(SECNAME, TNWEBPATH);
		if (f != null)
			tf_tnwebpath.setText(f);
		f = (String)s.getProperty(SECNAME, IMAGEURL);
		if (f != null)
			tf_pic_url.setText(f);
		cb_webpic.setSelected(s.getInt(s.getProperty(SECNAME, USEURLPATH), 0) == 1);
		boolean picsonly = s.getInt(s.getProperty(SECNAME, CPYPICSONLY), 1) == 0;
		cb_notCpyThmbHtml.setSelected(picsonly);
		cb_notCpyImgs.setSelected(s.getInt(s.getProperty(SECNAME, CPYPICS), 1) == 0 && picsonly);
	}
	
	public void save() {
		Serializer s = controller.getSerializer();
		s.setProperty(SECNAME, WEBROOT, tf_webroot.getText());
		s.setProperty(SECNAME, PUBMODE, new Integer(publishModeSel.getSelectedIndex()));
		s.setProperty(SECNAME, HTMLTEMPL, tf_htmltmpl.getText());
		s.setProperty(SECNAME, IMAGEPATH, tf_webpath.getText());
		s.setProperty(SECNAME, TNWEBPATH, tf_tnwebpath.getText());
		s.setProperty(SECNAME, IMAGEURL, tf_pic_url.getText());
		s.setProperty(SECNAME, USEURLPATH, cb_webpic.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, CPYPICS, cb_notCpyImgs.isSelected()?Resources.I_NO:Resources.I_YES);
		s.setProperty(SECNAME, CPYPICSONLY, cb_notCpyThmbHtml.isSelected()?Resources.I_NO:Resources.I_YES);
		getConnectionInfo(s);
	}
	
	Controller controller;
	JTextField tf_webroot, tf_htmltmpl, tf_webpath, tf_tnwebpath, tf_pic_url;
	JCheckBox cb_webpic, cb_notCpyImgs, cb_notCpyThmbHtml;
	JButton bt_brws_htmltmpl, bt_brws_wroot;
	RadioButtonsGroup publishModeSel;
	static FtpConnectionInfo connectioninfo = new FtpConnectionInfo();
	FtpDialog ftpdialog;

	abstract class PersistantDialog extends JDialog implements Persistable, ActionListener {
		
		PersistantDialog(JFrame owner, String title, boolean modal) {
			super(owner, title, modal);
		}

		protected void processWindowEvent(WindowEvent e) {
			if (e.getID() == WindowEvent.WINDOW_CLOSING)
				save();
			super.processWindowEvent(e);
		}

		public void actionPerformed(ActionEvent a) {
			if (a.getActionCommand().equals(Resources.CMD_RESET)) {
				load();
			}
		}
	}

	class FtpDialog extends PersistantDialog {
		FtpDialog() {
			super((JFrame)WebPublishOptionsTab.this.getTopLevelAncestor(), Resources.TITLE_FTP, true);
			java.awt.Container c = getContentPane();
			c.setLayout(new GranulatedLayout(2, 15, Resources.CTRL_VERT_SIZE,
											 Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET,
											 Resources.CTRL_HORIZ_GAP, 7));
			c.add(new JLabel(Resources.LABEL_FTP_HOST), "0,0,2");
			c.add(tf_hostname = new JTextField(), "0,1,2");

			c.add(new JLabel(Resources.LABEL_LOGIN), "0,2,2");
			c.add(tf_user = new JTextField(), "0,3,2");
			c.add(new JLabel(Resources.LABEL_PASSWORD), "0,4,1");
			c.add(tf_pswd = new JPasswordField(), "0,5,1");
			c.add(cb_keeppswd = new JCheckBox(Resources.LABEL_SAVE_PSWD), "1,5,1");
			c.add(cb_passivemode = new JCheckBox(Resources.LABEL_PASSIVE_MODE), "0,6,1");
			c.add(new JLabel(Resources.LABEL_CONN_TIMEOUT), "0,7,2");
			c.add(sl_conntimeout = new JSlider(0, 120, 20), "0,9,1,0");
			c.add(l_timeout = new JLabel(Resources.LABEL_SEC), "1,9,1");
			c.add(cb_useproxy = new JCheckBox(Resources.LABEL_USE_PROXY), "0,10,1");
			c.add(new JLabel(Resources.LABEL_HOST), "0,11,1");
			c.add(tf_proxyhost = new JTextField(), "0,12,2");
			c.add(new JLabel(Resources.LABEL_PORT), "0,13,1");
			c.add(tf_proxyport = new JTextField(), "0,14,1");
			tf_proxyport.setHorizontalAlignment(JTextField.RIGHT);
			JButton b;
			c.add(b = new JButton(Resources.CMD_RESET), "1,14,1");
			b.addActionListener(this);
			sl_conntimeout.addChangeListener( new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
				if (e.getSource() == sl_conntimeout) 
				l_timeout.setText(""+sl_conntimeout.getValue()+" "+Resources.LABEL_SEC);
				}
				});
			cb_useproxy.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
				boolean enabled = ((AbstractButton)e.getSource()).isSelected();
				tf_proxyhost.setEnabled(enabled);
				tf_proxyport.setEnabled(enabled);
				}
				});
			cb_keeppswd.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
				boolean enabled = ((AbstractButton)e.getSource()).isSelected();
				if(!enabled)
				tf_pswd.setText("");
				tf_pswd.setEnabled(enabled);
				}
				});
			pack();
			load();
		}

		public void save() {
			Serializer s = controller.getSerializer();
			s.setProperty(SECNAME, HOSTNAME, tf_hostname.getText());
			s.setProperty(SECNAME, FTPLOGIN, tf_user.getText());
			s.setProperty(SECNAME, PROXYHOST, tf_proxyhost.getText());
			Integer i;
			try {
				i = new Integer(tf_proxyport.getText());
			} catch(NumberFormatException e) {
				i = Resources.I_NO;
			}
			s.setProperty(SECNAME, PROXYPORT, i);
			// DEFTIMEOUT
			s.setProperty(SECNAME, TIMEOUT, new Integer(sl_conntimeout.getValue()*1000));
			s.setProperty(SECNAME, USEPROXY, cb_useproxy.isSelected()?Resources.I_YES:Resources.I_NO);
			s.setProperty(SECNAME, ASKPSWD, cb_keeppswd.isSelected()?Resources.I_NO:Resources.I_YES);
			s.setProperty(SECNAME, PASSIVEMODE, cb_passivemode.isSelected()?Resources.I_YES:Resources.I_NO);
			if(cb_keeppswd.isSelected()) {
				try {
					s.setProperty(SECNAME, FTPPASSWORD, 
					  BaseController.bytesToHex(controller.encryptXor(new String(tf_pswd.getPassword())).getBytes(BaseController.ISO_8859_1)));
				} catch(UnsupportedEncodingException uee) {
				}
			} else
				s.setProperty(SECNAME, FTPPASSWORD, "");
		}
		
		public void load() {
			Serializer s = controller.getSerializer();
			if (connectioninfo.host != null)
				tf_hostname.setText(connectioninfo.host);
			if (connectioninfo.user != null)
				tf_user.setText(connectioninfo.user);
			if (!connectioninfo.askPassword && connectioninfo.getPassword() != null)
				tf_pswd.setText(connectioninfo.getPassword());
			tf_proxyport.setText(""+connectioninfo.proxyPort);
			sl_conntimeout.setValue(connectioninfo.timeout/1000);
			l_timeout.setText(""+sl_conntimeout.getValue()+" "+Resources.LABEL_SEC);
			if (connectioninfo.proxyHost != null)
				tf_proxyhost.setText(connectioninfo.proxyHost);
			cb_useproxy.setSelected(connectioninfo.useProxy);
			cb_keeppswd.setSelected(!connectioninfo.askPassword);
			cb_passivemode.setSelected(!connectioninfo.active);
		}

		JSlider sl_conntimeout;
		JPasswordField tf_pswd;
		JTextField tf_proxyhost, tf_proxyport, tf_hostname, tf_user;
		JCheckBox cb_useproxy, cb_keeppswd, cb_passivemode;
		JLabel l_timeout;
	}

    class MailSettingsDialog extends PersistantDialog {
	MailSettingsDialog() {
	    super((JFrame)WebPublishOptionsTab.this.getTopLevelAncestor(), Resources.TITLE_EMAILS, true);
	    java.awt.Container c = getContentPane();
	    c.setLayout(new GranulatedLayout(3, 8, Resources.CTRL_VERT_SIZE,
		Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET,
		Resources.CTRL_HORIZ_GAP,6));
	    c.add(new JLabel(Resources.LABEL_NAME), "0,0,1");
	    c.add(tf_name = new JTextField(), "1,0,2");
	    c.add(new JLabel(Resources.LABEL_ORG), "0,1,1");
	    c.add(tf_organization = new JTextField(), "1,1,2");
	    c.add(new JLabel(Resources.LABEL_EMAILA), "0,2,1");
	    c.add(tf_email = new JTextField(), "1,2,2");
	    c.add(new JLabel(Resources.LABEL_REPLYA), "0,3,1");
	    c.add(tf_reply = new JTextField(), "1,3,2");
	    c.add(new JLabel(Resources.LABEL_SMTPSRV), "0,4,1");
	    c.add(tf_server = new JTextField(), "1,4,2");
	    c.add(new JLabel(Resources.LABEL_SMTPPRT), "0,5,1");
	    c.add(tf_port = new JTextField("25"), "1,5,1");
	    tf_port.setHorizontalAlignment(JTextField.RIGHT);
	    c.add(cb_ssl = new JCheckBox(Resources.LABEL_SSL), "2,5,1");
	    c.add(new JLabel(Resources.LABEL_SRVTIMEOUT), "0,6,1");
	    JButton b;
	    c.add(b = new JButton(Resources.CMD_RESET), "2,6,1");
	    b.addActionListener(this);
	    c.add(sl_timeout = new JSlider(0, 120, 20), "0,7,2,0"); // JSlider.HORIZONTAL
	    sl_timeout.setMajorTickSpacing(30);
	    sl_timeout.setMinorTickSpacing(5);
	    sl_timeout.setSnapToTicks(true);
	    /*sl_timeout.setLabelTable(sl_timeout.createStandardLabels(30));
	    sl_timeout.setPaintLabels(true);
	    sl_timeout.setPaintTicks(true);
	    sl_timeout.setPaintTrack(true);*/
	    c.add(l_timeout = new JLabel(Resources.LABEL_SEC), "2,7,1");
	    sl_timeout.addChangeListener( new ChangeListener() {
		public void stateChanged(ChangeEvent e) {
		    if (e.getSource() == sl_timeout) 
			l_timeout.setText(""+sl_timeout.getValue()+" "+Resources.LABEL_SEC);
		}
	    });
	    pack();
	    load();
	}

	public void save() {
		Serializer s = controller.getSerializer();
		s.setProperty(SECNAME, SMTPSERVER, tf_server.getText().trim());
		s.setProperty(SECNAME, SMTPUSER, tf_name.getText());
		s.setProperty(SECNAME, ORGANIZATION, tf_organization.getText());
		s.setProperty(SECNAME, REPLYADDR, tf_reply.getText());
		s.setProperty(SECNAME, EMAILADDR, tf_email.getText());
		try {
			s.setProperty(SECNAME, SMTPPORT, new Integer(tf_port.getText()));
		} catch(NumberFormatException e) {
		}
		s.setProperty(SECNAME, USESSL, cb_ssl.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, SRVTIMEOUT, new Integer(sl_timeout.getValue()));
	}

	public void load() {
		Serializer s = controller.getSerializer();
		String ps;
		cb_ssl.setSelected(s.getInt(s.getProperty(SECNAME, USESSL), 0) == 1);
		sl_timeout.setValue(s.getInt(s.getProperty(SECNAME, SRVTIMEOUT), 20));
		l_timeout.setText(""+sl_timeout.getValue()+" "+Resources.LABEL_SEC);
		ps = (String)s.getProperty(SECNAME, SMTPSERVER);
		if (ps != null)
			tf_server.setText(ps);
		ps = Serializer.arrayToString(s.getProperty(SECNAME, SMTPUSER));
		if (ps != null)
			tf_name.setText(ps);
		ps = Serializer.arrayToString(s.getProperty(SECNAME, ORGANIZATION));
		if (ps != null)
			tf_organization.setText(ps);
		ps = (String)s.getProperty(SECNAME, REPLYADDR);
		if (ps != null)
			tf_reply.setText(ps);
		ps = (String)s.getProperty(SECNAME, EMAILADDR);
		if (ps != null)
			tf_email.setText(ps);
		tf_port.setText(""+s.getInt(s.getProperty(SECNAME, SMTPPORT), 25));
	}

	JTextField tf_name, tf_organization, tf_email, tf_reply, tf_server, tf_port;
	JCheckBox cb_ssl;
	JSlider sl_timeout;
	JLabel l_timeout;
    }
    
	class HttpSettingsDialog extends PersistantDialog {
		HttpSettingsDialog() {
			super((JFrame)WebPublishOptionsTab.this.getTopLevelAncestor(), Resources.TITLE_HTTP, true);
			java.awt.Container c = getContentPane();
			c.setLayout(new GranulatedLayout(2, 18, Resources.CTRL_VERT_SIZE,
											 Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET,
											 Resources.CTRL_HORIZ_GAP, 8));
			c.add(new JLabel(Resources.LABEL_UPLOAD_SERVLET_URL), "0,0,2");
			c.add(tf_servletUrl = new JTextField(), "0,1,2");
			c.add(new JLabel(Resources.LABEL_UPLOAD_DST_NAME), "0,2,1");
			c.add(tf_inputDst = new JTextField(), "1,2,1");
			c.add(new JLabel(Resources.LABEL_UPLOAD_DATA_NAME), "0,3,1");
			c.add(tf_inputData = new JTextField(), "1,3,1");
			c.add(new JLabel(Resources.LABEL_HTTP_AUTH), "0,4,1");
			c.add(cb_auths = new JComboBox(Resources.HTTP_AUTHS), "1,4,1");
			c.add(new JLabel(Resources.LABEL_HTTP_LOGIN_URL), "0,5,1");
			c.add(tf_login_url = new JTextField(), "0,6,2");
			c.add(new JLabel(Resources.LABEL_LOGIN_NAME), "0,7,1");
			c.add(tf_loginName = new JTextField(), "1,7,1");
			c.add(new JLabel(Resources.LABEL_PASSWORD_NAME), "0,8,1");
			c.add(tf_passwordName = new JTextField(), "1,8,1");
			c.add(new JLabel(Resources.LABEL_HTTP_LOGIN_METHOD), "0,9,1");
			c.add(cb_loginMethod = new JComboBox(Resources.HTTP_LOGIN_METHODS), "1,9,1");
			c.add(new JLabel(Resources.LABEL_LOGIN), "0,10,1");
			c.add(tf_user = new JTextField(), "1,10,1");
			c.add(new JLabel(Resources.LABEL_PASSWORD), "0,11,1");
			c.add(tf_password = new JPasswordField(), "1,11,1");
			// for album
			c.add(new JLabel(Resources.LABEL_ALBUMNAME), "0,12,1");
			c.add(tf_albumName = new JTextField(), "1,12,1");
			c.add(new JLabel(Resources.LABEL_ALBUM_ID), "0,13,1");
			c.add(tf_albumId = new JTextField(), "1,13,1");
			
			c.add(new JLabel(Resources.LABEL_STATIC_QUERY), "0,14,2");
			c.add(tf_staticQuery = new JTextField(), "0,15,2");
			cb_auths.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					updateUI();
				}
				});
			
			c.add(cb_traceUpl = new JCheckBox(Resources.LABEL_TRACE_UPLOAD), "1,16,2");
				  
			JButton b;
			c.add(b = new JButton(Resources.CMD_RESET), "1,17,1");
			b.addActionListener(this);
			pack();
			load();
		}

		public void save() {
			Serializer s = controller.getSerializer();
			s.setProperty(SECNAME, UPL_SERVLET_URL, tf_servletUrl.getText().trim());
			s.setProperty(SECNAME, UPL_DEST_NAME, tf_inputDst.getText());
			s.setProperty(SECNAME, UPL_DATA_NAME, tf_inputData.getText());
			s.setProperty(SECNAME, HTTPPASSWORD_NAME, tf_passwordName.getText());
			s.setProperty(SECNAME, HTTPSTATICQUERY, tf_staticQuery.getText());
			s.setProperty(SECNAME, HTTPLOGIN_NAME, tf_loginName.getText());
			s.setProperty(SECNAME, HTTPLOGIN, tf_user.getText());
			try {
				s.setProperty(SECNAME, HTTPPASSWORD, 
					  BaseController.bytesToHex(controller.encryptXor(new String(tf_password.getPassword())).getBytes(BaseController.ISO_8859_1)));
			} catch(UnsupportedEncodingException uee) {
			}
			s.setProperty(SECNAME, HTTP_AUTH_SHC, new Integer(cb_auths.getSelectedIndex()));
			s.setProperty(SECNAME, HTTP_MANUAL_MODE, cb_traceUpl.isSelected()?Resources.I_YES:Resources.I_NO);
			s.setProperty(SECNAME, HTTPLOGINURL, tf_login_url.getText());
			s.setProperty(SECNAME, HTTPLOGINMETHOD, new Integer(cb_loginMethod.getSelectedIndex()));
			s.setProperty(SECNAME, HTTPALBUMNAME, tf_albumName.getText());
			s.setProperty(SECNAME, HTTPALBUMID, tf_albumId.getText());
		}

		public void load() {
			Serializer s = controller.getSerializer();
			tf_servletUrl.setText(s.arrayToString(s.getProperty(SECNAME, UPL_SERVLET_URL)));
			tf_inputDst.setText((String)s.getProperty(SECNAME, UPL_DEST_NAME));
			tf_inputData.setText((String)s.getProperty(SECNAME, UPL_DATA_NAME));
			tf_loginName.setText((String)s.getProperty(SECNAME, HTTPLOGIN_NAME));
			tf_passwordName.setText((String)s.getProperty(SECNAME, HTTPPASSWORD_NAME));
			tf_staticQuery.setText((String)s.getProperty(SECNAME, HTTPSTATICQUERY));
			tf_user.setText((String)s.getProperty(SECNAME, HTTPLOGIN));
			tf_albumName.setText((String)s.getProperty(SECNAME, HTTPALBUMNAME));
			tf_albumId.setText((String)s.getProperty(SECNAME, HTTPALBUMID));
			String sp = (String)s.getProperty(SECNAME, HTTPPASSWORD);
			if (sp != null) {
				try {
					tf_password.setText(Controller.encryptXor(
															  new String(BaseController.hexToBytes(sp), BaseController.ISO_8859_1)));
				} catch(UnsupportedEncodingException uee) {
				}
			}
			cb_traceUpl.setSelected(s.getInt(s.getProperty(SECNAME, HTTP_MANUAL_MODE), 0) == 1);			
			cb_auths.setSelectedIndex(Serializer.getInt(s.getProperty(SECNAME, HTTP_AUTH_SHC), 0));
			tf_login_url.setText((String)s.getProperty(SECNAME, HTTPLOGINURL));
			cb_loginMethod.setSelectedIndex(Serializer.getInt(s.getProperty(SECNAME, HTTPLOGINMETHOD), 0));
			updateUI();
		}
		
		private void updateUI() {
			boolean enabled = cb_auths.getSelectedIndex() > 0;
			tf_user.setEnabled(enabled);
			tf_password.setEnabled(enabled);
			cb_loginMethod.setEnabled(enabled);
			tf_login_url.setEnabled(enabled);
			tf_loginName.setEnabled(enabled);
			tf_passwordName.setEnabled(enabled);
			tf_staticQuery.setEnabled(enabled);
		}
		
		JTextField tf_servletUrl, tf_inputDst, tf_inputData,
			tf_user, tf_login_url, tf_loginName, tf_passwordName, tf_staticQuery,
			tf_albumName, tf_albumId;
		JPasswordField tf_password;
		JComboBox cb_auths, cb_loginMethod;
		JCheckBox cb_traceUpl;
	}
}