/*
 * 29/01/00		Initial version. mdm@techie.com
/*-----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */


import javax.sound.sampled.*;

import java.io.*;

/**
 * The <code>JavaSoundAP_AudioDevice</code> implements an audio
 * device by using the JavaSound API.
 *
 * @since 0.0.8
 * @author Mat McGowan
 */
public class AP_JavaSoundAudioDevice extends AP_AudioDeviceBase {
  private SourceDataLine	source = null;
  private AudioFormat		fmt = null;
  private byte[]			byteBuf = new byte[1024];
  private boolean			playing = false;

  // Four seconds max buffer
  private static final int bufferMs = 1000;

  public boolean isEightBitEightKhzMuLaw() {
    return false;
  }

  protected void setAudioFormat(AudioFormat _fmt) {
    fmt = _fmt;
  }

  protected AudioFormat getAudioFormat() {
    if (fmt==null) {
            AD_Decoder decoder = getDecoder();  // jl decoder
            fmt = new AudioFormat(decoder.getOutputFrequency(),
                                                      16,
                                                      decoder.getOutputChannels(),
                                                      true,
                                                      false);
    }
    return fmt;
  }

  protected DataLine.Info getSourceLineInfo() {
    AudioFormat afmt = getAudioFormat();
    DataLine.Info info = new DataLine.Info(SourceDataLine.class, afmt, bufferMs);
    return info;
  }

  public void open(AudioFormat _fmt) throws AD_JavaLayerException {
    if (!isOpen()) {
      setAudioFormat(_fmt);
      openImpl();
      setOpen(true);
    }
  }

  protected void openImpl() throws AD_JavaLayerException {
  }

  protected void createSource() throws AD_JavaLayerException {
          Throwable t = null;
          try {
            AudioFormat afmt = getAudioFormat();    // jl data audio format
            Line.Info info = new DataLine.Info(SourceDataLine.class, fmt, bufferMs);  // jl Info
            source = (SourceDataLine) AudioSystem.getLine(info);
            source.open(afmt, millisecondsToBytes(afmt, bufferMs));
            source.start();
          }
          catch (RuntimeException ex) {
                  t = ex;
          }
          catch (LinkageError ex) {
                  t = ex;
          }
          catch (LineUnavailableException ex) {
                  t = ex;
          }

          if (source == null)
                  throw new AD_JavaLayerException("cannot obtain source audio line", t);

  }

  public int millisecondsToBytes(AudioFormat _fmt, int time) {
    return (int)(time * (_fmt.getSampleRate() *
                                             _fmt.getChannels() *
                                             _fmt.getSampleSizeInBits()) / 8000.0);
  }

  /*private int bytesToMilliseconds(AudioFormat _fmt, int bytes)
  {
          return (int)(bytes*8000/(_fmt.getSampleRate()*_fmt.getChannels()* _fmt.getSampleSizeInBits()));
  }*/

  protected void closeImpl() {
    if (source != null) {
      source.stop();
      source.flush();
      source.drain();
      source.close();
    }
  }

  private long firstPTS = -1;
  protected void writeImpl(short[] samples, int offs, int len,  long pts, SystemDecoder systemDecoder)
          throws AD_JavaLayerException
  {

          if (source == null)
                  createSource();

          byte[] b = toByteArray(samples, offs, len);

          // long now = System.currentTimeMillis();
          int avail = source.available();
          // System.out.println("         ***********          dumpbuf: " + avail + " len: " + len * 2 + " fr: " + getFillRatio());

          // HACK HACK HACK
          // If we're filling the buffer (not yet playing), start the stream only long enough to write
          // to the buffer.
          if (firstPTS==-1) {
            firstPTS = pts;
          }


          if (playing) {
                  if (pts!=0) {
                    try {
                      long stc = systemDecoder.getSTC();
                      long delta = (source.getMicrosecondPosition())/1000+firstPTS-stc;
                      if (delta>80) {
                      //System.out.println("startpause: "+delta);
                        source.stop();
                        Thread.currentThread().sleep(delta);
                        source.start();
                      //System.out.println("stoppause: "+delta);
                      } else if (delta<-50) {
                        systemDecoder.slowdownSTC(-delta);
                              //System.out.println("systempause: "+-delta);
                      }

                    /*  long msInBuffer = bytesToMilliseconds(fmt, source.getBufferSize()-source.available());
                      long stc = systemDecoder.getSTC();
                      long stcWhenStartingToPlay = stc+msInBuffer; // stc when this data will start to play (if not adjusted)
                      long delta = pts-stcWhenStartingToPlay; // How much ahead of time the sound is
                      if (delta>50) {
                        //source.stop();
                        //Thread.currentThread().sleep(msInBuffer+delta);
                        //source.start();
                      } else if (delta<-50) {
                        //systemDecoder.slowdownSTC(-delta);
System.out.println(":systempause: "+(-delta));*/
                     // }

                    } catch (Exception e) {System.out.println(2);}
                  }
                  source.write(b, 0, len * 2);
          } else {
                  // This hack only works if the write won't overflow the buffer...so don't overflow it.
System.out.println(1);
                  source.start();
                  source.write(b, 0, len * 2);
                  source.stop();
          }
  }

  protected byte[] getByteArray(int length)
  {
          if (byteBuf.length < length)
          {
                  byteBuf = new byte[length+1024];
          }
          return byteBuf;
  }

  protected byte[] toByteArray(short[] samples, int offs, int len)
  {
          byte[] b = getByteArray(len*2);
          int idx = 0;
          short s;
          while (len-- > 0)
          {
                  s = samples[offs++];
                  b[idx++] = (byte)s;
                  b[idx++] = (byte)(s>>>8);
          }

          return b;
  }

  /*protected void flushImpl()
  {
          if (source != null) {
                  source.drain();
          }
  }*/

  public int getPosition()
  {
          int pos = 0;
          if (source != null) {
                  pos = (int)(source.getMicrosecondPosition()/1000);
          }
          return pos;
  }

  public float getFillRatio() {
          if (source == null) return 0;
          //source.start();
          //source.stop();
          return (float)1 - (source.available() / (float) source.getBufferSize());
  }


  /**
   * Start player playing
   */
  public void play() {
          playing = true;

          if (source != null) {
                  source.start();
          }
  }

  /**
   * Stop player playing
   */
  public void stop() {
          playing = false;
          if (source != null) {
                  source.stop();
          }
  }


  /**
   * Runs a short test by playing a short silent sound.
   */
  public void test()
          throws AD_JavaLayerException
  {
          return;
          /*
          try
          {
                  open(new AudioFormat(22050, 16, 1, true, false));
                  short[] data = new short[22050/10];
                  write(data, 0, data.length);
                  flush();
                  close();
          }
          catch (RuntimeException ex)
          {
                  throw new JavaLayerException("Device test failed: "+ex);
          }
          */
  }
}
