/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   BufferQueue.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/**
 *   The Buffer queue to control the order of the buffer
 */
class BufferQueue
{
	/**
	 *   Head and tail pointer
	 */
	ByteBuffer head = null, tail = null;

	/**
	 *   The base stream identifer
	 */
	private int streamIdentifer = 0;

	/**
	 *   Unused parameter
	 */
	private int STDBufferUBMark;
	private int STDBufferSizeUB;
	private boolean systemLockFlag;
        public boolean isStopped;




	/**
	 *   Constructor
	 */
	public BufferQueue(int nrOfEmptyByteBuffers)
	{
		head = tail = null;
                for (int i=0;i<nrOfEmptyByteBuffers;i++) // Only used for system buffer queue
                  enQueue(new ByteBuffer());
	}

	/**
	 *   Reset the BufferQueue and all buffer in it
	 */
	synchronized void reset()
	{
		streamIdentifer = 0;
		ByteBuffer temp = head;
		while (temp != null) {
			temp.reset();
			temp = temp.nextBuffer;
		}
		STDBufferUBMark = STDBufferSizeUB = 0;
		systemLockFlag = false;
	}

	/**
	 *   Dequeue one buffer from the queue, block the thread when no buffer is available
	 */
	synchronized ByteBuffer deQueue() throws InterruptedException
	{
//long time = System.currentTimeMillis();
		while (head == null)
			 wait(); // wait for a new buffer to enqueue
		// Now both head and tail != null
		ByteBuffer temp = head;
		if (tail == head) tail = head.getNext();
		head = head.getNext();
		temp.setNext(null);
//if ((System.currentTimeMillis()-time)>3000)
//  System.out.println("hmmmmm");
		return temp;
	}

	/**
	 *   Enqueue one buffer to the queue, wake up the waiting thread
	 */
	synchronized void enQueue(ByteBuffer buffer)
	{
		if (buffer == null) return;

		if (tail == null) {
			head = tail = buffer;
			notify(); // notify the waiting thread
		} else {
			tail.setNext(buffer);
			tail = buffer;
		}
	}

	/**
	 *   Get the queue's base stream identifer
	 */
	int getStreamIdentifer()
	{
		return streamIdentifer;
	}

	/**
	 *   Set the queue's base stream identifer
	 */
	void setStreamIdentifer(int value)
	{
		streamIdentifer = value;
	}

	/**
	 *   Set some unused parameters
	 */
	void setSTDBufferUBMark(int value)
	{
		STDBufferUBMark = value;
	}

	void setSTDBufferSizeUB(int value)
	{
		STDBufferSizeUB = value;
	}

	void setSystemLockFlag ( boolean value )
	{
		systemLockFlag = value;
	}
}