/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UiUpdater {
    public static final int FILE_SELECTED = 1;
    public static final int SELECTION_SELECTED = 2;
    public static final int DIRECTORY_SELECTED = 3;
    public static final int ALBUM_SELECTED = 3;
    public static final int MEDIA_FILE_SELECTED = 4;
    public static final int GRAPHICS_FILE_SELECTED = 5;
    public static final int IS_SELECTION = 6;
    static final int STATE_SIZE = 6;
    static int[] EVENTS = new int[]{1, 2, 3, 3, 4, 5, 6};
    private Hashtable lines = new Hashtable(6);
    private Hashtable states = new Hashtable(6);

    public UiUpdater() {
        int n = 0;
        while (n < EVENTS.length) {
            Integer n2 = new Integer(EVENTS[n]);
            this.lines.put(n2, new Vector());
            this.states.put(n2, Boolean.FALSE);
            ++n;
        }
    }

    public void addForNotification(Component component, int n) {
        Vector vector = (Vector)this.lines.get(new Integer(n));
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) == component) {
                return;
            }
            ++n2;
        }
        vector.addElement(component);
    }

    public void notify(boolean bl, int n) {
        Vector vector = (Vector)this.lines.get(new Integer(n));
        this.states.put(new Integer(n), bl ? Boolean.TRUE : Boolean.FALSE);
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            ((Component)vector.elementAt(n2)).setEnabled(bl);
            ++n2;
        }
    }

    public boolean isEnabled(int n) {
        Boolean bl = (Boolean)this.states.get(new Integer(n));
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void reset() {
        Enumeration enumeration = this.lines.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            int n = 0;
            while (n < vector.size()) {
                ((Component)vector.elementAt(n)).setEnabled(false);
                ++n;
            }
        }
        int n = 0;
        while (n < EVENTS.length) {
            this.states.put(new Integer(EVENTS[n]), Boolean.FALSE);
            ++n;
        }
    }
}

