/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.courier;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import rogatkin.Serializer;

public class FileCourier
implements Courier {
    Controller controller;
    Serializer s;
    String mask;
    String root;

    public FileCourier(Controller controller) {
        this.controller = controller;
        this.s = controller.getSerializer();
    }

    public void deliver(StringBuffer stringBuffer, String string, String string2, String string3) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.root, string));
        byte[] byArray = string3 != null && string3.length() > 0 ? stringBuffer.toString().getBytes(string3) : stringBuffer.toString().getBytes();
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public void deliver(String string, String string2) throws IOException {
        File file = new File(string);
        Controller.copyFile((File)file, (File)new File(this.root + string2, file.getName()));
        System.err.println("Copied " + file + " to " + this.root + string2 + file.getName());
    }

    public String deliver(AbstractFormat abstractFormat, String string) throws IOException {
        AbstractInfo abstractInfo = abstractFormat.getInfo();
        if (abstractInfo == null) {
            return "";
        }
        String string2 = FileNameFormat.makeValidPathName(new FileNameFormat(this.mask, true).format(abstractFormat), abstractFormat.getThumbnailType());
        File file = new File(this.root + string, string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (abstractInfo instanceof AbstractImageInfo) {
            ((AbstractImageInfo)abstractInfo).saveThumbnailImage((BasicJpeg)abstractFormat, fileOutputStream);
        } else {
            fileOutputStream.write(abstractFormat.getThumbnailData(null));
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        return new File(string, string2).getPath();
    }

    public void checkForDestPath(String string) throws IOException {
        new File(this.root + string).mkdirs();
    }

    public void init() throws IOException {
        this.mask = (String)this.s.getProperty((Object)"ThumbnailsOptions", (Object)"FileMask");
        if (this.mask == null || this.mask.length() == 0) {
            this.mask = "tumbnail%00c.jpg";
        }
        this.root = (String)this.s.getProperty((Object)"WebPublishOptions", (Object)"WebRoot");
        if (this.root == null) {
            this.root = "";
        } else if (this.root.length() > 0 && this.root.charAt(this.root.length() - 1) != '/' && this.root.charAt(this.root.length() - 1) != '\\') {
            this.root = this.root + File.separatorChar;
        }
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isContentIncluded() {
        return false;
    }

    public void done() {
    }
}

