/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2IllegalVersionException;
import de.vdheide.mp3.ID3v2WrongCRCException;
import de.vdheide.mp3.MP3File;
import de.vdheide.mp3.NoMP3FrameException;
import de.vdheide.mp3.TagContent;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.AbstractInfo;
import photoorganizer.formats.BasicJpeg;

public class MP3
implements AbstractFormat {
    public static final String[] LAYER_NAMES = new String[]{"I", "II", "III"};
    public static final String[] S_FREQ = new String[]{"44.1", "48", "32", "0"};
    public static final String[] MODE_NAMES = new String[]{"stereo", "j-stereo", "dual-ch", "mono"};
    public static final String[] GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Meta", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Brass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Poweer Ballad", "Rhytmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A Capela", "Euro-House", "Dance Hall"};
    public static final String MP3 = "MP3";
    public static final String TYPE = "MP3";
    protected static final Class[] EMPTY_PARAMS = new Class[0];
    protected static Icon icon = Controller.getResourceIcon((String)"mp3icon.jpg");
    protected static byte[] defaultIconData;
    Mp3Info info;
    static /* synthetic */ Class class$de$vdheide$mp3$TagContent;

    public MP3(File file) {
        try {
            if (!file.getName().regionMatches(true, file.getName().length() - "MP3".length(), "MP3", 0, "MP3".length())) {
                throw new Exception("Wrong extension for MP3 for file " + file);
            }
            this.info = new Mp3Info(file);
            this.info.getLength();
        }
        catch (Exception exception) {
            this.info = null;
        }
    }

    public AbstractInfo getInfo() {
        return this.info;
    }

    public boolean isValid() {
        return this.info != null;
    }

    public String getType() {
        return "MP3";
    }

    public String getThumbnailType() {
        return "jpeg";
    }

    public Icon getThumbnail(Dimension dimension) {
        try {
            byte[] byArray = this.info.getPicture().getBinaryContent();
        }
        catch (FrameDamagedException frameDamagedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    public InputStream getAsStream() throws IOException {
        if (this.info != null) {
            if (!Controller.isJdk1_4()) {
                return this.getUrl().openStream();
            }
            return new FileInputStream((File)((Object)this.info));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getThumbnailData(Dimension dimension) {
        Object object;
        try {
            object = this.info.getPicture().getBinaryContent();
            if (object != null) {
                return object;
            }
        }
        catch (FrameDamagedException frameDamagedException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = "MP3";
        synchronized (object) {
            if (defaultIconData == null) {
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(ClassLoader.getSystemResourceAsStream("mp3icon.jpg"));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                    Controller.copyStream((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream);
                    defaultIconData = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    defaultIconData = new byte[0];
                }
            }
        }
        return defaultIconData;
    }

    public long getFileSize() {
        return this.getLength();
    }

    public long getLength() {
        if (this.isValid()) {
            return this.info.length();
        }
        return -1L;
    }

    public String getName() {
        if (this.isValid()) {
            return this.info.getName();
        }
        return null;
    }

    public File getFile() {
        return this.info;
    }

    public boolean renameTo(File file) {
        if (this.info.renameTo(file)) {
            try {
                this.info = new Mp3Info(file);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public URL getUrl() {
        try {
            return this.info.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String toString() {
        if (this.isValid()) {
            return this.info.toString();
        }
        return super.toString();
    }

    public static String convertTime(long l) {
        return (l / 3600L > 0L ? String.valueOf(l / 60L / 60L) : "") + ':' + (l % 3600L / 60L < 10L ? "0" : "") + l % 3600L / 60L + ':' + (l % 60L < 10L ? "0" : "") + l % 60L;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Mp3Info
    extends MP3File
    implements AbstractInfo {
        protected Object[] fiveObjects;

        Mp3Info(File file) throws IOException, NoMP3FrameException, ID3v2WrongCRCException, ID3v2DecompressionException, ID3v2IllegalVersionException {
            super(file, "", BasicJpeg.getEncoding());
            this.fiveObjects = new Object[5];
        }

        public void setAttribute(String string, Object object) {
            try {
                this.getClass().getMethod("set" + string, object.getClass()).invoke((Object)this, object);
            }
            catch (Throwable throwable) {
                if (object instanceof String) {
                    try {
                        TagContent tagContent = new TagContent();
                        tagContent.setContent((String)object);
                        this.getClass().getMethod("set" + string, class$de$vdheide$mp3$TagContent == null ? (class$de$vdheide$mp3$TagContent = photoorganizer.formats.MP3.class$("de.vdheide.mp3.TagContent")) : class$de$vdheide$mp3$TagContent).invoke((Object)this, tagContent);
                    }
                    catch (Throwable throwable2) {
                        throw new IllegalArgumentException("Not supported attribute name " + string + " to set TagContent (" + object + ") <<" + throwable2);
                    }
                }
                throw new IllegalArgumentException("Not supported set attribute name " + string + " to value " + object + " <<" + throwable);
            }
        }

        public Object getAttribute(String string) {
            try {
                if ("charachter".equals(string)) {
                    return new Integer(this.getBitrate());
                }
                if ("timestamp".equals(string) || "Length".equals(string)) {
                    long l = this.getLength();
                    return (l / 3600L > 0L ? String.valueOf(l / 60L / 60L) : "") + ':' + l % 3600L / 60L + ':' + (l % 60L < 10L ? "0" : "") + l % 60L;
                }
                if ("quality".equals(string) || "Mode".equals(string)) {
                    return MODE_NAMES[this.getMode()];
                }
                if ("make".equals(string)) {
                    return this.getArtist().getTextContent();
                }
                Object object = this.getGenericAttribute(string);
                if (object instanceof TagContent) {
                    return ((TagContent)object).getTextContent();
                }
                return object;
            }
            catch (FrameDamagedException frameDamagedException) {
                frameDamagedException.printStackTrace();
                return null;
            }
        }

        public int getIntAttribute(String string) {
            if ("charachter".equals(string)) {
                try {
                    return Integer.parseInt(this.getYear().getTextContent());
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            Object object = this.getGenericAttribute(string);
            if (object != null) {
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                if (object instanceof String) {
                    try {
                        return Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                } else if (object instanceof TagContent) {
                    try {
                        return Integer.parseInt(((TagContent)object).getTextContent());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                return 0;
            }
            throw new IllegalArgumentException("Not supported attribute name for int " + string);
        }

        public float getFloatAttribute(String string) {
            if ("charachter".equals(string)) {
                return (float)this.getSamplerate() / 1000.0f;
            }
            Object object = this.getGenericAttribute(string);
            if (object != null) {
                if (object instanceof Float) {
                    return ((Float)object).floatValue();
                }
            } else {
                return 0.0f;
            }
            throw new IllegalArgumentException("Not supported attribute name for float " + string);
        }

        public long getLongAttribute(String string) {
            Object object = this.getGenericAttribute(string);
            if (object != null) {
                if (object instanceof Long) {
                    return (Long)object;
                }
            } else {
                return 0L;
            }
            throw new IllegalArgumentException("Not supported attribute name for long " + string);
        }

        public double getDoubleAttribute(String string) {
            Object object = this.getGenericAttribute(string);
            if (object != null) {
                if (object instanceof Double) {
                    return (Double)object;
                }
            } else {
                return 0.0;
            }
            throw new IllegalArgumentException("Not supported attribute name for double " + string);
        }

        public boolean getBoolAttribute(String string) {
            if ("charachter".equals(string)) {
                return this.getProtection();
            }
            Object object = this.getGenericAttribute(string);
            if (object != null) {
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
            } else {
                return false;
            }
            throw new IllegalArgumentException("Not supported attribute name for boolean " + string);
        }

        public String toString() {
            try {
                return "" + (this.getAttribute("make") != null ? this.getAttribute("make") : super.toString()) + ' ' + this.getAttribute("charachter") + ' ' + this.getAttribute("timestamp") + ' ' + this.getFloatAttribute("charachter");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return super.toString();
            }
        }

        public Object[] getFiveMajorAttributes() {
            try {
                this.fiveObjects[0] = this.getAttribute("Title");
            }
            catch (Exception exception) {
                this.fiveObjects[0] = "Unknown";
            }
            try {
                this.fiveObjects[1] = this.getAttribute("Artist");
            }
            catch (Exception exception) {
                this.fiveObjects[1] = "Unknown";
            }
            try {
                this.fiveObjects[2] = this.getAttribute("Album");
            }
            catch (Exception exception) {
                this.fiveObjects[2] = "Unknown";
            }
            try {
                this.fiveObjects[3] = new Integer(this.getIntAttribute("Year"));
            }
            catch (Exception exception) {
                this.fiveObjects[3] = "";
            }
            this.fiveObjects[4] = this.getName();
            return this.fiveObjects;
        }

        protected Object getGenericAttribute(String string) {
            try {
                return this.getClass().getMethod("get" + string, EMPTY_PARAMS).invoke((Object)this, (Object[])EMPTY_PARAMS);
            }
            catch (Throwable throwable) {
                if (throwable instanceof InvocationTargetException) {
                    throw new IllegalArgumentException("Not supported attribute name for " + string + " <<" + ((InvocationTargetException)throwable).getTargetException());
                }
                throw new IllegalArgumentException("Not supported attribute name for " + string + " <<" + throwable);
            }
        }
    }
}

