/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.HtmlProducer;
import photoorganizer.IrdControllable;
import photoorganizer.album.Access;
import photoorganizer.album.AlbumModel;
import photoorganizer.album.MediaAccess;
import photoorganizer.courier.FTPCourier;
import photoorganizer.courier.FileCourier;
import photoorganizer.courier.HTTPCourier;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.media.PlaybackRequest;
import photoorganizer.renderer.AlbumProperties;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.AlbumThumbnailsPanel;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PlaybackProperties;
import photoorganizer.renderer.SendEmailFrame;
import photoorganizer.renderer.Shuffler;
import photoorganizer.renderer.StatusBar;
import rogatkin.Serializer;

public class AlbumPane
extends JTree
implements ActionListener,
TreeSelectionListener,
Shuffler,
IrdControllable {
    public static final String[] IRD_NAVIGATIONS;
    protected AlbumThumbnailsPanel thumbnails;
    protected PhotoCollectionPanel collectionpanel;
    private StatusBar statusbar;
    private Controller controller;
    private AlbumSelectionDialog albumselection;
    MediaAccess access;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$photoorganizer$renderer$AlbumPane;

    public AlbumPane(Controller controller) {
        block2: {
            this.controller = controller;
            this.access = new MediaAccess(controller);
            this.setModel(new AlbumModel(this.access));
            this.getSelectionModel().setSelectionMode(1);
            this.statusbar = (StatusBar)controller.component(Controller.COMP_STATUSBAR);
            this.addTreeSelectionListener(this);
            this.addMouseListener(new MouseInputAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        Point point = ((JViewport)AlbumPane.this.getParent()).getViewPosition();
                        new AlbumRightBtnMenu(AlbumPane.this).show(AlbumPane.this.getParent(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
                    }
                }
            });
            this.setEditable(true);
            this.setTransferHandler(new TransferHandler(){

                protected Transferable createTransferable(JComponent jComponent) {
                    if (jComponent instanceof JTree) {
                        JTree jTree = (JTree)jComponent;
                        TreePath[] treePathArray = jTree.getSelectionPaths();
                        return new TransferableTreeNode(treePathArray, jTree);
                    }
                    return null;
                }

                public int getSourceActions(JComponent jComponent) {
                    return 1;
                }

                public boolean importData(JComponent jComponent, Transferable transferable) {
                    try {
                        TreePath[] treePathArray = ((TransferableTreeNode)transferable.getTransferData(transferable.getTransferDataFlavors()[0])).getTransferablePaths();
                        int n = AlbumPane.this.access.getAlbumId(AlbumPane.this.getSelectionPath());
                        if (n <= 0) {
                            int n2 = 0;
                            while (n2 < treePathArray.length) {
                                treePathArray[n2] = null;
                                ++n2;
                            }
                            return false;
                        }
                        int n3 = 0;
                        while (n3 < treePathArray.length) {
                            int n4 = AlbumPane.this.access.getAlbumId(treePathArray[n3]);
                            if (n4 <= 0 || n4 == n) {
                                System.err.println("An attempt to include the album to itself, or undefined source.");
                                treePathArray[n3] = null;
                            } else if (AlbumPane.this.access.insertAlbumToAlbum(new int[]{n}, n4) < 0) {
                                JOptionPane.showMessageDialog(AlbumPane.this.controller.getMainFrame(), "The album can't be moved/copied, because it includes target album(s).\n" + AlbumPane.this.access.getNameOfAlbum(n4) + "-->" + AlbumPane.this.access.getNameOfAlbum(n), "Error", 0);
                            }
                            ++n3;
                        }
                        return true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                }

                public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                    return true;
                }

                protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
                    if ((n & 2) != 0) {
                        try {
                            TreePath[] treePathArray = ((TransferableTreeNode)transferable.getTransferData(transferable.getTransferDataFlavors()[0])).getTransferablePaths();
                            int n2 = 0;
                            while (n2 < treePathArray.length) {
                                if (treePathArray[n2] != null) {
                                    AlbumPane.this.access.deleteAlbumFrom(new int[]{AlbumPane.this.access.getAlbumId(treePathArray[n2].getParentPath())}, AlbumPane.this.access.getAlbumId(treePathArray[n2]));
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if ((n & 3) != 0 && transferable != null) {
                        ((AlbumModel)AlbumPane.this.getModel()).fireTreeStructureChanged(this, new Object[]{AlbumPane.this.getModel().getRoot()}, null, null);
                    }
                }
            });
            try {
                this.getDropTarget().addDropTargetListener(new DropTargetAdapter(){

                    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                        Point point = dropTargetDragEvent.getLocation();
                        TreePath treePath = AlbumPane.this.getClosestPathForLocation(point.x, point.y);
                        if (treePath != null) {
                            AlbumPane.this.setSelectionPath(treePath);
                        }
                    }

                    public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    }
                });
            }
            catch (TooManyListenersException tooManyListenersException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.setDragEnabled(true);
    }

    void setTumbnailsPanel(AlbumThumbnailsPanel albumThumbnailsPanel) {
        this.thumbnails = albumThumbnailsPanel;
    }

    void setCollectionPanel(PhotoCollectionPanel photoCollectionPanel) {
        this.collectionpanel = photoCollectionPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        if (string.equals("To selection")) {
            this.collectionpanel.add(this.access.getAlbumContents(this.access.getAlbumId(this.getSelectionPath())));
        } else if (string.equals("Delete")) {
            this.access.deleteAlbumFrom(new int[]{this.access.getAlbumId(this.getSelectionPath().getParentPath())}, this.access.getAlbumId(this.getSelectionPath()));
            this.invalidateTree();
        } else if (string.equals("Delete all")) {
            this.access.deleteAlbum(this.access.getAlbumId(this.getSelectionPath()));
            this.invalidateTree();
        } else if (string.equals("Copy/move")) {
            final int n = this.access.getAlbumId(this.getSelectionPath());
            if (n > 0) {
                Serializer serializer = this.controller.getSerializer();
                final boolean bl2 = Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"MoveToAlbum"), (int)0) == 1;
                final String string2 = (String)serializer.getProperty((Object)"AlbumOptions", (Object)"AlbumRoot");
                new Thread(new Runnable(){

                    public synchronized void run() {
                        if (bl2) {
                            AlbumPane.this.moveAlbum(n, new File(string2 != null ? string2 : "."));
                        } else {
                            AlbumPane.this.copyAlbum(n, new File(string2 != null ? string2 : "."));
                        }
                        AlbumPane.this.statusbar.clearInfo();
                        AlbumPane.this.statusbar.clearProgress();
                    }
                }, "Album copyer").start();
            }
        } else if (string.equals("Show/Play")) {
            final int n = this.access.getAlbumId(this.getSelectionPath());
            final PlaybackRequest playbackRequest = new PlaybackRequest(this.controller.getSerializer());
            new Thread(new Runnable(){

                public void run() {
                    PlaybackProperties.doModal(AlbumPane.this.controller, playbackRequest);
                    if (playbackRequest.matcher != null) {
                        AlbumPane.this.showAlbum(n, playbackRequest);
                    }
                }
            }, "PlayAlbum").start();
        } else if (string.equals("Rename")) {
            this.startEditingAtPath(this.getSelectionPath());
        } else if (string.equals("This album")) {
            this.publishAlbum(this.access.getAlbumId(this.getSelectionPath()), false);
        } else if (string.equals("All albums")) {
            this.publishAlbum(this.access.getAlbumId(this.getSelectionPath()), true);
        } else if (string.equals("Properties...")) {
            new AlbumProperties(this, this.access.getAlbumId(this.getSelectionPath()), this.access);
        } else if (string.equals("To CSV...")) {
            JOptionPane.showMessageDialog(this, "For next release");
        } else if (string.equals("To Disk...")) {
            final int n = this.access.getAlbumId(this.getSelectionPath());
            JDirectoryChooser jDirectoryChooser = new JDirectoryChooser(new JFrame(), "/", null, n > 0 ? "Select destination for " + this.access.getNameOfAlbum(n) : "Select destination for whole album", "Copy", "Press this button to copy whole album or selected");
            this.controller.setWaitCursor(this.getTopLevelAncestor(), false);
            if (jDirectoryChooser.getDirectory() != null) {
                final File file = new File(jDirectoryChooser.getDirectory());
                new Thread(new Runnable(){

                    public synchronized void run() {
                        AlbumPane.this.copyAlbum(n, file);
                        AlbumPane.this.statusbar.clearInfo();
                        AlbumPane.this.statusbar.clearProgress();
                    }
                }, "Album copier").start();
            }
        } else if (string.equals("From CSV...")) {
            JOptionPane.showMessageDialog(this, "For next release");
        } else if (string.equals("From Disk...")) {
            int n = this.access.getAlbumId(this.getSelectionPath());
            if (n < 0) {
                JOptionPane.showMessageDialog(this.controller.getMainFrame(), "No target album selected for import.", "Error", 0);
                return;
            }
            JDirectoryChooser jDirectoryChooser = new JDirectoryChooser(new JFrame(), "/", null, "Select imported album location", "Import", "Press this button to importing album from specified location");
            this.controller.setWaitCursor(this.getTopLevelAncestor(), false);
            String string3 = jDirectoryChooser.getDirectory();
            if (string3 != null) {
                String string4 = null;
                Serializer serializer = this.controller.getSerializer();
                if (n > 0 && Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"AlbumFolders"), (int)0) == 1 && (string4 = (String)serializer.getProperty((Object)"AlbumOptions", (Object)"AlbumRoot")) != null) {
                    int[] nArray = this.access.getAlbumPath(n);
                    String string5 = this.access.getNameOfAlbum(n);
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        string5 = this.access.getNameOfAlbum(nArray[n2]) + File.separatorChar + string5;
                        ++n2;
                    }
                    File file = new File(string4, string5);
                    file.mkdirs();
                    string4 = file.toString();
                    System.err.println("result path " + string5);
                }
                this.importAlbum(n, string3, string4, Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"MoveToAlbum"), (int)0) == 1);
            }
        } else if (string.equals("Refresh")) {
            this.invalidateTree();
        }
    }

    public AlbumSelectionDialog getSelectionDialog() {
        if (this.albumselection == null) {
            this.createSelectionDialog();
        }
        return this.albumselection;
    }

    final synchronized void createSelectionDialog() {
        if (this.albumselection == null) {
            this.albumselection = new AlbumSelectionDialog(this.controller);
        }
    }

    void copyAlbum(int n, File file) {
        File file2;
        File[] fileArray = this.access.getAlbumContents(n);
        if (n != 0) {
            file2 = new File(file, this.access.getNameOfAlbum(n));
            file2.mkdir();
        } else {
            file2 = file;
        }
        this.statusbar.displayInfo("Copying->" + file2);
        this.statusbar.setProgress(fileArray.length);
        int n2 = 0;
        while (n2 < fileArray.length) {
            try {
                Controller.copyFile((File)fileArray[n2], (File)new File(file2, fileArray[n2].getName()));
                this.statusbar.tickProgress();
            }
            catch (IOException iOException) {
                System.err.println("Exception " + iOException + " in copying " + fileArray[n2]);
            }
            ++n2;
        }
        int[] nArray = this.access.getAlbumsId(n);
        int n3 = 0;
        while (n3 < nArray.length) {
            this.copyAlbum(nArray[n3], file2);
            ++n3;
        }
    }

    void moveAlbum(int n, File file) {
        Object object;
        File[] fileArray = this.access.getAlbumContents(n);
        File file2 = new File(file, this.access.getNameOfAlbum(n));
        file2.mkdir();
        this.statusbar.displayInfo("Moving->" + file2);
        this.statusbar.setProgress(fileArray.length);
        int n2 = 0;
        while (n2 < fileArray.length) {
            object = new File(fileArray[n2], "");
            if (fileArray[n2].renameTo(new File(file2, fileArray[n2].getName()))) {
                this.access.renamePictureTo(n, ((File)object).toString(), fileArray[n2].toString());
            } else {
                System.err.println("File " + fileArray[n2] + " hasn't been renamed");
            }
            ++n2;
        }
        object = this.access.getAlbumsId(n);
        int n3 = 0;
        while (n3 < ((int[])object).length) {
            this.moveAlbum(object[n3], file2);
            ++n3;
        }
    }

    public void publishAlbum(final int n, final boolean bl) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Courier courier = null;
                    Serializer serializer = AlbumPane.this.controller.getSerializer();
                    switch (Serializer.getInt((Object)serializer.getProperty((Object)"WebPublishOptions", (Object)"PublishingMode"), (int)0)) {
                        case 1: {
                            courier = new FTPCourier(AlbumPane.this.controller);
                            break;
                        }
                        case 2: {
                            courier = new HTTPCourier(AlbumPane.this.controller);
                            break;
                        }
                        case 3: {
                            new SendEmailFrame(AlbumPane.this.controller, AlbumPane.this.access.getAlbumContents(n));
                            return;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            courier = new FileCourier(AlbumPane.this.controller);
                        }
                    }
                    new HtmlProducer(AlbumPane.this.controller).produce(courier, n, bl);
                }
                catch (IOException iOException) {
                    AlbumPane.this.statusbar.flashInfo("Exception in Web publishing, see log for details.");
                    System.err.println("Exception in Web publishing " + iOException);
                    iOException.printStackTrace();
                }
            }
        }, "Album publishing").start();
    }

    public void showAlbum(int n, PlaybackRequest playbackRequest) {
        Object[] objectArray;
        if (playbackRequest.shuffled) {
            objectArray = Shuffler.Instance.getShuffledList(new Object[]{new Integer(n)}, this);
        } else {
            int[] nArray = this.access.getAlbumsId(n);
            int n2 = 0;
            while (n2 < nArray.length) {
                this.showAlbum(nArray[n2], playbackRequest);
                ++n2;
            }
            objectArray = this.access.getAlbumContents(n);
        }
        this.controller.playMediaList(objectArray, playbackRequest);
    }

    public void fill(List list, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Integer) {
                this.addShuffledAlbums(list, (Integer)objectArray[n]);
            } else if (objectArray[n] instanceof File) {
                list.add(objectArray[n]);
            }
            ++n;
        }
    }

    protected void addShuffledAlbums(List list, int n) {
        File[] fileArray = this.access.getAlbumContents(n);
        int n2 = 0;
        while (n2 < fileArray.length) {
            list.add(fileArray[n2]);
            ++n2;
        }
        int[] nArray = this.access.getAlbumsId(n);
        int n3 = 0;
        while (n3 < nArray.length) {
            this.addShuffledAlbums(list, nArray[n3]);
            ++n3;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.controller.setWaitCursor(this, true);
        this.thumbnails.updateImages(this.access.getAlbumContents(this.access.getAlbumId(treeSelectionEvent.getPath())));
        this.controller.setWaitCursor(this, false);
    }

    public void addToAlbum(AbstractFormat[] abstractFormatArray, TreePath[] treePathArray) {
        Serializer serializer = this.controller.getSerializer();
        boolean bl = Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"MoveToAlbum"), (int)0) == 1;
        boolean bl2 = Serializer.getInt((Object)serializer.getProperty((Object)"AlbumOptions", (Object)"AlbumFolders"), (int)0) == 1;
        String string = (String)serializer.getProperty((Object)"AlbumOptions", (Object)"AlbumRoot");
        int n = 0;
        while (treePathArray != null && n < treePathArray.length) {
            if (bl2) {
                String string2;
                Object[] objectArray = treePathArray[n].getPath();
                String string3 = string == null ? "." + File.separatorChar : string;
                int n2 = 1;
                while (n2 < objectArray.length) {
                    string3 = string3 + File.separator + objectArray[n2];
                    ++n2;
                }
                File file = new File(string3);
                if (!file.exists() && !file.mkdirs()) {
                    System.err.println("Album directory " + string3 + " can not be created, check album root location.");
                }
                if ((string2 = PhotoCollectionPanel.getRenameMask(this, serializer, " " + string3)) == null) break;
                FileNameFormat fileNameFormat = new FileNameFormat(string2, true);
                int n3 = 0;
                while (n3 < abstractFormatArray.length) {
                    File file2 = new File(string3, FileNameFormat.makeValidPathName(fileNameFormat.format(abstractFormatArray[n3])));
                    if (bl && n == 0 && !this.access.belongsToAlbum(abstractFormatArray[n3])) {
                        if (!abstractFormatArray[n3].renameTo(file2)) {
                            System.err.println("Problem in moving file " + abstractFormatArray[n3].getFile() + " to " + file2 + " album.");
                        }
                    } else {
                        try {
                            Controller.copyFile((File)abstractFormatArray[n3].getFile(), (File)file2);
                            abstractFormatArray[n3] = MediaFormatFactory.createMediaFormat(file2);
                        }
                        catch (IOException iOException) {
                            System.err.println("Problem in copying file " + abstractFormatArray[n3].getFile() + " to " + file2 + " album. (" + iOException + ')');
                        }
                    }
                    ++n3;
                }
            }
            this.access.insertMediasToAlbum(this.access.getAlbumId(treePathArray[n]), abstractFormatArray);
            ++n;
        }
    }

    void deletePicture(String string) {
        this.access.deletePicture(this.access.getAlbumId(this.getSelectionPath()), string);
    }

    void setCommentTo(String string, String string2) {
        this.access.setPictureComment(this.access.getAlbumId(this.getSelectionPath()), string, string2);
    }

    public String getCommentOf(String string) {
        return this.access.getPictureComment(this.access.getAlbumId(this.getSelectionPath()), string);
    }

    public void invalidateTree() {
        ((AlbumModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{this.getModel().getRoot()}, null, null);
    }

    public Access getAccess() {
        return this.access;
    }

    void importAlbum(int n, String string, String string2, boolean bl) {
        String[] stringArray = new File(string).list();
        Vector<AbstractFormat> vector = new Vector<AbstractFormat>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file;
            File file2 = new File(string, stringArray[n2]);
            if (file2.isDirectory()) {
                int n3 = this.access.createAlbum(stringArray[n2]);
                this.access.insertAlbumToAlbum(new int[]{n}, n3);
                file = null;
                if (string2 != null) {
                    file = new File(string2, stringArray[n2]);
                    file.mkdirs();
                }
                this.importAlbum(n3, file2.toString(), file == null ? (String)null : file.toString(), bl);
            } else {
                AbstractFormat abstractFormat = MediaFormatFactory.createMediaFormat(file2);
                if (abstractFormat != null && abstractFormat.isValid()) {
                    if (string2 != null) {
                        AbstractFormat abstractFormat2;
                        file = new File(string2, stringArray[n2]);
                        boolean bl2 = false;
                        if (bl) {
                            bl2 = file2.renameTo(file);
                        } else {
                            try {
                                Controller.copyFile((File)file2, (File)file);
                                bl2 = true;
                            }
                            catch (IOException iOException) {
                                System.err.println(iOException);
                            }
                        }
                        if (bl2 && (abstractFormat2 = MediaFormatFactory.createMediaFormat(file)) != null && abstractFormat2.isValid()) {
                            abstractFormat = abstractFormat2;
                        }
                    }
                    vector.addElement(abstractFormat);
                }
            }
            ++n2;
        }
        if (vector.size() > 0) {
            this.access.insertMediasToAlbum(n, vector.toArray(new AbstractFormat[vector.size()]));
        }
    }

    public String getName() {
        return "Album";
    }

    public String toString() {
        return this.getName();
    }

    public Iterator getKeyMnemonics() {
        return Arrays.asList(IRD_NAVIGATIONS).iterator();
    }

    public boolean doAction(String string) {
        return false;
    }

    public void bringOnTop() {
        this.controller.selectTab("Album");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$photoorganizer$renderer$AlbumPane == null ? (class$photoorganizer$renderer$AlbumPane = AlbumPane.class$("photoorganizer.renderer.AlbumPane")) : class$photoorganizer$renderer$AlbumPane).desiredAssertionStatus();
        IRD_NAVIGATIONS = new String[]{"left", "right", "up", "down", "colapse", "open", "select", "act"};
    }

    static class TransferableTreeNode
    implements Transferable {
        public static DataFlavor TREE_NODE_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String", "Media Album");
        private static DataFlavor[] albumNodeFlavors = new DataFlavor[]{TREE_NODE_FLAVOR};
        protected TreePath[] treePaths;
        protected JTree tree;

        TransferableTreeNode(TreePath[] treePathArray, JTree jTree) {
            this.treePaths = treePathArray;
            this.tree = jTree;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return albumNodeFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(albumNodeFlavors[0]);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(albumNodeFlavors[0])) {
                return this;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public TreePath[] getTransferablePaths() {
            return this.treePaths;
        }
    }

    class AlbumRightBtnMenu
    extends JPopupMenu {
        AlbumRightBtnMenu(ActionListener actionListener) {
            AlbumPane.this.controller.getUiUpdater().notify(AlbumPane.this.getSelectionPath() != null, 3);
            JMenuItem jMenuItem = new JMenuItem("To selection");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            this.addSeparator();
            jMenuItem = new JMenuItem("Show/Play");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            this.addSeparator();
            jMenuItem = new JMenuItem("Copy/move");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            this.addSeparator();
            jMenuItem = new JMenuItem("Delete");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            jMenuItem = new JMenuItem("Delete all");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            jMenuItem = new JMenuItem("Rename");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            this.addSeparator();
            JMenu jMenu = new JMenu("Publish");
            jMenuItem = new JMenuItem("This album");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            jMenuItem = new JMenuItem("All albums");
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            this.add(jMenu);
            this.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setEnabled(AlbumPane.this.controller.getUiUpdater().isEnabled(3));
            this.addSeparator();
            jMenuItem = new JMenuItem("Refresh");
            this.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
        }
    }
}

