/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import javazoom.jl.player.AudioDevice;
import javazoom.jl.player.FactoryRegistry;
import javazoom.jl.player.JavaSoundAudioDevice;
import photoorganizer.IrdControllable;
import photoorganizer.formats.AbstractFormat;

public class MediaPlayerPanel
extends JPanel
implements ActionListener,
IrdControllable {
    static final int MS_IN_FRAME = 26;
    protected static final MessageFormat INFO_FMT = new MessageFormat("<html><font size=\"2\" color=\"blue\"><b>Title:</b>{0}<br><b>Artist:</b>{1}<br><b>Album:</b>{2}<br><b>Year:</b>{3}</font><br><font size=\"1\" color=\"black\">{4}</font></html>");
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioDevice audio;
    private volatile boolean closed = false;
    private InputStream inputStream;
    protected boolean autoClose;
    protected boolean play;
    protected JSlider progress;
    protected JButton stop;
    protected JButton resume;
    protected JButton close;
    protected JButton skip;
    protected JButton advanced;
    protected JEditorPane tp_info;
    protected Window window;
    protected WindowListener windowListener;
    protected JPanel advancedPanel;
    protected Map remoteCommandMap;
    protected int mark;

    protected MediaPlayerPanel() throws IOException {
        this(true);
    }

    public MediaPlayerPanel(boolean bl) throws IOException {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.tp_info = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(this.tp_info);
        jPanel.add((Component)jScrollPane, "North");
        jScrollPane.setPreferredSize(new Dimension(200, 60));
        this.tp_info.setContentType("text/html");
        this.tp_info.setEditable(false);
        this.progress = new JSlider();
        jPanel.add((Component)this.progress, "Center");
        this.remoteCommandMap = new HashMap(4);
        this.add((Component)jPanel, "North");
        this.advancedPanel = new JPanel();
        this.advancedPanel.setLayout(new FlowLayout());
        this.advancedPanel.add(new JButton("Mark"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.resume = new JButton("Resume");
        jPanel2.add(this.resume);
        this.resume.addActionListener(this);
        this.resume.setEnabled(false);
        this.remoteCommandMap.put("Resume", this.resume);
        if (bl) {
            this.skip = new JButton("Skip");
            jPanel2.add(this.skip);
            this.skip.addActionListener(this);
            this.skip.setEnabled(false);
            this.remoteCommandMap.put("Skip", this.skip);
        } else {
            this.remoteCommandMap.put("Skip", null);
        }
        this.stop = new JButton("Stop");
        jPanel2.add(this.stop);
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
        this.remoteCommandMap.put("Stop", this.stop);
        this.close = new JButton("Close");
        jPanel2.add(this.close);
        this.close.addActionListener(this);
        this.remoteCommandMap.put("Close", this.close);
        this.advanced = new JButton("Advanced >>");
        jPanel2.add(this.advanced);
        this.add((Component)jPanel2, "Center");
        this.advanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MediaPlayerPanel.this.getComponentCount() > 2) {
                    MediaPlayerPanel.this.remove(MediaPlayerPanel.this.advancedPanel);
                    MediaPlayerPanel.this.advanced.setText("Advanced >>");
                } else {
                    MediaPlayerPanel.this.add((Component)MediaPlayerPanel.this.advancedPanel, "South");
                    MediaPlayerPanel.this.advanced.setText("Normal <<");
                }
                MediaPlayerPanel.this.pack();
            }
        });
        this.progress.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    int n = jSlider.getValue();
                    MediaPlayerPanel.this.stop();
                    MediaPlayerPanel.this.mark = n * 1000 / 26;
                }
            }
        });
    }

    public MediaPlayerPanel(AbstractFormat abstractFormat, Window window, int n) throws IOException {
        this(false);
        this.window = window;
        if (window != null) {
            window.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MediaPlayerPanel.this.window.dispose();
                }

                public void windowClosed(WindowEvent windowEvent) {
                    MediaPlayerPanel.this.close();
                }
            });
        }
        this.replay(abstractFormat, n);
        this.autoClose = true;
    }

    public static MediaPlayerPanel getIrdControllable() {
        try {
            return new MediaPlayerPanel();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized void waitForCompletion() {
        if (!this.play) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void replay(AbstractFormat abstractFormat) throws IOException {
        this.replay(abstractFormat, 0);
    }

    public synchronized WindowListener getWindowListener() {
        if (this.windowListener == null) {
            this.windowListener = new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MediaPlayerPanel.this.close();
                }
            };
        }
        return this.windowListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(final AbstractFormat abstractFormat, final int n) throws IOException {
        if (!this.closed) {
            this.close();
        }
        this.decoder = new Decoder();
        try {
            this.audio = FactoryRegistry.systemRegistry().createAudioDevice();
        }
        catch (Exception exception) {
            throw new IOException("createAudioDevice: " + exception);
        }
        this.progress.setMaximum((int)abstractFormat.getInfo().getLongAttribute("Length"));
        this.resume();
        this.bitstream = new Bitstream(abstractFormat.getAsStream());
        MediaPlayerPanel mediaPlayerPanel = this;
        synchronized (mediaPlayerPanel) {
            this.closed = false;
        }
        this.updateTitle("Now is playing " + abstractFormat.toString());
        this.tp_info.setText(INFO_FMT.format(abstractFormat.getInfo().getFiveMajorAttributes()));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block23: {
                    try {
                        Object object;
                        long l = System.currentTimeMillis();
                        int n3 = 0;
                        int n2 = 0;
                        while (!(n != 0 && n2 >= n || MediaPlayerPanel.this.closed)) {
                            Header header;
                            if (!MediaPlayerPanel.this.play) {
                                object = MediaPlayerPanel.this.audio;
                                synchronized (object) {
                                    MediaPlayerPanel.this.resume.setEnabled(true);
                                    try {
                                        MediaPlayerPanel.this.audio.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                            }
                            if ((header = MediaPlayerPanel.this.bitstream.readFrame()) == null) break;
                            SampleBuffer sampleBuffer = (SampleBuffer)MediaPlayerPanel.this.decoder.decodeFrame(header, MediaPlayerPanel.this.bitstream);
                            if (MediaPlayerPanel.this.mark < n2) {
                                MediaPlayerPanel mediaPlayerPanel = MediaPlayerPanel.this;
                                synchronized (mediaPlayerPanel) {
                                    if (!MediaPlayerPanel.this.audio.isOpen() && MediaPlayerPanel.this.decoder != null) {
                                        AudioFormat audioFormat = new AudioFormat(MediaPlayerPanel.this.decoder.getOutputFrequency(), 16, MediaPlayerPanel.this.decoder.getOutputChannels(), true, false);
                                        ((JavaSoundAudioDevice)MediaPlayerPanel.this.audio).open(audioFormat);
                                        System.err.println("Playing " + abstractFormat + " intro " + n + " header " + header);
                                    }
                                }
                                MediaPlayerPanel.this.audio.write(sampleBuffer.getBuffer(), 0, sampleBuffer.getBufferLength());
                                MediaPlayerPanel.this.progress.setValue(MediaPlayerPanel.this.audio.getPosition() / 1000);
                            }
                            MediaPlayerPanel.this.bitstream.closeFrame();
                            ++n3;
                            ++n2;
                        }
                        if (!MediaPlayerPanel.this.closed) {
                            MediaPlayerPanel.this.audio.flush();
                        }
                        System.err.println("Frames " + n3 + " time " + (System.currentTimeMillis() - l) / 1000L + " audio time " + MediaPlayerPanel.this.audio.getPosition() / 1000);
                        MediaPlayerPanel.this.play = false;
                        object = MediaPlayerPanel.this;
                        synchronized (object) {
                            MediaPlayerPanel.this.notify();
                        }
                        MediaPlayerPanel.this.progress.setValue(0);
                        if (MediaPlayerPanel.this.window != null && MediaPlayerPanel.this.autoClose) {
                            MediaPlayerPanel.this.window.dispose();
                        } else {
                            if (MediaPlayerPanel.this.skip != null) {
                                MediaPlayerPanel.this.skip.setEnabled(false);
                            }
                            MediaPlayerPanel.this.stop.setEnabled(false);
                            MediaPlayerPanel.this.resume.setEnabled(false);
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof JavaLayerException && ((JavaLayerException)throwable).getException() != null) {
                            ((JavaLayerException)throwable).getException().printStackTrace();
                        } else {
                            throwable.printStackTrace();
                        }
                        if (!(throwable instanceof ThreadDeath)) break block23;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
        }, "MediaPlayer " + abstractFormat).start();
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.resume) {
            this.resume();
        } else if (object == this.stop) {
            this.stop();
        } else {
            if (object == this.close) {
                if (this.window != null) {
                    this.window.dispose();
                    this.window = null;
                } else {
                    this.close();
                    this.updateTitle("Closed");
                    this.tp_info.setText("");
                }
                MediaPlayerPanel mediaPlayerPanel = this;
                synchronized (mediaPlayerPanel) {
                    this.notify();
                }
            }
            if (object == this.skip) {
                this.stop();
                MediaPlayerPanel mediaPlayerPanel = this;
                synchronized (mediaPlayerPanel) {
                    this.notify();
                }
            }
        }
    }

    public void stop() {
        if (this.audio != null && this.play) {
            this.play = false;
            this.stop.setEnabled(false);
            if (this.skip != null) {
                this.skip.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (this.audio != null && !this.play) {
            AudioDevice audioDevice = this.audio;
            synchronized (audioDevice) {
                this.play = true;
                this.audio.notify();
            }
            this.stop.setEnabled(true);
            this.close.setEnabled(true);
            if (this.skip != null) {
                this.skip.setEnabled(true);
            }
            this.resume.setEnabled(false);
        }
    }

    public synchronized void close() {
        this.closed = true;
        this.progress.setValue(0);
        this.play = false;
        if (this.audio != null) {
            this.audio.close();
        }
        this.decoder = null;
        if (this.bitstream != null) {
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.stop.setEnabled(false);
        if (this.skip != null) {
            this.skip.setEnabled(false);
        }
        this.resume.setEnabled(false);
        this.close.setEnabled(false);
        this.notify();
    }

    public String getName() {
        return "Media Player";
    }

    public String toString() {
        return this.getName();
    }

    public Iterator getKeyMnemonics() {
        return this.remoteCommandMap.keySet().iterator();
    }

    public boolean doAction(String string) {
        System.err.println("MP:Doing action " + string);
        if (this.remoteCommandMap.get(string) == null) {
            return false;
        }
        this.actionPerformed(new ActionEvent(this.remoteCommandMap.get(string), string.hashCode(), string));
        return true;
    }

    public void bringOnTop() {
        this.requestFocus();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
        }
    }

    public void updateTitle(String string) {
        Container container = this.getTopLevelAncestor();
        if (container != null && container instanceof Frame) {
            ((Frame)container).setTitle(string);
        }
    }

    protected void pack() {
        Container container = this.getTopLevelAncestor();
        if (container != null && container instanceof Frame) {
            ((Frame)container).pack();
        } else {
            this.doLayout();
        }
    }
}

