/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import photoorganizer.Controller;
import photoorganizer.IrdControllable;
import photoorganizer.Resources;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.Observable;
import photoorganizer.renderer.ThumbnailsPanel;
import rogatkin.Serializer;

public class PhotoImagePanel
extends JPanel
implements ActionListener,
Observable,
IrdControllable {
    private JScrollPane scroller;
    private Observable iviewer;
    private ThumbnailsPanel thumbspanel;
    private Controller controller;
    private BasicJpeg jpeg;

    public PhotoImagePanel(Controller controller) {
        this.controller = controller;
        this.setLayout(new BorderLayout());
        this.scroller = new JScrollPane(new ImageComponent());
        this.add((Component)this.scroller, "Center");
        this.setMinimumSize(Resources.MIN_PANEL_DIMENSION);
    }

    public void setThumbnailsPanel(ThumbnailsPanel thumbnailsPanel) {
        this.thumbspanel = thumbnailsPanel;
    }

    public void update(Icon icon) {
        if (this.iviewer == null || this.iviewer == this) {
            if (icon instanceof ImageIcon) {
                ((ImageIcon)icon).setImage(this.getScaled(((ImageIcon)icon).getImage()));
            }
            ((Observable)((Object)this.scroller.getViewport().getView())).update(icon);
        } else {
            if (this.iviewer instanceof ImageFrame) {
                ((ImageFrame)this.iviewer).setTitle("MediaChest version 1.1 - " + this.jpeg.getLocationName());
            }
            this.iviewer.update(icon);
        }
    }

    public void updateView(AbstractFormat abstractFormat) {
        Container container;
        if (abstractFormat instanceof BasicJpeg) {
            this.jpeg = (BasicJpeg)abstractFormat;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Icon icon = PhotoImagePanel.this.jpeg.getIcon();
                    if (icon != null) {
                        PhotoImagePanel.this.update(icon);
                    }
                }
            });
        }
        if ((container = this.getParent()) != null && container instanceof JTabbedPane) {
            ((JTabbedPane)container).setSelectedComponent(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PopUp")) {
            if (this.iviewer != null) {
                if (this.iviewer instanceof ImageFrame) {
                    return;
                }
                if (this.iviewer instanceof ImageWindow) {
                    ((Window)((Object)this.iviewer)).dispose();
                }
            }
            this.iviewer = new ImageFrame("MediaChest version 1.1 - " + this.jpeg.getLocationName());
        } else if (string.equals("GetBack")) {
            if (this.iviewer != null && this.iviewer != this) {
                ((Window)((Object)this.iviewer)).dispose();
                this.iviewer = null;
            }
        } else if (string.equals("FullScreen")) {
            if (this.iviewer != null) {
                if (this.iviewer instanceof ImageWindow) {
                    return;
                }
                if (this.iviewer instanceof ImageFrame) {
                    ((Window)((Object)this.iviewer)).dispose();
                }
            }
            this.iviewer = new ImageWindow();
        } else if (string.equals("Next")) {
            this.thumbspanel.showNext();
        } else if (string.equals("Prev")) {
            this.thumbspanel.showPrev();
        }
    }

    protected Image getScaled(Image image) {
        if (!this.isScaling()) {
            return image;
        }
        Dimension dimension = this.getSize();
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        if (n <= dimension.width && n2 < dimension.height) {
            return image;
        }
        if (n / dimension.width > n2 / dimension.height) {
            return image.getScaledInstance(dimension.width, n2 * dimension.width / n, 4);
        }
        return image.getScaledInstance(n * dimension.height / n2, dimension.height, 2);
    }

    protected boolean isScaling() {
        Serializer serializer = this.controller.getSerializer();
        return Serializer.getInt((Object)serializer.getProperty((Object)"AppearanceOptions", (Object)"FitToSize"), (int)0) == 1;
    }

    protected void trigger() {
        if (this.iviewer != null && this.iviewer != this) {
            ((Window)((Object)this.iviewer)).dispose();
            this.iviewer = null;
        } else {
            this.iviewer = new ImageFrame("MediaChest version 1.1 - " + this.jpeg.getLocationName());
        }
    }

    public String getName() {
        return "Image Viewer";
    }

    public Iterator getKeyMnemonics() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add("FullScreen");
        arrayList.add("Next");
        arrayList.add("Prev");
        return arrayList.iterator();
    }

    public boolean doAction(String string) {
        this.actionPerformed(new ActionEvent(this, string.hashCode(), string));
        return true;
    }

    public void bringOnTop() {
    }

    static /* synthetic */ ThumbnailsPanel access$200(PhotoImagePanel photoImagePanel) {
        return photoImagePanel.thumbspanel;
    }

    class ImageWindow
    extends JWindow
    implements Observable {
        public ImageWindow() {
            this.getContentPane().add(PhotoImagePanel.this.scroller);
            this.pack();
            this.setVisible(true);
            this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
            PhotoImagePanel.this.scroller.getViewport().getView().requestFocus();
        }

        public void update(Icon icon) {
            ((Observable)((Object)PhotoImagePanel.this.scroller.getViewport().getView())).update(icon);
        }

        public void dispose() {
            PhotoImagePanel.this.iviewer = PhotoImagePanel.this;
            PhotoImagePanel.this.add(PhotoImagePanel.this.scroller);
            PhotoImagePanel.this.revalidate();
            super.dispose();
        }
    }

    class ImageFrame
    extends JFrame
    implements Observable {
        public ImageFrame(String string) {
            super(string);
            this.getContentPane().add(PhotoImagePanel.this.scroller);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setVisible(true);
            this.setIconImage(PhotoImagePanel.this.controller.getMainIcon());
            PhotoImagePanel.this.scroller.getViewport().getView().requestFocus();
        }

        public void dispose() {
            PhotoImagePanel.this.iviewer = PhotoImagePanel.this;
            PhotoImagePanel.this.add(PhotoImagePanel.this.scroller);
            PhotoImagePanel.this.revalidate();
            super.dispose();
        }

        public void update(Icon icon) {
            ((Observable)((Object)PhotoImagePanel.this.scroller.getViewport().getView())).update(icon);
        }
    }

    class ImageComponent
    extends JLabel
    implements Observable {
        public ImageComponent() {
            super(new ImageIcon());
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ ImageComponent this$1;
                {
                    this.this$1 = imageComponent;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if (mouseEvent.getClickCount() == 2 && (n & 0x10) > 0) {
                        ImageComponent.access$100(this.this$1).trigger();
                    } else if ((n & 4) > 0) {
                        Point point = ((JViewport)this.this$1.getParent()).getViewPosition();
                        this.this$1.new ImageRButtonMenu(ImageComponent.access$100(this.this$1)).show(this.this$1.getParent(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ ImageComponent this$1;
                {
                    this.this$1 = imageComponent;
                }

                public void keyReleased(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 33: 
                        case 109: {
                            PhotoImagePanel.access$200(ImageComponent.access$100(this.this$1)).showPrev();
                            break;
                        }
                        case 34: 
                        case 107: {
                            PhotoImagePanel.access$200(ImageComponent.access$100(this.this$1)).showNext();
                        }
                    }
                }
            });
        }

        public void update(Image image) {
            if (image == null) {
                return;
            }
            PhotoImagePanel.this.controller.setWaitCursor(this, true);
            ((ImageIcon)this.getIcon()).setImage(image);
            this.revalidate();
            this.repaint();
            Serializer serializer = PhotoImagePanel.this.controller.getSerializer();
            String string = Serializer.arrayToString((Object)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"ToolTipMask"));
            if (string != null) {
                this.setToolTipText(new FileNameFormat(string).format(PhotoImagePanel.this.jpeg));
            }
            this.requestFocus();
        }

        public void update(Icon icon) {
            if (icon == null) {
                return;
            }
            PhotoImagePanel.this.controller.setWaitCursor(this, true);
            this.setIcon(icon);
            this.revalidate();
            Serializer serializer = PhotoImagePanel.this.controller.getSerializer();
            String string = Serializer.arrayToString((Object)serializer.getProperty((Object)"ThumbnailsOptions", (Object)"ToolTipMask"));
            if (string != null) {
                this.setToolTipText(new FileNameFormat(string).format(PhotoImagePanel.this.jpeg));
            }
            this.requestFocus();
        }

        public void paint(Graphics graphics) {
            try {
                super.paint(graphics);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            PhotoImagePanel.this.controller.setWaitCursor(this, false);
        }

        static /* synthetic */ PhotoImagePanel access$100(ImageComponent imageComponent) {
            return imageComponent.PhotoImagePanel.this;
        }

        class ImageRButtonMenu
        extends JPopupMenu {
            ImageRButtonMenu(ActionListener actionListener) {
                JMenuItem jMenuItem = new JMenuItem("PopUp");
                this.add(jMenuItem);
                jMenuItem.addActionListener(actionListener);
                jMenuItem = new JMenuItem("GetBack");
                this.add(jMenuItem);
                jMenuItem.addActionListener(actionListener);
                jMenuItem = new JMenuItem("FullScreen");
                this.add(jMenuItem);
                jMenuItem.addActionListener(actionListener);
                this.addSeparator();
                jMenuItem = new JMenuItem("Next");
                this.add(jMenuItem);
                jMenuItem.addActionListener(actionListener);
                jMenuItem = new JMenuItem("Prev");
                this.add(jMenuItem);
                jMenuItem.addActionListener(actionListener);
            }
        }
    }
}

