/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.Address;
import addressbook.Chat;
import addressbook.EMail;
import addressbook.GenericAttribute;
import addressbook.Link;
import addressbook.Name;
import addressbook.PGP;
import addressbook.Telephone;
import addressbook.XMLSaver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import rogatkin.HttpUtils;

public class Contact
extends XMLSaver {
    Name name;
    String title;
    Date dob;
    Vector addresses;
    Vector emails;
    Vector links;
    Vector chats;
    Vector pgps;
    Vector comments;
    Vector telephones;
    static final SimpleDateFormat DOB_XML_FMT = new SimpleDateFormat("'YEAR=\"'yyyy'\" MONTH=\"'MM'\" DAY=\"'dd'\"'");

    public Contact() {
    }

    public Contact(Name name) {
        this.name = name;
    }

    public void setValue(Object object) {
        if (object instanceof Name) {
            this.name = (Name)object;
        }
    }

    public void setDOB(Date date) {
        this.dob = date;
    }

    public Date getDOB() {
        return this.dob;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public Name getName() {
        return this.name;
    }

    public void add(Address address) {
        if (this.addresses == null) {
            this.addresses = new Vector();
        }
        this.addresses.addElement(address);
    }

    public Address remove(Address address) {
        if (this.addresses != null && this.addresses.remove(address)) {
            return address;
        }
        return null;
    }

    public Vector getAddresses() {
        return this.addresses;
    }

    public void add(Telephone telephone) {
        if (this.telephones == null) {
            this.telephones = new Vector();
        }
        this.telephones.addElement(telephone);
    }

    public Telephone remove(Telephone telephone) {
        if (this.telephones != null && this.telephones.remove(telephone)) {
            return telephone;
        }
        return null;
    }

    public Vector getTelephones() {
        return this.telephones;
    }

    public void add(EMail eMail) {
        if (this.emails == null) {
            this.emails = new Vector();
        }
        this.emails.addElement(eMail);
    }

    public EMail remove(EMail eMail) {
        if (this.emails != null && this.emails.remove(eMail)) {
            return eMail;
        }
        return null;
    }

    public Vector getEMails() {
        return this.emails;
    }

    public void add(Link link) {
        if (this.links == null) {
            this.links = new Vector();
        }
        this.links.addElement(link);
    }

    public Link remove(Link link) {
        if (this.links != null && this.links.remove(link)) {
            return link;
        }
        return null;
    }

    public Vector getLinks() {
        return this.links;
    }

    public void add(Chat chat) {
        if (this.chats == null) {
            this.chats = new Vector();
        }
        this.chats.addElement(chat);
    }

    public Chat remove(Chat chat) {
        if (this.chats != null && this.chats.remove(chat)) {
            return chat;
        }
        return null;
    }

    public Vector getChats() {
        return this.chats;
    }

    public void add(PGP pGP) {
        if (this.pgps == null) {
            this.pgps = new Vector();
        }
        this.pgps.addElement(pGP);
    }

    public PGP remove(PGP pGP) {
        if (this.pgps != null && this.pgps.remove(pGP)) {
            return pGP;
        }
        return null;
    }

    public Vector getPGPs() {
        return this.pgps;
    }

    public void add(String string) {
        if (this.comments == null) {
            this.comments = new Vector();
        }
        if (string != null && string.trim().length() > 0) {
            this.comments.addElement(string);
        }
    }

    public String remove(String string) {
        if (this.comments != null && this.comments.remove(string)) {
            return string;
        }
        return null;
    }

    public Vector getComments() {
        return this.comments;
    }

    public void add(Object object) {
        if (object instanceof Address) {
            this.add((Address)object);
        } else if (object instanceof Telephone) {
            this.add((Telephone)object);
        } else if (object instanceof EMail) {
            this.add((EMail)object);
        } else if (object instanceof Link) {
            this.add((Link)object);
        } else if (object instanceof Chat) {
            this.add((Chat)object);
        } else if (object instanceof PGP) {
            this.add((PGP)object);
        } else if (object instanceof String) {
            this.add((String)object);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            while (n < vector.size()) {
                this.add(vector.elementAt(n));
                ++n;
            }
        }
    }

    protected void saveVecXML(Vector vector, OutputStream outputStream, String string) throws IOException, UnsupportedEncodingException {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            ((GenericAttribute)vector.elementAt(n)).saveXML(outputStream, string, n);
            ++n;
        }
    }

    public void saveXML(OutputStream outputStream, String string, int n) throws IOException, UnsupportedEncodingException {
        outputStream.write("<PERSON>".getBytes(string));
        this.name.saveXML(outputStream, string, 0);
        if (this.dob != null) {
            outputStream.write("<DOB ".getBytes(string));
            outputStream.write(DOB_XML_FMT.format(this.dob).getBytes(string));
            outputStream.write("/>".getBytes(string));
        }
        this.saveVecXML(this.addresses, outputStream, string);
        this.saveVecXML(this.emails, outputStream, string);
        this.saveVecXML(this.links, outputStream, string);
        this.saveVecXML(this.chats, outputStream, string);
        this.saveVecXML(this.pgps, outputStream, string);
        this.saveVecXML(this.telephones, outputStream, string);
        if (this.comments != null) {
            int n2 = 0;
            while (n2 < this.comments.size()) {
                outputStream.write(("<COMMENT ORDER=\"" + n2 + "\">").getBytes(string));
                outputStream.write(HttpUtils.htmlEncode((String)((String)this.comments.elementAt(n2))).getBytes(string));
                outputStream.write("</COMMENT>".getBytes(string));
                ++n2;
            }
        }
        outputStream.write("</PERSON>".getBytes(string));
    }
}

