/* PhotoOrganizer - $RCSfile: MediaAccess.java,v $                               
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.                         
 * Redistribution and use in source and binary forms, with or without                 
 * modification, are permitted provided that the following conditions                 
 * are met:                                                                           
 * 1. Redistributions of source code must retain the above copyright                  
 *    notice, this list of conditions and the following disclaimer.                   
 * 2. Redistributions in binary form must reproduce the above copyright               
 *    notice, this list of conditions and the following disclaimer in the             
 *    documentation and/or other materials provided with the distribution.            
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND            
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE             
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE        
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR        
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL            
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR        
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER        
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT                
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY         
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF            
 *  SUCH DAMAGE.                                                                      
 *                                                                                    
 *  Visit http://drogatkin.openestate.net to get the latest infromation               
 *  about Rogatkin's products.                                                        
 *  $Id: MediaAccess.java,v 1.2 2001/06/27 20:22:44 rogatkin Exp $                
 */                                                                                   

package photoorganizer.album;
import java.sql.*;
import java.io.File;
import java.util.Vector;
import java.util.Calendar;
//import javax.swing.tree.TreePath;

import rogatkin.*;
import photoorganizer.Controller;
//import photoorganizer.Resources;
//import photoorganizer.renderer.*;
import photoorganizer.formats.*;

/** this class extends basic database operation for music content
 */
public class MediaAccess extends Access { 
	
	static final String MEDIAS_DATABASE = "Medias";         
	static final String [][]MEDIAS_DATABASE_STRUCTURE = {     
		{"MediaId", " INTEGER NOT NULL,"},                        
		{"Name", " CHAR(255) NOT NULL,"},                       
		{"LocId", " INTEGER,"},
		{"TempLoc", " CHAR,"},       
		{"ChkSum", " INTEGER,"},     
		{"Length", " INTEGER,"},   
		{"Artist", " CHAR(255),"},   
		{"Year", " TIMESTAMP,"},     
		{"Title", " CHAR(255),"},    
		{"Album", " CHAR(100),"},    
		{"Genre", " INTEGER,"}, // TINYINT 
		{"Quality", " CHAR(10),"},   
		{"Composer", " CHAR(100),"},
		{"Conductor", " CHAR(100),"},
		{"Band", " CHAR(100),"},
		{"Lyricist", " CHAR(100),"},
		{"Type", " INTEGER,"}, //TINYINT 
		{"Commentary", " CHAR(255)"} 
		//",PRIMARY KEY (MediaId),"+   
		//"UNIQUE (MediaId)"+          
	};                                                          
	static final int MEDIAS_MEDIAID = 0;                        
	static final int MEDIAS_NAME = 1;                         
	static final int MEDIAS_LOCID = 2;
	static final int MEDIAS_TEMPLOC = 3;                        
	static final int MEDIAS_CHKSUM = 4;                       
	static final int MEDIAS_LENGTH = 5;                         
	static final int MEDIAS_ARTIST = 6;                      
	static final int MEDIAS_YEAR = 7;                      
	static final int MEDIAS_TITLE = 8;                     
	static final int MEDIAS_ALBUM = 9;                        
	static final int MEDIAS_GENRE = 10;                         
	static final int MEDIAS_QUALITY = 11;                     
	static final int MEDIAS_COMPOSER = 12;                        
	static final int MEDIAS_CONDUCTOR = 13;                       
	static final int MEDIAS_BAND = 14;                  
	static final int MEDIAS_LYRICIST = 15;                       
	static final int MEDIAS_TYPE = 16;                       
	static final int MEDIAS_COMMENTARY = 17;                  
	
	static final String IDENTIFIERS_TABLE = "Identifiers";
    
	static final String [] TABLES = {PICTURES_DATABASE, MEDIAS_DATABASE,
        CONNECTION_DATABASE, ALBUM_DATABASE,
        GROUPS_DATABASE, LOCATIONS_DATABASE, };

    // better approach is to create a hashtable and use table as a key to description
    static final String [][][] DESCRIPTIONS = {PICTURES_DATABASE_STRUCTURE, MEDIAS_DATABASE_STRUCTURE,
        CONNECTION_DATABASE_STRUCTURE, ALBUM_DATABASE_STRUCTURE,
        GROUPS_DATABASE_STRUCTURE, LOCATIONS_DATABASE_STRUCTURE};
	
	public MediaAccess(Controller controller) {
		super(controller);
	}
	
	protected String[] getTables() {
		String [] result = new String[TABLES.length + 1];
		System.arraycopy(TABLES, 0, result, 0, TABLES.length);
		result[TABLES.length] = IDENTIFIERS_TABLE;
		return result;
	}
	
	protected String[][][] getDescriptions() {
		String[][][] result = new String[DESCRIPTIONS.length + 1][][];
		System.arraycopy(DESCRIPTIONS, 0, result, 0, DESCRIPTIONS.length);
		String [][]idents = new String[TABLES.length][];
		for (int i=0; i<TABLES.length-1; i++)
			idents[i] = new String[] {TABLES[i], " INTEGER,"};
		idents[TABLES.length-1] = new String[] {TABLES[TABLES.length-1], " INTEGER"};
		result[TABLES.length] = idents;
		return result;
	}
	
	// we allow to exist different medias in the same album
	public void insertMediasToAlbum(int album, AbstractFormat []medias) {
		// find out only images first
		boolean wasImage = false;
		boolean wasAudio = false;
		Vector otherKind = null;
		int r=0;
		for (int f=0; f<medias.length; f++) {
			if (MP3.TYPE.equals(medias[f].getType())){
				if (wasImage) {// mixed
					if (otherKind == null) {
						otherKind = new Vector();
						r = f;
					}
					otherKind.addElement(medias[f]);					
				} else {
					wasAudio = true;
					if (r < f)
						medias[r] = medias[f];
					r++;
				}
			} else {
				if(wasAudio) {// mixed
					if (otherKind == null) {
						otherKind = new Vector();
						r = f;
					}
					otherKind.addElement(medias[f]);
				} else {
					wasImage = true;
					if (r < f)
						medias[r] = medias[f];
					r++;
				}
			}
		}
		if (wasImage) {
			if (r < medias.length && otherKind != null /* !? too strong */) {
				BasicJpeg []res = new BasicJpeg[r];
				System.arraycopy(medias, 0, res, 0, r);
				insertPicturesToAlbum(album, res);
				insertAudiosToAlbum(album, (AbstractFormat [])otherKind.toArray(new AbstractFormat [otherKind.size()]));
			} else
				insertPicturesToAlbum(album, medias);
		} else if (wasAudio) {
			if (r < medias.length && otherKind != null /* !? too strong */) {
				AbstractFormat []res = new AbstractFormat[r];
				System.arraycopy(medias, 0, res, 0, r);
				insertAudiosToAlbum(album, res);
				insertPicturesToAlbum(album, (AbstractFormat[])otherKind.toArray(new AbstractFormat [otherKind.size()]));
			} else
				insertAudiosToAlbum(album, medias);
		}			
	}
	
	public synchronized void insertAudiosToAlbum(int album, AbstractFormat []medias) {
		final String INSERTAUDIOSTOALBUM_1 = SQL_INSERT+LOCATIONS_DATABASE+" ("+
			LOCATIONS_DATABASE_STRUCTURE[LOCATIONS_LOCID][0]+','+
			LOCATIONS_DATABASE_STRUCTURE[LOCATIONS_DISK][0]+") VALUES (";
		final String INSERTAUDIOSTOALBUM_2 = SQL_INSERT+MEDIAS_DATABASE+" (";

		final String INSERTAUDIOSTOALBUM_3 = SQL_INSERT+CONNECTION_DATABASE+" ("+
			CONNECTION_DATABASE_STRUCTURE[CONNECTION_PICID][0]+','+
			CONNECTION_DATABASE_STRUCTURE[CONNECTION_ALBUMID][0]+','+
			CONNECTION_DATABASE_STRUCTURE[CONNECTION_SEQNUMBER][0]+") VALUES (";
		// move code below to constant part
		StringBuffer fieldparts = new StringBuffer(MEDIAS_DATABASE_STRUCTURE[0][0]);
		StringBuffer valueparts = new StringBuffer(" VALUES (?");
		for (int i=1; i<MEDIAS_DATABASE_STRUCTURE.length; i++) {
			fieldparts.append(',').append(MEDIAS_DATABASE_STRUCTURE[i][0]);
			valueparts.append(",?");
		}
		fieldparts.append(')');
		valueparts.append(')');
		PreparedStatement pstmt;
		Statement stmt;
		try {
			pstmt = getAvailableConnection().prepareStatement(INSERTAUDIOSTOALBUM_2+fieldparts.toString()+valueparts.toString());
			stmt = getAvailableConnection().createStatement();
		} catch (SQLException ex) {
			printChainedSqlException(ex);
			return;
		}
		for (int i=0; i<medias.length; i++) {
			try {
				// cross pic/media tables unique id
				int medid = generateUniqueId(PICTURES_DATABASE, MEDIAS_DATABASE_STRUCTURE[MEDIAS_MEDIAID][0]);
				if (medid == -1) 
					continue;
				AbstractInfo ai = medias[i].getInfo();
				if (ai == null)
					continue;
				pstmt.setInt(MEDIAS_MEDIAID+1, medid);
				// note database field index start from 1
				for (int k=2; k<=MEDIAS_DATABASE_STRUCTURE.length; k++) {
					try {
						switch(k-1) {
							case MEDIAS_NAME:
								pstmt.setString(k, medias[i].getFile().getPath());
								break;
							case MEDIAS_LOCID:
								pstmt.setInt(k, 0);
								break;
							case MEDIAS_TEMPLOC:
								pstmt.setString(k, "N");
								break;
							case MEDIAS_CHKSUM:
								pstmt.setInt(k, 0);
								break;
							case MEDIAS_LENGTH:
								try {
									pstmt.setInt(k, (int)ai.getLongAttribute(AbstractInfo.LENGTH));
								} catch(Exception ie) {
									pstmt.setLong(k, -1);
								}
								break;
							case MEDIAS_ARTIST:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.ARTIST).toString());
								break;
							case MEDIAS_YEAR:
								Calendar calendar   = Calendar.getInstance();
								try {
									calendar.set(  Calendar.YEAR,  ai.getIntAttribute(AbstractInfo.YEAR));
								} catch(Exception ie) {
									calendar.set(  Calendar.YEAR, 1970 );
								}
								pstmt.setTimestamp(k, new Timestamp(calendar.getTime().getTime()));
								break;
							case MEDIAS_TITLE:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.TITLE).toString());
								break;
							case MEDIAS_ALBUM:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.ALBUM).toString());
								break;
							case MEDIAS_GENRE:
								try {
									pstmt.setInt(k, ai.getIntAttribute(AbstractInfo.GENRE));
									//pstmt.setByte(k, 255&ai.getIntAttribute(AbstractInfo.GENRE));
								} catch(Exception ie) {
									pstmt.setInt(k, -1);
								}
								break;
							case MEDIAS_QUALITY:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.ESS_QUALITY).toString());
								break;
							case MEDIAS_COMPOSER:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.COMPOSER).toString());
								break;
							case MEDIAS_CONDUCTOR:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.CONDUCTOR).toString());
								break;
							case MEDIAS_BAND:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.BAND).toString());
								break;
							case MEDIAS_LYRICIST:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.LYRICIST).toString());
								break;

							case MEDIAS_TYPE:
								try {
									pstmt.setInt(k, ai.getIntAttribute(AbstractInfo.MPEGLEVEL));
								} catch(Exception ie) {
									pstmt.setInt(k, -1);
								}
								break;
							case MEDIAS_COMMENTARY:
								pstmt.setString(k, ai.getAttribute(AbstractInfo.COMMENTS).toString());
								break;
							default:
								pstmt.setObject(k, null);
						}
					} catch(Exception e) {
						pstmt.setString(k, "");						
					}
				}
				pstmt.executeUpdate();
				stmt.executeUpdate(INSERTAUDIOSTOALBUM_3+medid+','+album+','+i+')');
			} catch (SQLException ex) {
				System.err.println(INSERTAUDIOSTOALBUM_2+fieldparts.toString()+valueparts.toString());
				printChainedSqlException(ex);
			}
		}
		try {
			pstmt.close();
			stmt.close();
		} catch (SQLException ex) {
			printChainedSqlException(ex);
		}		
	}

	public boolean belongsToAlbum(AbstractFormat format) {
		final String BELONGSTOALBUM_1 = SQL_SELECT+
			MEDIAS_DATABASE_STRUCTURE[MEDIAS_NAME][0]+SQL_FROM+
			MEDIAS_DATABASE+SQL_WHERE+
			MEDIAS_DATABASE_STRUCTURE[MEDIAS_NAME][0]+'=';		
		if (format == null)
			return false;
		if (super.belongsToAlbum(format))
			return true;
		try {
			boolean belongs;
			Statement stmt = getAvailableConnection().createStatement();
			ResultSet rs = stmt.executeQuery(BELONGSTOALBUM_1+SQLQuote(format.getFile().getPath())); // getUrl could be better
			belongs = rs.next();
			rs.close();
			stmt.close();
			return belongs;
		} catch (SQLException ex) {
			printChainedSqlException(ex);
			return false;
		}		
	}

	public File[] getAlbumContents(int album) {
		final String []GETALBUMSCONTENTS = { 
			SQL_SELECT+PICTURES_DATABASE_STRUCTURE[PICTURES_NAME][0]+SQL_FROM+
			CONNECTION_DATABASE+','+PICTURES_DATABASE+SQL_WHERE+
			CONNECTION_DATABASE+'.'+CONNECTION_DATABASE_STRUCTURE[CONNECTION_PICID][0]+'='+
			PICTURES_DATABASE+'.'+PICTURES_DATABASE_STRUCTURE[PICTURES_PICID][0]+SQL_AND+
			CONNECTION_DATABASE_STRUCTURE[CONNECTION_ALBUMID][0]+'=',
			
			SQL_SELECT+MEDIAS_DATABASE_STRUCTURE[MEDIAS_NAME][0]+SQL_FROM+
			CONNECTION_DATABASE+','+MEDIAS_DATABASE+SQL_WHERE+
			CONNECTION_DATABASE+'.'+CONNECTION_DATABASE_STRUCTURE[CONNECTION_PICID][0]+'='+
			MEDIAS_DATABASE+'.'+MEDIAS_DATABASE_STRUCTURE[MEDIAS_MEDIAID][0]+SQL_AND+
			CONNECTION_DATABASE_STRUCTURE[CONNECTION_ALBUMID][0]+'='}; 
		final String []GETALBUMSCONTENTS_ENDS = { 
			"",
			SQL_ORDERBY  + CONNECTION_DATABASE_STRUCTURE[CONNECTION_SEQNUMBER][0] + SQL_ASC};
					
		File [] result = new File[0];
		Statement stmt = null;
		ResultSet rs = null;
		for (int i=0; i<GETALBUMSCONTENTS.length; i++)
			try {
				stmt = getAvailableConnection().createStatement();
				rs = stmt.executeQuery(GETALBUMSCONTENTS[i]+album+GETALBUMSCONTENTS_ENDS[i]);
				while(rs.next()) {
					File[] _tf = new File[result.length+1];
					System.arraycopy(result, 0, _tf, 0, result.length);
					_tf[result.length] = new File(rs.getString(1).trim());
					result = _tf;
				}
			} catch (SQLException ex) {
				System.err.println(GETALBUMSCONTENTS[i]+album+GETALBUMSCONTENTS_ENDS[i]);
				printChainedSqlException(ex);
			} finally {
				try {
					rs.close();
				} catch(Exception e){
				}
				try {
					stmt.close();
				} catch(Exception e){
				}				
			}
		return result;
	}
	
	synchronized int generateUniqueId(String database, String field) {
		int result = 1;
		Statement stmt = null;
		ResultSet rs = null;
		try {
			stmt = getAvailableConnection().createStatement();
			stmt.setMaxRows(1);
			rs = stmt.executeQuery (SQL_SELECT+database+SQL_FROM+IDENTIFIERS_TABLE);
			if(rs.next()) {
				result = rs.getInt(1);
				stmt.executeUpdate(SQL_UPDATE+IDENTIFIERS_TABLE+SQL_SET+database+'='+
								   (result+1)+
								   (rs.wasNull()?"":SQL_WHERE+database+'='+result));
				result++;
			} else {
				stmt.executeUpdate(SQL_INSERT+IDENTIFIERS_TABLE+" ("+database+") VALUES("+
								   result+')');
			}
		} catch (SQLException ex) {
			printChainedSqlException(ex);
		} finally {
			try {
				rs.close();
			} catch(Exception e){
			}
			try {
				stmt.close();
			} catch(Exception e){
			}				
		}
		return result;
	}
	
	public synchronized void deletePicture(int mediaId) {
		final String DELETEMEDIA = SQL_DELETE+SQL_FROM+MEDIAS_DATABASE+
			SQL_WHERE+MEDIAS_DATABASE_STRUCTURE[MEDIAS_MEDIAID][0]+'=';
		super.deletePicture(mediaId);
		
		Statement stmt = null;
		try {
			stmt = getAvailableConnection().createStatement();
			stmt.executeUpdate(DELETEMEDIA+mediaId);
		} catch (SQLException ex) {
			printChainedSqlException(ex);
			System.err.println("For queries "+DELETEMEDIA+mediaId);
		} finally {
			try {
				stmt.close();
			} catch(Exception e) {
			}
		}		
	}
	
    public synchronized void deletePicture(int album, String name) {
        final String DELETEMEDIA_1 = SQL_SELECT+
            CONNECTION_DATABASE+'.'+CONNECTION_DATABASE_STRUCTURE[CONNECTION_PICID][0]+SQL_FROM+
            CONNECTION_DATABASE+','+MEDIAS_DATABASE+SQL_WHERE+
            CONNECTION_DATABASE+'.'+CONNECTION_DATABASE_STRUCTURE[CONNECTION_PICID][0]+'='+
            MEDIAS_DATABASE+'.'+MEDIAS_DATABASE_STRUCTURE[MEDIAS_MEDIAID][0]+SQL_AND+
            CONNECTION_DATABASE+'.'+CONNECTION_DATABASE_STRUCTURE[CONNECTION_ALBUMID][0]+'=';
        final String DELETEMEDIA_2 = SQL_AND+
            MEDIAS_DATABASE+'.'+MEDIAS_DATABASE_STRUCTURE[MEDIAS_NAME][0]+"=";

        final String DELETEMEDIA_3 = SQL_DELETE+SQL_FROM+
            CONNECTION_DATABASE+
            SQL_WHERE+CONNECTION_DATABASE_STRUCTURE[CONNECTION_PICID][0]+'=';
        final String DELETEMEDIA_4 = " AND "+
            CONNECTION_DATABASE_STRUCTURE[CONNECTION_ALBUMID][0]+'=';
		super.deletePicture(album, name);
		Statement stmt = null;
		ResultSet rs = null;
		Statement stmt2 = null;
        try {
            stmt = getAvailableConnection().createStatement();
            rs = stmt.executeQuery(DELETEMEDIA_1+album+DELETEMEDIA_2+SQLQuote(name));
            if(rs.next()) { // should be one pair only
                stmt2 = getAvailableConnection().createStatement();
                stmt.executeUpdate(DELETEMEDIA_3+rs.getInt(1)+DELETEMEDIA_4+album);
                stmt2.close();
				stmt2 = null;
            }
        } catch (SQLException ex) {
            printChainedSqlException(ex);
            System.err.println("For queries "+DELETEMEDIA_1+album+DELETEMEDIA_2+'\''+name+"'\n"+
                DELETEMEDIA_3+'?'+DELETEMEDIA_4+album);
		} finally {
			try {
				stmt2.close();
			} catch(Exception e) {
			}
			try {
				rs.close();
			} catch(Exception e) {
			}
			try {
				stmt.close();
			} catch(Exception e) {
			}
		}
    }	
}
