/* PhotoOrganizer - $RCSfile: BaseConfigurableTableModel.java,v $                           
 * Copyright (C) 2001 Dmitriy Rogatkin.  All rights reserved.                    
 * Redistribution and use in source and binary forms, with or without            
 * modification, are permitted provided that the following conditions            
 * are met:                                                                      
 * 1. Redistributions of source code must retain the above copyright             
 *    notice, this list of conditions and the following disclaimer.              
 * 2. Redistributions in binary form must reproduce the above copyright          
 *    notice, this list of conditions and the following disclaimer in the        
 *    documentation and/or other materials provided with the distribution.       
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND       
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE        
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE   
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR   
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL       
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR   
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER   
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT           
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF       
 *  SUCH DAMAGE.                                                                 
 *                                                                               
 *  Visit http://drogatkin.openestate.net to get the latest infromation          
 *  about Rogatkin's products.                                                   
 *  $Id: BaseConfigurableTableModel.java,v 1.3 2001/07/19 07:58:31 rogatkin Exp $            
 */             
package photoorganizer.renderer;
import java.io.File;
import java.util.Date;
import java.text.DateFormat;
import javax.swing.table.AbstractTableModel;

import photoorganizer.Resources;
import photoorganizer.Controller;
import rogatkin.Serializer;
import photoorganizer.formats.*;

public abstract class BaseConfigurableTableModel extends AbstractTableModel {
	// The the returned file length for directories. 
	public static final Long ZERO = new Long(0); 

	// Types and names of the columns.
	protected ColumnDescriptor[] colsDescriptor;
	

	protected abstract int getDescriptionIndex();
	
	public void updateView(Serializer serializer) {
		colsDescriptor = AppearanceOptionsTab.readDescriptions(serializer)[getDescriptionIndex()];
		//revalidate();
	}

	protected Class getFirstColumnClass() {
			return null;
	}

	public int getColumnCount() {
		for (int result = colsDescriptor.length-1; result >= 0; result--)
			if (colsDescriptor[result] != null)
				return result+1;
		return 0;
	}

	public String getColumnName(int column) {
		return colsDescriptor[column].label;
	}

	public Class getColumnClass(int column) {
		if (column == 0) {
			Class result = getFirstColumnClass();
			if (result != null)
				return result;
		}						
		switch(colsDescriptor[column].type) {
			case 0:
				return String.class;
			case 1:
				return Boolean.class;
			case 2:
				return Number.class;
			case AppearanceOptionsTab.TYP_DATE:
				return Date.class;
			case 4:
				return Integer.class;
			case 5:
				return Float.class;
			case 6:
				return Rational.class;
		}			
		return String.class;
	}
	/*
	public Object getValueAt(int row, int column) {
		// race condition, if the row changing
		return getValueAt(getFile(row), getInfo(row), column);	
	}
	
	public Object getValueAt(Object node, int column) {
		return getValueAt(getFile(node), getInfo(node), column);
	}*/
	
	protected Object getValueAt(File file, AbstractInfo info, int column) {
		ColumnDescriptor descriptor = colsDescriptor[column];
		String methods[] = descriptor.attributes;
		Object result = null;
		if (methods == null)
			return result;
		if (methods.length > 0 && info != null) {				
			result = getInfoAttribute(info, methods[0], descriptor.type);				
			if (result != null)
				return result;
			if (methods.length > 1)
				result = getInfoAttribute(info, methods[1], descriptor.type);
			if (result != null)
				return result;
		}
		if (methods.length > 2) {				
			if (Resources.LIST_NAME.equals(methods[2]))
				result = file.getName();
			else if (Resources.LIST_TYPE.equals(methods[2]))
				result = file.isDirectory()?Resources.LABEL_DIRECTORY:Resources.LABEL_FILE;
			else if (Resources.LIST_LENGTH.equals(methods[2]))
				result = file.isFile() ? new Long(file.length()) : ZERO;
			else if (Resources.LIST_DATE.equals(methods[2])) {
				if (descriptor.type == AppearanceOptionsTab.TYP_DATE)
					result = new Date(file.lastModified());
				else
					result = DateFormat.getDateInstance(DateFormat.SHORT).format(new Date(file.lastModified()));
			} else if (Resources.LIST_ATTRS.equals(methods[2]))
				result = ""+(file.isDirectory()?"d":".")+(file.isFile()?"f":".")+(file.isHidden()?"h":".");
		}

		return result; 
	}

	protected Object getInfoAttribute(AbstractInfo info, String name, int type) {
		Object result = null;
		try {
			switch(type) {
				case 0:
				case 2:
					if (AbstractInfo.GENRE.equals(name))
						try {
							result = MP3.GENRES[info.getIntAttribute(name)];
							break;
						} catch(Exception e) {
						}					
					result = info.getAttribute(name);
					break;
				case 1:
					result = info.getBoolAttribute(name)?Boolean.TRUE:Boolean.FALSE;
					break;
				case AppearanceOptionsTab.TYP_DATE: 
					result = info.getAttribute(name);
					if (result instanceof Date)
						result = DateFormat.getDateInstance(DateFormat.SHORT).format(result);
					break;
				case 4: 
					result = new Integer(info.getIntAttribute(name));
					break;
				case 5: 
					result = new Float(info.getFloatAttribute(name));
					break;
			}
		} catch(Exception e) {
		}
		return result;
	}	
}
