/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ui.PlayerWindow;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.RTPSocket;

public class RTPSocketPlayer
implements ControllerListener {
    String address = "224.144.251.245";
    int port = 9000;
    RTPSocket rtpsocket = new RTPSocket();
    RTPPushDataSource rtcpsource;
    PlayerWindow playerWindow;
    Player player;
    private int maxsize = 2000;
    UDPHandler rtp;
    UDPHandler rtcp;

    public static void main(String[] args) {
        new RTPSocketPlayer();
    }

    public RTPSocketPlayer() {
        this.rtpsocket.setContentType("rtpraw");
        this.rtp = new UDPHandler(this.address, this.port);
        this.rtpsocket.setOutputStream(this.rtp);
        this.rtpsocket.setInputStream(this.rtp);
        this.rtcp = new UDPHandler(this.address, this.port + 1);
        this.rtcpsource = this.rtpsocket.getControlChannel();
        this.rtcpsource.setOutputStream(this.rtcp);
        this.rtcpsource.setInputStream(this.rtcp);
        try {
            this.rtpsocket.connect();
            this.player = Manager.createPlayer(this.rtpsocket);
        }
        catch (NoPlayerException e2) {
            System.err.println(e2.getMessage());
            e2.printStackTrace();
            return;
        }
        catch (IOException e3) {
            System.err.println(e3.getMessage());
            e3.printStackTrace();
            return;
        }
        if (this.player != null) {
            this.player.addControllerListener(this);
            this.playerWindow = new PlayerWindow(this.player);
        }
    }

    public synchronized void controllerUpdate(ControllerEvent ce) {
        if (ce instanceof ControllerErrorEvent) {
            if (this.player != null) {
                this.player.removeControllerListener(this);
            }
            this.playerWindow = null;
            if (this.rtp != null) {
                this.rtp.close();
            }
            if (this.rtcp != null) {
                this.rtcp.close();
            }
        }
    }

    private DatagramSocket InitSocket(String sockaddress, int sockport) {
        InetAddress addr = null;
        DatagramSocket sock = null;
        try {
            addr = InetAddress.getByName(sockaddress);
            if (addr.isMulticastAddress()) {
                MulticastSocket msock = new MulticastSocket(sockport);
                msock.joinGroup(addr);
                sock = msock;
            } else {
                sock = new DatagramSocket(sockport, addr);
            }
            return sock;
        }
        catch (SocketException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (UnknownHostException e3) {
            e3.printStackTrace();
            return null;
        }
        catch (IOException e4) {
            e4.printStackTrace();
            return null;
        }
    }

    public class UDPHandler
    extends Thread
    implements PushSourceStream,
    OutputDataStream {
        DatagramSocket mysock;
        DatagramPacket dp;
        SourceTransferHandler outputhandler;
        String myaddress;
        int myport;
        boolean closed = false;

        public UDPHandler(String haddress, int hport) {
            RTPSocketPlayer.this = RTPSocketPlayer.this;
            this.myaddress = haddress;
            this.myport = hport;
            this.mysock = RTPSocketPlayer.this.InitSocket(this.myaddress, this.myport);
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                if (this.closed) {
                    this.cleanup();
                    return;
                }
                try {
                    int len;
                    do {
                        this.dp = new DatagramPacket(new byte[RTPSocketPlayer.this.maxsize], RTPSocketPlayer.this.maxsize);
                        this.mysock.receive(this.dp);
                        if (this.closed) {
                            this.cleanup();
                            return;
                        }
                        len = this.dp.getLength();
                        if (len <= RTPSocketPlayer.this.maxsize >> 1) continue;
                        RTPSocketPlayer.this.maxsize = len << 1;
                    } while (len >= this.dp.getData().length);
                }
                catch (Exception exception) {
                    this.cleanup();
                    return;
                }
                if (this.outputhandler == null) continue;
                this.outputhandler.transferData(this);
            }
        }

        public void close() {
            this.closed = true;
        }

        private void cleanup() {
            this.mysock.close();
            this.stop();
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String controlName) {
            return null;
        }

        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        public long getContentLength() {
            return -1L;
        }

        public boolean endOfStream() {
            return false;
        }

        public int read(byte[] buffer, int offset, int length) {
            System.arraycopy(this.dp.getData(), 0, buffer, offset, this.dp.getLength());
            return this.dp.getData().length;
        }

        public int getMinimumTransferSize() {
            return this.dp.getLength();
        }

        public void setTransferHandler(SourceTransferHandler transferHandler) {
            this.outputhandler = transferHandler;
        }

        public int write(byte[] buffer, int offset, int length) {
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(this.myaddress);
            }
            catch (UnknownHostException unknownHostException) {}
            DatagramPacket dp = new DatagramPacket(buffer, length, addr, this.myport);
            try {
                this.mysock.send(dp);
            }
            catch (IOException iOException) {}
            return dp.getLength();
        }
    }
}

