/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicSourceModule;
import com.sun.media.MyOutputConnector;
import com.sun.media.util.LoopThread;
import javax.media.Buffer;
import javax.media.Track;
import javax.media.TrackListener;

class SourceThread
extends LoopThread
implements TrackListener {
    BasicSourceModule bsm;
    int index;
    protected MyOutputConnector oc;
    protected boolean readBlocked = false;
    protected boolean checkLatency = false;
    protected boolean resetted = false;
    long sequenceNum;
    long lastRelativeTime;
    long currentTime;
    long counter;
    boolean relativeTimeResetted = false;

    public SourceThread(BasicSourceModule bsm, MyOutputConnector oc, int i2) {
        this.bsm = bsm;
        this.oc = oc;
        this.index = i2;
        this.setName(String.valueOf(this.getName()) + ": " + oc.track);
        oc.track.setTrackListener(this);
    }

    public synchronized void start() {
        super.start();
        this.relativeTimeResetted = true;
    }

    public void cleanUp() {
        this.bsm = null;
        this.oc = null;
    }

    public void readHasBlocked(Track t) {
        this.readBlocked = true;
        if (this.bsm.moduleListener != null) {
            this.bsm.moduleListener.dataBlocked(this.bsm, true);
        }
    }

    protected boolean process() {
        this.readBlocked = false;
        Buffer buffer = this.oc.getEmptyBuffer();
        this.bsm.jmd.moduleOut(this.bsm, this.index, buffer, true);
        buffer.setOffset(0);
        buffer.setLength(0);
        buffer.setFlags(0);
        buffer.setSequenceNumber(this.sequenceNum++);
        if (this.resetted) {
            Object object = this.bsm.resetSync;
            synchronized (object) {
                if (this.resetted) {
                    buffer.setFlags(256);
                    this.resetted = false;
                    this.pause();
                    if (this.bsm.checkAllPaused()) {
                        this.bsm.parser.stop();
                        this.bsm.parser.reset();
                    }
                    this.bsm.jmd.moduleOut(this.bsm, this.index, buffer, false);
                    this.oc.writeReport();
                    boolean bl = true;
                    Object var4_5 = null;
                    return bl;
                }
            }
        }
        this.oc.track.readFrame(buffer);
        if ((buffer.getFlags() & 0x80) != 0 && buffer.getTimeStamp() != -1L) {
            this.remapRelativeTime(buffer);
        }
        if (this.checkLatency) {
            buffer.setFlags(buffer.getFlags() | 0x200);
            if (this.bsm.moduleListener != null) {
                this.bsm.moduleListener.markedDataArrived(this.bsm, buffer);
            }
            this.checkLatency = false;
        } else {
            buffer.setFlags(buffer.getFlags() & 0xFFFFFDFF);
        }
        if (this.readBlocked && this.bsm.moduleListener != null) {
            this.bsm.moduleListener.dataBlocked(this.bsm, false);
        }
        if (buffer.isEOM()) {
            Object object = this.bsm.resetSync;
            synchronized (object) {
                if (!this.resetted) {
                    this.pause();
                    if (this.bsm.checkAllPaused()) {
                        this.bsm.parser.stop();
                    }
                }
            }
        } else {
            this.bsm.bitsRead += (long)buffer.getLength();
        }
        this.bsm.jmd.moduleOut(this.bsm, this.index, buffer, false);
        this.oc.writeReport();
        return true;
    }

    private void remapRelativeTime(Buffer buffer) {
        if (this.relativeTimeResetted) {
            this.relativeTimeResetted = false;
            this.currentTime = this.bsm.getMediaNanoseconds();
        } else {
            this.currentTime += buffer.getTimeStamp() - this.lastRelativeTime;
        }
        this.lastRelativeTime = buffer.getTimeStamp();
        buffer.setTimeStamp(this.currentTime);
        buffer.setFlags(buffer.getFlags() & 0xFFFFFF7F);
    }
}

