/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video;

import com.sun.media.BasicCodec;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class IV32Decoder
extends BasicCodec {
    private VideoFormat inputFormat;
    private YUVFormat outputFormat;
    private static boolean loaded;
    private static boolean canLoad;
    private int peer;
    private int quality;

    public IV32Decoder() {
        this.inputFormats = new VideoFormat[1];
        this.inputFormats[0] = new VideoFormat("iv32");
        this.outputFormats = new YUVFormat[1];
        this.outputFormats[0] = new YUVFormat();
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (!(in instanceof VideoFormat) || !in.getEncoding().equalsIgnoreCase("iv32")) {
            return new Format[0];
        }
        Format[] out = new Format[]{this.computeOutputFormat(in)};
        return out;
    }

    public Format setInputFormat(Format input) {
        this.inputFormat = (VideoFormat)input;
        return input;
    }

    public Format setOutputFormat(Format output) {
        this.outputFormat = (YUVFormat)output;
        return output;
    }

    private final YUVFormat computeOutputFormat(Format in) {
        VideoFormat indeo = (VideoFormat)in;
        Dimension size = indeo.getSize();
        int strideY = 0;
        int strideUV = 0;
        int strideHeight = 0;
        int dec = 512;
        if (size != null) {
            strideY = (size.width + 3) / 4 * 4;
            strideHeight = (size.height + 3) / 4 * 4;
        } else {
            size = new Dimension(320, 240);
            strideY = 320;
            strideHeight = 240;
        }
        strideUV = (strideY + 6) / 4 * 4;
        int strideUVHeight = (strideHeight + 6) / 4 * 4;
        int offsetY = strideY;
        int offsetV = strideY + strideY * strideHeight + strideUV;
        int offsetU = offsetV + strideUV * strideUVHeight + strideUV;
        int datasize = offsetU + offsetU - offsetV - strideUV;
        strideUV = (size.width + 12) / 16 * 4;
        YUVFormat yuv = new YUVFormat(size, datasize, Format.byteArray, indeo.getFrameRate(), dec, strideY, strideUV, offsetY, offsetU, offsetV);
        return yuv;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native Indeo decoder");
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmiv32");
                loaded = true;
            }
            catch (Throwable throwable) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native Indeo decoder");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set on Indeo decoder");
        }
        if (this.peer != 0) {
            this.close();
        }
        try {
            Dimension size = this.inputFormat.getSize();
            this.peer = this.initDecoder(size.width, size.height);
        }
        catch (Throwable throwable) {}
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize Indeo decoder");
        }
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeDecoder(this.peer);
        }
        this.peer = 0;
    }

    public void reset() {
        try {
            this.close();
            this.open();
        }
        catch (Exception exception) {
            this.peer = 0;
        }
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        Format outFormat = outBuffer.getFormat();
        byte[] inData = (byte[])inBuffer.getData();
        byte[] outData = (byte[])outBuffer.getData();
        if (outFormat == null || outFormat != this.outputFormat) {
            outBuffer.setFormat(this.outputFormat);
        }
        if (outData == null || outData.length < this.outputFormat.getMaxDataLength()) {
            outData = new byte[this.outputFormat.getMaxDataLength()];
            outBuffer.setData(outData);
        }
        if (this.peer == 0) {
            try {
                this.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return 1;
            }
        }
        Dimension size = this.inputFormat.getSize();
        int outWidth = size.width;
        int returnVal = this.decodeIndeo(this.peer, inData, inBuffer.getLength(), size.width, size.height, outData, outWidth, size.height);
        outBuffer.setLength(returnVal);
        outBuffer.setOffset(0);
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        return 0;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "Indeo 3.2 Decoder";
    }

    private native int initDecoder(int var1, int var2);

    private native int decodeIndeo(int var1, byte[] var2, int var3, int var4, int var5, byte[] var6, int var7, int var8);

    private native boolean freeDecoder(int var1);

    static {
        canLoad = true;
    }
}

