/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.BasicController;
import com.sun.media.BasicPlayer;
import com.sun.media.content.application.x_shockwave_flash.Flash;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.media.IncompatibleSourceException;
import javax.media.StopByRequestEvent;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

public class Handler
extends BasicPlayer {
    private Flash flash;
    private Component visualComponent;
    private DataSource dsource;
    private Component controlComp;
    private Thread flashThread;
    private FlashController flashController = new FlashController();

    public Handler() {
        this.manageController(this.flashController);
        this.flash = new Flash();
        this.visualComponent = new VideoComponent();
        if (this.visualComponent == null || this.flash == null) {
            return;
        }
        this.flash.setComponent(this.visualComponent);
        AWTEventToEvent eventListener = new AWTEventToEvent();
        this.visualComponent.addMouseListener(eventListener);
        this.visualComponent.addMouseMotionListener(eventListener);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException("Only PullDataSources are supported");
        }
        PullDataSource pds = (PullDataSource)source;
        this.dsource = source;
    }

    protected boolean audioEnabled() {
        return true;
    }

    protected boolean videoEnabled() {
        return true;
    }

    public void updateStats() {
    }

    protected TimeBase getMasterTimeBase() {
        return this.flashController.getMasterTimeBase();
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.visualComponent;
    }

    class FlashController
    extends BasicController {
        protected boolean isConfigurable() {
            return false;
        }

        protected TimeBase getMasterTimeBase() {
            return new SystemTimeBase();
        }

        protected boolean doRealize() {
            PullDataSource pds = (PullDataSource)Handler.this.dsource;
            PullSourceStream[] pss = pds.getStreams();
            if (Handler.this.flash == null || pss == null) {
                return false;
            }
            Handler.this.flash.loadScript(pss[0]);
            return true;
        }

        protected boolean doPrefetch() {
            if (Handler.this.flashThread == null) {
                Handler.this.flashThread = Handler.this.flash.startNonApplet();
            }
            return true;
        }

        protected void abortRealize() {
        }

        protected void abortPrefetch() {
        }

        protected void doClose() {
            if (Handler.this.flash != null) {
                Handler.this.flash.stop();
            }
            Handler.this.flashThread = null;
        }

        protected void doStart() {
            if (Handler.this.flash != null) {
                Handler.this.flash.startPlay();
            }
        }

        public void doStop() {
            if (Handler.this.flash != null) {
                Handler.this.flash.stopPlay();
            }
            this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        }

        protected float doSetRate(float factor) {
            return 1.0f;
        }

        FlashController() {
            Handler.this = Handler.this;
        }
    }

    class VideoComponent
    extends Canvas {
        public void update(Graphics g2) {
            Handler.this.flash.update(g2);
        }

        public void paint(Graphics g2) {
            Handler.this.flash.paint(g2);
        }

        public synchronized Dimension getPreferredSize() {
            return new Dimension(600, 400);
        }

        VideoComponent() {
            Handler.this = Handler.this;
        }
    }

    class AWTEventToEvent
    implements MouseListener,
    MouseMotionListener {
        private void sendEvent(int evtType, MouseEvent awtEvt) {
            Event evt = new Event(null, evtType, null);
            evt.id = evtType;
            evt.x = awtEvt.getX();
            evt.y = awtEvt.getY();
            evt.clickCount = awtEvt.getClickCount();
            if (Handler.this.flash != null) {
                Handler.this.flash.handleEvent(evt);
            }
        }

        public void mouseClicked(MouseEvent awtEvt) {
            this.sendEvent(501, awtEvt);
        }

        public void mouseEntered(MouseEvent awtEvt) {
            this.sendEvent(504, awtEvt);
        }

        public void mouseExited(MouseEvent awtEvt) {
            this.sendEvent(505, awtEvt);
        }

        public void mousePressed(MouseEvent awtEvt) {
            this.sendEvent(501, awtEvt);
        }

        public void mouseReleased(MouseEvent awtEvt) {
            this.sendEvent(502, awtEvt);
        }

        public void mouseDragged(MouseEvent awtEvt) {
            this.sendEvent(506, awtEvt);
        }

        public void mouseMoved(MouseEvent awtEvt) {
            this.sendEvent(503, awtEvt);
        }

        AWTEventToEvent() {
            Handler.this = Handler.this;
        }
    }
}

