/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.Rect;

class SParser {
    byte[] script;
    int pos;
    int end;
    int bitBuf;
    int bitPos;

    final void Attach(byte[] s, int start) {
        this.script = s;
        this.pos = start;
    }

    final int GetByte() {
        return this.script[this.pos++] & 0xFF;
    }

    final int GetWord() {
        int w = this.script[this.pos] & 0xFF | (this.script[this.pos + 1] & 0xFF) << 8;
        this.pos += 2;
        return w;
    }

    final int GetSWord() {
        int w = this.GetWord();
        if ((w & 0x8000) != 0) {
            w |= 0xFFFF0000;
        }
        return w;
    }

    final int GetDWord() {
        int i2 = this.script[this.pos] & 0xFF | (this.script[this.pos + 1] & 0xFF) << 8 | (this.script[this.pos + 2] & 0xFF) << 16 | (this.script[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return i2;
    }

    final byte[] GetByteArray(int length) {
        byte[] buffer = new byte[length];
        System.arraycopy(this.script, this.pos, buffer, 0, length);
        this.pos += length;
        return buffer;
    }

    final void CopyByteArray(byte[] dstBuffer, int dstPos, int length) {
        System.arraycopy(this.script, this.pos, dstBuffer, dstPos, length);
        this.pos += length;
    }

    void GetColorTransform(ColorTransform cx) {
        this.InitBits();
        cx.flags = this.GetBits(2);
        int nBits = this.GetBits(4);
        if ((cx.flags & 1) != 0) {
            cx.ra = this.GetSBits(nBits);
            cx.ga = this.GetSBits(nBits);
            cx.ba = this.GetSBits(nBits);
        } else {
            cx.ba = 256;
            cx.ga = 256;
            cx.ra = 256;
        }
        if ((cx.flags & 2) != 0) {
            cx.rb = this.GetSBits(nBits);
            cx.gb = this.GetSBits(nBits);
            cx.bb = this.GetSBits(nBits);
        } else {
            cx.bb = 0;
            cx.gb = 0;
            cx.rb = 0;
        }
    }

    final int GetColor() {
        int color = -16777216;
        color |= this.GetByte() << 16;
        color |= this.GetByte() << 8;
        return color |= this.GetByte();
    }

    final Rect GetRect() {
        this.InitBits();
        int nBits = this.GetBits(5);
        Rect r2 = new Rect();
        r2.xmin = this.GetSBits(nBits);
        r2.xmax = this.GetSBits(nBits);
        r2.ymin = this.GetSBits(nBits);
        r2.ymax = this.GetSBits(nBits);
        return r2;
    }

    final Matrix GetMatrix() {
        int nBits;
        this.InitBits();
        Matrix mat = new Matrix();
        if (this.GetBits(1) != 0) {
            nBits = this.GetBits(5);
            mat.a = this.GetSBits(nBits);
            mat.d = this.GetSBits(nBits);
        } else {
            mat.d = 65536;
            mat.a = 65536;
        }
        if (this.GetBits(1) != 0) {
            nBits = this.GetBits(5);
            mat.b = this.GetSBits(nBits);
            mat.c = this.GetSBits(nBits);
        } else {
            mat.c = 0;
            mat.b = 0;
        }
        nBits = this.GetBits(5);
        mat.tx = this.GetSBits(nBits);
        mat.ty = this.GetSBits(nBits);
        return mat;
    }

    final String GetString() {
        char ch;
        int len = 0;
        int savedPos = this.pos;
        while ((ch = (char)this.GetByte()) != '\u0000') {
            ++len;
        }
        this.pos = savedPos;
        char[] buf = new char[len];
        int i2 = 0;
        while (true) {
            char ch2 = (char)this.GetByte();
            if (i2 == len) break;
            buf[i2++] = ch2;
        }
        return new String(buf);
    }

    final void InitBits() {
        this.bitPos = 0;
        this.bitBuf = 0;
    }

    final int GetBits(int n2) {
        int s;
        int v = 0;
        while ((s = n2 - this.bitPos) > 0) {
            v |= this.bitBuf << s;
            n2 -= this.bitPos;
            this.bitBuf = this.GetByte();
            this.bitPos = 8;
        }
        this.bitPos -= n2;
        this.bitBuf &= 255 >>> 8 - this.bitPos;
        return v |= this.bitBuf >>> -s;
    }

    final int GetSBits(int n2) {
        int v = this.GetBits(n2);
        if ((v & 1 << n2 - 1) != 0) {
            v |= -1 << n2;
        }
        return v;
    }

    final void GetSoundInfo(int[] loops, int[] syncFlags, boolean skip) {
        block9: {
            int code;
            block8: {
                code = this.GetByte();
                if (!skip) break block8;
                if ((code & 1) != 0) {
                    this.GetDWord();
                }
                if ((code & 2) != 0) {
                    this.GetDWord();
                }
                if ((code & 4) != 0) {
                    this.GetWord();
                }
                if ((code & 8) == 0) break block9;
                int nPoints = this.GetByte();
                int i2 = 0;
                while (i2 < nPoints) {
                    this.GetDWord();
                    this.GetWord();
                    this.GetWord();
                    ++i2;
                }
                break block9;
            }
            syncFlags[0] = code >> 4;
            if ((code & 1) != 0) {
                this.GetDWord();
            }
            if ((code & 2) != 0) {
                this.GetDWord();
            }
            loops[0] = (code & 4) != 0 ? this.GetWord() : 1;
            if ((code & 8) != 0) {
                int nPoints = this.GetByte();
                int i3 = 0;
                while (i3 < nPoints) {
                    this.GetDWord();
                    this.GetWord();
                    this.GetWord();
                    ++i3;
                }
            }
        }
    }

    SParser() {
    }
}

