/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtsp;

import com.sun.media.BasicPlayer;
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtsp.RtspAppListener;
import com.sun.media.rtsp.RtspListener;
import com.sun.media.rtsp.RtspManager;
import com.sun.media.rtsp.RtspUrl;
import com.sun.media.rtsp.protocol.Message;
import com.sun.media.rtsp.protocol.ResponseMessage;
import com.sun.media.rtsp.protocol.SdpParser;
import com.sun.media.rtsp.protocol.SessionHeader;
import java.awt.Component;
import java.awt.Panel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.rtcp.SourceDescription;

public class Handler
extends BasicPlayer
implements RtspListener,
ReceiveStreamListener {
    private final int INITIALIZED = 0;
    private final int REALIZED = 1;
    private final int PLAYING = 2;
    private final int PAUSING = 3;
    private final int TIMER_1 = 12000;
    private final int TIMER_2 = 5000;
    private String url;
    private RtspManager rtspManager;
    private int connectionId;
    private Player rtpPlayer;
    private Panel videoPanel;
    private Vector listeners;
    private SessionManager videoManager;
    private SessionManager audioManager;
    private long duration;
    private Message message;
    private boolean managersCreated;
    private String audio_sessionId;
    private String video_sessionId;
    private String audio_track;
    private String video_track;
    private long startPos;
    private long sequenceNumber;
    private boolean loop;
    private int state;
    private static Vector mgrList;
    private static Vector playerList;
    boolean checkEOM = true;
    private boolean failed;
    private Integer stateLock = new Integer(0);
    boolean responseReceived;

    public Handler() {
        Object url = null;
        RtspManager rtspManager = null;
        this.url = url;
        this.rtspManager = rtspManager;
        this.startPos = 0L;
        this.sequenceNumber = 500L;
        this.loop = true;
        this.framePositioning = false;
        mgrList = new Vector();
        this.listeners = new Vector();
        playerList = new Vector();
        rtspManager.addListener(this);
        this.videoPanel = new Panel();
        this.state = 0;
    }

    protected synchronized boolean doRealize() {
        boolean realized = super.doRealize();
        String ipAddress = this.getServerIpAddress(this.url);
        if (ipAddress == null) {
            this.sendStatusMessage(1, "Invalid server address.");
            realized = false;
        } else {
            RtspUrl rtspUrl = new RtspUrl(this.url);
            this.connectionId = this.rtspManager.createConnection(ipAddress);
            if (this.connectionId == -1) {
                this.sendStatusMessage(2, "Server down.");
                realized = false;
            } else {
                int port_1 = 1030;
                int port_2 = 1032;
                if (!this.managersCreated) {
                    System.out.println("creating managers...");
                    String serverAddress = null;
                    try {
                        serverAddress = InetAddress.getByName(rtspUrl.getHost()).getHostAddress();
                    }
                    catch (UnknownHostException e2) {
                        e2.printStackTrace();
                    }
                    this.audioManager = null;
                    while (this.audioManager == null) {
                        this.audioManager = this.createManager(serverAddress, String.valueOf(port_1), "1");
                        if (this.audioManager != null) continue;
                        port_1 += 10;
                    }
                    this.videoManager = null;
                    while (this.videoManager == null) {
                        this.videoManager = this.createManager(serverAddress, String.valueOf(port_2), "1");
                        if (this.videoManager != null) continue;
                        port_2 += 10;
                    }
                    this.managersCreated = true;
                }
                String msg = "DESCRIBE rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Accept: application/sdp\r\n\r\n";
                this.rtspManager.sendMessage(this.connectionId, msg);
                boolean timeout = this.waitForResponse(12000);
                if (timeout) {
                    this.sendStatusMessage(3, "Timeout received.");
                    return false;
                }
                if (this.getStatusCode() == 200) {
                    this.setDuration();
                } else if (this.getStatusCode() == 404) {
                    this.sendStatusMessage(4, "Media not found.");
                    return false;
                }
                this.video_track = this.getVideoTrackID();
                this.audio_track = this.getAudioTrackID();
                msg = "SETUP rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + "/trackID=" + this.audio_track + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Transport: RTP/AVP;unicast;client_port=" + port_1 + "-" + (port_1 + 1) + "\r\n\r\n";
                this.rtspManager.sendMessage(this.connectionId, msg);
                timeout = this.waitForResponse(5000);
                if (timeout) {
                    this.sendStatusMessage(3, "Timeout received.");
                    return false;
                }
                ResponseMessage responseMsg = (ResponseMessage)this.message.getParameter();
                SessionHeader hdr = (SessionHeader)responseMsg.getResponse().getHeader((int)3).parameter;
                this.audio_sessionId = hdr.getSessionId();
                msg = "SETUP rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + "/trackID=" + this.video_track + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Transport: RTP/AVP;unicast;client_port=" + port_2 + "-" + (port_2 + 1) + "\r\n\r\n";
                this.rtspManager.sendMessage(this.connectionId, msg);
                timeout = this.waitForResponse(5000);
                if (timeout) {
                    this.sendStatusMessage(3, "Timeout received.");
                    return false;
                }
                responseMsg = (ResponseMessage)this.message.getParameter();
                hdr = (SessionHeader)responseMsg.getResponse().getHeader((int)3).parameter;
                this.video_sessionId = hdr.getSessionId();
            }
        }
        if (realized) {
            this.state = 1;
        }
        return realized;
    }

    private void setDuration() {
        ResponseMessage msg = (ResponseMessage)this.message.getParameter();
        SdpParser sdp = (SdpParser)msg.getResponse().getHeader((int)10).parameter;
        this.duration = (long)(sdp.getDuration() * 1.0E9);
        System.out.println("--->setDuration(): " + sdp.getDuration());
    }

    private String getVideoTrackID() {
        ResponseMessage msg = (ResponseMessage)this.message.getParameter();
        SdpParser sdp = (SdpParser)msg.getResponse().getHeader((int)10).parameter;
        return sdp.getVideoTrackID();
    }

    private String getAudioTrackID() {
        ResponseMessage msg = (ResponseMessage)this.message.getParameter();
        SdpParser sdp = (SdpParser)msg.getResponse().getHeader((int)10).parameter;
        return sdp.getAudioTrackID();
    }

    public boolean doPrefetch() {
        boolean prefetched = super.doPrefetch();
        return prefetched;
    }

    public void doStart() {
        System.out.println("doStart()");
        if (this.state >= 1) {
            this.checkEOM = true;
            super.doStart();
            this.startPlayers();
            System.out.println("doStart...");
            RtspUrl rtspUrl = new RtspUrl(this.url);
            String msg = "PLAY rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Range: npt=" + this.startPos / 1000000000L + "-\r\n" + "Session: " + this.audio_sessionId + "\r\n\r\n";
            this.rtspManager.sendMessage(this.connectionId, msg);
            boolean timeout = this.waitForResponse(5000);
            if (timeout) {
                this.sendStatusMessage(3, "Timeout received.");
                return;
            }
            msg = "PLAY rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Range: npt=" + this.startPos / 1000000000L + "-\r\n" + "Session: " + this.video_sessionId + "\r\n\r\n";
            this.rtspManager.sendMessage(this.connectionId, msg);
            timeout = this.waitForResponse(5000);
            if (timeout) {
                this.sendStatusMessage(3, "Timeout received.");
                return;
            }
            this.rtspManager.sendMessage(this.connectionId, msg);
            this.sendStatusMessage(5, "Playing...");
        }
    }

    public void doSetMediaTime(Time now) {
        super.doSetMediaTime(now);
        System.out.println("doSetMediaTime(): " + now.getNanoseconds() / 1000000000L);
        this.startPos = now.getNanoseconds();
        int i2 = 0;
        while (i2 < playerList.size()) {
            Player player = (Player)playerList.elementAt(i2);
            player.setMediaTime(new Time(this.startPos));
            ++i2;
        }
    }

    public Time getMediaTime() {
        Time time = super.getMediaTime();
        if (this.checkEOM && time.getNanoseconds() >= this.duration) {
            this.stopControllerOnly();
            this.sendStatusMessage(7, "End of media reached.");
            this.checkEOM = false;
        }
        return time;
    }

    public void doStop() {
        System.out.println("doStop()");
        super.doStop();
        this.startPos = this.getMediaTime().getNanoseconds();
        this.stopPlayers();
        RtspUrl rtspUrl = new RtspUrl(this.url);
        String msg = "PAUSE rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Session: " + this.audio_sessionId + "\r\n\r\n";
        this.rtspManager.sendMessage(this.connectionId, msg);
        boolean timeout = this.waitForResponse(5000);
        if (timeout) {
            this.sendStatusMessage(3, "Timeout received.");
            return;
        }
        msg = "PAUSE rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Session: " + this.video_sessionId + "\r\n\r\n";
        this.rtspManager.sendMessage(this.connectionId, msg);
        timeout = this.waitForResponse(5000);
        if (timeout) {
            this.sendStatusMessage(3, "Timeout received.");
            return;
        }
        this.sendStatusMessage(6, "Pausing...");
    }

    public void teardown() {
        super.doStop();
        this.audioManager.closeSession("server down");
        this.videoManager.closeSession("server down");
        RtspUrl rtspUrl = new RtspUrl(this.url);
        String msg = "TEARDOWN rtsp://" + rtspUrl.getHost() + "/" + rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Session: " + this.audio_sessionId + "\r\n\r\n";
        this.rtspManager.sendMessage(this.connectionId, msg);
        boolean timeout = this.waitForResponse(5000);
        if (timeout) {
            this.sendStatusMessage(3, "Timeout received.");
            return;
        }
        this.rtspManager.closeConnection(this.connectionId);
        System.out.println("teardown response arrived.");
    }

    public boolean audioEnabled() {
        boolean enabled = true;
        System.out.println("audioEnabled: " + enabled);
        return enabled;
    }

    public boolean videoEnabled() {
        boolean enabled = true;
        System.out.println("videoEnabled: " + enabled);
        return enabled;
    }

    public void updateStats() {
    }

    protected TimeBase getMasterTimeBase() {
        return null;
    }

    public void update(ReceiveStreamEvent event) {
        Player newplayer = null;
        SessionManager source = (SessionManager)event.getSource();
        System.out.println("event: " + event);
        if (event instanceof NewReceiveStreamEvent) {
            String cname = "Java Media Player";
            ReceiveStream stream = null;
            try {
                stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                Participant part = stream.getParticipant();
                if (part != null) {
                    cname = part.getCNAME();
                }
                DataSource dsource = stream.getDataSource();
                System.out.println("data source: " + dsource);
                newplayer = Manager.createPlayer(dsource);
            }
            catch (Exception e2) {
                System.err.println("newReceiveStreamEvent exception " + e2.getMessage());
                return;
            }
            if (newplayer == null) {
                return;
            }
            playerList.addElement(newplayer);
            newplayer.addControllerListener(this);
            newplayer.realize();
            this.waitForState(newplayer, 300);
            Component component = newplayer.getVisualComponent();
            newplayer.start();
            if (component != null) {
                this.videoPanel.add(component);
            } else {
                this.rtpPlayer = newplayer;
            }
            if (playerList.size() == 2) {
                int i2 = 0;
                while (i2 < this.listeners.size()) {
                    ((RtspAppListener)this.listeners.elementAt(i2)).streamsReceivedEvent();
                    ++i2;
                }
            }
        }
    }

    public Integer getStateLock() {
        return this.stateLock;
    }

    public long getMediaNanoseconds() {
        long value = 0L;
        value = this.rtpPlayer == null ? 0L : this.rtpPlayer.getMediaNanoseconds();
        System.out.println("getNanos: " + value);
        return value;
    }

    public Time getDuration() {
        Time time = new Time(this.duration);
        return time;
    }

    private synchronized boolean waitForState(Player p2, int state) {
        p2.addControllerListener(new StateListener());
        this.failed = false;
        while (p2.getState() < state && !this.failed) {
            Integer n2 = this.getStateLock();
            synchronized (n2) {
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var5_5 = null;
                    return bl;
                }
            }
        }
        return !this.failed;
    }

    private String getServerIpAddress(String url) {
        String ipAddress = null;
        RtspUrl rtspUrl = new RtspUrl(url);
        String name = rtspUrl.getHost();
        try {
            ipAddress = InetAddress.getByName(name).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Host unknown: " + name);
        }
        return ipAddress;
    }

    private synchronized boolean waitForResponse(int time) {
        boolean timeout = false;
        this.responseReceived = false;
        try {
            Handler handler = this;
            synchronized (handler) {
                this.wait(time);
                if (this.responseReceived) {
                    ++this.sequenceNumber;
                } else {
                    timeout = true;
                }
            }
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return timeout;
    }

    public void rtspMessageIndication(int connectionId, Message message) {
        this.message = message;
        this.responseReceived = true;
        Handler handler = this;
        synchronized (handler) {
            this.notify();
        }
    }

    public void rtspConnectionTerminated(int connectionId) {
        System.out.println("RtspPlayer::rtspConnectionTerminated");
    }

    public SessionManager createManager(String address, String sport, String sttl) {
        RTPSessionMgr mgr = new RTPSessionMgr();
        if (mgr == null) {
            return null;
        }
        mgrList.addElement(mgr);
        mgr.addReceiveStreamListener(this);
        String cname = mgr.generateCNAME();
        String username = null;
        try {
            username = System.getProperty("user.name");
        }
        catch (SecurityException securityException) {
            username = "jmf-user";
        }
        SessionAddress localaddr = new SessionAddress();
        try {
            InetAddress destaddr = InetAddress.getByName(address);
            int port = new Integer(sport);
            int ttl = new Integer(sttl);
            SessionAddress sessaddr = new SessionAddress(destaddr, port, destaddr, port + 1);
            SourceDescription[] userdesclist = new SourceDescription[]{new SourceDescription(3, "jmf-user@sun.com", 1, false), new SourceDescription(1, cname, 1, false), new SourceDescription(6, "JMF RTP Player v2.0", 1, false)};
            mgr.initSession(localaddr, userdesclist, 0.05, 0.25);
            mgr.startSession(sessaddr, ttl, null);
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
            return null;
        }
        return mgr;
    }

    public Component getVideoPanel() {
        return this.videoPanel;
    }

    public Component getVideoControl() {
        Component videoControl = null;
        videoControl = this.getControlPanelComponent();
        return videoControl;
    }

    public GainControl getGainControl() {
        System.out.println("getGainControl() called.");
        GainControl gainControl = null;
        int i2 = 0;
        while (i2 < playerList.size()) {
            Player player = (Player)playerList.elementAt(i2);
            gainControl = player.getGainControl();
            if (gainControl != null) break;
            ++i2;
        }
        if (gainControl == null) {
            System.out.println("no gain control found: " + playerList.size());
        }
        return gainControl;
    }

    public Control[] getAllControls() {
        Panel controlPanel = new Panel();
        int size = 0;
        int i2 = 0;
        while (i2 < playerList.size()) {
            this.controls = ((Player)playerList.elementAt(i2)).getControls();
            size += this.controls.length;
            ++i2;
        }
        Control[] controls = new Control[size];
        int counter = 0;
        int i3 = 0;
        while (i3 < playerList.size()) {
            controls = ((Player)playerList.elementAt(i3)).getControls();
            int k2 = 0;
            while (k2 < controls.length) {
                controls[counter++] = controls[k2];
                ++k2;
            }
            ++i3;
        }
        return controls;
    }

    public Control[] getControls() {
        Control[] controls = new Control[]{};
        int i2 = 0;
        while (i2 < playerList.size()) {
            Player player = (Player)playerList.elementAt(i2);
            if (player.getGainControl() == null) {
                controls = player.getControls();
                break;
            }
            ++i2;
        }
        return controls;
    }

    private void startPlayers() {
        int i2 = 0;
        while (i2 < playerList.size()) {
            Player player = (Player)playerList.elementAt(i2);
            player.start();
            ++i2;
        }
    }

    private void stopPlayers() {
        int i2 = 0;
        while (i2 < playerList.size()) {
            Player player = (Player)playerList.elementAt(i2);
            player.stop();
            ++i2;
        }
    }

    private void sendStatusMessage(int code, String message) {
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            ((RtspAppListener)this.listeners.elementAt(i2)).postStatusMessage(code, message);
            ++i2;
        }
    }

    public void addListener(RtspAppListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeListener(RtspAppListener listener) {
        this.listeners.removeElement(listener);
    }

    private int getStatusCode() {
        ResponseMessage responseMsg = (ResponseMessage)this.message.getParameter();
        return responseMsg.getResponse().getStatusLine().getCode();
    }

    static /* synthetic */ boolean access$0(Handler $0) {
        return $0.failed;
    }

    class StateListener
    implements ControllerListener {
        public void controllerUpdate(ControllerEvent ce) {
            Integer n2;
            if (ce instanceof ResourceUnavailableEvent) {
                Handler.this.failed = true;
                n2 = Handler.this.getStateLock();
                synchronized (n2) {
                    Handler.this.getStateLock().notifyAll();
                }
            }
            if (ce instanceof RealizeCompleteEvent) {
                System.out.println("xxx --- complete --- XXX");
            }
            if (ce instanceof ControllerEvent) {
                n2 = Handler.this.getStateLock();
                synchronized (n2) {
                    Handler.this.getStateLock().notifyAll();
                }
            }
            if (ce instanceof EndOfMediaEvent) {
                Handler.this.sendStatusMessage(8, "Ready.");
            }
        }

        StateListener() {
            Handler.this = Handler.this;
        }
    }
}

