/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.ibm.media.codec.video.h263.JavaDecoder;
import com.sun.media.CircularBuffer;
import com.sun.media.codec.video.h261.NativeDecoder;
import com.sun.media.parser.RawStreamParser;
import java.awt.Dimension;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;

public class RawBufferParser
extends RawStreamParser {
    protected boolean closed = false;
    static final String NAMEBUFFER = "Raw video/audio buffer stream parser";

    public String getName() {
        return NAMEBUFFER;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.streams = ((PushBufferDataSource)source).getStreams();
        if (this.streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (this.streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(this.streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = this.streams;
    }

    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PushBufferStream;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        int i2 = 0;
        while (i2 < this.streams.length) {
            this.tracks[i2] = new FrameTrack(this, (PushBufferStream)this.streams[i2], 1);
            ++i2;
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                int i2 = 0;
                while (i2 < this.tracks.length) {
                    ((FrameTrack)this.tracks[i2]).stop();
                    ((FrameTrack)this.tracks[i2]).close();
                    ++i2;
                }
                this.source.disconnect();
            }
            catch (Exception exception) {}
            this.source = null;
        }
    }

    public Track[] getTracks() {
        int i2 = 0;
        while (i2 < this.tracks.length) {
            ((FrameTrack)this.tracks[i2]).parse();
            ++i2;
        }
        return this.tracks;
    }

    public void start() throws IOException {
        this.source.start();
        int i2 = 0;
        while (i2 < this.tracks.length) {
            ((FrameTrack)this.tracks[i2]).start();
            ++i2;
        }
    }

    public void stop() {
        try {
            this.source.stop();
            int i2 = 0;
            while (i2 < this.tracks.length) {
                ((FrameTrack)this.tracks[i2]).stop();
                ++i2;
            }
        }
        catch (Exception exception) {}
    }

    public void reset() {
    }

    class FrameTrack
    implements Track,
    BufferTransferHandler {
        Demultiplexer parser;
        PushBufferStream pbs;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format;
        TrackListener listener;
        Integer stateReq = new Integer(0);
        boolean stopped = true;
        boolean closed = false;
        boolean parsed = false;

        public FrameTrack(Demultiplexer parser, PushBufferStream pbs, int numOfBufs) {
            RawBufferParser.this = RawBufferParser.this;
            this.pbs = pbs;
            pbs.setTransferHandler(this);
            this.bufferQ = new CircularBuffer(numOfBufs);
            this.format = pbs.getFormat();
            System.err.println("Track format is " + this.format);
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            if (t) {
                this.pbs.setTransferHandler(this);
            } else {
                this.pbs.setTransferHandler(null);
            }
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        public void parse() {
            if (this.parsed || this.format.getEncoding() == null || !this.format.getEncoding().endsWith("rtp")) {
                this.parsed = true;
                return;
            }
            if (this.format.getEncoding().equals("jpeg/rtp")) {
                this.parseRTPJPEG();
            } else if (this.format.getEncoding().equals("h261/rtp")) {
                this.parseRTPH261();
            } else if (this.format.getEncoding().equals("h263/rtp")) {
                this.parseRTPH263();
            }
            this.parsed = true;
        }

        public void parseRTPJPEG() {
            Buffer b2 = new Buffer();
            do {
                this.readFrame(b2);
            } while ((b2.getFlags() & 0x400) == 0);
            byte[] data = (byte[])b2.getData();
            int width = (data[b2.getOffset() + 6] & 0xFF) * 8;
            int height = (data[b2.getOffset() + 7] & 0xFF) * 8;
            this.format = new VideoFormat("jpeg/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
        }

        public void parseRTPH261() {
            int skipBytes;
            int offset;
            byte[] data;
            Buffer b2 = new Buffer();
            do {
                this.readFrame(b2);
            } while ((data = (byte[])b2.getData()) == null || data[(offset = b2.getOffset()) + (skipBytes = 4)] != 0 || data[offset + skipBytes + 1] != 1 || (data[offset + skipBytes + 2] & 0xFC) != 0);
            int s = data[offset + skipBytes + 3] >> 3 & 1;
            int width = NativeDecoder.widths[s];
            int height = NativeDecoder.heights[s];
            this.format = new VideoFormat("h261/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
        }

        public void parseRTPH263() {
            int offset;
            int payloadLen;
            byte[] data;
            Buffer b2 = new Buffer();
            while (true) {
                this.readFrame(b2);
                data = (byte[])b2.getData();
                if (data == null) continue;
                payloadLen = JavaDecoder.getPayloadHeaderLength(data, b2.getOffset());
                offset = b2.getOffset();
                if (data[offset + payloadLen] == 0 && data[offset + payloadLen + 1] == 0 && (data[offset + payloadLen + 2] & 0xFC) == 128) break;
            }
            int s = data[offset + payloadLen + 4] >> 2 & 7;
            int width = JavaDecoder.widths[s];
            int height = JavaDecoder.heights[s];
            this.format = new VideoFormat("h263/rtp", new Dimension(width, height), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
        }

        public void stop() {
            Object object = this.stateReq;
            synchronized (object) {
                this.stopped = true;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        public void start() {
            Object object = this.stateReq;
            synchronized (object) {
                this.stopped = false;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        public void close() {
            this.setEnabled(false);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.closed = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void readFrame(Buffer buffer) {
            Object object;
            Buffer filled;
            Object object2 = this.stateReq;
            synchronized (object2) {
                if (this.stopped) {
                    buffer.setDiscard(true);
                    buffer.setFormat(this.format);
                    return;
                }
            }
            object2 = this.bufferQ;
            synchronized (object2) {
                while (true) {
                    if (this.bufferQ.canRead()) {
                        filled = this.bufferQ.read();
                        this.bufferQ.notifyAll();
                        break;
                    }
                    try {
                        this.bufferQ.wait();
                        object = this.stateReq;
                        synchronized (object) {
                            if (this.stopped) {
                                buffer.setDiscard(true);
                                buffer.setFormat(this.format);
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            Object data = filled.getData();
            filled.setData(buffer.getData());
            buffer.setData(data);
            buffer.setLength(filled.getLength());
            buffer.setOffset(filled.getOffset());
            buffer.setFormat(filled.getFormat());
            buffer.setTimeStamp(filled.getTimeStamp());
            buffer.setFlags(filled.getFlags());
            buffer.setSequenceNumber(filled.getSequenceNumber());
            Object hdr = filled.getHeader();
            filled.setHeader(buffer.getHeader());
            buffer.setHeader(hdr);
            this.format = filled.getFormat();
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
                return;
            }
        }

        public int mapTimeToFrame(Time t) {
            return -1;
        }

        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void transferData(PushBufferStream pbs) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (true) {
                    if (this.bufferQ.canWrite() || this.closed) {
                        if (!this.closed) break;
                        return;
                    }
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
                buffer = this.bufferQ.getEmptyBuffer();
                this.bufferQ.notifyAll();
            }
            try {
                pbs.read(buffer);
            }
            catch (IOException iOException) {
                buffer.setDiscard(true);
            }
            circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
                return;
            }
        }
    }
}

