/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.BasicPlugIn;
import com.sun.media.MediaTimeBase;
import com.sun.media.renderer.audio.device.AudioOutput;
import java.awt.Component;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Owned;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;

public abstract class AudioRenderer
extends BasicPlugIn
implements Renderer,
Prefetchable,
Clock {
    Format[] supportedFormats;
    protected AudioFormat inputFormat;
    protected AudioOutput device;
    protected AudioTimeBase timeBase;
    protected boolean started = false;
    protected boolean prefetched = false;
    protected boolean resetted = false;
    protected boolean devicePaused = true;
    protected GainControl gainControl;
    protected BufferControl bufferControl;
    long mediaTimeAnchor;
    long startTime = Long.MAX_VALUE;
    long stopTime = Long.MAX_VALUE;
    long ticksSinceLastReset;
    float rate = 1.0f;
    TimeBase master;
    static int DefaultMinBufferSize = 62;
    static int DefaultMaxBufferSize = 4000;
    static long bufLenReq = 200L;

    public AudioRenderer() {
        this.timeBase = new AudioTimeBase(this);
        this.bufferControl = new BC(this);
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public Format setInputFormat(Format format) {
        int i2 = 0;
        while (i2 < this.supportedFormats.length) {
            if (this.supportedFormats[i2].matches(format)) {
                this.inputFormat = (AudioFormat)format;
                return format;
            }
            ++i2;
        }
        return null;
    }

    public void close() {
        this.stop();
        if (this.device != null) {
            this.pauseDevice();
            this.device.flush();
            this.mediaTimeAnchor = this.getMediaNanoseconds();
            this.ticksSinceLastReset = 0L;
            this.device.dispose();
        }
        this.device = null;
    }

    public void reset() {
        this.resetted = true;
        this.mediaTimeAnchor = this.getMediaNanoseconds();
        if (this.device != null) {
            this.device.flush();
            this.ticksSinceLastReset = this.device.getMediaNanoseconds();
        } else {
            this.ticksSinceLastReset = 0L;
        }
        this.prefetched = false;
    }

    synchronized void pauseDevice() {
        if (!this.devicePaused && this.device != null) {
            this.device.pause();
            this.devicePaused = true;
        }
        this.timeBase.mediaStopped();
    }

    synchronized void resumeDevice() {
        this.timeBase.mediaStarted();
        if (this.devicePaused && this.device != null) {
            this.device.resume();
            this.devicePaused = false;
        }
    }

    public void start() {
        this.syncStart(this.getTimeBase().getTime());
    }

    public synchronized void drain() {
        if (this.started && this.device != null) {
            this.device.drain();
        }
        this.prefetched = false;
    }

    public int process(Buffer buffer) {
        int rtn = this.processData(buffer);
        if (buffer.isEOM() && rtn != 2) {
            this.drain();
            this.stop();
            this.pauseDevice();
        }
        return rtn;
    }

    protected boolean checkInput(Buffer buffer) {
        Format format = buffer.getFormat();
        if (this.device == null || this.inputFormat == null || !this.inputFormat.equals(format)) {
            if (!this.initDevice((AudioFormat)format)) {
                buffer.setDiscard(true);
                return false;
            }
            this.inputFormat = (AudioFormat)format;
        }
        return true;
    }

    protected int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        return this.doProcessData(buffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int doProcessData(Buffer buffer) {
        byte[] data = (byte[])buffer.getData();
        int remain = buffer.getLength();
        int off = buffer.getOffset();
        int len = 0;
        AudioRenderer audioRenderer = this;
        synchronized (audioRenderer) {
            if (!this.started) {
                if (!this.devicePaused) {
                    this.pauseDevice();
                }
                this.resetted = false;
                int available = this.device.bufferAvailable();
                if (available > remain) {
                    available = remain;
                }
                if (available > 0) {
                    len = this.device.write(data, off, available);
                }
                buffer.setLength(remain - len);
                if (buffer.getLength() <= 0) {
                    if (!buffer.isEOM()) return 0;
                }
                buffer.setOffset(off + len);
                this.prefetched = true;
                return 2;
            }
        }
        try {
            while (remain > 0 && !this.resetted) {
                len = this.device.write(data, off, remain);
                off += len;
                remain -= len;
            }
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        buffer.setLength(0);
        buffer.setOffset(0);
        return 0;
    }

    protected boolean initDevice(AudioFormat format) {
        if (format == null) {
            System.err.println("AudioRenderer: ERROR: Unknown AudioFormat");
            return false;
        }
        if (this.device != null) {
            this.device.drain();
            this.mediaTimeAnchor = this.getMediaNanoseconds();
            this.ticksSinceLastReset = 0L;
            this.device.dispose();
            this.device = null;
        }
        AudioFormat audioFormat = new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getEndian(), format.getSigned());
        this.device = this.createDevice(audioFormat);
        if (this.device == null || !this.device.initialize(audioFormat, AudioRenderer.computeBufferSize(audioFormat))) {
            this.device = null;
            return false;
        }
        this.device.setMute(this.gainControl.getMute());
        this.device.setGain(this.gainControl.getDB());
        if (this.rate != 1.0f && this.rate != this.device.setRate(this.rate)) {
            System.err.println("The AudioRenderer does not support the given rate: " + this.rate);
            this.device.setRate(1.0f);
        }
        if (this.started) {
            this.resumeDevice();
        }
        return true;
    }

    protected abstract AudioOutput createDevice(AudioFormat var1);

    protected void processByWaiting(Buffer buffer) {
        AudioRenderer audioRenderer = this;
        synchronized (audioRenderer) {
            if (!this.started) {
                this.prefetched = true;
                Object var3_3 = null;
                return;
            }
        }
        AudioFormat format = (AudioFormat)buffer.getFormat();
        int sampleRate = (int)format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int channels = format.getChannels();
        long duration = buffer.getLength() * 1000 / (sampleSize / 8 * sampleRate * channels);
        int timeToWait = (int)((float)duration / this.getRate());
        try {
            Thread.currentThread();
            Thread.sleep(timeToWait);
        }
        catch (Exception exception) {}
        buffer.setLength(0);
        buffer.setOffset(0);
        this.mediaTimeAnchor += duration * 1000000L;
    }

    public Object[] getControls() {
        Object[] c2 = new Control[]{this.gainControl, this.bufferControl};
        return c2;
    }

    public boolean isPrefetched() {
        return this.prefetched;
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (!(master instanceof AudioTimeBase)) {
            System.err.println("AudioRenderer cannot be controlled by time bases other than its own: " + master);
            throw new IncompatibleTimeBaseException();
        }
        this.master = master;
    }

    public synchronized void syncStart(Time at) {
        this.started = true;
        this.prefetched = true;
        this.resetted = false;
        this.resumeDevice();
        this.startTime = at.getNanoseconds();
    }

    public synchronized void stop() {
        this.started = false;
        this.prefetched = false;
    }

    public void setStopTime(Time t) {
        this.stopTime = t.getNanoseconds();
    }

    public Time getStopTime() {
        return new Time(this.stopTime);
    }

    public void setMediaTime(Time now) {
        this.mediaTimeAnchor = now.getNanoseconds();
    }

    public Time getMediaTime() {
        return new Time(this.getMediaNanoseconds());
    }

    public long getMediaNanoseconds() {
        return this.mediaTimeAnchor + (this.device != null ? this.device.getMediaNanoseconds() : 0L) - this.ticksSinceLastReset;
    }

    public Time getSyncTime() {
        return new Time(0L);
    }

    public TimeBase getTimeBase() {
        if (this.master != null) {
            return this.master;
        }
        return this.timeBase;
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return new Time((long)((float)(t.getNanoseconds() - this.mediaTimeAnchor) / this.rate) + this.startTime);
    }

    public float getRate() {
        return this.rate;
    }

    public float setRate(float factor) {
        this.rate = this.device == null ? factor : this.device.setRate(factor);
        return this.rate;
    }

    public static int computeBufferSize(AudioFormat f2) {
        long bytesPerSecond = (long)(f2.getSampleRate() * (double)f2.getChannels() * (double)f2.getSampleSizeInBits() / 8.0);
        long bufLen = bufLenReq < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (bufLenReq > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : bufLenReq);
        float r2 = (float)bufLen / 1000.0f;
        long bufSize = (long)((float)bytesPerSecond * r2);
        return (int)bufSize;
    }

    class AudioTimeBase
    extends MediaTimeBase {
        AudioRenderer renderer;

        AudioTimeBase(AudioRenderer r2) {
            AudioRenderer.this = AudioRenderer.this;
            this.renderer = r2;
        }

        public long getMediaTime() {
            return AudioRenderer.this.device != null ? AudioRenderer.this.device.getMediaNanoseconds() : 0L;
        }
    }

    class BC
    implements BufferControl,
    Owned {
        AudioRenderer renderer;

        BC(AudioRenderer ar) {
            AudioRenderer.this = AudioRenderer.this;
            this.renderer = ar;
        }

        public long getBufferLength() {
            return bufLenReq;
        }

        public long setBufferLength(long time) {
            bufLenReq = time < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (time > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : time);
            return bufLenReq;
        }

        public long getMinimumThreshold() {
            return 0L;
        }

        public long setMinimumThreshold(long time) {
            return 0L;
        }

        public void setEnabledThreshold(boolean b2) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return this.renderer;
        }
    }
}

