/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.SunAudioOutput;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;

public class SunAudioRenderer
extends AudioRenderer {
    static String NAME = "SunAudio Renderer";

    public SunAudioRenderer() {
        this.supportedFormats = new Format[1];
        this.supportedFormats[0] = new AudioFormat("ULAW", 8000.0, 8, 1, -1, -1);
        this.gainControl = new MCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (!SunAudioRenderer.grabDevice()) {
            throw new ResourceUnavailableException("AudioRenderer: Failed to initialize audio device.");
        }
    }

    public void close() {
        super.close();
    }

    protected AudioOutput createDevice(AudioFormat format) {
        return new SunAudioOutput();
    }

    private static synchronized boolean grabDevice() {
        if (!AudioPlayer.player.isAlive()) {
            System.out.println("Audio device is busy");
            return false;
        }
        return true;
    }

    public float setRate(float factor) {
        return super.setRate(1.0f);
    }

    class MCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected MCA(AudioRenderer r2) {
            super(false);
            SunAudioRenderer.this = SunAudioRenderer.this;
            this.renderer = r2;
        }

        public void setMute(boolean mute) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(mute);
            }
            super.setMute(mute);
        }

        public float getLevel() {
            return -1.0f;
        }
    }
}

