/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.SSRCCache;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class FormatInfo {
    private Hashtable formatlist = new Hashtable(10);
    private SSRCCache cache;
    public static final int PAYLOAD_NOTFOUND = -1;

    public FormatInfo() {
        this.InitFormats();
    }

    public void setCache(SSRCCache cache) {
        this.cache = cache;
    }

    public void add(int payload, Format fmt) {
        Format located = (Format)this.formatlist.get(new Integer(payload));
        if (located != null) {
            return;
        }
        this.formatlist.put(new Integer(payload), fmt);
        if (this.cache != null && fmt instanceof VideoFormat) {
            this.cache.clockrate[payload] = 90000;
        }
        if (this.cache != null && fmt instanceof AudioFormat) {
            this.cache.clockrate[payload] = (int)((AudioFormat)fmt).getSampleRate();
        }
    }

    public Format get(int payload) {
        return (Format)this.formatlist.get(new Integer(payload));
    }

    public int getPayload(Format fmt) {
        if (fmt.getEncoding() != null && fmt.getEncoding().equals("g729a/rtp")) {
            fmt = new AudioFormat("g729/rtp");
        }
        Enumeration e2 = this.formatlist.keys();
        while (e2.hasMoreElements()) {
            Integer i2 = (Integer)e2.nextElement();
            Format f2 = (Format)this.formatlist.get(i2);
            if (!f2.matches(fmt)) continue;
            return i2;
        }
        return -1;
    }

    public void InitFormats() {
        this.formatlist.put(new Integer(0), new AudioFormat("ULAW/rtp", 8000.0, 8, 1));
        this.formatlist.put(new Integer(3), new AudioFormat("gsm/rtp", 8000.0, -1, 1));
        this.formatlist.put(new Integer(4), new AudioFormat("g723/rtp", 8000.0, -1, 1));
        this.formatlist.put(new Integer(5), new AudioFormat("dvi/rtp", 8000.0, 4, 1));
        this.formatlist.put(new Integer(15), new AudioFormat("g728/rtp", 8000.0, -1, 1));
        this.formatlist.put(new Integer(16), new AudioFormat("dvi/rtp", 11025.0, 4, 1));
        this.formatlist.put(new Integer(17), new AudioFormat("dvi/rtp", 22050.0, 4, 1));
        this.formatlist.put(new Integer(18), new AudioFormat("g729/rtp", 8000.0, -1, 1));
        this.formatlist.put(new Integer(26), new VideoFormat("jpeg/rtp"));
        this.formatlist.put(new Integer(31), new VideoFormat("h261/rtp"));
        this.formatlist.put(new Integer(34), new VideoFormat("h263/rtp"));
    }

    public static boolean isSupported(int payload) {
        switch (payload) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 31: 
            case 34: {
                return true;
            }
        }
        return false;
    }
}

