/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.RTCPBYEPacket;
import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPRRPacket;
import com.sun.media.rtp.RTCPRawSender;
import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTCPSDESItem;
import com.sun.media.rtp.RTCPSDESPacket;
import com.sun.media.rtp.RTCPSRPacket;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class RTCPTransmitter {
    RTCPRawSender sender;
    OverallStats stats;
    SSRCCache cache;
    int sdescounter;
    SSRCInfo ssrc;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public RTCPTransmitter(SSRCCache cache) {
        this.cache = cache;
        this.stats = cache.sm.defaultstats;
    }

    public RTCPTransmitter(SSRCCache cache, RTCPRawSender sender) {
        this(cache);
        this.setSender(sender);
        this.stats = cache.sm.defaultstats;
    }

    public RTCPTransmitter(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address));
    }

    public RTCPTransmitter(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address, sender));
    }

    public void setSender(RTCPRawSender s) {
        this.sender = s;
    }

    public void setSSRCInfo(SSRCInfo info) {
        this.ssrc = info;
    }

    public RTCPRawSender getSender() {
        return this.sender;
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    protected void transmit(RTCPCompoundPacket p2) {
        try {
            this.sender.sendTo(p2);
            if (this.ssrc instanceof SendSSRCInfo) {
                ++((SendSSRCInfo)this.ssrc).stats.total_rtcp;
                ++this.cache.sm.transstats.rtcp_sent;
            }
            this.cache.updateavgrtcpsize(p2.length);
            this.cache.tp = System.currentTimeMillis();
            this.cache.pmembers = this.cache.alivecount;
            if (this.cache.initial) {
                this.cache.initial = false;
            }
            if (!this.cache.rtcpsent) {
                this.cache.rtcpsent = true;
            }
        }
        catch (IOException iOException) {
            this.stats.update(6, 1);
            ++this.cache.sm.transstats.transmit_failed;
        }
    }

    public void report() {
        Vector repvec = this.makereports();
        Object[] packets = new RTCPPacket[repvec.size()];
        repvec.copyInto(packets);
        RTCPCompoundPacket cp = new RTCPCompoundPacket((RTCPPacket[])packets);
        this.transmit(cp);
    }

    public void bye(String reason) {
        if (reason != null) {
            this.bye(this.ssrc.ssrc, reason.getBytes());
        } else {
            this.bye(this.ssrc.ssrc, null);
        }
    }

    public void bye(int ssrc, byte[] reason) {
        boolean bye;
        double delay;
        if (!this.cache.rtcpsent) {
            return;
        }
        this.cache.byestate = true;
        Vector repvec = this.makereports();
        Object[] packets = new RTCPPacket[repvec.size() + 1];
        repvec.copyInto(packets);
        int[] ssrclist = new int[]{ssrc};
        RTCPBYEPacket byep = new RTCPBYEPacket(ssrclist, reason);
        packets[packets.length - 1] = byep;
        RTCPCompoundPacket cp = new RTCPCompoundPacket((RTCPPacket[])packets);
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        if (this.cache.alivecount > 50) {
            this.cache.reset(byep.length);
            delay = this.cache.calcReportInterval(this.ssrc.sender, false);
            bye = false;
        } else {
            bye = true;
            delay = 0.0;
        }
        try {
            while (!bye) {
                RTCPTransmitter e2 = this;
                synchronized (e2) {
                    this.wait((long)delay);
                }
                if (delay == 0.0) continue;
                double reschedule = this.cache.OnExpire(false);
                if (reschedule == 0.0) {
                    bye = true;
                    continue;
                }
                delay = reschedule;
            }
        }
        catch (InterruptedException e3) {
            e3.printStackTrace();
        }
        this.transmit(cp);
        this.sdescounter = 0;
    }

    protected Vector makereports() {
        RTCPReportBlock[] reports;
        Vector<RTCPPacket> packets = new Vector<RTCPPacket>();
        SSRCInfo ourinfo = this.ssrc;
        boolean senderreport = false;
        if (ourinfo.sender) {
            senderreport = true;
        }
        long time = System.currentTimeMillis();
        long ntptime = (long)((double)(time + 220898880000L) * 4294967.296);
        RTCPReportBlock[] firstrep = reports = this.makerecreports(time);
        if (reports.length > 31) {
            firstrep = new RTCPReportBlock[31];
            System.arraycopy(reports, 0, firstrep, 0, 31);
        }
        if (senderreport) {
            RTCPSRPacket srp = new RTCPSRPacket(ourinfo.ssrc, firstrep);
            packets.addElement(srp);
            srp.ntptimestamplsw = ntptime;
            srp.ntptimestampmsw = 0L;
            srp.rtptimestamp = (int)((double)(time - ourinfo.starttime) * ((double)ourinfo.clockrate / 1000.0));
            srp.packetcount = ourinfo.maxseq - ourinfo.baseseq;
            srp.octetcount = ourinfo.bytesreceived;
        } else {
            RTCPRRPacket rrp = new RTCPRRPacket(ourinfo.ssrc, firstrep);
            packets.addElement(rrp);
        }
        if (firstrep != reports) {
            int offset = 31;
            while (offset < reports.length) {
                if (reports.length - offset < 31) {
                    firstrep = new RTCPReportBlock[reports.length - offset];
                }
                System.arraycopy(reports, offset, firstrep, 0, firstrep.length);
                RTCPRRPacket rrp = new RTCPRRPacket(ourinfo.ssrc, firstrep);
                packets.addElement(rrp);
                offset += 31;
            }
        }
        RTCPSDESPacket sp = new RTCPSDESPacket(new RTCPSDES[1]);
        sp.sdes[0] = new RTCPSDES();
        sp.sdes[0].ssrc = this.ssrc.ssrc;
        Vector<RTCPSDESItem> itemvec = new Vector<RTCPSDESItem>();
        itemvec.addElement(new RTCPSDESItem(1, ourinfo.sourceInfo.getCNAME()));
        if (this.sdescounter % 3 == 0) {
            if (ourinfo.name != null && ourinfo.name.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(2, ourinfo.name.getDescription()));
            }
            if (ourinfo.email != null && ourinfo.email.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(3, ourinfo.email.getDescription()));
            }
            if (ourinfo.phone != null && ourinfo.phone.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(4, ourinfo.phone.getDescription()));
            }
            if (ourinfo.loc != null && ourinfo.loc.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(5, ourinfo.loc.getDescription()));
            }
            if (ourinfo.tool != null && ourinfo.tool.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(6, ourinfo.tool.getDescription()));
            }
            if (ourinfo.note != null && ourinfo.note.getDescription() != null) {
                itemvec.addElement(new RTCPSDESItem(7, ourinfo.note.getDescription()));
            }
        }
        ++this.sdescounter;
        sp.sdes[0].items = new RTCPSDESItem[itemvec.size()];
        itemvec.copyInto(sp.sdes[0].items);
        packets.addElement(sp);
        return packets;
    }

    protected RTCPReportBlock[] makerecreports(long time) {
        Vector<RTCPReportBlock> reports = new Vector<RTCPReportBlock>();
        Enumeration enumeration = this.cache.cache.elements();
        while (enumeration.hasMoreElements()) {
            double frac;
            SSRCInfo info = (SSRCInfo)enumeration.nextElement();
            if (info.ours || !info.sender) continue;
            RTCPReportBlock rep = new RTCPReportBlock();
            rep.ssrc = info.ssrc;
            rep.lastseq = info.maxseq + info.cycles;
            rep.jitter = (int)info.jitter;
            rep.lsr = (int)(info.lastSRntptimestamp >> 32);
            rep.dlsr = (int)((double)(time - info.lastSRreceiptTime) * 65.536);
            rep.packetslost = (int)(rep.lastseq - (long)info.baseseq + 1L - (long)info.received);
            if (rep.packetslost < 0) {
                rep.packetslost = 0;
            }
            if ((frac = (double)(rep.packetslost - info.prevlost) / (double)(rep.lastseq - (long)info.prevmaxseq)) < 0.0) {
                frac = 0.0;
            }
            rep.fractionlost = (int)(frac * 256.0);
            info.prevmaxseq = (int)rep.lastseq;
            info.prevlost = rep.packetslost;
            reports.addElement(rep);
        }
        Object[] reportsarr = new RTCPReportBlock[reports.size()];
        reports.copyInto(reportsarr);
        return reportsarr;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

