/*
 * Decompiled with CFR 0.152.
 */
public class Mp3Header {
    private static int[][][] bitrates;
    private static int[] bitmask;
    private static String[][][] bitrate_str;
    private static double[][] ms_per_frame_array;
    String fileStr = new String();
    private String[] mp3_version = new String[]{"MPEG 2", "MPEG 1"};
    private String[] mp3_mode = new String[]{"stereo", "joint stereo", "dual channel", "single channel"};
    private String[] mp3_frequency = new String[]{"44.1", "48", "32"};
    private String[] mp3_layer = new String[]{"Layer 1", "Layer 2", "Layer 3"};
    public int headerBuf;
    private int h_version;
    private int h_freq;
    private int h_layer;
    private boolean h_protection = false;
    private int h_bitrate_index;
    private int h_padding;
    private int h_mode;
    private int h_mode_extension;
    private int h_fsize;
    private int h_intensity_stereo_bound;
    private boolean h_copyright = true;
    private boolean h_original = true;
    private int h_number_of_subbands;
    private int channel_bitrate;
    private int bufferIntSize = 433;
    private byte[] dataBuffer = new byte[this.bufferIntSize];
    private int wordPtr;
    private int bitindex;
    public Crc16 crc;
    private int[] offset;
    private int checksum;
    private int framesize;
    private boolean initial_sync;
    private int nSlots;
    private static int[][] frequencies;
    public static final String NULL;
    public static final int MPEG1 = 1;
    public static final int MPEG2 = 2;
    public static final int fourtyfour_point_one = 0;
    public static final int fourtyeight = 1;
    public static final int thirtytwo = 2;
    public static final int stereo = 0;
    public static final int joint_stereo = 1;
    public static final int dual_channel = 2;
    public static final int single_channel = 3;
    public static final int both = 0;
    public static final int left = 1;
    public static final int right = 2;
    public static final int downmix = 3;

    public Mp3Header() {
        this.clearMP3Header();
    }

    public int mode() {
        return this.h_mode;
    }

    public int layer() {
        return this.h_layer;
    }

    public boolean checksums() {
        return !this.h_protection;
    }

    public int intensity_stereo_bound() {
        return this.h_intensity_stereo_bound;
    }

    public boolean copyright() {
        return this.h_copyright;
    }

    public boolean original() {
        return this.h_original;
    }

    public boolean checksum_ok() {
        return this.checksum == this.crc.checksum();
    }

    public int bitrate_index() {
        return this.h_bitrate_index;
    }

    public int frequency() {
        return frequencies[this.h_version][this.h_freq];
    }

    int padding() {
        return this.h_padding;
    }

    int slots() {
        return this.nSlots;
    }

    int mode_extension() {
        return this.h_mode_extension;
    }

    public int get_bits(int n) {
        int n2 = 0;
        int n3 = this.bitindex + n;
        if (n3 <= 32) {
            n2 = this.dataBuffer[this.wordPtr] >> 32 - n3 & bitmask[n];
            if ((this.bitindex += n) == 32) {
                this.bitindex = 0;
                ++this.wordPtr;
            }
            return n2;
        }
        short s = (short)(this.dataBuffer[this.wordPtr] >> 16);
        ++this.wordPtr;
        short s2 = this.dataBuffer[this.wordPtr];
        n2 = s2;
        n2 <<= 16;
        n2 = s;
        n2 >>= 48 - n3;
        this.bitindex = n3 - 32;
        return n2 &= bitmask[n];
    }

    public void clearMP3Header() {
        this.headerBuf = -1;
        this.h_version = -1;
        this.h_freq = -1;
        this.h_layer = -1;
        this.h_protection = false;
        this.h_bitrate_index = -1;
        this.h_padding = 0;
        this.h_mode = -1;
        this.h_mode_extension = -1;
        this.h_intensity_stereo_bound = -1;
        this.h_copyright = false;
        this.h_original = false;
        this.wordPtr = 0;
        this.framesize = 0;
        this.nSlots = 0;
        this.crc = null;
        this.offset = null;
        this.initial_sync = false;
    }

    public boolean read_header(MP3InputStream mP3InputStream, Crc16 crc16) {
        if (!this.initial_sync) {
            if (!mP3InputStream.get_header(0)) {
                return false;
            }
            this.headerBuf = MP3InputStream.current_headervalue();
            this.h_version = this.headerBuf >> 19 & 1;
            this.h_freq = this.headerBuf >>> 10 & 3;
            if (this.h_freq > 2) {
                this.h_freq = 2;
            }
            mP3InputStream.set_syncword(this.headerBuf & 0xFFF80CC0);
            this.initial_sync = true;
        } else if (mP3InputStream.get_header(1)) {
            this.headerBuf = MP3InputStream.current_headervalue();
        } else {
            return false;
        }
        this.h_layer = 4 - (this.headerBuf >> 17 & 3);
        this.h_protection = (this.headerBuf >> 16 & 1) == 1;
        this.h_bitrate_index = this.headerBuf >> 12 & 0xF;
        this.h_padding = this.headerBuf >> 9 & 1;
        this.h_mode = this.headerBuf >> 6 & 3;
        this.h_mode_extension = this.headerBuf >> 4 & 3;
        this.h_intensity_stereo_bound = this.h_mode == 1 ? (this.h_mode_extension << 2) + 4 : 0;
        this.h_copyright = (this.headerBuf >> 3 & 1) == 1;
        this.h_original = (this.headerBuf >> 2 & 1) == 1;
        this.calculateSubbands();
        this.h_fsize = this.calculate_framesize();
        if (!mP3InputStream.readMP3Frame(this.framesize)) {
            return false;
        }
        if (!this.h_protection) {
            this.checksum = (short)MP3InputStream.get_bits(16);
            if (this.crc == null) {
                this.crc = new Crc16();
            }
            this.crc.add_bits(this.headerBuf, 16);
            crc16 = this.crc;
        } else {
            crc16 = null;
        }
        if (this.h_freq == 0) {
            int n;
            int n2;
            if (this.offset == null) {
                n2 = this.max_number_of_frames(mP3InputStream);
                this.offset = new int[n2];
                n = 0;
                while (n < n2) {
                    this.offset[n] = 0;
                    ++n;
                }
            }
            n2 = mP3InputStream.current_frame();
            n = mP3InputStream.last_frame();
            if (n2 > 0 && n2 == n) {
                this.offset[n2] = this.offset[n2 - 1] + this.h_padding;
            } else {
                this.offset[0] = this.h_padding;
            }
        }
        return true;
    }

    public void calculateSubbands() {
        if (this.h_layer == 1) {
            this.h_number_of_subbands = 32;
        } else {
            this.channel_bitrate = this.h_bitrate_index;
            if (this.h_mode != 3) {
                this.channel_bitrate = this.channel_bitrate == 4 ? 1 : (this.channel_bitrate -= 4);
            }
            this.h_number_of_subbands = this.channel_bitrate == 1 || this.channel_bitrate == 2 ? (this.h_freq == 2 ? 12 : 8) : (this.h_freq == 1 || this.channel_bitrate >= 3 && this.channel_bitrate <= 5 ? 27 : 30);
        }
        if (this.h_intensity_stereo_bound > this.h_number_of_subbands) {
            this.h_intensity_stereo_bound = this.h_number_of_subbands;
        }
    }

    public int number_subbands() {
        return this.h_number_of_subbands;
    }

    public int calculate_framesize() {
        if (this.h_layer == 1) {
            this.framesize = 12 * bitrates[this.h_version][0][this.h_bitrate_index] / frequencies[this.h_version][this.h_freq];
            if (this.h_padding >= 1) {
                ++this.framesize;
            }
            this.framesize <<= 2;
        } else {
            this.framesize = 144 * bitrates[this.h_version][this.h_layer - 1][this.h_bitrate_index] / frequencies[this.h_version][this.h_freq];
            if (this.h_version == 2) {
                this.framesize >>= 1;
            }
            if (this.h_padding >= 1) {
                ++this.framesize;
            }
            this.nSlots = this.h_layer == 3 ? (this.h_version == 1 ? this.framesize - (this.h_mode == 3 ? 17 : 32) - (this.h_protection ? 0 : 2) - 4 : this.framesize - (this.h_mode == 3 ? 9 : 17) - (this.h_protection ? 0 : 2) - 4) : 0;
        }
        this.framesize -= 4;
        return this.framesize;
    }

    public String layer_string() {
        switch (this.h_layer) {
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
        }
        return NULL;
    }

    public String bitrate_string() {
        return bitrate_str[this.h_version][this.h_layer - 1][this.h_bitrate_index];
    }

    public int sample_frequency() {
        return this.h_freq;
    }

    public String frequency_string() {
        switch (this.h_freq) {
            case 2: {
                if (this.h_version == 1) {
                    return "32 kHz        ";
                }
                return "16 kHz        ";
            }
            case 0: {
                if (this.h_version == 1) {
                    return "44.1 kHz     ";
                }
                return "22.05 kHz   ";
            }
            case 1: {
                if (this.h_version == 1) {
                    return "48 kHz        ";
                }
                return "24 kHz        ";
            }
        }
        return NULL;
    }

    public String mode_string() {
        switch (this.h_mode) {
            case 0: {
                return "Stereo                             ";
            }
            case 1: {
                return "Joint stereo                      ";
            }
            case 2: {
                return "Dual channel                    ";
            }
            case 3: {
                return "Single channel                ";
            }
        }
        return NULL;
    }

    public String version_string() {
        switch (this.h_version) {
            case 1: {
                return "MPEG-1                    ";
            }
            case 2: {
                return "MPEG-2 LSF                ";
            }
        }
        return NULL;
    }

    public int version() {
        return this.h_version;
    }

    public String copyRight_string() {
        if (this.h_copyright) {
            return "Copyright Material";
        }
        return "Public Domain";
    }

    public String originalWork_string() {
        if (this.h_original) {
            return "Original Work";
        }
        return "Public Domain";
    }

    int max_number_of_frames(MP3InputStream mP3InputStream) {
        return (int)mP3InputStream.file_size() / (this.framesize + 4 - this.h_padding);
    }

    int min_number_of_frames(MP3InputStream mP3InputStream) {
        return (int)mP3InputStream.file_size() / (this.framesize + 5 - this.h_padding);
    }

    double ms_per_frame() {
        return ms_per_frame_array[this.h_layer - 1][this.h_freq];
    }

    double total_ms(MP3InputStream mP3InputStream) {
        return (double)this.max_number_of_frames(mP3InputStream) * this.ms_per_frame();
    }

    static {
        int[][][] nArrayArray = new int[2][][];
        int[][] nArrayArray2 = new int[3][];
        int[] nArray = new int[16];
        nArray[1] = 32000;
        nArray[2] = 48000;
        nArray[3] = 56000;
        nArray[4] = 64000;
        nArray[5] = 80000;
        nArray[6] = 96000;
        nArray[7] = 112000;
        nArray[8] = 128000;
        nArray[9] = 144000;
        nArray[10] = 160000;
        nArray[11] = 176000;
        nArray[12] = 192000;
        nArray[13] = 224000;
        nArray[14] = 256000;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 8000;
        nArray2[2] = 16000;
        nArray2[3] = 24000;
        nArray2[4] = 32000;
        nArray2[5] = 40000;
        nArray2[6] = 48000;
        nArray2[7] = 56000;
        nArray2[8] = 64000;
        nArray2[9] = 80000;
        nArray2[10] = 96000;
        nArray2[11] = 112000;
        nArray2[12] = 128000;
        nArray2[13] = 144000;
        nArray2[14] = 160000;
        nArrayArray2[1] = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 8000;
        nArray3[2] = 16000;
        nArray3[3] = 24000;
        nArray3[4] = 32000;
        nArray3[5] = 40000;
        nArray3[6] = 48000;
        nArray3[7] = 56000;
        nArray3[8] = 64000;
        nArray3[9] = 80000;
        nArray3[10] = 96000;
        nArray3[11] = 112000;
        nArray3[12] = 128000;
        nArray3[13] = 144000;
        nArray3[14] = 160000;
        nArrayArray2[2] = nArray3;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[3][];
        int[] nArray4 = new int[16];
        nArray4[1] = 32000;
        nArray4[2] = 64000;
        nArray4[3] = 96000;
        nArray4[4] = 128000;
        nArray4[5] = 160000;
        nArray4[6] = 192000;
        nArray4[7] = 224000;
        nArray4[8] = 256000;
        nArray4[9] = 288000;
        nArray4[10] = 320000;
        nArray4[11] = 352000;
        nArray4[12] = 384000;
        nArray4[13] = 416000;
        nArray4[14] = 448000;
        nArrayArray3[0] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[1] = 32000;
        nArray5[2] = 48000;
        nArray5[3] = 56000;
        nArray5[4] = 64000;
        nArray5[5] = 80000;
        nArray5[6] = 96000;
        nArray5[7] = 112000;
        nArray5[8] = 128000;
        nArray5[9] = 160000;
        nArray5[10] = 192000;
        nArray5[11] = 224000;
        nArray5[12] = 256000;
        nArray5[13] = 320000;
        nArray5[14] = 384000;
        nArrayArray3[1] = nArray5;
        int[] nArray6 = new int[16];
        nArray6[1] = 32000;
        nArray6[2] = 40000;
        nArray6[3] = 48000;
        nArray6[4] = 56000;
        nArray6[5] = 64000;
        nArray6[6] = 80000;
        nArray6[7] = 96000;
        nArray6[8] = 112000;
        nArray6[9] = 128000;
        nArray6[10] = 160000;
        nArray6[11] = 192000;
        nArray6[12] = 224000;
        nArray6[13] = 256000;
        nArray6[14] = 320000;
        nArrayArray3[2] = nArray6;
        nArrayArray[1] = nArrayArray3;
        bitrates = nArrayArray;
        int[] nArray7 = new int[18];
        nArray7[1] = 1;
        nArray7[2] = 3;
        nArray7[3] = 7;
        nArray7[4] = 15;
        nArray7[5] = 31;
        nArray7[6] = 63;
        nArray7[7] = 127;
        nArray7[8] = 255;
        nArray7[9] = 511;
        nArray7[10] = 1023;
        nArray7[11] = 2047;
        nArray7[12] = 4095;
        nArray7[13] = 8191;
        nArray7[14] = 16383;
        nArray7[15] = Short.MAX_VALUE;
        nArray7[16] = 65535;
        nArray7[17] = 131071;
        bitmask = nArray7;
        bitrate_str = new String[][][]{{{"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "176 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}, {"free format", "8 kbit/s", "16 kbit/s", "24 kbit/s", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "144 kbit/s", "160 kbit/s", "forbidden"}}, {{"free format", "32 kbit/s", "64 kbit/s", "96 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "288 kbit/s", "320 kbit/s", "352 kbit/s", "384 kbit/s", "416 kbit/s", "448 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "384 kbit/s", "forbidden"}, {"free format", "32 kbit/s", "40 kbit/s", "48 kbit/s", "56 kbit/s", "64 kbit/s", "80 kbit/s", "96 kbit/s", "112 kbit/s", "128 kbit/s", "160 kbit/s", "192 kbit/s", "224 kbit/s", "256 kbit/s", "320 kbit/s", "forbidden"}}};
        ms_per_frame_array = new double[][]{{8.707483291625977, 8.0, 12.0}, {26.12244987487793, 24.0, 36.0}, {26.12244987487793, 24.0, 36.0}};
        frequencies = new int[][]{{22050, 24000, 16000, 1}, {44100, 48000, 32000, 1}};
        NULL = new String();
    }
}

