/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;

public abstract class AbstractWriter {
    private ElementIterator it;
    private Writer out;
    private int indentLevel = 0;
    private int indentSpace = 2;
    private Document doc = null;
    private int maxLineLength = 100;
    private int currLength = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int offsetIndent = 0;
    protected static final char NEWLINE = '\n';

    protected AbstractWriter(Writer writer, Document document) {
        this(writer, document, 0, document.getLength());
    }

    protected AbstractWriter(Writer writer, Document document, int n, int n2) {
        this.doc = document;
        this.it = new ElementIterator(document.getDefaultRootElement());
        this.out = writer;
        this.startOffset = n;
        this.endOffset = n + n2;
    }

    protected AbstractWriter(Writer writer, Element element) {
        this(writer, element, 0, element.getEndOffset());
    }

    protected AbstractWriter(Writer writer, Element element, int n, int n2) {
        this.doc = element.getDocument();
        this.it = new ElementIterator(element);
        this.out = writer;
        this.startOffset = n;
        this.endOffset = n + n2;
    }

    protected void decrIndent() {
        if (this.offsetIndent > 0) {
            --this.offsetIndent;
        } else {
            --this.indentLevel;
        }
    }

    protected Document getDocument() {
        return this.doc;
    }

    protected ElementIterator getElementIterator() {
        return this.it;
    }

    protected String getText(Element element) throws BadLocationException {
        return this.doc.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
    }

    protected boolean inRange(Element element) {
        return element.getStartOffset() >= this.startOffset && element.getStartOffset() < this.endOffset || this.startOffset >= element.getStartOffset() && this.startOffset < element.getEndOffset();
    }

    protected void incrIndent() {
        if (this.offsetIndent > 0) {
            ++this.offsetIndent;
        } else if (++this.indentLevel * this.indentSpace >= this.maxLineLength) {
            ++this.offsetIndent;
            --this.indentLevel;
        }
    }

    protected void indent() throws IOException {
        int n = this.indentLevel * this.indentSpace;
        int n2 = 0;
        while (n2 < n) {
            this.write(' ');
            ++n2;
        }
    }

    protected void setIndentSpace(int n) {
        this.indentSpace = n;
    }

    protected void setLineLength(int n) {
        this.maxLineLength = n;
    }

    protected void text(Element element) throws BadLocationException, IOException {
        String string = this.getText(element);
        if (string.length() > 0) {
            this.write(string);
        }
    }

    protected abstract void write() throws IOException, BadLocationException;

    protected void write(char c) throws IOException {
        this.out.write(c);
        if (c == '\n') {
            this.currLength = 0;
        } else {
            ++this.currLength;
            if (this.currLength == this.maxLineLength) {
                this.out.write(10);
                this.currLength = 0;
                this.indent();
            }
        }
    }

    protected void write(String string) throws IOException {
        int n = this.indentLevel * this.indentSpace;
        int n2 = string.indexOf(10);
        if (this.currLength + string.length() <= this.maxLineLength) {
            this.out.write(string);
            this.currLength += string.length();
            if (n2 >= 0) {
                this.currLength -= n2 - 1;
            }
        } else if (n + string.length() <= this.maxLineLength) {
            this.out.write(10);
            this.currLength = 0;
            this.indent();
            this.out.write(string);
            this.currLength = n + string.length();
            if (n2 >= 0) {
                this.currLength -= n2 - 1;
            }
        } else {
            int n3 = this.maxLineLength - n;
            String string2 = string.substring(0, n3);
            this.write(string2);
            string2 = string.substring(n3, string.length());
            this.write(string2);
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.write(" " + e + "=" + attributeSet.getAttribute(e));
        }
    }
}

