/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.CaptureDeviceManager;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.MediaTimeSetEvent;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TransitionEvent;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.FormatChangeEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.util.BufferToImage;
import rtp.RTPDialog;

public class JMStudio
extends Frame
implements ControllerListener,
ActionListener,
ItemListener {
    public MediaPlayer player;
    MediaPlayer newPlayer;
    static double defaultScale = 1.0;
    Component controlComp;
    Component visualComp;
    Component progressBar;
    Control jmdControl;
    Panel framePanel;
    FileDialog fd;
    Insets insets;
    Menu menu;
    Menu visited;
    PopupMenu zoomMenu;
    OpenURLDialog urlDialog;
    CheckboxMenuItem cbAutoPlay;
    CheckboxMenuItem cbAutoLoop;
    CheckboxMenuItem cbAspectRatio;
    MenuItem itemSaveAs;
    MenuItem itemClose;
    MenuItem itemPlugInViewer;
    MenuItem itemFullScreen;
    MenuItem itemSnapShot;
    CheckboxMenuItem itemCaptureControls;
    SnapFrame snapFrame;
    public RTPDialog rtpd;
    Format lastSnapFormat;
    BufferToImage bti;
    Dimension preFullSize;
    boolean windowCreated = false;
    static boolean queryCaptureCards;
    boolean newVideo = false;
    boolean panelResized = false;
    static int listenPort;
    String mediaURL = "";
    String filename = "";
    String newFilename = "";
    String fileDirectory = ".";
    DataSource inputDataSource;
    DataSource newDataSource;
    static Vector fileList;
    static String visitedFile;
    boolean inFullScreen = false;
    Window screen;
    MouseListener unFullML;
    Integer localLock = new Integer(0);
    int fileListSize;
    ActionListener vfl;
    FrameGrabbingControl grabberControl;
    CaptureControlsDialog dlgCaptureControls;
    static int windowCount;
    static final String APPNAME = "JMStudio";
    static final String LABEL_OPENFILE = "Open File...";
    static final String LABEL_OPENURL = "Open URL...";
    static final String LABEL_OPENRTPSESSION = "Open RTP Session...";
    static final String LABEL_SAVEAS = "Save As...";
    static final String LABEL_EXPORT = "Export...";
    static final String LABEL_TRANSMIT = "Transmit...";
    static final String LABEL_CLOSE = "Close";
    static final String LABEL_PLUGINS = "PlugIn Viewer";
    static final String LABEL_EXIT = "Exit";
    static final String LABEL_FILE = "File";
    static final String LABEL_CLONE = "New Window";
    static final String LABEL_VISITED = "Visited URLs";
    static final String LABEL_OPTIONS = "Player";
    static final String LABEL_AUTOLOOP = "Auto Loop";
    static final String LABEL_KEEPASPECT = "Maintain Aspect Ratio";
    static final String LABEL_AUTOPLAY = "Auto Play";
    static final String LABEL_FULLSCREEN = "Full Screen";
    static final String LABEL_SNAPSHOT = "Snap Shot";
    static final String LABEL_CAPTUREPREVIEW = "Capture Preview...";
    static final String LABEL_HELP = "Help";
    static final String LABEL_HELPABOUT = "About JM Studio...";
    static final String LABEL_CAPTURECONTROLS = "Capture Controls...";

    public JMStudio(MediaPlayer player, String name) {
        super(APPNAME);
        this.player = player;
        if (name != null) {
            this.filename = name;
            this.mediaURL = name;
        }
        if (windowCount == 0) {
            this.initProps();
        }
        ++windowCount;
        this.setMenuBar(this.createMenuBar());
        if (fileList == null) {
            this.loadVisitedList();
        }
        if (queryCaptureCards) {
            this.doQueryCaptureCards();
        }
        this.vfl = new 1();
        this.updateVisitedList();
        this.setLayout(new BorderLayout());
        this.framePanel = new Panel();
        this.framePanel.setLayout(null);
        this.add((Component)this.framePanel, "Center");
        this.setBlankSize();
        ((Component)this).setVisible(true);
        this.addWindowListener(new 2());
        this.framePanel.addComponentListener(new 3());
        this.addComponentListener(new 4());
    }

    protected void initProps() {
        Properties props = new Properties(System.getProperties());
        props = new Properties(props);
        String sep = File.separator;
        File theUserPropertiesFile = new File(String.valueOf(System.getProperty("user.home")) + sep + ".hotjava" + sep + "properties");
        try {
            FileInputStream in = new FileInputStream(theUserPropertiesFile);
            props.load(new BufferedInputStream(in));
            in.close();
        }
        catch (Exception exception) {}
        System.setProperties(props);
    }

    public void addNotify() {
        super.addNotify();
        this.insets = this.getInsets();
        this.windowCreated = true;
        this.setCenterLocation(this, null, this.insets.left + this.insets.right + 320, this.insets.top + this.insets.bottom);
        if (this.player != null) {
            this.player.addControllerListener(this);
            this.player.realize();
        }
    }

    public void setBlankSize() {
        Insets insets = this.getInsets();
        ((Component)this).setSize(320 + insets.left + insets.right, insets.top + insets.bottom);
        this.checkMenu();
    }

    private void setCenterLocation(Frame self, Frame parent, int width, int height) {
        Rectangle rect;
        if (parent != null) {
            rect = parent.getBounds();
        } else {
            Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
            rect = new Rectangle(new Point(0, 0), d2);
        }
        ((Component)self).setSize(width, height);
        ((Component)self).setLocation(rect.x + (rect.width - width) / 2, rect.y + (rect.height - height) / 2);
    }

    private void fullScreen(boolean toFullScreen) {
        if (toFullScreen) {
            this.inFullScreen = true;
            if (this.visualComp == null) {
                return;
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Point location = new Point(0, 0);
            if (this.screen == null) {
                this.screen = new Window(this);
                ((Component)this.screen).setSize(screenSize);
                ((Component)this.screen).setLocation(0, 0);
                this.screen.setLayout(null);
                ((Component)this.screen).setBackground(Color.black);
                this.screen.addNotify();
            }
            this.preFullSize = this.getSize();
            this.screen.toFront();
            this.framePanel.remove(this.player);
            Dimension size = this.visualComp.getPreferredSize();
            if ((float)size.width / (float)size.height >= (float)screenSize.width / (float)screenSize.height) {
                size.height = size.height * screenSize.width / size.width;
                size.width = screenSize.width;
                location.x = 0;
                location.y = (screenSize.height - size.height) / 2;
            } else {
                size.width = size.width * screenSize.height / size.height;
                size.height = screenSize.height;
                location.y = 0;
                location.x = (screenSize.width - size.width) / 2;
            }
            this.screen.add(this.player);
            Toolkit.getDefaultToolkit().sync();
            this.player.setSize(size);
            this.player.setLocation(location);
            this.unFullML = new 5();
            this.visualComp.addMouseListener(this.unFullML);
            ((Component)this.screen).setVisible(true);
        } else {
            this.inFullScreen = false;
            this.visualComp.removeMouseListener(this.unFullML);
            ((Component)this.screen).setVisible(false);
            this.screen.remove(this.player);
            this.framePanel.add("Center", this.player);
            ((Component)this).setSize(this.preFullSize);
            Toolkit.getDefaultToolkit().sync();
            this.doResize();
        }
    }

    public void checkMenu() {
        boolean enable = this.player != null;
        this.itemSaveAs.setEnabled(enable);
        this.itemClose.setEnabled(enable || this.rtpd != null);
        this.itemPlugInViewer.setEnabled(enable);
        this.itemFullScreen.setEnabled(enable);
        this.itemSnapShot.setEnabled(enable && this.grabberControl != null);
    }

    private void sleep(long time) {
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (Exception exception) {}
    }

    String getURL() {
        return this.mediaURL;
    }

    private MenuBar createMenuBar() {
        MenuBar mb = new MenuBar();
        JMStudio al = this;
        Menu mnFile = new Menu(LABEL_FILE);
        MenuShortcut shortcut = new MenuShortcut(79);
        MenuItem item = new MenuItem(LABEL_OPENFILE, shortcut);
        mnFile.add(item);
        item.addActionListener(this);
        shortcut = new MenuShortcut(85);
        item = new MenuItem(LABEL_OPENURL, shortcut);
        mnFile.add(item);
        item.addActionListener(this);
        shortcut = new MenuShortcut(82);
        item = new MenuItem(LABEL_OPENRTPSESSION, shortcut);
        mnFile.add(item);
        item.addActionListener(this);
        shortcut = new MenuShortcut(80);
        item = new MenuItem(LABEL_CAPTUREPREVIEW, shortcut);
        mnFile.add(item);
        item.addActionListener(this);
        this.itemCaptureControls = new CheckboxMenuItem(LABEL_CAPTURECONTROLS, false);
        mnFile.add(this.itemCaptureControls);
        this.itemCaptureControls.setEnabled(false);
        this.itemCaptureControls.addItemListener(this);
        shortcut = new MenuShortcut(65);
        this.itemSaveAs = new MenuItem(LABEL_SAVEAS, shortcut);
        mnFile.add(this.itemSaveAs);
        this.itemSaveAs.addActionListener(this);
        shortcut = new MenuShortcut(84);
        item = new MenuItem(LABEL_TRANSMIT, shortcut);
        mnFile.add(item);
        item.addActionListener(this);
        shortcut = new MenuShortcut(87);
        this.itemClose = new MenuItem(LABEL_CLOSE, shortcut);
        mnFile.add(this.itemClose);
        this.itemClose.addActionListener(this);
        this.visited = new Menu(LABEL_VISITED);
        mnFile.add(this.visited);
        shortcut = new MenuShortcut(78);
        item = new MenuItem(LABEL_CLONE, shortcut);
        mnFile.add(item);
        item.addActionListener(this);
        mnFile.insertSeparator(7);
        mnFile.insertSeparator(9);
        shortcut = new MenuShortcut(86);
        this.itemPlugInViewer = new MenuItem(LABEL_PLUGINS, shortcut);
        mnFile.add(this.itemPlugInViewer);
        this.itemPlugInViewer.addActionListener(this);
        shortcut = new MenuShortcut(88);
        item = new MenuItem(LABEL_EXIT, shortcut);
        mnFile.add(item);
        item.addActionListener(this);
        mnFile.insertSeparator(12);
        Menu mnOptions = new Menu(LABEL_OPTIONS);
        this.cbAutoPlay = new CheckboxMenuItem(LABEL_AUTOPLAY);
        this.cbAutoPlay.setState(true);
        mnOptions.add(this.cbAutoPlay);
        this.cbAutoLoop = new CheckboxMenuItem(LABEL_AUTOLOOP);
        this.cbAutoLoop.setState(true);
        mnOptions.add(this.cbAutoLoop);
        this.cbAutoLoop.addItemListener(new 6());
        this.cbAspectRatio = new CheckboxMenuItem(LABEL_KEEPASPECT);
        this.cbAspectRatio.setState(false);
        mnOptions.add(this.cbAspectRatio);
        shortcut = new MenuShortcut(70);
        this.itemFullScreen = new MenuItem(LABEL_FULLSCREEN, shortcut);
        mnOptions.add(this.itemFullScreen);
        this.itemFullScreen.addActionListener(this);
        shortcut = new MenuShortcut(83);
        this.itemSnapShot = new MenuItem(LABEL_SNAPSHOT, shortcut);
        mnOptions.add(this.itemSnapShot);
        this.itemSnapShot.addActionListener(this);
        this.cbAspectRatio.addItemListener(new 7());
        Menu mnHelp = new Menu(LABEL_HELP);
        shortcut = new MenuShortcut(72);
        item = new MenuItem(LABEL_HELPABOUT, shortcut);
        mnHelp.add(item);
        item.addActionListener(this);
        this.menu = mnFile;
        mb.add(mnFile);
        mb.add(mnOptions);
        mb.add(mnHelp);
        return mb;
    }

    public void doResize() {
        if (this.inFullScreen) {
            return;
        }
        Dimension d2 = this.framePanel.getSize();
        int videoHeight = d2.height;
        if (this.controlComp != null) {
            if (this.visualComp != null && (videoHeight -= this.controlComp.getPreferredSize().height) < 2) {
                videoHeight = 2;
            }
            if (d2.width < 80) {
                d2.width = 80;
            }
            this.controlComp.setBounds(0, videoHeight, d2.width, this.controlComp.getPreferredSize().height);
            this.controlComp.invalidate();
        }
        if (this.visualComp != null) {
            this.player.setBounds(0, 0, d2.width, videoHeight);
        }
        this.framePanel.validate();
    }

    public void openURL() {
        if (this.urlDialog == null) {
            this.urlDialog = new OpenURLDialog(this);
        }
        this.urlDialog.show();
    }

    private boolean closeCapture() {
        if (this.player == null) {
            return true;
        }
        if (this.inputDataSource != null && this.inputDataSource instanceof CaptureDevice) {
            String result = MessageDialog.createOKCancelDialog(this, "Cannot open a capture device twice. Should I close the preview?");
            if (result != null && result.equals(" OK ")) {
                this.killThePlayer();
                this.player = null;
                return true;
            }
            return false;
        }
        return true;
    }

    public synchronized void killThePlayer() {
        if (this.player != null) {
            if (this.jmdControl != null && this.jmdControl instanceof Component) {
                Component c2 = (Component)((Object)this.jmdControl);
                c2.setVisible(false);
                this.jmdControl = null;
            }
            if (this.dlgCaptureControls != null) {
                this.dlgCaptureControls.dispose();
                this.dlgCaptureControls = null;
                this.itemCaptureControls.setState(false);
                this.itemCaptureControls.setEnabled(false);
            }
            this.player.close();
            this.progressBar = null;
            this.setTitle(APPNAME);
            this.filename = null;
            this.mediaURL = null;
            this.inputDataSource = null;
        }
    }

    public synchronized void controllerUpdate(ControllerEvent ce) {
        if (ce instanceof RealizeCompleteEvent) {
            int width = 320;
            int height = 0;
            this.insets = this.getInsets();
            if (this.rtpd != null) {
                this.closeRTPSession();
            }
            if (this.progressBar != null) {
                this.framePanel.remove(this.progressBar);
            }
            if (this.player != null && (this.visualComp = this.player.getVisualComponent()) != null) {
                width = this.player.getPreferredSize().width;
                height = this.player.getPreferredSize().height;
                width = (int)((double)width * defaultScale);
                height = (int)((double)height * defaultScale);
                this.framePanel.add(this.player);
                this.player.setBounds(0, 0, width, height);
                this.addPopupMenu(this.visualComp);
                this.newVideo = true;
            }
            if ((this.controlComp = this.player.getControlPanelComponent()) != null) {
                int prefHeight = this.controlComp.getPreferredSize().height;
                this.framePanel.add(this.controlComp);
                this.controlComp.setBounds(0, height, width, prefHeight);
                height += prefHeight;
                this.newVideo = true;
            }
            this.jmdControl = this.player.getControl("com.sun.media.JMD");
            this.grabberControl = (FrameGrabbingControl)this.player.getControl("javax.media.control.FrameGrabbingControl");
            if (this.filename != null) {
                if (this.filename.indexOf("file:") == 0) {
                    this.filename = this.filename.substring(5);
                }
                this.setTitle(String.valueOf(this.filename) + " - " + APPNAME);
            }
            this.player.prefetch();
            this.checkMenu();
        } else if (ce instanceof PrefetchCompleteEvent) {
            if (this.newVideo) {
                if (this.visualComp != null) {
                    Dimension vSize = this.player.getPreferredSize();
                    vSize.width = (int)((double)vSize.width * defaultScale);
                    vSize.height = (int)((double)vSize.height * defaultScale);
                    if (this.controlComp != null) {
                        vSize.height += this.controlComp.getPreferredSize().height;
                    }
                    this.panelResized = false;
                    ((Component)this).setSize(vSize.width + this.insets.left + this.insets.right, vSize.height + this.insets.top + this.insets.bottom);
                    int waited = 0;
                    while (!this.panelResized && waited < 2000) {
                        try {
                            waited += 50;
                            Thread.currentThread();
                            Thread.sleep(50L);
                            Thread.currentThread();
                            Thread.yield();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    int height = 1;
                    if (this.controlComp != null) {
                        height = this.controlComp.getPreferredSize().height;
                    }
                    ((Component)this).setSize(320 + this.insets.left + this.insets.right, height + this.insets.top + this.insets.bottom);
                }
                this.newVideo = false;
            }
            if (this.cbAutoPlay.getState() && this.player.getTargetState() != 600) {
                this.player.start();
            }
        } else if (ce instanceof ControllerErrorEvent) {
            MessageDialog.createErrorDialogModeless(this, "ControllerErrorEvent." + String.valueOf('\r') + ce.toString());
            this.killThePlayer();
            if (this.visualComp != null) {
                this.visualComp.remove(this.zoomMenu);
            }
            this.framePanel.removeAll();
            this.visualComp = null;
            this.controlComp = null;
            this.player.removeControllerListener(this);
            this.player.close();
            this.player = null;
            this.setBlankSize();
            this.progressBar = null;
        } else if (ce instanceof ControllerClosedEvent) {
            if (this.visualComp != null) {
                this.visualComp.remove(this.zoomMenu);
                this.visualComp = null;
            }
            if (this.controlComp != null) {
                this.controlComp = null;
            }
            this.player = null;
            this.framePanel.removeAll();
            this.framePanel.setSize(0, 0);
            System.gc();
            System.runFinalization();
            if (this.rtpd == null) {
                this.setBlankSize();
            } else {
                this.checkMenu();
            }
            this.progressBar = null;
            if (this.newPlayer != null) {
                this.player = this.newPlayer;
                this.filename = this.newFilename;
                this.inputDataSource = this.newDataSource;
                this.newFilename = null;
                this.newPlayer = null;
                this.newDataSource = null;
                this.player.addControllerListener(this);
                this.player.realize();
                this.validate();
            }
        } else if (ce instanceof DurationUpdateEvent) {
            Time t = ((DurationUpdateEvent)ce).getDuration();
        } else if (ce instanceof CachingControlEvent) {
            CachingControl cc;
            if (this.rtpd != null) {
                this.closeRTPSession();
            }
            if ((cc = ((CachingControlEvent)ce).getCachingControl()) != null && this.progressBar == null) {
                this.progressBar = cc.getControlComponent();
                if (this.progressBar == null) {
                    this.progressBar = cc.getProgressBarComponent();
                }
                if (this.progressBar != null) {
                    this.framePanel.add(this.progressBar);
                    Dimension prefSize = this.progressBar.getPreferredSize();
                    this.progressBar.setBounds(0, 0, prefSize.width, prefSize.height);
                    this.insets = this.getInsets();
                    this.framePanel.setSize(prefSize.width, prefSize.height);
                    ((Component)this).setSize(this.insets.left + this.insets.right + prefSize.width, this.insets.top + this.insets.bottom + prefSize.height);
                }
            }
        } else if (!(ce instanceof StartEvent || ce instanceof MediaTimeSetEvent || ce instanceof TransitionEvent || ce instanceof RateChangeEvent || ce instanceof StopTimeChangeEvent)) {
            if (ce instanceof SizeChangeEvent) {
                if (this.framePanel != null) {
                    SizeChangeEvent sce = (SizeChangeEvent)ce;
                    int nooWidth = (int)((double)sce.getWidth() * defaultScale);
                    int nooHeight = (int)((double)sce.getHeight() * defaultScale);
                    if (this.controlComp != null) {
                        nooHeight += this.controlComp.getPreferredSize().height;
                    }
                    if (this.framePanel.getSize().width != nooWidth || this.framePanel.getSize().height != nooHeight) {
                        ((Component)this).setSize(nooWidth + this.insets.left + this.insets.right, nooHeight + this.insets.top + this.insets.bottom);
                    } else {
                        this.doResize();
                    }
                }
            } else if (ce.getClass().getName().endsWith("ReplaceURLEvent")) {
                try {
                    Class.forName("com.ibm.media.ReplaceURLEvent").isAssignableFrom(ce.getClass());
                    Method m2 = ce.getClass().getMethod("getURL", null);
                    URL url = (URL)m2.invoke((Object)ce, null);
                    this.open(url.toString());
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        }
        if (ce instanceof FormatChangeEvent) {
            Dimension vSize = new Dimension(320, 0);
            Component oldVisualComp = this.visualComp;
            this.visualComp = this.player.getVisualComponent();
            if (this.visualComp != null && oldVisualComp != this.visualComp) {
                if (oldVisualComp != null) {
                    oldVisualComp.remove(this.zoomMenu);
                }
                this.framePanel.remove(this.player);
                vSize = this.player.getPreferredSize();
                vSize.width = (int)((double)vSize.width * defaultScale);
                vSize.height = (int)((double)vSize.height * defaultScale);
                this.framePanel.add(this.player);
                this.player.setBounds(0, 0, vSize.width, vSize.height);
                this.addPopupMenu(this.visualComp);
            }
            Component oldComp = this.controlComp;
            this.controlComp = this.player.getControlPanelComponent();
            if (this.controlComp != null && oldComp != this.controlComp) {
                this.framePanel.remove(oldComp);
                this.framePanel.add(this.controlComp);
                if (this.controlComp != null) {
                    int prefHeight = this.controlComp.getPreferredSize().height;
                    this.controlComp.setBounds(0, vSize.height, vSize.width, prefHeight);
                }
            }
        }
    }

    private void closeRTPSession() {
        Integer n2 = this.localLock;
        synchronized (n2) {
            if (this.rtpd == null) {
                Object var2_2 = null;
                return;
            }
            this.rtpd.close();
            this.rtpd = null;
        }
    }

    public void zoomTo(float z) {
        this.insets = this.getInsets();
        if (this.visualComp != null) {
            Dimension d2 = this.player.getPreferredSize();
            d2.width = (int)((float)d2.width * z);
            d2.height = (int)((float)d2.height * z);
            if (this.controlComp != null) {
                d2.height += this.controlComp.getPreferredSize().height;
            }
            ((Component)this).setSize(d2.width + this.insets.left + this.insets.right, d2.height + this.insets.top + this.insets.bottom);
        }
    }

    private void addPopupMenu(Component visual) {
        this.zoomMenu = new PopupMenu("Zoom");
        if (visual != null) {
            visual.add(this.zoomMenu);
        }
        MenuItem mi = new MenuItem("Scale 1:2");
        this.zoomMenu.add(mi);
        mi.addActionListener(this);
        mi = new MenuItem("Scale 1:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(this);
        mi = new MenuItem("Scale 2:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(this);
        mi = new MenuItem("Scale 4:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(this);
        if (visual != null) {
            visual.addMouseListener(new 8());
        }
    }

    public boolean openFile(String filename) {
        return this.open(filename);
    }

    public boolean open(Object source) {
        MediaLocator mrl = null;
        MediaPlayer player = null;
        String urlName = "Unknown";
        if (source instanceof String) {
            urlName = (String)source;
            mrl = new MediaLocator(urlName);
            if (mrl == null) {
                this.message("Can't build URL for " + urlName);
                return false;
            }
            player = this.createMediaPlayer((String)source);
        } else if (source instanceof DataSource) {
            mrl = ((DataSource)source).getLocator();
            urlName = mrl.toString();
            this.newDataSource = (DataSource)source;
            player = this.createMediaPlayer(this.newDataSource);
        }
        if (player != null) {
            player.setPlaybackLoop(this.cbAutoLoop.getState());
            player.setFixedAspectRatio(this.cbAspectRatio.getState());
            player.setPopupActive(false);
            player.setControlPanelVisible(false);
            this.itemClose.setEnabled(true);
            if (this.player == null) {
                this.player = player;
                this.inputDataSource = this.newDataSource;
                player.addControllerListener(this);
                player.realize();
                this.filename = urlName;
            } else {
                this.newPlayer = player;
                this.newFilename = urlName;
                this.killThePlayer();
            }
            String url = null;
            if (mrl != null) {
                url = mrl.toExternalForm();
            }
            if (url != null) {
                this.mediaURL = urlName;
                this.addToFileList(url);
                this.updateVisitedList();
            }
        }
        return player != null;
    }

    private int getVisitedIndex(String ext) {
        int index = -1;
        int i2 = 0;
        while (i2 < this.visited.getItemCount()) {
            String item = this.visited.getItem(i2).getLabel();
            if (item.equals(ext)) {
                return i2;
            }
            ++i2;
        }
        this.visited.add(new Menu(ext));
        return this.visited.getItemCount() - 1;
    }

    void addToFileList(String url) {
        if (fileList == null) {
            this.loadVisitedList();
        }
        int i2 = 0;
        while (i2 < fileList.size()) {
            if (((String)fileList.elementAt(i2)).equalsIgnoreCase(url)) {
                return;
            }
            ++i2;
        }
        fileList.addElement(url);
        this.saveVisitedList();
    }

    void loadVisitedList() {
        block4: {
            fileList = new Vector();
            String vf = System.getProperty("user.home");
            if (vf == null) break block4;
            visitedFile = String.valueOf(vf) + File.separator + "." + APPNAME;
            File fin = new File(visitedFile);
            try {
                if (fin.exists()) {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(fin));
                    while ((line = br.readLine()) != null) {
                        fileList.addElement(line);
                    }
                    br.close();
                    break block4;
                }
                queryCaptureCards = true;
                FileOutputStream fout = new FileOutputStream(visitedFile, true);
                fout.close();
            }
            catch (IOException iOException) {}
        }
    }

    void saveVisitedList() {
        block3: {
            if (visitedFile == null || fileList == null || fileList.size() <= 0) break block3;
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(visitedFile));
                int i2 = 0;
                while (i2 < fileList.size()) {
                    String url = (String)fileList.elementAt(i2);
                    bw.write(url, 0, url.length());
                    bw.newLine();
                    ++i2;
                }
                bw.close();
            }
            catch (IOException iOException) {
                System.err.println("Could not write visited file list");
            }
        }
    }

    synchronized void updateVisitedList() {
        if (this.fileListSize == fileList.size()) {
            return;
        }
        int i2 = this.fileListSize;
        while (i2 < fileList.size()) {
            String url = (String)fileList.elementAt(i2);
            int extpos = url.lastIndexOf(".");
            if (extpos >= 1) {
                String ext = url.substring(extpos + 1).toUpperCase();
                int index = this.getVisitedIndex(ext);
                Menu filetype = (Menu)this.visited.getItem(index);
                MenuItem m2 = new MenuItem(url);
                m2.addActionListener(this.vfl);
                filetype.add(m2);
            }
            ++i2;
        }
        this.fileListSize = fileList.size();
    }

    MediaPlayer createMediaPlayer(String mediaFile) {
        MediaPlayer player = null;
        player = new MediaPlayer();
        if (!mediaFile.equals("")) {
            player.setMediaLocator(new MediaLocator(mediaFile));
            if (player.getPlayer() == null) {
                this.message("Could not create player for " + mediaFile);
                return null;
            }
        }
        return player;
    }

    MediaPlayer createMediaPlayer(DataSource ds) {
        MediaPlayer player = null;
        player = new MediaPlayer();
        if (ds != null) {
            player.setDataSource(ds);
            if (player.getPlayer() == null) {
                this.message("Could not create player for " + ds);
                return null;
            }
        }
        return player;
    }

    public void fitFrame() {
        int controlHeight = 0;
        if (this.controlComp != null) {
            controlHeight = this.controlComp.getPreferredSize().height;
        }
        if (this.visualComp != null) {
            Dimension vcS = this.visualComp.getSize();
            Dimension d2 = this.framePanel.getSize();
            Insets s = this.getInsets();
            if (d2.width < vcS.width - 1 || d2.width > vcS.width + 1 || d2.height < vcS.height + controlHeight - 1 || d2.height > vcS.height + controlHeight + 1) {
                ((Component)this).setSize(vcS.width + s.left + s.right, vcS.height + controlHeight + s.top + s.bottom);
            }
        }
    }

    private void doQueryCaptureCards() {
        queryCaptureCards = false;
        Vector captureDevices = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
        if (captureDevices != null && captureDevices.size() > 0) {
            return;
        }
        Class<?> auto = null;
        try {
            auto = Class.forName("VFWAuto");
        }
        catch (Exception exception) {}
        if (auto == null) {
            try {
                auto = Class.forName("SunVideoAuto");
            }
            catch (Exception exception) {}
        }
        if (auto == null) {
            return;
        }
        Frame message = new Frame("Querying capture devices...");
        message.add(new Label("JMStudio is looking for Video Capture devices.This might take a few minutes."));
        message.pack();
        ((Component)message).setVisible(true);
        try {
            Object instance = auto.newInstance();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            this.message("Capture device query unsuccesful!");
        }
        message.dispose();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        String command = ae.getActionCommand();
        if (command == null && source instanceof MenuItem) {
            command = ((MenuItem)source).getActionCommand();
        }
        if (command.equals(LABEL_OPENFILE)) {
            if (this.fd == null) {
                this.fd = new FileDialog((Frame)this, LABEL_OPENFILE, 0);
            }
            this.fd.setDirectory(this.fileDirectory);
            this.fd.show();
            if (this.fd.getFile() != null) {
                this.fileDirectory = this.fd.getDirectory();
                String filename = String.valueOf(this.fileDirectory) + this.fd.getFile();
                this.openFile("file:" + filename);
            }
        } else if (command.equals(LABEL_OPENURL)) {
            this.openURL();
        } else if (command.equals(LABEL_SNAPSHOT)) {
            Image im;
            Buffer buf = this.grabberControl.grabFrame();
            if (this.bti == null || !buf.getFormat().equals(this.lastSnapFormat)) {
                this.bti = new BufferToImage((VideoFormat)buf.getFormat());
                this.lastSnapFormat = buf.getFormat();
            }
            if ((im = this.bti.createImage(buf)) != null) {
                if (this.snapFrame == null) {
                    this.snapFrame = new SnapFrame(im);
                    ((Component)this.snapFrame).setVisible(true);
                }
                this.snapFrame.setImage(im);
                this.snapFrame.setTitle(String.valueOf(this.filename) + " - Snap Shot");
            }
        } else if (command.equals(LABEL_CAPTUREPREVIEW)) {
            CaptureDialog dialogCapture = new CaptureDialog(this);
            dialogCapture.show();
            DataSource dataSource = dialogCapture.createCaptureDataSource();
            if (dataSource != null) {
                this.open(dataSource);
                if (dataSource != null) {
                    this.dlgCaptureControls = new CaptureControlsDialog((Frame)this, dataSource, this.itemCaptureControls);
                    if (this.dlgCaptureControls.isEmpty()) {
                        this.dlgCaptureControls = null;
                    } else {
                        ((Component)this.dlgCaptureControls).setVisible(true);
                        this.itemCaptureControls.setEnabled(true);
                        this.itemCaptureControls.setState(true);
                    }
                }
            }
        } else if (command.equals(LABEL_OPENRTPSESSION)) {
            if (this.rtpd != null) {
                JMStudio newWindow = new JMStudio(null, "RTP Session");
                newWindow.rtpd = new RTPDialog(newWindow);
            } else {
                this.rtpd = new RTPDialog(this);
            }
        } else if (command.equals(LABEL_SAVEAS)) {
            String urlString = this.getURL();
            Format format = this.getCaptureFormat();
            if (urlString != null && urlString.length() > 1 && this.closeCapture()) {
                SaveAsDialog sad = new SaveAsDialog((Frame)this, urlString, format);
            }
        } else if (command.equals(LABEL_TRANSMIT)) {
            String urlString = this.getURL();
            Format format = this.getCaptureFormat();
            if (this.closeCapture()) {
                TransmitWizard dlgTransmit = new TransmitWizard((Frame)this, urlString);
                dlgTransmit.show();
            }
        } else if (command.equals(LABEL_CLOSE)) {
            this.killThePlayer();
            if (this.rtpd != null) {
                this.closeRTPSession();
            }
        } else if (command.equals(LABEL_PLUGINS)) {
            if (this.player != null && this.jmdControl != null && this.jmdControl instanceof Component) {
                ((Component)((Object)this.jmdControl)).setVisible(true);
            }
        } else if (command.equals(LABEL_FULLSCREEN)) {
            this.fullScreen(true);
        } else if (command.equals(LABEL_EXIT)) {
            this.killThePlayer();
            JMStudio urlString = this;
            synchronized (urlString) {
                this.dispose();
            }
            if (--windowCount == 0) {
                this.saveVisitedList();
                System.exit(0);
            }
        } else if (command.indexOf("1:2") >= 0) {
            this.zoomTo(0.5f);
        } else if (command.indexOf("1:1") >= 0) {
            this.zoomTo(1.0f);
        } else if (command.indexOf("2:1") >= 0) {
            this.zoomTo(2.0f);
        } else if (command.indexOf("4:1") >= 0) {
            this.zoomTo(4.0f);
        } else if (command.equals(LABEL_CLONE)) {
            JMStudio jpnew = new JMStudio(null, null);
            jpnew.fileDirectory = this.fileDirectory;
            jpnew.cbAutoPlay.setState(this.cbAutoPlay.getState());
            jpnew.cbAutoLoop.setState(this.cbAutoLoop.getState());
            jpnew.cbAspectRatio.setState(this.cbAspectRatio.getState());
        } else if (command.equals(LABEL_HELPABOUT)) {
            AboutDialog.createDialog(this);
        }
    }

    private Format getCaptureFormat() {
        FormatControl[] fcs;
        Format format = null;
        if (this.inputDataSource != null && this.inputDataSource instanceof CaptureDevice && (fcs = ((CaptureDevice)((Object)this.inputDataSource)).getFormatControls()) != null && fcs.length > 0) {
            format = fcs[0].getFormat();
        }
        return format;
    }

    public void itemStateChanged(ItemEvent event) {
        Object objSource = event.getSource();
        if (objSource == this.itemCaptureControls) {
            boolean boolState = this.itemCaptureControls.getState();
            if (this.dlgCaptureControls != null) {
                ((Component)this.dlgCaptureControls).setVisible(boolState);
            }
        }
    }

    public static void main(String[] args) {
        int i2 = 0;
        while (i2 < args.length) {
            Object player = null;
            String mediaFile = args[i2];
            if (mediaFile.equals("-x") && i2 + 1 < args.length) {
                String scale = args[i2 + 1];
                try {
                    defaultScale = Double.valueOf(scale);
                }
                catch (NumberFormatException numberFormatException) {
                    defaultScale = 1.0;
                }
                i2 += 2;
                continue;
            }
            Object mrl = null;
            if (mediaFile.indexOf(":") < 2) {
                if (mediaFile.indexOf("/") != 0) {
                    mediaFile = "/" + mediaFile;
                }
                mediaFile = "file:" + mediaFile;
            }
            JMStudio jmstudio = new JMStudio(null, null);
            jmstudio.open(mediaFile);
            ++i2;
        }
        if (windowCount == 0) {
            new JMStudio(null, null);
        }
    }

    private void message(String s) {
        MessageDialog.createErrorDialog((Frame)this, s);
    }

    static {
        listenPort = 4000;
        fileList = null;
        visitedFile = null;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            JMStudio.this.open(ae.getActionCommand());
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            JMStudio.this.killThePlayer();
            if (JMStudio.this.rtpd != null) {
                JMStudio.this.closeRTPSession();
            }
            while (JMStudio.this.player != null) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            JMStudio jMStudio = JMStudio.this;
            synchronized (jMStudio) {
                JMStudio.this.dispose();
            }
            if (JMStudio.this.snapFrame != null) {
                JMStudio.this.snapFrame.dispose();
            }
            if (--windowCount == 0) {
                System.exit(0);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            JMStudio.this.panelResized = true;
            JMStudio.this.doResize();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            JMStudio.this.insets = JMStudio.this.getInsets();
            Dimension dim = JMStudio.this.getSize();
            JMStudio.this.framePanel.setSize(dim.width - JMStudio.this.insets.left - JMStudio.this.insets.right, dim.height - JMStudio.this.insets.top - JMStudio.this.insets.bottom);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends MouseAdapter {
        public void mouseClicked(MouseEvent me) {
            JMStudio.this.fullScreen(false);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            if (JMStudio.this.player != null) {
                JMStudio.this.player.setPlaybackLoop(JMStudio.this.cbAutoLoop.getState());
            }
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ItemListener {
        public void itemStateChanged(ItemEvent ie) {
            if (JMStudio.this.player != null) {
                JMStudio.this.player.setFixedAspectRatio(JMStudio.this.cbAspectRatio.getState());
                JMStudio.this.doResize();
                JMStudio.this.fitFrame();
            }
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                JMStudio.this.zoomMenu.show(JMStudio.this.visualComp, me.getX(), me.getY());
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                JMStudio.this.zoomMenu.show(JMStudio.this.visualComp, me.getX(), me.getY());
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                JMStudio.this.zoomMenu.show(JMStudio.this.visualComp, me.getX(), me.getY());
            }
        }

        /* synthetic */ 8() {
        }
    }

    public class OpenURLDialog
    extends Dialog {
        TextField url;

        OpenURLDialog(Frame frame) {
            super(frame, false);
            JMStudio.this = JMStudio.this;
            this.setTitle("Open URL");
            ((Component)this).setBackground(Color.lightGray);
            this.addWindowListener(new 9(this));
            this.setLayout(new BorderLayout());
            Panel row = new Panel();
            row.setLayout(new FlowLayout());
            row.add(new Label("URL:", 2));
            this.url = new TextField("", 30);
            this.url.addActionListener(new 10(this));
            row.add(this.url);
            this.add("North", row);
            row = new Panel();
            row.setLayout(new FlowLayout());
            Button button = new Button("Open");
            row.add(button);
            button.addActionListener(new 11(this));
            button = new Button("Cancel");
            row.add(button);
            button.addActionListener(new 12(this));
            this.add("South", row);
            this.pack();
            this.setResizable(false);
        }

        public void setVisible(boolean show) {
            super.setVisible(show);
            this.url.selectAll();
            this.url.requestFocus();
        }

        public void open() {
            if (JMStudio.this.open(this.url.getText())) {
                this.setVisible(false);
            }
        }

        public void cancel() {
            this.setVisible(false);
        }
    }
}

