/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.mpega;

import com.ibm.media.codec.audio.AudioCodec;
import com.sun.media.JMFSecurityManager;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeDecoder
extends AudioCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1998.";
    static final int MAX_MPEG_STREAM_FRAME_SIZE = 1728;
    static final int MAX_PCM_FRAME_SIZE = 2304;
    static final int INTERNAL_BUFFER_LEN = 86400;
    static final int DECODE_ONE_FRAME_ONLY = 0;
    static final int DECODE_MANY_FRAMES = 1;
    static final int MPEG_CD_QUALITY = 0;
    static final int MPEG_HIGH_QUALITY = 1;
    static final int MPEG_MEDIUM_QUALITY = 2;
    static final int MPEG_NOERROR = 0;
    static final int MPEG_ERROR = 1;
    private int mpegAudioQuality = 0;
    private int one_frame_flag = 1;
    private long[] pdata = new long[1];
    private int[] samp_freq = new int[1];
    private int[] stereo = new int[1];
    private int[] in_bytes_read = new int[1];
    private int[] num_samples_done = new int[1];
    private byte[] internalBuffer = new byte[86420];
    private int internalBufferDataLen;

    private static native int mpeg_initialization(long[] var0, int var1);

    private static native int mpeg_audio_decode(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7, int var8, int[] var9, int[] var10, int[] var11, int[] var12);

    private static native int mpeg_terminate(long var0);

    public NativeDecoder() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("mpegaudio")};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "MPEG Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmmpega");
            this.internalBufferDataLen = 0;
            NativeDecoder.mpeg_initialization(this.pdata, this.mpegAudioQuality);
            return;
        }
        catch (Throwable t) {
            System.out.println("Unable to load " + this.PLUGIN_NAME + "\n" + t);
            throw new ResourceUnavailableException("Unable to load " + this.PLUGIN_NAME);
        }
    }

    public void reset() {
        this.close();
        try {
            this.open();
        }
        catch (Exception exception) {}
    }

    public void close() {
        NativeDecoder.mpeg_terminate(this.pdata[0]);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int inpLength = inputBuffer.getLength();
        int outLength = 1764000;
        int returnResult = 0;
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
        if (86400 - this.internalBufferDataLen > inpLength) {
            System.arraycopy(inpData, inputBuffer.getOffset(), this.internalBuffer, this.internalBufferDataLen, inpLength);
            this.internalBufferDataLen += inpLength;
        } else {
            returnResult |= 2;
        }
        int rc = NativeDecoder.mpeg_audio_decode(this.pdata[0], this.internalBuffer, 0, this.internalBufferDataLen, outData, 0, outData.length, this.one_frame_flag, this.num_samples_done, this.in_bytes_read, this.samp_freq, this.stereo);
        if (rc != 0) {
            return returnResult | 1;
        }
        if (this.in_bytes_read[0] > this.internalBufferDataLen) {
            this.in_bytes_read[0] = this.internalBufferDataLen;
        }
        System.arraycopy(this.internalBuffer, this.in_bytes_read[0], this.internalBuffer, 0, this.internalBufferDataLen - this.in_bytes_read[0]);
        this.internalBufferDataLen -= this.in_bytes_read[0];
        outLength = this.num_samples_done[0] << 1;
        if (outLength > 0) {
            this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        } else {
            returnResult |= 4;
        }
        return returnResult;
    }
}

