/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import java.io.IOException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;

class MergingDataSource
extends DataSource {
    DataSource[] sources;
    SourceStream[] streams;

    MergingDataSource(DataSource[] sources) {
        this.sources = sources;
    }

    public String getContentType() {
        boolean isRaw = true;
        int index = 0;
        while (index < this.sources.length) {
            if (!this.sources[index].getContentType().equals("raw")) {
                isRaw = false;
                break;
            }
            ++index;
        }
        if (isRaw) {
            return "raw";
        }
        if (this.sources.length == 1) {
            return this.sources[0].getContentType();
        }
        return "application.mixed-data";
    }

    public void connect() throws IOException {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].connect();
            ++i2;
        }
    }

    public void disconnect() {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].disconnect();
            ++i2;
        }
    }

    public void start() throws IOException {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].start();
            ++i2;
        }
    }

    public void stop() throws IOException {
        int i2 = 0;
        while (i2 < this.sources.length) {
            this.sources[i2].stop();
            ++i2;
        }
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Time getDuration() {
        Time longest = new Time(0L);
        int i2 = 0;
        while (i2 < this.sources.length) {
            Time sourceDuration = this.sources[i2].getDuration();
            if (sourceDuration.getSeconds() > longest.getSeconds()) {
                longest = sourceDuration;
            }
            ++i2;
        }
        return longest;
    }
}

