/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import com.ibm.media.protocol.CloneableSourceStreamAdapter;
import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;

class SuperCloneableDataSource
extends DataSource {
    protected DataSource input;
    public CloneableSourceStreamAdapter[] streamsAdapters;
    public SourceStream[] streams;
    private Vector clones = new Vector();

    SuperCloneableDataSource(DataSource input) {
        this.input = input;
        SourceStream[] originalStreams = null;
        if (input instanceof PullDataSource) {
            originalStreams = ((PullDataSource)input).getStreams();
        }
        if (input instanceof PushDataSource) {
            originalStreams = ((PushDataSource)input).getStreams();
        }
        if (input instanceof PullBufferDataSource) {
            originalStreams = ((PullBufferDataSource)input).getStreams();
        }
        if (input instanceof PushBufferDataSource) {
            originalStreams = ((PushBufferDataSource)input).getStreams();
        }
        this.streamsAdapters = new CloneableSourceStreamAdapter[originalStreams.length];
        int i2 = 0;
        while (i2 < originalStreams.length) {
            this.streamsAdapters[i2] = new CloneableSourceStreamAdapter(originalStreams[i2]);
            ++i2;
        }
    }

    DataSource createClone() {
        DataSource newSlave = this.input instanceof PullDataSource || this.input instanceof PushDataSource ? new PushDataSourceSlave() : new PushBufferDataSourceSlave();
        this.clones.addElement(newSlave);
        return newSlave;
    }

    public String getContentType() {
        return this.input.getContentType();
    }

    public void connect() throws IOException {
        this.input.connect();
    }

    public void disconnect() {
        this.input.disconnect();
    }

    public void start() throws IOException {
        this.input.start();
    }

    public void stop() throws IOException {
        this.input.stop();
    }

    public Object[] getControls() {
        return this.input.getControls();
    }

    public Object getControl(String controlType) {
        return this.input.getControl(controlType);
    }

    public Time getDuration() {
        return this.input.getDuration();
    }

    class PushDataSourceSlave
    extends PushDataSource {
        PushSourceStream[] streams;

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public void connect() throws IOException {
        }

        public void disconnect() {
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }

        public PushSourceStream[] getStreams() {
            if (this.streams == null) {
                this.streams = new PushSourceStream[SuperCloneableDataSource.this.streamsAdapters.length];
                int i2 = 0;
                while (i2 < this.streams.length) {
                    this.streams[i2] = (PushSourceStream)SuperCloneableDataSource.this.streamsAdapters[i2].createSlave();
                    ++i2;
                }
            }
            return this.streams;
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Object getControl(String controlType) {
            return SuperCloneableDataSource.this.input.getControl(controlType);
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }

        PushDataSourceSlave() {
            SuperCloneableDataSource.this = SuperCloneableDataSource.this;
        }
    }

    class PushBufferDataSourceSlave
    extends PushBufferDataSource {
        PushBufferStream[] streams;

        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        public void connect() throws IOException {
        }

        public void disconnect() {
        }

        public void start() throws IOException {
        }

        public void stop() throws IOException {
        }

        public PushBufferStream[] getStreams() {
            if (this.streams == null) {
                this.streams = new PushBufferStream[SuperCloneableDataSource.this.streamsAdapters.length];
                int i2 = 0;
                while (i2 < this.streams.length) {
                    this.streams[i2] = (PushBufferStream)SuperCloneableDataSource.this.streamsAdapters[i2].createSlave();
                    ++i2;
                }
            }
            return this.streams;
        }

        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        public Object getControl(String controlType) {
            return SuperCloneableDataSource.this.input.getControl(controlType);
        }

        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }

        PushBufferDataSourceSlave() {
            SuperCloneableDataSource.this = SuperCloneableDataSource.this;
        }
    }
}

