/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.ResourceUnavailableException;

public abstract class BasicPlugIn
implements PlugIn {
    private static final boolean DEBUG = false;
    protected Object[] controls = new Control[0];
    private static boolean jdkInit;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;

    protected void error() {
        throw new RuntimeException(String.valueOf(this.getClass().getName()) + " PlugIn error");
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            int i2 = 0;
            while (i2 < cs.length) {
                if (cls.isInstance(cs[i2])) {
                    return cs[i2];
                }
                ++i2;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Format matches(Format in, Format[] outs) {
        int i2 = 0;
        while (i2 < outs.length) {
            if (in.matches(outs[i2])) {
                return outs[i2];
            }
            ++i2;
        }
        return null;
    }

    protected byte[] validateByteArraySize(Buffer buffer, int newSize) {
        byte[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof byte[]) {
            typedArray = (byte[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            byte[] tempArray = new byte[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new byte[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected short[] validateShortArraySize(Buffer buffer, int newSize) {
        short[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof short[]) {
            typedArray = (short[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            short[] tempArray = new short[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new short[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    protected int[] validateIntArraySize(Buffer buffer, int newSize) {
        int[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof int[]) {
            typedArray = (int[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            int[] tempArray = new int[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new int[newSize];
        }
        buffer.setData(typedArray);
        return typedArray;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = BasicPlugIn.class$("java.lang.Class"))).getMethod("forName", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = BasicPlugIn.class$("java.lang.String")), Boolean.TYPE, class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = BasicPlugIn.class$("java.lang.ClassLoader")));
            getSystemClassLoaderM = (class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = BasicPlugIn.class$("java.lang.ClassLoader"))).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = BasicPlugIn.class$("java.lang.ClassLoader"))), null);
            getContextClassLoaderM = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = BasicPlugIn.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e2) {
                if (!BasicPlugIn.checkIfJDK12()) {
                    throw new ClassNotFoundException(e2.getMessage());
                }
            }
            catch (Error e3) {
                if (BasicPlugIn.checkIfJDK12()) break block9;
                throw e3;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = BasicPlugIn.class$("java.lang.Class"))), className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = BasicPlugIn.class$("java.lang.Class"))), className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e4) {
                throw new ClassNotFoundException(e4.getMessage());
            }
            catch (Error e5) {
                throw e5;
            }
        }
    }

    public abstract String getName();

    public abstract void open() throws ResourceUnavailableException;

    public abstract void close();

    public abstract void reset();

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

