/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.codec.video.jpeg.NativeEncoder;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeEncoder
extends BasicCodec {
    private RGBFormat inputFormat;
    private VideoFormat outputFormat;
    private static boolean loaded;
    private static boolean canLoad;
    private int peer;
    private static int QSCALE;
    private float quality = 1.0f;
    private float prevQuality;
    private int PACKET_SIZE = 960;
    private int currentSeq = (int)System.currentTimeMillis();
    private long timestamp = (long)((double)System.currentTimeMillis() * Math.random());
    private byte[] rtp_data;
    private int copyLength = this.PACKET_SIZE;
    private boolean newframe = true;
    private int current_offset;
    int returnVal;
    private boolean dropFrame = false;
    private boolean minimal = false;
    private static final int DEFAULT_FRAMERATE = 15;

    public NativeEncoder() {
        this.inputFormats = new RGBFormat[1];
        this.inputFormats[0] = new RGBFormat();
        this.outputFormats = new VideoFormat[1];
        this.outputFormats[0] = new VideoFormat("jpeg");
        1.QCA qualityControl = new 1.QCA(this);
        1 fpc = new 1();
        this.controls = new Control[2];
        this.controls[0] = qualityControl;
        this.controls[1] = fpc;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(in)) {
            return new Format[0];
        }
        Format[] out = new Format[]{this.computeOutputFormat(in)};
        return out;
    }

    private boolean verifyInputFormat(Format input) {
        if (!(input instanceof RGBFormat)) {
            return false;
        }
        RGBFormat rgb = (RGBFormat)input;
        return rgb.getDataType() == Format.byteArray && rgb.getBitsPerPixel() == 24 && rgb.getRedMask() == 3 && rgb.getGreenMask() == 2 && rgb.getBlueMask() == 1 && rgb.getSize() != null && rgb.getLineStride() >= rgb.getSize().width && rgb.getPixelStride() == 3;
    }

    public Format setInputFormat(Format input) {
        if (!this.verifyInputFormat(input)) {
            return null;
        }
        this.inputFormat = (RGBFormat)input;
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (BasicPlugIn.matches(output, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (VideoFormat)output;
        return output;
    }

    private final VideoFormat computeOutputFormat(Format in) {
        RGBFormat rgb = (RGBFormat)in;
        Dimension size = rgb.getSize();
        int maxDataLength = size.width * size.height * 3;
        VideoFormat jpeg = new VideoFormat("jpeg", size, maxDataLength, Format.byteArray, rgb.getFrameRate());
        return jpeg;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native JPEG converter");
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmjpeg");
                loaded = true;
            }
            catch (Throwable throwable) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native JPEG encoder");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set on the JPEG encoder");
        }
        if (this.peer != 0) {
            this.close();
        }
        Dimension size = this.inputFormat.getSize();
        try {
            this.peer = this.initJPEGEncoder(size.width, size.height, (int)(this.quality * (float)QSCALE));
        }
        catch (Throwable throwable) {}
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize JPEG encoder");
        }
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeJPEGEncoder(this.peer);
        }
        this.peer = 0;
    }

    public void reset() {
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        boolean flipped;
        Object header = null;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (this.minimal || this.dropFrame) {
            outBuffer.setFlags(outBuffer.getFlags() | 2);
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        Format outFormat = outBuffer.getFormat();
        byte[] inData = (byte[])inBuffer.getData();
        boolean bl = flipped = ((RGBFormat)inFormat).getFlipped() == 1;
        if (this.outputFormat.getEncoding().equals("jpeg")) {
            float changeQuality;
            byte[] outData = (byte[])outBuffer.getData();
            if (outData == null || outData.length < this.outputFormat.getMaxDataLength()) {
                outData = new byte[this.outputFormat.getMaxDataLength()];
                outBuffer.setData(outData);
            }
            if (outFormat == null) {
                outBuffer.setFormat(this.outputFormat);
            }
            if (this.peer == 0) {
                try {
                    this.open();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    return 1;
                }
            }
            if (this.prevQuality != this.quality) {
                this.prevQuality = this.quality;
                changeQuality = this.quality * (float)QSCALE;
            } else {
                changeQuality = -1.0f;
            }
            Dimension size = this.inputFormat.getSize();
            this.returnVal = this.encodeJPEG(this.peer, inData, size.width, size.height, outData, outData.length, (int)changeQuality, flipped);
            if (this.returnVal > 0) {
                outBuffer.setLength(this.returnVal);
                outBuffer.setOffset(0);
                inBuffer.setLength(0);
                outBuffer.setFlags(16);
                outBuffer.setTimeStamp(inBuffer.getTimeStamp());
                return 0;
            }
            outBuffer.setDiscard(true);
            return 1;
        }
        return 1;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Encoder";
    }

    private native int initJPEGEncoder(int var1, int var2, int var3);

    private native int encodeJPEG(int var1, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7, boolean var8);

    private native boolean freeJPEGEncoder(int var1);

    public static void main(String[] args) {
        int width = 320;
        int height = 240;
        RGBFormat in = new RGBFormat(new Dimension(width, height), width * height * 3, Format.byteArray, -1.0f, 24, 1, 1, 2, 3, 3, width * 3, 0, -1);
        VideoFormat out = new VideoFormat("jpeg", new Dimension(width, height), width * height * 3, Format.byteArray, -1.0f);
        NativeEncoder e2 = new NativeEncoder();
        if (e2.setInputFormat(in) != null && e2.setOutputFormat(out) != null) {
            try {
                e2.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                System.err.println("Couldn't open encoder");
                System.exit(0);
            }
            byte[] rgbData = new byte[width * height * 3];
            System.err.println("Filling rgb data");
            int i2 = 0;
            while (i2 < width * height * 3) {
                rgbData[i2] = (byte)(i2 % 3 * (i2 % width) % 255);
                ++i2;
            }
            System.err.println("Encoding");
            Buffer inBuffer = new Buffer();
            inBuffer.setFormat(in);
            inBuffer.setData(rgbData);
            inBuffer.setLength(width * height * 3);
            Buffer outBuffer = new Buffer();
            outBuffer.setFormat(out);
            int result = e2.process(inBuffer, outBuffer);
            System.err.println("Result = " + result);
            e2.close();
        }
        System.exit(0);
    }

    static /* synthetic */ float access$0(NativeEncoder $0) {
        return $0.quality;
    }

    static /* synthetic */ void access$1(NativeEncoder $0, float $1) {
        $0.quality = $1;
    }

    static /* synthetic */ boolean access$4(NativeEncoder $0) {
        return $0.dropFrame;
    }

    static {
        canLoad = true;
        QSCALE = 100;
    }

    private final class 1
    implements FrameProcessingControl {
        public boolean setMinimalProcessing(boolean newMinimal) {
            NativeEncoder.this.minimal = newMinimal;
            return NativeEncoder.this.minimal;
        }

        public void setFramesBehind(float frames) {
            if (frames >= 1.0f) {
                NativeEncoder.this.dropFrame = true;
            } else {
                NativeEncoder.this.dropFrame = false;
            }
        }

        public Component getControlComponent() {
            return null;
        }

        public int getFramesDropped() {
            return 0;
        }

        /* synthetic */ 1() {
        }
    }
}

