/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import java.awt.Dimension;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.format.VideoFormat;

public class RTPDePacketizer {
    private long discardtimestamp = -1L;
    private JPEGFrame currentframe;
    private Vector misorderq = new Vector();
    private boolean newframe = true;
    private int sequenceNumber;
    private int quality;
    private int type = -1;

    public int getQuality() {
        return this.quality;
    }

    public int getType() {
        return this.type;
    }

    public int process(Buffer inBuffer) {
        if (inBuffer.getTimeStamp() == this.discardtimestamp) {
            return 4;
        }
        if (!this.newframe && this.currentframe != null && inBuffer.getTimeStamp() != this.currentframe.rtptimestamp) {
            if (!this.FirstPacket(inBuffer)) {
                this.discardtimestamp = inBuffer.getTimeStamp();
                this.misorderq.removeAllElements();
                this.newframe = true;
                return 4;
            }
            this.currentframe = this.CreateNewFrame(inBuffer);
            return 4;
        }
        if (this.newframe) {
            if (this.FirstPacket(inBuffer)) {
                this.newframe = false;
                this.currentframe = this.CreateNewFrame(inBuffer);
                return 4;
            }
            this.discardtimestamp = inBuffer.getTimeStamp();
            this.misorderq.removeAllElements();
            this.newframe = true;
            return 4;
        }
        if (inBuffer.getSequenceNumber() != this.currentframe.seqno + 1L) {
            if ((inBuffer.getFlags() & 0x400) != 0) {
                this.newframe = true;
                this.misorderq.removeAllElements();
                this.currentframe = null;
                return 4;
            }
            this.currentframe.misordered = true;
            this.InsertPkt(inBuffer);
            return 4;
        }
        Buffer b2 = this.MakeUpForLostPkts(inBuffer);
        int ret = this.AddToFrame(b2, inBuffer);
        return ret;
    }

    private void InsertPkt(Buffer inBuffer) {
        Buffer b2 = this.CopyInto(inBuffer);
        if (this.misorderq.size() == 0) {
            this.misorderq.insertElementAt(b2, 0);
            return;
        }
        int i2 = 0;
        while (i2 < this.misorderq.size()) {
            Buffer currpkt = (Buffer)this.misorderq.elementAt(i2);
            if (currpkt.getSequenceNumber() - inBuffer.getSequenceNumber() > 0L) {
                this.misorderq.insertElementAt(b2, i2);
                return;
            }
            ++i2;
        }
        this.misorderq.addElement(b2);
    }

    private int AddToFrame(Buffer currBuffer, Buffer inBuffer) {
        Buffer b2 = this.CopyInto(currBuffer);
        this.currentframe.Add(b2);
        if ((b2.getFlags() & 0x400) != 0) {
            int offset = b2.getOffset();
            byte[] inBuff = (byte[])b2.getData();
            this.type = inBuff[offset + 4] & 0xFF;
            this.quality = inBuff[offset + 5] & 0xFF;
            int width = inBuff[offset + 6] & 0xFF;
            int height = inBuff[offset + 7] & 0xFF;
            int outoffset = 0;
            byte[] dest = new byte[this.currentframe.datalength];
            int i2 = 0;
            while (i2 < this.currentframe.data.size()) {
                Buffer src = (Buffer)this.currentframe.data.elementAt(i2);
                System.arraycopy((byte[])src.getData(), offset + 8, dest, outoffset, src.getLength() - 8);
                outoffset += src.getLength() - 8;
                ++i2;
            }
            Dimension d2 = new Dimension(width * 8, height * 8);
            inBuffer.setFormat(new VideoFormat("jpeg", d2, outoffset, inBuffer.getFormat().getDataType(), -1.0f));
            inBuffer.setData(dest);
            inBuffer.setLength(outoffset);
            inBuffer.setTimeStamp(0L);
            inBuffer.setSequenceNumber(this.sequenceNumber++);
            this.newframe = true;
            this.misorderq.removeAllElements();
            this.currentframe = null;
            return 0;
        }
        return 4;
    }

    private Buffer MakeUpForLostPkts(Buffer inBuffer) {
        Buffer b2 = this.CopyInto(inBuffer);
        if (this.misorderq == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.misorderq.size()) {
            Buffer currpkt = (Buffer)this.misorderq.elementAt(i2);
            if (currpkt.getSequenceNumber() != this.currentframe.seqno + 1L) break;
            this.currentframe.Add(b2);
            ++i2;
        }
        return b2;
    }

    private boolean FirstPacket(Buffer inBuffer) {
        if (inBuffer == null) {
            return false;
        }
        byte[] fragoffset = new byte[3];
        byte[] payload = (byte[])inBuffer.getData();
        if (payload == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < 3) {
            System.arraycopy(payload, inBuffer.getOffset() + 1 + i2, fragoffset, i2, 1);
            ++i2;
        }
        return fragoffset[0] == 0 && fragoffset[1] == 0 && fragoffset[2] == 0;
    }

    private JPEGFrame CreateNewFrame(Buffer inBuffer) {
        Buffer b2 = this.CopyInto(inBuffer);
        JPEGFrame newframe = new JPEGFrame(b2);
        newframe.Add(b2);
        return newframe;
    }

    private Buffer CopyInto(Buffer src) {
        Buffer dest = new Buffer();
        dest.setData(src.getData());
        src.setData(null);
        dest.setSequenceNumber(src.getSequenceNumber());
        dest.setTimeStamp(src.getTimeStamp());
        dest.setHeader(src.getHeader());
        src.setHeader(null);
        dest.setFormat(src.getFormat());
        dest.setLength(src.getLength());
        dest.setOffset(src.getOffset());
        dest.setFlags(src.getFlags());
        return dest;
    }

    class JPEGFrame {
        public long rtptimestamp = -1L;
        public long seqno = -1L;
        public boolean misordered = false;
        private int datalength;
        private Vector data = new Vector();

        public JPEGFrame(Buffer buffer) {
            RTPDePacketizer.this = RTPDePacketizer.this;
            this.rtptimestamp = buffer.getTimeStamp();
        }

        public void Add(Buffer buffer) {
            this.data.addElement(buffer);
            this.seqno = buffer.getSequenceNumber();
            this.datalength += buffer.getLength() - 8;
        }

        public Vector getData() {
            return this.data;
        }

        public int getLength() {
            return this.datalength;
        }
    }
}

