/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.vcm;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.format.AviVideoFormat;
import com.sun.media.util.DynamicPlugIn;
import com.sun.media.vfw.BitMapInfo;
import com.sun.media.vfw.ICInfo;
import com.sun.media.vfw.VCM;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.control.QualityControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeDecoder
extends BasicCodec
implements DynamicPlugIn {
    private static boolean loaded;
    protected VideoFormat inputFormat;
    protected VideoFormat outputFormat;
    private static String[] supportedEncodings;
    private int vcmHandle;
    private boolean debug = false;
    private BitMapInfo biIn;
    private BitMapInfo biOut;
    private boolean dropFrame = false;
    private Control[] controls;
    private DC dc;

    public NativeDecoder() {
        if (!loaded) {
            throw new UnsatisfiedLinkError("Cannot load native libraries");
        }
        this.inputFormats = new VideoFormat[1];
        this.inputFormats[0] = new VideoFormat(null);
        this.outputFormats = new VideoFormat[1];
        this.outputFormats[0] = new RGBFormat();
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    private static synchronized void querySupportedEncodings() {
        boolean result;
        int i2;
        ICInfo icinfo = new ICInfo();
        BitMapInfo biOut = new BitMapInfo();
        Vector<String> listEncoding = new Vector<String>();
        for (i2 = 0; (result = VCM.icInfoEnum("vidc", i2, icinfo = new ICInfo())) && i2 <= 30; ++i2) {
            int handle;
            if (icinfo.fccHandler == null || icinfo.fccHandler.equalsIgnoreCase("mjpg") || icinfo.fccHandler.equalsIgnoreCase("iv32") || icinfo.fccHandler.equalsIgnoreCase("cvid") || (handle = VCM.icOpen("vidc", icinfo.fccHandler, 2)) == 0) continue;
            if (icinfo.fccHandler.equalsIgnoreCase("ir41")) {
                icinfo.fccHandler = "IV41";
            }
            listEncoding.addElement(icinfo.fccHandler);
            VCM.icClose(handle);
        }
        listEncoding.addElement("YVU9");
        supportedEncodings = new String[listEncoding.size()];
        i2 = 0;
        while (i2 < supportedEncodings.length) {
            NativeDecoder.supportedEncodings[i2] = (String)listEncoding.elementAt(i2);
            ++i2;
        }
    }

    public Format[] getSupportedInputFormats() {
        if (supportedEncodings == null) {
            NativeDecoder.querySupportedEncodings();
        }
        this.inputFormats = new VideoFormat[supportedEncodings.length];
        int i2 = 0;
        while (i2 < supportedEncodings.length) {
            this.inputFormats[i2] = new VideoFormat(supportedEncodings[i2]);
            ++i2;
        }
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (BasicPlugIn.matches(in, this.inputFormats) == null) {
            return new Format[0];
        }
        VideoFormat video = (VideoFormat)in;
        Dimension size = video.getSize();
        if (size == null) {
            size = new Dimension(320, 240);
        }
        RGBFormat[] tryFormats = new RGBFormat[]{new RGBFormat(size, size.width * size.height * 3, Format.byteArray, video.getFrameRate(), 24, 0, 3, 2, 1, 3, size.width * 3, 1, -1), new RGBFormat(size, size.width * size.height * 3, Format.byteArray, video.getFrameRate(), 24, 0, 3, 2, 1, 3, size.width * 3, 0, -1), new RGBFormat(size, size.width * size.height, Format.shortArray, video.getFrameRate(), 16, 1, 31744, 992, 31, 1, size.width, 0, -1), new RGBFormat(size, size.width * size.height, Format.shortArray, video.getFrameRate(), 16, 1, 31744, 992, 31, 1, size.width, 1, -1)};
        if (this.debug) {
            System.err.println("Input format = " + new BitMapInfo(video));
        }
        Vector<RGBFormat> supportedOuts = new Vector<RGBFormat>();
        int handle = VCM.icLocate("vidc", "RGB", new BitMapInfo(video), null, 2);
        if (handle != 0) {
            int n2 = 0;
            while (n2 < tryFormats.length) {
                if (VCM.icDecompressBegin(handle, new BitMapInfo(video), new BitMapInfo(tryFormats[n2]))) {
                    supportedOuts.addElement(tryFormats[n2]);
                    VCM.icDecompressEnd(handle);
                }
                ++n2;
            }
            VCM.icClose(handle);
        }
        Format[] outs = new Format[supportedOuts.size()];
        int i2 = 0;
        while (i2 < outs.length) {
            outs[i2] = (Format)supportedOuts.elementAt(i2);
            ++i2;
        }
        return outs;
    }

    public Format setInputFormat(Format in) {
        String encoding = in.getEncoding();
        if (encoding.equalsIgnoreCase("iv32") || encoding.equalsIgnoreCase("cvid") || encoding.equalsIgnoreCase("mjpg") || encoding.equalsIgnoreCase("RGB")) {
            return null;
        }
        if (in instanceof VideoFormat && BasicPlugIn.matches(in, this.inputFormats) != null) {
            this.inputFormat = (VideoFormat)in;
            return in;
        }
        return null;
    }

    public Format setOutputFormat(Format out) {
        if (out instanceof RGBFormat) {
            this.outputFormat = (RGBFormat)out;
            if (this.debug) {
                System.err.println("VCM.setOutputFormat : " + this.outputFormat);
            }
            return out;
        }
        return null;
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set!");
        }
        Dimension size = this.inputFormat.getSize();
        BitMapInfo bi = null;
        String inFourCC = this.inputFormat.getEncoding();
        this.biOut = new BitMapInfo();
        if (this.inputFormat instanceof AviVideoFormat) {
            bi = new BitMapInfo(this.inputFormat);
            if (this.debug) {
                System.err.println("VCM.open, BMI = " + bi);
            }
        }
        this.biIn = bi != null && bi instanceof BitMapInfo ? bi : new BitMapInfo(inFourCC, size.width, size.height);
        String cramHack = inFourCC;
        if (cramHack.equalsIgnoreCase("cram")) {
            cramHack = "msvc";
        }
        this.vcmHandle = VCM.icLocate("vidc", "RGB", this.biIn, null, 2);
        if (this.debug) {
            System.err.println("open.vcmHandle for " + inFourCC + " = " + this.vcmHandle);
        }
        if (this.vcmHandle == 0) {
            throw new ResourceUnavailableException("Could not open VCM driver");
        }
        BitMapInfo testOut = new BitMapInfo();
        if (this.debug) {
            System.err.println("open.preferred out = " + testOut);
        }
        this.biOut = new BitMapInfo(this.outputFormat);
        if (this.debug) {
            System.err.println("open.requested out = " + this.biOut);
        }
        boolean tryFlip = true;
        boolean result = VCM.icDecompressBegin(this.vcmHandle, this.biIn, this.biOut);
        if (!result) {
            if (this.debug) {
                System.err.println("VCM.open : Could not set i/o format");
            }
            this.close();
            throw new ResourceUnavailableException("Formats not supported");
        }
    }

    public void close() {
        if (this.vcmHandle != 0) {
            VCM.icClose(this.vcmHandle);
        }
        this.vcmHandle = 0;
    }

    public void reset() {
        if (this.vcmHandle != 0) {
            VCM.icDecompressEnd(this.vcmHandle);
            VCM.icDecompressBegin(this.vcmHandle, this.biIn, this.biOut);
        }
    }

    public int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        Format outf = outBuffer.getFormat();
        Object outBuf = outBuffer.getData();
        if (outf == null) {
            outBuffer.setFormat(this.outputFormat);
        }
        int bufType = 1;
        if (this.outputFormat.getDataType() == Format.byteArray) {
            if (outBuf == null || !(outBuf instanceof byte[]) || ((byte[])outBuf).length < this.outputFormat.getMaxDataLength()) {
                outBuf = new byte[this.outputFormat.getMaxDataLength()];
                outBuffer.setData(outBuf);
            }
        } else if (this.outputFormat.getDataType() == Format.shortArray) {
            if (outBuf == null || !(outBuf instanceof short[]) || ((short[])outBuf).length < this.outputFormat.getMaxDataLength()) {
                outBuf = new short[this.outputFormat.getMaxDataLength()];
                outBuffer.setData(outBuf);
            }
            bufType = 2;
        }
        Object inBuf = inBuffer.getData();
        long flags = 0L;
        int size = inBuffer.getLength();
        if (size < 2) {
            return 1;
        }
        Object header = inBuffer.getHeader();
        if (header != null && header instanceof Integer) {
            flags = ((Integer)header).intValue();
        }
        if (this.dropFrame) {
            flags |= 0x20000000L;
        }
        this.biIn.biSizeImage = size;
        int result = VCM.icDecompress(this.vcmHandle, flags, this.biIn, inBuf, this.biOut, outBuf, bufType);
        if (this.dropFrame) {
            outBuffer.setDiscard(true);
        } else {
            outBuffer.setLength(this.outputFormat.getMaxDataLength());
        }
        if (result < 0) {
            return 1;
        }
        return 0;
    }

    public Object[] getControls() {
        if (this.dc == null) {
            this.dc = new DC();
            this.controls = new Control[1];
            this.controls[0] = this.dc;
        }
        return this.controls;
    }

    public String getName() {
        return "VCM Decoder";
    }

    void dropNextFrame(boolean on) {
        this.dropFrame = on;
    }

    public Format[] getBaseInputFormats() {
        Format[] formats = new Format[]{new VideoFormat(null)};
        return formats;
    }

    public Format[] getBaseOutputFormats() {
        Format[] formats = new Format[]{new RGBFormat()};
        return formats;
    }

    static {
        JMFSecurityManager.loadLibrary("jmvcm");
        loaded = true;
        supportedEncodings = null;
    }

    class DC
    implements FrameProcessingControl,
    QualityControl {
        public Component getControlComponent() {
            return null;
        }

        public boolean setMinimalProcessing(boolean on) {
            NativeDecoder.this.dropNextFrame(true);
            return true;
        }

        public void setFramesBehind(float framesBehind) {
            if (framesBehind > 0.0f) {
                NativeDecoder.this.dropNextFrame(true);
            } else {
                NativeDecoder.this.dropNextFrame(false);
            }
        }

        public int getFramesDropped() {
            return 0;
        }

        public float setQuality(float quality) {
            return 1.0f;
        }

        public float getQuality() {
            return 1.0f;
        }

        public float getPreferredQuality() {
            return 1.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return true;
        }

        DC() {
            NativeDecoder.this = NativeDecoder.this;
        }
    }
}

