/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.controls.AtomicControlAdapter;
import com.sun.media.controls.NumericControl;
import com.sun.media.controls.NumericControlAdapter;
import com.sun.media.ui.Slider;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.media.Control;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public class GainControlAdapter
implements GainControl {
    Vector listeners;
    boolean muteState;
    Component component;
    NumericControl volumeControl;
    static float DefLevel = 0.4f;
    float dB;
    float level = DefLevel;

    public GainControlAdapter() {
    }

    public GainControlAdapter(boolean mute) {
        this.muteState = mute;
        this.setLevel(DefLevel);
    }

    public void setMute(boolean mute) {
        if (this.muteState != mute) {
            this.muteState = mute;
            this.informListeners();
        }
    }

    public boolean getMute() {
        return this.muteState;
    }

    public float setDB(float gain) {
        if (this.dB != gain) {
            float mult;
            this.dB = gain;
            this.level = mult = (float)Math.pow(10.0, (double)this.dB / 20.0);
            if ((double)this.level < 0.0) {
                this.setLevel(0.0f);
            } else if ((double)this.level > 1.0) {
                this.setLevel(1.0f);
            } else {
                this.informListeners();
                if (this.volumeControl != null) {
                    ((AtomicControlAdapter)((Object)this.volumeControl)).informListeners();
                }
            }
        }
        return this.dB;
    }

    public float getDB() {
        return this.dB;
    }

    public float setLevel(float level) {
        if ((double)level < 0.0) {
            level = 0.0f;
        }
        if ((double)level > 1.0) {
            level = 1.0f;
        }
        if (this.level != level) {
            this.level = level;
            this.dB = (float)(Math.log(level == 0.0f ? 1.0E-4 : (double)level) / Math.log(10.0) * 20.0);
            this.informListeners();
            if (this.volumeControl != null) {
                ((AtomicControlAdapter)((Object)this.volumeControl)).informListeners();
            }
        }
        return this.level;
    }

    public float getLevel() {
        return this.level;
    }

    public synchronized void addGainChangeListener(GainChangeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.addElement(listener);
        }
    }

    public synchronized void removeGainChangeListener(GainChangeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    public Component getControlComponent() {
        if (this.component == null) {
            float[] detents = new float[]{};
            this.component = new Slider(detents, new Color(128, 128, 128));
            this.volumeControl = new VolumeControl(0.0f, 1.0f, 0.5f, 0.001f, false, this.component, true, null);
            ((Slider)this.component).setControl(this.volumeControl);
        }
        return this.component;
    }

    protected synchronized void informListeners() {
        if (this.listeners != null) {
            GainChangeEvent gce = new GainChangeEvent(this, this.muteState, this.dB, this.level);
            int i2 = 0;
            while (i2 < this.listeners.size()) {
                GainChangeListener gcl = (GainChangeListener)this.listeners.elementAt(i2);
                gcl.gainChange(gce);
                ++i2;
            }
        }
    }

    class VolumeControl
    extends NumericControlAdapter {
        int type;

        public VolumeControl(float ll, float ul, float dv, float gran, boolean log, Component comp, boolean def, Control paren) {
            super(ll, ul, dv, gran, log, comp, def, paren);
            GainControlAdapter.this = GainControlAdapter.this;
        }

        public float setValue(float val) {
            if (GainControlAdapter.this.getLevel() != val) {
                GainControlAdapter.this.setLevel(val);
                System.err.println("setValue: " + val);
                this.informListeners();
            }
            return val;
        }

        public float getValue() {
            return GainControlAdapter.this.getLevel();
        }
    }
}

