/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class GsmParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private Format format;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private int encoding;
    private String encodingString;
    private int sampleRate;
    private int samplesPerBlock;
    private int bytesPerSecond = 1650;
    private int blockSize = 33;
    private long minLocation;
    private long maxLocation;
    private PullSourceStream stream;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.x_gsm")};

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        this.readHeader();
        this.bufferSize = this.bytesPerSecond;
        this.tracks[0] = new GsmTrack((AudioFormat)this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        this.minLocation = this.getLocation(this.stream);
        long contentLength = this.stream.getContentLength();
        if (contentLength != -1L) {
            double durationSeconds = contentLength / (long)this.bytesPerSecond;
            this.duration = new Time(durationSeconds);
            this.maxLocation = contentLength;
        } else {
            this.maxLocation = Long.MAX_VALUE;
        }
        boolean signed = true;
        boolean bigEndian = false;
        this.format = new AudioFormat("gsm", 8000.0, 16, 1, bigEndian ? 1 : 0, signed ? 1 : 0, this.blockSize * 8, -1.0, Format.byteArray);
    }

    public Time setPosition(Time where, int rounding) {
        if (!this.seekable) {
            return this.getMediaTime();
        }
        long time = where.getNanoseconds();
        if (time < 0L) {
            time = 0L;
        }
        double newPosd = (double)(time * (long)this.bytesPerSecond) / 1.0E9;
        double remainder = newPosd % (double)this.blockSize;
        long newPos = (long)(newPosd - remainder);
        if (remainder > 0.0) {
            switch (rounding) {
                case 1: {
                    newPos += (long)this.blockSize;
                    break;
                }
                case 3: {
                    if (!(remainder > (double)this.blockSize / 2.0)) break;
                    newPos += (long)this.blockSize;
                    break;
                }
            }
        }
        if (newPos > this.maxLocation) {
            newPos = this.maxLocation;
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(newPos += this.minLocation);
        if (this.cacheStream != null) {
            GsmParser gsmParser = this;
            synchronized (gsmParser) {
                this.cacheStream.abortRead();
            }
        }
        return where;
    }

    public Time getMediaTime() {
        long seekLocation = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long location = seekLocation != -1L ? seekLocation - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)location / (double)this.bytesPerSecond);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        long mediaSizeAtEOM;
        if (this.duration.equals(Duration.DURATION_UNKNOWN) && this.tracks[0] != null && (mediaSizeAtEOM = ((BasicTrack)this.tracks[0]).getMediaSizeAtEOM()) > 0L) {
            double durationSeconds = mediaSizeAtEOM / (long)this.bytesPerSecond;
            this.duration = new Time(durationSeconds);
        }
        return this.duration;
    }

    public String getName() {
        return "Parser for raw GSM";
    }

    class GsmTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame = 0.02f;
        private SettableTime frameToTime = new SettableTime();

        GsmTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize, long minLocation, long maxLocation) {
            super(GsmParser.this, format, enabled, GsmParser.this.duration, startTime, numBuffers, bufferSize, GsmParser.this.stream, minLocation, maxLocation);
            GsmParser.this = GsmParser.this;
            double sampleRate = format.getSampleRate();
            int channels = format.getChannels();
            int sampleSizeInBits = format.getSampleSizeInBits();
            long durationNano = this.duration.getNanoseconds();
        }

        GsmTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize) {
            this(format, enabled, startTime, numBuffers, bufferSize, 0L, Long.MAX_VALUE);
        }
    }
}

