/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.rtp;

import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.rtp.RTPSourceStream;
import java.io.IOException;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.RTPControl;

public class DataSource
extends BasicPushBufferDataSource {
    private PushBufferStream[] srcStreams = new PushBufferStream[1];
    private boolean stopped = true;
    Player streamplayer;
    RTPSessionMgr mgr;
    RTPControl rtpcontrol = new RTPControlImpl();
    DataSource childsrc;

    public void setMgr(RTPSessionMgr mgr) {
        System.out.println("manager being set to " + mgr);
        this.mgr = mgr;
    }

    public RTPSessionMgr getMgr() {
        return this.mgr;
    }

    public void setChild(DataSource source) {
        this.childsrc = source;
    }

    public DataSource() {
        this.setContentType("rtp");
    }

    public PushBufferStream[] getStreams() {
        if (!this.connected) {
            return null;
        }
        return this.srcStreams;
    }

    public void setPlayer(Player player) {
        this.streamplayer = player;
    }

    public Player getPlayer() {
        return this.streamplayer;
    }

    public void setSourceStream(PushBufferStream stream) {
        if (this.srcStreams != null) {
            this.srcStreams[0] = stream;
        }
    }

    public void setLocator(MediaLocator mrl) {
        super.setLocator(mrl);
    }

    public void start() throws IOException {
        super.start();
        if (this.childsrc != null) {
            this.childsrc.start();
        }
        if (this.srcStreams != null) {
            int i2 = 0;
            while (i2 < this.srcStreams.length) {
                ((RTPSourceStream)this.srcStreams[i2]).start();
                ++i2;
            }
        }
    }

    public void stop() throws IOException {
        super.stop();
        if (this.childsrc != null) {
            this.childsrc.stop();
        }
        if (this.srcStreams != null) {
            int i2 = 0;
            while (i2 < this.srcStreams.length) {
                ((RTPSourceStream)this.srcStreams[i2]).stop();
                ++i2;
            }
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void connect() throws IOException {
        if (this.mgr != null) {
            this.mgr.startSession();
        }
        if (this.srcStreams != null) {
            int i2 = 0;
            while (i2 < this.srcStreams.length) {
                if (this.srcStreams[i2] != null) {
                    ((RTPSourceStream)this.srcStreams[i2]).connect();
                }
                ++i2;
            }
        }
        this.connected = true;
    }

    public void disconnect() {
        if (this.srcStreams != null) {
            int i2 = 0;
            while (i2 < this.srcStreams.length) {
                ((RTPSourceStream)this.srcStreams[i2]).close();
                ++i2;
            }
        }
        if (this.mgr != null) {
            this.mgr.removeDataSource(this);
            this.mgr.closeSession();
            this.mgr = null;
            this.started = false;
            this.connected = false;
            return;
        }
    }

    public Object[] getControls() {
        Object[] controls = new RTPControl[]{this.rtpcontrol};
        return controls;
    }

    public void setControl(Object control) {
        this.rtpcontrol = (RTPControl)control;
    }

    public Object getControl(String controlName) {
        if (controlName.equals("javax.media.rtp.RTPControl")) {
            return this.rtpcontrol;
        }
        return null;
    }
}

