/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.renderer.video.HeavyComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;

public abstract class BasicVideoRenderer
extends BasicPlugIn
implements VideoRenderer,
FrameGrabbingControl {
    protected String name;
    protected transient VideoFormat[] supportedFormats;
    protected VideoFormat inputFormat;
    protected int outWidth = -1;
    protected int outHeight = -1;
    protected int inWidth = -1;
    protected int inHeight = -1;
    protected Component component;
    protected ComponentListener compListener;
    protected boolean componentAvailable = false;
    protected Rectangle bounds;
    protected boolean started = false;
    protected Control[] controls;
    protected FrameGrabbingControl frameGrabber;
    protected Buffer lastBuffer = new Buffer();
    protected Object lastData;

    public BasicVideoRenderer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void close() {
    }

    public void reset() {
    }

    public int process(Buffer inbuffer) {
        int result;
        Buffer buffer = this.lastBuffer;
        synchronized (buffer) {
            result = this.doProcess(inbuffer);
            if (result == 0 && inbuffer.getData() != null) {
                this.lastBuffer.setData(inbuffer.getData());
                this.lastBuffer.setFlags(inbuffer.getFlags());
                this.lastBuffer.setFormat(inbuffer.getFormat());
                this.lastBuffer.setHeader(inbuffer.getHeader());
                this.lastBuffer.setLength(inbuffer.getLength());
                this.lastBuffer.setOffset(inbuffer.getOffset());
                inbuffer.setData(this.lastData);
                this.lastData = this.lastBuffer.getData();
            }
        }
        return result;
    }

    protected abstract int doProcess(Buffer var1);

    public Format setInputFormat(Format format) {
        if (BasicPlugIn.matches(format, this.supportedFormats) != null) {
            this.inputFormat = (VideoFormat)format;
            Dimension size = this.inputFormat.getSize();
            if (size != null) {
                this.inWidth = size.width;
                this.inHeight = size.height;
            }
            return format;
        }
        return null;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public Component getComponent() {
        if (this.component == null) {
            try {
                Class<?> mshc = Class.forName("com.sun.media.renderer.video.MSHeavyComponent");
                if (mshc != null) {
                    this.component = (Component)mshc.newInstance();
                }
            }
            catch (Throwable throwable) {
                this.component = new HeavyComponent();
            }
            ((HeavyComponent)this.component).setRenderer(this);
            this.component.setBackground(this.getPreferredBackground());
            if (this.compListener == null) {
                this.compListener = new CompListener();
            }
            this.component.addComponentListener(this.compListener);
        }
        return this.component;
    }

    public synchronized boolean setComponent(Component comp) {
        this.reset();
        this.component = comp;
        if (this.compListener == null) {
            this.compListener = new CompListener();
        }
        this.component.addComponentListener(this.compListener);
        return true;
    }

    public void setBounds(Rectangle rect) {
        this.bounds = rect;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected Color getPreferredBackground() {
        return Color.black;
    }

    void resized(Component c2) {
        if (c2 != null && c2 == this.component) {
            Dimension d2 = this.component.getSize();
            this.outWidth = d2.width;
            this.outHeight = d2.height;
        }
    }

    synchronized void setAvailable(boolean on) {
        this.componentAvailable = on;
        if (!this.componentAvailable) {
            this.removingComponent();
        }
    }

    protected void removingComponent() {
    }

    protected Dimension myPreferredSize() {
        return new Dimension(this.inWidth, this.inHeight);
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void repaint() {
        System.err.println("repaint call not implemented on this renderer");
    }

    public Object[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        this.frameGrabber = this;
        this.controls = new Control[1];
        this.controls[0] = this.frameGrabber;
        return this.controls;
    }

    public Component getControlComponent() {
        return null;
    }

    public Buffer grabFrame() {
        Buffer buffer = this.lastBuffer;
        synchronized (buffer) {
            Object[] newData;
            Buffer newBuffer = new Buffer();
            newBuffer.setFormat(this.lastBuffer.getFormat());
            newBuffer.setFlags(this.lastBuffer.getFlags());
            newBuffer.setLength(this.lastBuffer.getLength());
            newBuffer.setOffset(0);
            newBuffer.setHeader(this.lastBuffer.getHeader());
            newBuffer.setData(this.lastBuffer.getData());
            Object data = this.lastBuffer.getData();
            int length = this.lastBuffer.getLength();
            if (data instanceof byte[]) {
                newData = new byte[length];
            } else if (data instanceof short[]) {
                newData = new short[length];
            } else if (data instanceof int[]) {
                newData = new int[length];
            } else {
                Buffer buffer2 = newBuffer;
                Object var3_8 = null;
                return buffer2;
            }
            System.arraycopy(data, this.lastBuffer.getOffset(), newData, 0, length);
            newBuffer.setData(newData);
            Buffer buffer3 = newBuffer;
            Object var3_9 = null;
            return buffer3;
        }
    }

    public class CompListener
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            BasicVideoRenderer.this.resized(ce.getComponent());
        }

        public CompListener() {
            BasicVideoRenderer.this = BasicVideoRenderer.this;
        }
    }
}

