/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.FormatInfo;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.OverallTransStats;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTCPRawReceiver;
import com.sun.media.rtp.RTCPRawSender;
import com.sun.media.rtp.RTCPReceiver;
import com.sun.media.rtp.RTCPReporter;
import com.sun.media.rtp.RTCPTransmitter;
import com.sun.media.rtp.RTPControlImpl;
import com.sun.media.rtp.RTPDemultiplexer;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.RTPReceiver;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RTPSourceInfoCache;
import com.sun.media.rtp.RTPSourceStream;
import com.sun.media.rtp.RTPTransmitter;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCCacheCleaner;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.TrueRandom;
import com.sun.media.rtp.util.PacketForwarder;
import com.sun.media.rtp.util.RTPPacketSender;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.EncryptionInfo;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.RemoteParticipant;
import javax.media.rtp.SSRCInUseException;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.SessionManagerException;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.StreamClosedEvent;
import javax.media.rtp.rtcp.SourceDescription;

public class RTPSessionMgr
implements SessionManager {
    boolean bindtome = false;
    private SSRCCache cache;
    int ttl;
    int sendercount;
    InetAddress localDataAddress;
    int localDataPort;
    InetAddress localControlAddress;
    int localControlPort;
    InetAddress dataaddress;
    InetAddress controladdress;
    int dataport;
    int controlport;
    RTPPushDataSource rtpsource;
    RTPPushDataSource rtcpsource;
    long defaultSSRC = 0L;
    PacketForwarder rtcpforwarder;
    PacketForwarder rtpforwarder;
    UDPPacketSender udpsender;
    RTPPacketSender rtpsender;
    RTCPRawSender sender;
    SSRCCacheCleaner cleaner;
    private boolean unicast = false;
    private boolean startedparticipating = false;
    private boolean nonparticipating = false;
    private boolean nosockets = false;
    private boolean started = false;
    private boolean initialized = false;
    RTPDemultiplexer rtpdemultiplexer;
    protected Vector sessionlistener = new Vector();
    protected Vector remotelistener = new Vector();
    protected Vector streamlistener = new Vector();
    protected Vector sendstreamlistener = new Vector();
    private static final int GET_ALL_PARTICIPANTS = -1;
    boolean encryption = false;
    Hashtable dslist;
    FormatInfo formatinfo;
    com.sun.media.protocol.rtp.DataSource defaultsource;
    PushBufferStream defaultstream;
    Format defaultformat;
    BufferControl buffercontrol;
    OverallStats defaultstats;
    OverallTransStats transstats;
    int defaultsourceid;
    Vector sendstreamlist = new Vector(1);
    RTPTransmitter rtptransmitter;
    boolean bds = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    Vector peerlist = new Vector();
    boolean multi_unicast = false;
    Hashtable peerrtplist = new Hashtable(5);
    Hashtable peerrtcplist = new Hashtable(5);

    public RTPSessionMgr() {
        this.dslist = new Hashtable(5);
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
    }

    public Object[] getControls() {
        Object[] c2 = new Object[]{this.buffercontrol};
        return c2;
    }

    public Object getControl(String controlname) {
        if (controlname.equals("javax.media.control.BufferControl")) {
            return this.buffercontrol;
        }
        return null;
    }

    public int initSession(SessionAddress localAddress, long defaultSSRC, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) throws InvalidSessionAddressException {
        InetAddress host;
        if (this.initialized) {
            return -1;
        }
        if (rtcp_bw_fraction == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = defaultSSRC;
        this.localDataAddress = localAddress.getDataAddress();
        this.localControlAddress = localAddress.getControlAddress();
        this.localDataPort = localAddress.getDataPort();
        this.localControlPort = localAddress.getControlPort();
        InetAddress[] addrlist = null;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            host = InetAddress.getLocalHost();
            String hostname = host.getHostName();
            addrlist = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e3) {
            System.err.println("InitSession : UnknownHostExcpetion " + e3.getMessage());
            e3.printStackTrace();
            return -1;
        }
        if (this.localDataAddress == null) {
            this.localDataAddress = host;
        }
        if (this.localControlAddress == null) {
            this.localControlAddress = host;
        }
        boolean dataok = false;
        boolean ctlok = false;
        int i2 = 0;
        while (!(i2 >= addrlist.length || dataok && ctlok)) {
            if (addrlist[i2].equals(this.localDataAddress)) {
                dataok = true;
            }
            if (addrlist[i2].equals(this.localControlAddress)) {
                ctlok = true;
            }
            ++i2;
        }
        String s = "Does not belong to any of this hosts local interfaces";
        if (!dataok) {
            throw new InvalidSessionAddressException("Local Data Address" + s);
        }
        if (!ctlok) {
            throw new InvalidSessionAddressException("Local Control Address" + s);
        }
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = rtcp_bw_fraction;
        this.cache.rtcp_sender_bw_fraction = rtcp_sender_bw_fraction;
        this.cache.ourssrc = this.cache.get((int)defaultSSRC, host, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(defaultUserDesc)) {
            SourceDescription[] newUserDesc = this.setCNAME(defaultUserDesc);
            this.cache.ourssrc.setSourceDescription(newUserDesc);
        } else {
            this.cache.ourssrc.setSourceDescription(defaultUserDesc);
        }
        this.cache.ourssrc.ssrc = (int)defaultSSRC;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    public int initSession(SessionAddress localAddress, SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) throws InvalidSessionAddressException {
        long defaultSSRC = this.generateSSRC();
        return this.initSession(localAddress, defaultSSRC, defaultUserDesc, rtcp_bw_fraction, rtcp_sender_bw_fraction);
    }

    /*
     * Unable to fully structure code
     */
    public int startSession(SessionAddress destAddress, int mcastScope, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        if (this.started) {
            return -1;
        }
        if (mcastScope < 1) {
            mcastScope = 1;
        }
        this.ttl = mcastScope;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.controlport = destAddress.getControlPort();
        this.dataport = destAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = destAddress.getDataAddress();
        this.controladdress = destAddress.getControlAddress();
        if (RTPSessionMgr.jmfSecurity != null) {
            permission = null;
            try {
                if (RTPSessionMgr.jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    RTPSessionMgr.jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "connect";
                    RTPSessionMgr.jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (RTPSessionMgr.jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e) {
                if (permission.startsWith("read")) {
                    RTPSessionMgr.jmfSecurity.permissionFailureNotification(1);
                }
                RTPSessionMgr.jmfSecurity.permissionFailureNotification(128);
            }
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        rtcpr = null;
        rtpr = null;
        mine = null;
        try {
            mine = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            System.out.println("unknownhost excpetion " + e.getMessage());
            e.printStackTrace();
        }
        if (this.dataaddress.equals(mine)) {
            this.unicast = true;
        }
        if (!this.dataaddress.isMulticastAddress() && !this.dataaddress.equals(mine)) {
            this.bindtome = this.isBroadcast(this.dataaddress) == false || this.Win32() != false;
        }
        if (!this.bindtome) {
            try {
                try {
                    rtcpr = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats);
                    if (this.dataaddress != null) {
                        rtpr = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
                    }
                }
                catch (SocketException e) {
                    throw new IOException(e.getMessage());
                }
                var8_13 = null;
                if (this.dataaddress == null || rtpr != null || rtcpr == null) ** GOTO lbl91
                System.err.println("could not create RTCP/RTP raw receivers");
                rtcpr.closeSource();
            }
            catch (Throwable var7_9) {
                var8_14 = null;
                if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
                throw var7_9;
            }
        } else {
            try {
                try {
                    rtcpr = new RTCPRawReceiver(this.controlport, mine.getHostAddress(), this.defaultstats);
                    if (this.dataaddress != null) {
                        rtpr = new RTPRawReceiver(this.dataport, mine.getHostAddress(), this.defaultstats);
                    }
                }
                catch (SocketException e) {
                    throw new IOException(e.getMessage());
                }
                var8_15 = null;
                if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
            }
            catch (Throwable var7_10) {
                var8_16 = null;
                if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
                throw var7_10;
            }
        }
lbl91:
        // 3 sources

        this.rtpdemultiplexer = new RTPDemultiplexer(this.cache);
        this.rtcpforwarder = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        if (rtpr != null) {
            this.rtpforwarder = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpdemultiplexer));
        }
        this.rtcpforwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpforwarder != null) {
            this.rtpforwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.cleaner = new SSRCCacheCleaner(this.cache);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startparticipating(this.controlport, this.dataaddress.getHostAddress(), this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public int startSession(SessionAddress localdestAddress, SessionAddress remotedestAddress, EncryptionInfo encryptionInfo) throws IOException, InvalidSessionAddressException {
        if (this.started) {
            return -1;
        }
        this.cache.sessionbandwidth = 384000;
        this.controlport = localdestAddress.getControlPort();
        this.dataport = localdestAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = localdestAddress.getDataAddress();
        this.controladdress = localdestAddress.getControlAddress();
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "connect";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                if (permission.startsWith("read")) {
                    jmfSecurity.permissionFailureNotification(1);
                }
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Local Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        RTCPRawReceiver rtcpr = null;
        RTPRawReceiver rtpr = null;
        InetAddress mine = null;
        try {
            mine = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e3) {
            System.out.println("unknownhost excpetion " + e3.getMessage());
            e3.printStackTrace();
        }
        try {
            try {
                rtcpr = new RTCPRawReceiver(this.controlport, this.controladdress.getHostAddress(), this.defaultstats);
                if (this.dataaddress != null) {
                    rtpr = new RTPRawReceiver(this.dataport, this.dataaddress.getHostAddress(), this.defaultstats);
                }
            }
            catch (SocketException e4) {
                throw new IOException(e4.getMessage());
            }
            Object var8_11 = null;
            if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                System.err.println("could not create RTCP/RTP raw receivers");
                rtcpr.closeSource();
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (this.dataaddress != null && rtpr == null && rtcpr != null) {
                System.err.println("could not create RTCP/RTP raw receivers");
                rtcpr.closeSource();
            }
            throw throwable;
        }
        this.rtpdemultiplexer = new RTPDemultiplexer(this.cache);
        this.rtcpforwarder = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        if (rtpr != null) {
            this.rtpforwarder = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpdemultiplexer));
        }
        this.rtcpforwarder.startPF("RTCP Forwarder for address" + this.controladdress.toString() + "port " + this.controlport);
        if (this.rtpforwarder != null) {
            this.rtpforwarder.startPF("RTP Forwarder for address " + this.dataaddress.toString() + "port " + this.dataport);
        }
        this.controlport = remotedestAddress.getControlPort();
        this.dataport = remotedestAddress.getDataPort();
        this.CheckRTPPorts(this.dataport, this.controlport);
        this.dataaddress = remotedestAddress.getDataAddress();
        this.controladdress = remotedestAddress.getControlAddress();
        if (this.dataaddress.isMulticastAddress() || this.controladdress.isMulticastAddress() || this.isBroadcast(this.dataaddress) || this.isBroadcast(this.controladdress)) {
            throw new InvalidSessionAddressException("Remote Address must be UNICAST IP addresses");
        }
        this.CheckRTPAddress(this.dataaddress, this.controladdress);
        this.cleaner = new SSRCCacheCleaner(this.cache);
        if (!this.nonparticipating && !this.unicast && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startparticipating(this.controlport, this.dataaddress.getHostAddress(), this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public void addSessionListener(SessionListener listener) {
        if (!this.sessionlistener.contains(listener)) {
            this.sessionlistener.addElement(listener);
        }
    }

    public void addRemoteListener(RemoteListener listener) {
        if (!this.remotelistener.contains(listener)) {
            this.remotelistener.addElement(listener);
        }
    }

    public void addReceiveStreamListener(ReceiveStreamListener listener) {
        if (!this.streamlistener.contains(listener)) {
            this.streamlistener.addElement(listener);
        }
    }

    public void addSendStreamListener(SendStreamListener listener) {
        if (!this.sendstreamlistener.contains(listener)) {
            this.sendstreamlistener.addElement(listener);
        }
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionlistener.removeElement(listener);
    }

    public void removeRemoteListener(RemoteListener listener) {
        this.remotelistener.removeElement(listener);
    }

    public void removeReceiveStreamListener(ReceiveStreamListener listener) {
        this.streamlistener.removeElement(listener);
    }

    public void removeSendStreamListener(SendStreamListener listener) {
    }

    public long getDefaultSSRC() {
        return this.defaultSSRC;
    }

    public Vector getRemoteParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Participant participant = (Participant)elements.nextElement();
            if (participant == null || !(participant instanceof RemoteParticipant)) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public Vector getActiveParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Vector streams;
            Participant participant = (Participant)elements.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (streams = participant.getStreams()).size() <= 0) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public Vector getPassiveParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Vector streams;
            Participant participant = (Participant)elements.nextElement();
            if (participant != null && participant instanceof LocalParticipant && this.nonparticipating || (streams = participant.getStreams()).size() != 0) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public LocalParticipant getLocalParticipant() {
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Participant participant = (Participant)elements.nextElement();
            if (participant == null || this.nonparticipating || !(participant instanceof LocalParticipant)) continue;
            return (LocalParticipant)participant;
        }
        return null;
    }

    public Vector getAllParticipants() {
        Vector<Participant> participantlist = new Vector<Participant>();
        RTPSourceInfoCache sic = this.cache.getRTPSICache();
        Hashtable hash = sic.getCacheTable();
        Enumeration elements = hash.elements();
        while (elements.hasMoreElements()) {
            Participant participant = (Participant)elements.nextElement();
            if (participant == null || participant instanceof LocalParticipant && this.nonparticipating) continue;
            participantlist.addElement(participant);
        }
        return participantlist;
    }

    public Vector getReceiveStreams() {
        Vector<RTPStream> smstreamlist = new Vector<RTPStream>();
        Vector participantlist = this.getAllParticipants();
        int i2 = 0;
        while (i2 < participantlist.size()) {
            Participant part = (Participant)participantlist.elementAt(i2);
            Vector partstreams = part.getStreams();
            int j2 = 0;
            while (j2 < partstreams.size()) {
                RTPStream stream = (RTPStream)partstreams.elementAt(j2);
                if (stream instanceof ReceiveStream) {
                    smstreamlist.addElement(stream);
                }
                ++j2;
            }
            ++i2;
        }
        smstreamlist.trimToSize();
        return smstreamlist;
    }

    public Vector getSendStreams() {
        return null;
    }

    public RTPStream getStream(long filterssrc) {
        Vector participantlist = null;
        participantlist = this.getAllParticipants();
        if (participantlist == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < participantlist.size()) {
            RTPSourceInfo si = (RTPSourceInfo)participantlist.elementAt(i2);
            RTPStream stream = si.getSSRCStream(filterssrc);
            if (stream != null) {
                return stream;
            }
            ++i2;
        }
        return null;
    }

    public int getMulticastScope() {
        return this.ttl;
    }

    public void setMulticastScope(int multicastScope) {
        block3: {
            if (multicastScope < 1) {
                multicastScope = 1;
            }
            this.ttl = multicastScope;
            this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
            if (this.udpsender == null) break block3;
            try {
                this.udpsender.setttl(this.ttl);
            }
            catch (IOException e2) {
                System.err.println("setMulticastScope Exception " + e2.getMessage());
                e2.printStackTrace();
            }
        }
    }

    public void closeSession(String reason) {
        this.stopparticipating(reason, this.cache.ourssrc);
        if (this.cache != null) {
            Enumeration e2 = this.cache.cache.elements();
            while (e2.hasMoreElements()) {
                SSRCInfo s = (SSRCInfo)e2.nextElement();
                if (s.dstream != null) {
                    s.dstream.close();
                }
                if (s instanceof SendSSRCInfo) {
                    ((SendSSRCInfo)s).close();
                }
                this.stopparticipating(reason, s);
            }
        }
        int i2 = 0;
        while (i2 < this.sendstreamlist.size()) {
            this.removeSendStream((SendStream)this.sendstreamlist.elementAt(i2));
            ++i2;
        }
        if (this.rtptransmitter != null) {
            this.rtptransmitter.close();
        }
        if (this.rtcpforwarder != null) {
            this.rtcpforwarder.close();
        }
        if (this.cleaner != null) {
            this.cleaner.stop();
        }
        if (this.cache != null) {
            this.cache.destroy();
        }
        if (this.rtpforwarder != null) {
            this.rtpforwarder.close();
        }
        if (this.multi_unicast) {
            this.removeAllPeers();
        }
    }

    public String generateCNAME() {
        String hostname = null;
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "connect";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                if (permission.startsWith("read")) {
                    jmfSecurity.permissionFailureNotification(1);
                }
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            InetAddress host = InetAddress.getLocalHost();
            hostname = host.getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        String cname = String.valueOf(System.getProperty("user.name")) + "@" + hostname;
        return cname;
    }

    public long generateSSRC() {
        long ssrc = TrueRandom.rand();
        return ssrc;
    }

    public SessionAddress getSessionAddress() {
        SessionAddress destAddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        return destAddress;
    }

    public SessionAddress getLocalSessionAddress() {
        SessionAddress localAddr = new SessionAddress(this.localDataAddress, this.localDataPort, this.localControlAddress, this.localControlPort);
        return localAddr;
    }

    public GlobalReceptionStats getGlobalReceptionStats() {
        return this.defaultstats;
    }

    public GlobalTransmissionStats getGlobalTransmissionStats() {
        return this.transstats;
    }

    public void addFormat(Format info, int payload) {
        if (this.formatinfo != null) {
            this.formatinfo.add(payload, info);
        }
    }

    public SendStream createSendStream(int ssrc, DataSource ds, int streamindex) throws UnsupportedFormatException, IOException, SSRCInUseException {
        SSRCInfo i2 = this.cache.lookup(ssrc);
        if (i2 != null) {
            throw new SSRCInUseException("SSRC supplied is already in use");
        }
        long newssrc = ssrc;
        if (this.cache.rtcp_bw_fraction == 0.0) {
            throw new IOException("Initialized with zero RTP/RTCP outgoing bandwidth. Cannot create a sending stream ");
        }
        PushBufferStream[] streams = ((PushBufferDataSource)ds).getStreams();
        PushBufferStream sendstream = streams[streamindex];
        Format fmt = sendstream.getFormat();
        int payload = this.formatinfo.getPayload(fmt);
        if (payload == -1) {
            throw new UnsupportedFormatException("Format of Stream not supported in RTP Session Manager", fmt);
        }
        SSRCInfo info = null;
        if (this.sendercount == 0) {
            info = new SendSSRCInfo(this.cache.ourssrc);
            info.ours = true;
            this.cache.ourssrc = info;
            this.cache.getMainCache().put(new Integer(info.ssrc), info);
        } else {
            info = this.cache.get((int)newssrc, this.dataaddress, this.dataport, 3);
            info.ours = true;
            info.reporter = !this.nosockets ? this.startparticipating(this.controlport, this.controladdress.getHostAddress(), info) : this.startparticipating(this.rtcpsource, info);
        }
        info.payloadType = payload;
        info.sinkstream.setSSRCInfo((SendSSRCInfo)info);
        ((SendSSRCInfo)info).setFormat(fmt);
        if (fmt instanceof VideoFormat) {
            info.clockrate = 90000;
        } else if (fmt instanceof AudioFormat) {
            info.clockrate = (int)((AudioFormat)fmt).getSampleRate();
        } else {
            throw new UnsupportedFormatException("Format not supported", fmt);
        }
        info.pds = ds;
        sendstream.setTransferHandler(info.sinkstream);
        if (this.multi_unicast) {
            SessionAddress a2 = (SessionAddress)this.peerlist.firstElement();
            this.dataport = a2.getDataPort();
            this.dataaddress = a2.getDataAddress();
            if (this.dataaddress == null) {
                throw new IOException("Atleast one peer must be added");
            }
        }
        if (this.rtptransmitter == null) {
            this.rtptransmitter = !this.nosockets ? this.startDataTransmission(this.dataport, this.dataaddress.getHostAddress()) : this.startDataTransmission(this.rtpsource);
        }
        info.sinkstream.setTransmitter(this.rtptransmitter);
        this.addSendStream((SendStream)((Object)info));
        if (this.multi_unicast) {
            int j2 = 0;
            while (j2 < this.peerlist.size()) {
                SessionAddress peerAddress = (SessionAddress)this.peerlist.elementAt(j2);
                if (info.sinkstream.transmitter.sender.peerlist == null) {
                    info.sinkstream.transmitter.sender.peerlist = new Vector();
                }
                info.sinkstream.transmitter.sender.peerlist.addElement(peerAddress);
                if (this.cache != null) {
                    Enumeration e2 = this.cache.cache.elements();
                    while (e2.hasMoreElements()) {
                        SSRCInfo s = (SSRCInfo)e2.nextElement();
                        if (!(s instanceof SendSSRCInfo)) continue;
                        s.reporter.transmit.sender.control = true;
                        if (s.reporter.transmit.sender.peerlist == null) {
                            s.reporter.transmit.sender.peerlist = new Vector();
                        }
                        s.reporter.transmit.sender.peerlist.addElement(peerAddress);
                    }
                }
                ++j2;
            }
        }
        info.sinkstream.startStream();
        NewSendStreamEvent evt = new NewSendStreamEvent(this, (SendStream)((Object)info));
        this.cache.eventhandler.postEvent(evt);
        return (SendStream)((Object)info);
    }

    public SendStream createSendStream(DataSource ds, int streamindex) throws IOException, UnsupportedFormatException {
        long newssrc = 0L;
        while (this.cache.lookup((int)(newssrc = this.generateSSRC())) != null) {
        }
        SendStream s = null;
        try {
            s = this.createSendStream((int)newssrc, ds, streamindex);
        }
        catch (SSRCInUseException sSRCInUseException) {}
        return s;
    }

    public int startSession(int mcastScope, EncryptionInfo encryptionInfo) throws IOException {
        this.multi_unicast = true;
        if (mcastScope < 1) {
            mcastScope = 1;
        }
        this.ttl = mcastScope;
        this.cache.sessionbandwidth = this.ttl <= 16 ? 384000 : (this.ttl <= 64 ? 128000 : (this.ttl <= 128 ? 16000 : (this.ttl <= 192 ? 6625 : 4000)));
        this.cleaner = new SSRCCacheCleaner(this.cache);
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void addPeer(SessionAddress peerAddress) throws IOException, InvalidSessionAddressException {
        i = 0;
        while (i < this.peerlist.size()) {
            a = (SessionAddress)this.peerlist.elementAt(i);
            if (a.equals(peerAddress)) {
                return;
            }
            ++i;
        }
        this.peerlist.addElement(peerAddress);
        this.CheckRTPPorts(peerAddress.getDataPort(), peerAddress.getControlPort());
        if (RTPSessionMgr.jmfSecurity != null) {
            permission = null;
            try {
                if (RTPSessionMgr.jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    RTPSessionMgr.jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "connect";
                    RTPSessionMgr.jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (RTPSessionMgr.jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e) {
                if (permission.startsWith("read")) {
                    RTPSessionMgr.jmfSecurity.permissionFailureNotification(1);
                }
                RTPSessionMgr.jmfSecurity.permissionFailureNotification(128);
            }
        }
        rtcpr = null;
        rtpr = null;
        dataadd = peerAddress.getDataAddress();
        controladd = peerAddress.getControlAddress();
        datap = peerAddress.getDataPort();
        controlp = peerAddress.getControlPort();
        this.CheckRTPAddress(dataadd, controladd);
        mine = null;
        try {
            mine = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            System.out.println("unknownhost excpetion " + e.getMessage());
            e.printStackTrace();
        }
        if (!dataadd.isMulticastAddress() && !dataadd.equals(mine)) {
            this.bindtome = this.isBroadcast(dataadd) == false || this.Win32() != false;
        }
        if (!this.bindtome) {
            try {
                try {
                    rtcpr = new RTCPRawReceiver(controlp, controladd.getHostAddress(), this.defaultstats);
                    if (dataadd != null) {
                        rtpr = new RTPRawReceiver(datap, dataadd.getHostAddress(), this.defaultstats);
                    }
                }
                catch (SocketException e) {
                    throw new IOException(e.getMessage());
                }
                var11_19 = null;
                if (dataadd == null || rtpr != null || rtcpr == null) ** GOTO lbl91
                System.err.println("could not create RTCP/RTP raw receivers");
                rtcpr.closeSource();
            }
            catch (Throwable e) {
                var11_20 = null;
                if (dataadd != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
                throw e;
            }
        } else {
            try {
                try {
                    rtcpr = new RTCPRawReceiver(controlp, mine.getHostAddress(), this.defaultstats);
                    if (dataadd != null) {
                        rtpr = new RTPRawReceiver(datap, mine.getHostAddress(), this.defaultstats);
                    }
                }
                catch (SocketException e) {
                    throw new IOException(e.getMessage());
                }
                var11_19 = null;
                if (dataadd != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
            }
            catch (Throwable e) {
                var11_21 = null;
                if (dataadd != null && rtpr == null && rtcpr != null) {
                    System.err.println("could not create RTCP/RTP raw receivers");
                    rtcpr.closeSource();
                }
                throw e;
            }
        }
lbl91:
        // 3 sources

        rtcpf = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        rtpf = null;
        if (rtpr != null) {
            rtpf = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpdemultiplexer));
        }
        rtcpf.startPF("RTCP Forwarder for address" + controladd.toString() + "port " + controlp);
        if (rtpf != null) {
            rtpf.startPF("RTP Forwarder for address " + dataadd.toString() + "port " + datap);
        }
        this.peerrtplist.put(peerAddress, rtpf);
        this.peerrtcplist.put(peerAddress, rtcpf);
        if (this.cache.ourssrc != null) {
            if (this.cache.ourssrc.reporter == null) {
                this.controladdress = controladd;
                this.controlport = controlp;
                this.cache.ourssrc.reporter = this.startparticipating(controlp, dataadd.getHostAddress(), this.cache.ourssrc);
            }
            if (this.cache.ourssrc.reporter.transmit.sender.peerlist == null) {
                this.cache.ourssrc.reporter.transmit.sender.peerlist = new Vector<E>();
            }
        }
        this.cache.ourssrc.reporter.transmit.sender.peerlist.addElement(peerAddress);
        if (this.cache != null) {
            e = this.cache.cache.elements();
            while (e.hasMoreElements()) {
                s = (SSRCInfo)e.nextElement();
                if (!(s instanceof SendSSRCInfo)) continue;
                s.reporter.transmit.sender.control = true;
                if (s.reporter.transmit.sender.peerlist != null) continue;
                s.reporter.transmit.sender.peerlist = new Vector<E>();
                s.reporter.transmit.sender.peerlist.addElement(peerAddress);
            }
        }
        j = 0;
        while (j < this.sendstreamlist.size()) {
            i = (SendSSRCInfo)this.sendstreamlist.elementAt(j);
            if (i.sinkstream.transmitter.sender.peerlist == null) {
                i.sinkstream.transmitter.sender.peerlist = new Vector<E>();
                i.sinkstream.transmitter.sender.peerlist.addElement(peerAddress);
            }
            ++j;
        }
    }

    public void removePeer(SessionAddress peerAddress) {
        PacketForwarder rtpf = (PacketForwarder)this.peerrtplist.get(peerAddress);
        PacketForwarder rtcpf = (PacketForwarder)this.peerrtplist.get(peerAddress);
        if (rtpf != null) {
            rtpf.close();
        }
        if (rtcpf != null) {
            rtcpf.close();
        }
        int i2 = 0;
        while (i2 < this.peerlist.size()) {
            SessionAddress a2 = (SessionAddress)this.peerlist.elementAt(i2);
            if (a2.equals(peerAddress)) {
                this.peerlist.removeElementAt(i2);
            }
            ++i2;
        }
    }

    public void removeAllPeers() {
        int i2 = 0;
        while (i2 < this.peerlist.size()) {
            this.removePeer((SessionAddress)this.peerlist.elementAt(i2));
            ++i2;
        }
    }

    public Vector getPeers() {
        return this.peerlist;
    }

    void addSendStream(SendStream s) {
        this.sendstreamlist.addElement(s);
    }

    void removeSendStream(SendStream s) {
        this.sendstreamlist.removeElement(s);
        if (((SendSSRCInfo)s).sinkstream != null) {
            ((SendSSRCInfo)s).sinkstream.close();
            StreamClosedEvent evt = new StreamClosedEvent(this, s);
            this.cache.eventhandler.postEvent(evt);
            this.stopparticipating("Closed Stream", (SendSSRCInfo)s);
        }
        if (this.sendstreamlist.size() == 0 && this.cache.ourssrc != null) {
            PassiveSSRCInfo info = new PassiveSSRCInfo(this.getSSRCCache().ourssrc);
            this.cache.ourssrc = info;
            this.cache.getMainCache().put(new Integer(info.ssrc), info);
        }
    }

    private RTPTransmitter startDataTransmission(int port, String address) throws IOException {
        RTPTransmitter transmitter = null;
        RTPRawSender sender = null;
        this.udpsender = this.localDataPort == -1 ? new UDPPacketSender(this.dataaddress, this.dataport) : new UDPPacketSender(this.localControlPort, this.localControlAddress, this.dataaddress, this.dataport);
        if (this.ttl != 1) {
            this.udpsender.setttl(this.ttl);
        }
        sender = new RTPRawSender(this.dataport, address, this.udpsender);
        transmitter = new RTPTransmitter(this.cache, sender);
        return transmitter;
    }

    private RTPTransmitter startDataTransmission(RTPPushDataSource s) {
        RTPRawSender sender = null;
        RTPTransmitter transmitter = null;
        this.rtpsender = new RTPPacketSender(s);
        sender = new RTPRawSender(this.rtpsender);
        transmitter = new RTPTransmitter(this.cache, sender);
        return transmitter;
    }

    public void UpdateEncodings(DataSource source) {
        RTPControlImpl control = (RTPControlImpl)source.getControl("javax.media.rtp.RTPControl");
        if (control != null && control.codeclist != null) {
            Enumeration e2 = control.codeclist.keys();
            while (e2.hasMoreElements()) {
                Integer p2 = (Integer)e2.nextElement();
                this.formatinfo.add(p2, (Format)control.codeclist.get(p2));
            }
        }
    }

    private int startSession(RTPPushDataSource rtpsource, RTPPushDataSource rtcpsource, EncryptionInfo info) {
        if (!this.initialized) {
            return -1;
        }
        if (this.started) {
            return -1;
        }
        this.cache.sessionbandwidth = 384000;
        RTPRawReceiver rtpr = new RTPRawReceiver(rtpsource, this.defaultstats);
        RTCPRawReceiver rtcpr = new RTCPRawReceiver(rtcpsource, this.defaultstats);
        this.rtpdemultiplexer = new RTPDemultiplexer(this.cache);
        this.rtpforwarder = new PacketForwarder(rtpr, new RTPReceiver(this.cache, this.rtpdemultiplexer));
        if (this.rtpforwarder != null) {
            this.rtpforwarder.startPF("RTP Forwarder ");
        }
        this.rtcpforwarder = new PacketForwarder(rtcpr, new RTCPReceiver(this.cache));
        if (this.rtcpforwarder != null) {
            this.rtcpforwarder.startPF("RTP Forwarder ");
        }
        this.cleaner = new SSRCCacheCleaner(this.cache);
        if (!this.nonparticipating && this.cache.ourssrc != null) {
            this.cache.ourssrc.reporter = this.startparticipating(rtcpsource, this.cache.ourssrc);
        }
        this.started = true;
        return 0;
    }

    public RTPSessionMgr(RTPPushDataSource netdatasource) {
        this.nosockets = true;
        this.rtpsource = netdatasource;
        if (this.rtpsource instanceof RTPSocket) {
            this.rtcpsource = ((RTPSocket)this.rtpsource).getControlChannel();
        }
        this.dslist = new Hashtable(5);
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        com.sun.media.protocol.rtp.DataSource newsource = this.createNewDS(null);
        this.UpdateEncodings(netdatasource);
        RTPControl contrl = (RTPControl)netdatasource.getControl("javax.media.rtp.RTPControl");
        newsource.setControl(contrl);
        this.initSession(this.setSDES(), 0.05, 0.25);
        this.startSession(this.rtpsource, this.rtcpsource, null);
    }

    public RTPSessionMgr(com.sun.media.protocol.rtp.DataSource configds) throws IOException {
        this.formatinfo = new FormatInfo();
        this.buffercontrol = new BufferControlImpl();
        this.defaultstats = new OverallStats();
        this.transstats = new OverallTransStats();
        this.dslist = new Hashtable(5);
        this.UpdateEncodings(configds);
        RTPMediaLocator mrl = null;
        try {
            mrl = new RTPMediaLocator(configds.getLocator().toString());
        }
        catch (MalformedURLException e2) {
            throw new IOException("RTP URL is Malformed " + e2.getMessage());
        }
        com.sun.media.protocol.rtp.DataSource newsource = this.createNewDS(mrl);
        RTPControl contrl = (RTPControl)configds.getControl("javax.media.rtp.RTPControl");
        newsource.setControl(contrl);
        String address = mrl.getSessionAddress();
        this.dataport = mrl.getSessionPort();
        this.controlport = this.dataport + 1;
        this.ttl = mrl.getTTL();
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e3) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            this.controladdress = this.dataaddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException e4) {
            e4.printStackTrace();
        }
        SessionAddress localaddr = new SessionAddress();
        try {
            this.initSession(localaddr, this.setSDES(), 0.05, 0.25);
        }
        catch (SessionManagerException e5) {
            throw new IOException("SessionManager exception " + e5.getMessage());
        }
    }

    public void addMRL(RTPMediaLocator mrl) {
        int ssrc = (int)mrl.getSSRC();
        if (ssrc == 0) {
            return;
        }
        com.sun.media.protocol.rtp.DataSource reqsource = (com.sun.media.protocol.rtp.DataSource)this.dslist.get(new Integer(ssrc));
        if (reqsource != null) {
            return;
        }
        com.sun.media.protocol.rtp.DataSource newSource = this.createNewDS(mrl);
    }

    public boolean isDefaultDSassigned() {
        return this.bds;
    }

    public Format getFormat(int payload) {
        return this.formatinfo.get(payload);
    }

    public void setDefaultDSassigned(int ssrc) {
        this.bds = true;
        this.defaultsourceid = ssrc;
        this.dslist.put(new Integer(ssrc), this.defaultsource);
    }

    public com.sun.media.protocol.rtp.DataSource createNewDS(int ssrcid) {
        com.sun.media.protocol.rtp.DataSource source = new com.sun.media.protocol.rtp.DataSource();
        source.setContentType("raw");
        try {
            source.connect();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        RTPSourceStream stream = new RTPSourceStream();
        source.setSourceStream(stream);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(stream);
        this.dslist.put(new Integer(ssrcid), source);
        return source;
    }

    public com.sun.media.protocol.rtp.DataSource createNewDS(RTPMediaLocator mrl) {
        com.sun.media.protocol.rtp.DataSource source = new com.sun.media.protocol.rtp.DataSource();
        source.setContentType("raw");
        try {
            source.connect();
        }
        catch (IOException e2) {
            System.err.println("IOException in createNewDS() " + e2.getMessage());
            e2.printStackTrace();
        }
        RTPSourceStream stream = new RTPSourceStream();
        source.setSourceStream(stream);
        ((BufferControlImpl)this.buffercontrol).addSourceStream(stream);
        if (mrl != null && (int)mrl.getSSRC() != 0) {
            this.dslist.put(new Integer((int)mrl.getSSRC()), source);
        } else {
            this.defaultsource = source;
            this.defaultstream = stream;
        }
        return source;
    }

    public com.sun.media.protocol.rtp.DataSource getDataSource(RTPMediaLocator mrl) {
        if (mrl == null) {
            return this.defaultsource;
        }
        int ssrc = (int)mrl.getSSRC();
        if (ssrc == 0) {
            return this.defaultsource;
        }
        return (com.sun.media.protocol.rtp.DataSource)this.dslist.get(new Integer(ssrc));
    }

    public String toString() {
        String s = "RTPSession Manager  \n\tSSRCCache  " + this.cache + "\n\tDataport  " + this.dataport + "\n\tControlport  " + this.controlport + "\n\tAddress  " + this.dataaddress + "\n\tRTPForwarder  " + this.rtpforwarder + "\n\tRTPDEmux  " + this.rtpdemultiplexer;
        return s;
    }

    public boolean IsNonParticipating() {
        return this.nonparticipating;
    }

    public void startSession() throws IOException {
        SessionAddress destaddress = new SessionAddress(this.dataaddress, this.dataport, this.controladdress, this.controlport);
        try {
            this.startSession(destaddress, this.ttl, null);
        }
        catch (SessionManagerException e2) {
            throw new IOException("SessionManager exception " + e2.getMessage());
        }
    }

    public void closeSession() {
        if (this.dslist.isEmpty() || this.nosockets) {
            this.closeSession("DataSource disconnected");
        }
    }

    public void removeDataSource(com.sun.media.protocol.rtp.DataSource source) {
        if (source == this.defaultsource) {
            this.defaultsource = null;
            this.defaultstream = null;
            this.defaultsourceid = 0;
            this.bds = false;
        }
        Enumeration ds = this.dslist.keys();
        while (ds.hasMoreElements()) {
            Integer key = (Integer)ds.nextElement();
            com.sun.media.protocol.rtp.DataSource current = (com.sun.media.protocol.rtp.DataSource)this.dslist.get(key);
            if (current != source) continue;
            this.dslist.remove(key);
            break;
        }
    }

    void startRTCPReports(InetAddress remoteAddress) {
        block3: {
            if (this.nonparticipating || this.startedparticipating) break block3;
            try {
                if (this.cache.ourssrc != null) {
                    this.cache.ourssrc.reporter = this.startparticipating(this.controlport, remoteAddress.getHostAddress(), this.cache.ourssrc);
                }
            }
            catch (IOException e2) {
                System.err.println("startRTCPReports " + e2.getMessage());
                e2.printStackTrace();
            }
        }
    }

    boolean isUnicast() {
        return this.unicast;
    }

    public void addUnicastAddr(InetAddress destAddress) {
        if (this.sender != null) {
            this.sender.addDestAddr(destAddress);
        }
    }

    public boolean isSenderDefaultAddr(InetAddress destAddress) {
        if (this.sender == null) {
            return false;
        }
        InetAddress defaultaddr = this.sender.getRemoteAddr();
        return defaultaddr.equals(destAddress);
    }

    SSRCCache getSSRCCache() {
        return this.cache;
    }

    void setSessionBandwidth(int bw) {
        this.cache.sessionbandwidth = bw;
    }

    private SourceDescription[] setSDES() {
        SourceDescription[] desclist = new SourceDescription[3];
        if (desclist == null) {
            return null;
        }
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 1);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(1);
            }
        }
        int i2 = 0;
        while (i2 < desclist.length) {
            if (i2 == 0) {
                desclist[i2] = new SourceDescription(2, System.getProperty("user.name"), 1, false);
            } else if (i2 == 1) {
                desclist[i2] = new SourceDescription(1, this.generateCNAME(), 1, false);
            } else if (i2 == 2) {
                desclist[i2] = new SourceDescription(6, "JMF RTP Player v1.0", 1, false);
            }
            ++i2;
        }
        return desclist;
    }

    private SourceDescription[] setCNAME(SourceDescription[] desclist) {
        String descval = null;
        boolean cname = false;
        if (desclist == null) {
            desclist = new SourceDescription[1];
            descval = this.generateCNAME();
            desclist[0] = new SourceDescription(1, descval, 1, false);
            return desclist;
        }
        int i2 = 0;
        while (i2 < desclist.length) {
            int type = desclist[i2].getType();
            descval = desclist[i2].getDescription();
            if (type == 1 && descval == null) {
                descval = this.generateCNAME();
                cname = true;
                break;
            }
            ++i2;
        }
        if (cname) {
            return desclist;
        }
        SourceDescription[] newdesclist = new SourceDescription[desclist.length + 1];
        newdesclist[0] = new SourceDescription(1, this.generateCNAME(), 1, false);
        int curr = 1;
        int i3 = 0;
        while (i3 < desclist.length) {
            newdesclist[curr] = new SourceDescription(desclist[i3].getType(), desclist[i3].getDescription(), 1, false);
            ++curr;
            ++i3;
        }
        return newdesclist;
    }

    private boolean isCNAME(SourceDescription[] desclist) {
        String descval = null;
        boolean cname = false;
        if (desclist == null) {
            return cname;
        }
        int i2 = 0;
        while (i2 < desclist.length) {
            try {
                int type = desclist[i2].getType();
                descval = desclist[i2].getDescription();
                if (type == 1 && descval != null) {
                    cname = true;
                }
            }
            catch (Exception exception) {}
            ++i2;
        }
        return cname;
    }

    private void CheckRTPPorts(int dataport, int controlport) throws InvalidSessionAddressException {
        if (dataport == 0 || dataport == -1) {
            dataport = controlport - 1;
        }
        if (controlport == 0 || controlport == -1) {
            controlport = dataport + 1;
        }
        if (dataport != 0 && dataport % 2 != 0) {
            throw new InvalidSessionAddressException("Data Port must be valid and even");
        }
        if (controlport != 0 && controlport % 2 != 1) {
            throw new InvalidSessionAddressException("Control Port must be valid  and Odd");
        }
        if (controlport != dataport + 1) {
            throw new InvalidSessionAddressException("Control Port must be one higher than the Data Port");
        }
    }

    private void CheckRTPAddress(InetAddress dataaddress, InetAddress controladdress) throws InvalidSessionAddressException {
        if (dataaddress == null && controladdress == null) {
            throw new InvalidSessionAddressException("Data and control addresses are null");
        }
        if (controladdress == null && dataaddress != null) {
            controladdress = dataaddress;
        }
        if (dataaddress == null && controladdress != null) {
            dataaddress = controladdress;
        }
    }

    private synchronized RTCPReporter startparticipating(RTPPushDataSource dest, SSRCInfo info) {
        this.startedparticipating = true;
        this.rtpsender = new RTPPacketSender(dest);
        RTCPRawSender sender = new RTCPRawSender(this.rtpsender);
        RTCPTransmitter transmitter = new RTCPTransmitter(this.cache, sender);
        transmitter.setSSRCInfo(info);
        RTCPReporter reporter = new RTCPReporter(this.cache, transmitter);
        return reporter;
    }

    private synchronized RTCPReporter startparticipating(int port, String address, SSRCInfo info) throws IOException {
        this.startedparticipating = true;
        UDPPacketSender udpsender = null;
        if (this.localControlPort == -1) {
            udpsender = new UDPPacketSender(this.controladdress, this.controlport);
            this.localControlPort = udpsender.getLocalPort();
            this.localControlAddress = udpsender.getLocalAddress();
        } else {
            udpsender = new UDPPacketSender(this.localControlPort, this.localControlAddress, this.controladdress, this.controlport);
        }
        if (this.ttl != 1) {
            udpsender.setttl(this.ttl);
        }
        RTCPRawSender sender = new RTCPRawSender(port, address, udpsender);
        RTCPTransmitter transmitter = new RTCPTransmitter(this.cache, sender);
        transmitter.setSSRCInfo(info);
        RTCPReporter reporter = new RTCPReporter(this.cache, transmitter);
        return reporter;
    }

    private synchronized void stopparticipating(String reason, SSRCInfo info) {
        if (info.reporter != null) {
            info.reporter.close(reason);
            info.reporter = null;
        }
    }

    private int initSession(SourceDescription[] defaultUserDesc, double rtcp_bw_fraction, double rtcp_sender_bw_fraction) {
        if (this.initialized) {
            return -1;
        }
        InetAddress host = null;
        if (rtcp_bw_fraction == 0.0) {
            this.nonparticipating = true;
        }
        this.defaultSSRC = this.generateSSRC();
        this.cache = new SSRCCache(this);
        this.formatinfo.setCache(this.cache);
        this.cache.rtcp_bw_fraction = rtcp_bw_fraction;
        this.cache.rtcp_sender_bw_fraction = rtcp_sender_bw_fraction;
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable e2) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        try {
            host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e3) {
            System.err.println("InitSession : UnknownHostExcpetion " + e3.getMessage());
            e3.printStackTrace();
            return -1;
        }
        this.cache.ourssrc = this.cache.get((int)this.defaultSSRC, null, 0, 2);
        this.cache.ourssrc.setAlive(true);
        if (!this.isCNAME(defaultUserDesc)) {
            SourceDescription[] newUserDesc = this.setCNAME(defaultUserDesc);
            this.cache.ourssrc.setSourceDescription(newUserDesc);
        } else {
            this.cache.ourssrc.setSourceDescription(defaultUserDesc);
        }
        this.cache.ourssrc.ssrc = (int)this.defaultSSRC;
        this.cache.ourssrc.setOurs(true);
        this.initialized = true;
        return 0;
    }

    boolean isBroadcast(InetAddress checkaddr) {
        InetAddress mine = null;
        try {
            mine = InetAddress.getLocalHost();
            byte[] addr = mine.getAddress();
            int address = addr[3] & 0xFF;
            address |= addr[2] << 8 & 0xFF00;
            address |= addr[1] << 16 & 0xFF0000;
            byte[] dataaddr = checkaddr.getAddress();
            int daddress = dataaddr[3] & 0xFF;
            daddress |= dataaddr[2] << 8 & 0xFF00;
            daddress |= dataaddr[1] << 16 & 0xFF0000;
            if (((address |= addr[0] << 24 & 0xFF000000) | 0xFF) == (daddress |= dataaddr[0] << 24 & 0xFF000000)) {
                return true;
            }
        }
        catch (UnknownHostException e2) {
            System.err.println(e2.getMessage());
        }
        return false;
    }

    private boolean Win32() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

