/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.rtp.util.Packet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTPPacket
extends Packet {
    public Packet base;
    public boolean extensionPresent;
    public int marker;
    public int payloadType;
    public int seqnum;
    public long timestamp;
    public int ssrc;
    public int[] csrc;
    public int extensionType;
    public byte[] extension;
    public int payloadoffset;
    public int payloadlength;

    public RTPPacket() {
    }

    public RTPPacket(Packet p2) {
        super(p2);
        this.base = p2;
    }

    public String toString() {
        String s = "RTP Packet:\n\tPayload Type: " + this.payloadType + "    Marker: " + this.marker + "\n\tSequence Number: " + this.seqnum + "\n\tTimestamp: " + this.timestamp + "\n\tSSRC (Sync Source): " + this.ssrc + "\n\tPayload Length: " + this.payloadlength + "    Payload Offset: " + this.payloadoffset + "\n";
        if (this.csrc.length > 0) {
            s = String.valueOf(s) + "Contributing sources:  " + this.csrc[0];
            int i2 = 1;
            while (i2 < this.csrc.length) {
                s = String.valueOf(s) + ", " + this.csrc[i2];
                ++i2;
            }
            s = String.valueOf(s) + "\n";
        }
        if (this.extensionPresent) {
            s = String.valueOf(s) + "\tExtension:  type " + this.extensionType + ", length " + this.extension.length + "\n";
        }
        return s;
    }

    public int calcLength() {
        return this.payloadlength + 12;
    }

    public void assemble(int len, boolean encrypted) {
        this.length = len;
        this.offset = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(len);
        DataOutputStream out = new DataOutputStream(baos);
        try {
            out.writeByte(128);
            int mp = this.payloadType;
            if (this.marker == 1) {
                mp = this.payloadType | 0x80;
            }
            out.writeByte((byte)mp);
            out.writeShort(this.seqnum);
            out.writeInt((int)this.timestamp);
            out.writeInt(this.ssrc);
            out.write(this.base.data, 0, this.data.length);
            this.data = baos.toByteArray();
        }
        catch (IOException iOException) {
            System.out.println("caught IOException in DOS");
        }
    }
}

