/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class H263Format
extends VideoFormat {
    private static String ENCODING = "h263";
    protected int advancedPrediction = -1;
    protected int arithmeticCoding = -1;
    protected int errorCompensation = -1;
    protected int hrDB = -1;
    protected int pbFrames = -1;
    protected int unrestrictedVector = -1;

    public H263Format() {
        super(ENCODING);
    }

    public H263Format(Dimension size, int maxDataLength, Class dataType, float frameRate, int advancedPrediction, int arithmeticCoding, int errorCompensation, int hrDB, int pbFrames, int unrestrictedVector) {
        super(ENCODING, size, maxDataLength, dataType, frameRate);
        this.advancedPrediction = advancedPrediction;
        this.arithmeticCoding = arithmeticCoding;
        this.errorCompensation = errorCompensation;
        this.hrDB = hrDB;
        this.pbFrames = pbFrames;
        this.unrestrictedVector = unrestrictedVector;
    }

    public int getAdvancedPrediction() {
        return this.advancedPrediction;
    }

    public int getArithmeticCoding() {
        return this.arithmeticCoding;
    }

    public int getErrorCompensation() {
        return this.errorCompensation;
    }

    public int getHrDB() {
        return this.hrDB;
    }

    public int getPBFrames() {
        return this.pbFrames;
    }

    public int getUnrestrictedVector() {
        return this.unrestrictedVector;
    }

    public String toString() {
        return "H.263 video format";
    }

    public boolean equals(Object format) {
        if (format instanceof H263Format) {
            H263Format other = (H263Format)format;
            return super.equals(format) && this.advancedPrediction == other.advancedPrediction && this.arithmeticCoding == other.arithmeticCoding && this.errorCompensation == other.errorCompensation && this.hrDB == other.hrDB && this.pbFrames == other.pbFrames && this.unrestrictedVector == other.unrestrictedVector;
        }
        return false;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof H263Format)) {
            return true;
        }
        H263Format other = (H263Format)format;
        return !(this.advancedPrediction != -1 && other.advancedPrediction != -1 && this.advancedPrediction != other.advancedPrediction || this.arithmeticCoding != -1 && other.arithmeticCoding != -1 && this.arithmeticCoding != other.arithmeticCoding || this.errorCompensation != -1 && other.errorCompensation != -1 && this.errorCompensation != other.errorCompensation || this.hrDB != -1 && other.hrDB != -1 && this.hrDB != other.hrDB || this.pbFrames != -1 && other.pbFrames != -1 && this.pbFrames != other.pbFrames || this.unrestrictedVector != -1 && other.unrestrictedVector != -1 && this.unrestrictedVector != other.unrestrictedVector);
    }

    public Format intersects(Format format) {
        Format fmt = super.intersects(format);
        if (fmt == null) {
            return null;
        }
        if (!(format instanceof H263Format)) {
            return fmt;
        }
        H263Format other = (H263Format)format;
        H263Format res = (H263Format)fmt;
        res.advancedPrediction = this.advancedPrediction != -1 ? this.advancedPrediction : other.advancedPrediction;
        res.arithmeticCoding = this.arithmeticCoding != -1 ? this.arithmeticCoding : other.arithmeticCoding;
        res.errorCompensation = this.errorCompensation != -1 ? this.errorCompensation : other.errorCompensation;
        res.hrDB = this.hrDB != -1 ? this.hrDB : other.hrDB;
        res.pbFrames = this.pbFrames != -1 ? this.pbFrames : other.pbFrames;
        res.unrestrictedVector = this.unrestrictedVector != -1 ? this.unrestrictedVector : other.unrestrictedVector;
        return res;
    }

    public Object clone() {
        H263Format f2 = new H263Format();
        f2.copy(this);
        return f2;
    }

    protected void copy(Format f2) {
        super.copy(f2);
        H263Format other = (H263Format)f2;
        this.advancedPrediction = other.advancedPrediction;
        this.arithmeticCoding = other.arithmeticCoding;
        this.errorCompensation = other.errorCompensation;
        this.hrDB = other.hrDB;
        this.pbFrames = other.pbFrames;
        this.unrestrictedVector = other.unrestrictedVector;
    }
}

