/*
 * Decompiled with CFR 0.152.
 */
package bigbrother;

import bigbrother.ADObject;
import bigbrother.AboutDialog;
import bigbrother.ActiveDirectory;
import bigbrother.AppImage;
import bigbrother.LoginDialog;
import bigbrother.UserList;
import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffTheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import netbios.NetBIOS;

class BigBrother
extends JFrame
implements Runnable,
ActionListener {
    JProgressBar progressBar;
    JLabel progressLabel;
    JToolBar actionBar;
    ActiveDirectory source;
    UserList list;
    ADObject[] users;
    Thread runner;

    public BigBrother() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BigBrother.this.dispose();
                System.exit(0);
            }
        });
        this.source = new ActiveDirectory();
        this.list = new UserList();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.progressLabel = new JLabel();
        jPanel.add(this.progressLabel);
        jPanel.add(this.progressBar);
        this.actionBar = new JToolBar();
        JButton jButton = new JButton(new AppImage("Images/login.gif"));
        jButton.setActionCommand("login");
        jButton.addActionListener(this);
        jButton.setToolTipText("Log on/Log off Active Directory Server");
        jButton.setMargin(new Insets(0, 0, 0, 0));
        this.actionBar.add(jButton);
        this.actionBar.add(new JToolBar.Separator());
        JButton jButton2 = new JButton(new AppImage("Images/refresh.gif"));
        jButton2.setActionCommand("refresh");
        jButton2.addActionListener(this);
        jButton2.setToolTipText("Refresh");
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        this.actionBar.add(jButton2);
        this.actionBar.add(new JToolBar.Separator());
        JButton jButton3 = new JButton(new AppImage("Images/help.gif"));
        jButton3.setActionCommand("about");
        jButton3.addActionListener(this);
        jButton3.setToolTipText("About this application");
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        this.actionBar.add(jButton3);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.list, "Center");
        this.getContentPane().add((Component)this.actionBar, "North");
        this.getContentPane().add((Component)jPanel, "South");
    }

    public void showInit() {
        AboutDialog aboutDialog = new AboutDialog(this, true);
        aboutDialog.setVisible(true);
    }

    public void login() {
        this.list.setData(null);
        LoginDialog loginDialog = new LoginDialog(this);
        loginDialog.setVisible(true);
    }

    void login(LoginDialog loginDialog, String string, String string2, String string3, String string4) {
        LoginThread loginThread = new LoginThread(this.source, loginDialog, string, string2, string3, string4);
        loginThread.start();
    }

    public void run() {
        ThreadGroup threadGroup = new ThreadGroup("network");
        this.progressLabel.setText("Retreiving user accounts");
        this.progressBar.setVisible(true);
        this.source.synchronize();
        this.users = this.source.getUsers();
        this.list.setData(this.users);
        this.progressLabel.setText("Retreiving network information");
        this.progressBar.setVisible(true);
        int n2 = 0;
        while (n2 < this.users.length) {
            ADObject[] aDObjectArray = n2 < this.users.length - 10 ? new ADObject[10] : new ADObject[this.users.length - n2];
            int n3 = 0;
            while (n3 < aDObjectArray.length) {
                aDObjectArray[n3] = this.users[n2 + n3];
                ++n3;
            }
            NetworkThread networkThread = new NetworkThread(threadGroup, aDObjectArray);
            networkThread.start();
            n2 += 10;
        }
        try {
            do {
                Thread.sleep(1000L);
            } while (threadGroup.activeCount() > 0);
            this.progressLabel.setText("");
            this.progressBar.setVisible(false);
            this.list.setData(this.users);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void collectData() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("login".equals(actionEvent.getActionCommand())) {
            if (!this.source.isConnected()) {
                LoginDialog loginDialog = new LoginDialog(this);
                loginDialog.setVisible(true);
            } else {
                this.source.logoff();
                this.list.setData(null);
                this.users = new ADObject[0];
                this.progressLabel.setText("Logged Off");
            }
        } else if ("refresh".equals(actionEvent.getActionCommand())) {
            if (this.source.isConnected()) {
                this.collectData();
            }
        } else if ("about".equals(actionEvent.getActionCommand())) {
            AboutDialog aboutDialog = new AboutDialog(this, false);
            aboutDialog.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        try {
            serializable = new KunststoffLookAndFeel();
            KunststoffLookAndFeel.setCurrentTheme(new KunststoffTheme());
            UIManager.setLookAndFeel((LookAndFeel)((Object)serializable));
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        serializable = new BigBrother();
        ((Window)serializable).setSize(640, 480);
        ((Frame)serializable).setTitle("Big Brother Lite");
        ((JFrame)serializable).setIconImage(new AppImage("Images/logosmall.jpg").getImage());
        ((Window)serializable).setVisible(true);
        ((BigBrother)serializable).showInit();
    }

    class LoginThread
    extends Thread {
        ActiveDirectory source;
        LoginDialog login;
        String username;
        String password;
        String server;
        String domain;

        public LoginThread(ActiveDirectory activeDirectory, LoginDialog loginDialog, String string, String string2, String string3, String string4) {
            this.source = activeDirectory;
            this.login = loginDialog;
            this.username = string;
            this.password = string2;
            this.server = string3;
            this.domain = string4;
        }

        public void run() {
            BigBrother.this.progressLabel.setText("Logging in to Active Directory");
            BigBrother.this.progressBar.setVisible(true);
            try {
                this.source.login(this.username, this.password, this.server, this.domain);
                this.login.setVisible(false);
                BigBrother.this.collectData();
            }
            catch (Exception exception) {
                this.login.catchError(exception);
            }
            BigBrother.this.progressLabel.setText("");
            BigBrother.this.progressBar.setVisible(false);
        }
    }

    class NetworkThread
    extends Thread {
        ADObject[] users;

        public NetworkThread(ThreadGroup threadGroup, ADObject[] aDObjectArray) {
            super(threadGroup, "");
            this.users = aDObjectArray;
        }

        public void run() {
            int n2 = 0;
            while (n2 < this.users.length) {
                String string = this.users[n2].getValue("userPrincipalName");
                int n3 = string.indexOf("@");
                if (n3 >= 0) {
                    String string2 = "";
                    InetAddress inetAddress = NetBIOS.resolveUser(string.substring(0, n3).toUpperCase());
                    if (inetAddress != null) {
                        string2 = NetBIOS.getHostName(inetAddress);
                        if (string2 == null) {
                            string2 = "";
                        }
                        try {
                            String string3 = inetAddress.toString();
                            string3 = string3.substring(1, string3.length());
                            this.users[n2].setValue("resolvedhost", string2 + " (" + string3 + ") ");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

