/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import stec.iws.AdminCPanel;
import stec.iws.AdminConstants;
import stec.iws.AdminContext;
import stec.iws.AdminLogin;
import stec.iws.AdminServlet;
import stec.iws.AdminUtils;
import stec.lang.DString;

public class AdminMonitor {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayMonitor(AdminContext adminContext) throws IOException, ServletException {
        int n;
        adminContext.setForm("monitor");
        adminContext.response.setHeader("Connection", "Close");
        String string = new String(AdminServlet.monitor_template);
        String string2 = adminContext.request.getParameter("error_message");
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%error_message%", string2);
        String string3 = adminContext.request.getParameter("interval");
        try {
            n = Integer.parseInt(string3);
            if (n < 1) {
                n = AdminMonitor.getInterval(adminContext);
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = AdminMonitor.getInterval(adminContext);
        }
        String string4 = String.valueOf(n);
        string = DString.replace(string, "%interval%", string4);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < AdminConstants.INTERVALS.length) {
            if (string4.equals(AdminConstants.INTERVALS[n2][0])) {
                stringBuffer.append("<OPTION VALUE=" + AdminConstants.INTERVALS[n2][0] + " SELECTED>" + AdminConstants.INTERVALS[n2][1] + "\n");
            } else {
                stringBuffer.append("<OPTION VALUE=" + AdminConstants.INTERVALS[n2][0] + ">" + AdminConstants.INTERVALS[n2][1] + "\n");
            }
            ++n2;
        }
        string = DString.replace(string, "%intervals%", stringBuffer.toString());
        ServletOutputStream servletOutputStream = adminContext.response.getOutputStream();
        int n3 = string.indexOf("%status%");
        if (n3 == -1) {
            servletOutputStream.print(string);
            servletOutputStream.flush();
            return;
        }
        servletOutputStream.print(string.substring(0, n3));
        servletOutputStream.flush();
        int n4 = adminContext.request.getServerPort();
        if (n4 == -1) {
            n4 = 80;
        }
        String string5 = String.valueOf(adminContext.request.getServerName()) + ":" + n4;
        if (AdminServlet.servers == null) {
            String[] stringArray = new String[4];
            stringArray[0] = "1";
            stringArray[1] = string5;
            AdminMonitor.outputServer(adminContext, stringArray);
        } else {
            int n5 = 0;
            while (n5 < AdminServlet.servers.length) {
                if (AdminServlet.servers[n5][1].equalsIgnoreCase(string5)) {
                    AdminServlet.servers[n5][0] = "1";
                }
                AdminMonitor.outputServer(adminContext, AdminServlet.servers[n5]);
                ++n5;
            }
        }
        servletOutputStream.print(string.substring(n3 + "%status%".length()));
        servletOutputStream.flush();
    }

    protected static void doMonitor(AdminContext adminContext) throws ServletException, IOException {
        adminContext.setForm("monitor");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            AdminMonitor.refresh(adminContext);
            return;
        }
        if (string.equals("help")) {
            AdminUtils.help(adminContext, adminContext.form, "");
            return;
        }
        if (string.equals("refresh")) {
            AdminMonitor.refresh(adminContext);
            return;
        }
        if (string.equals("select")) {
            AdminCPanel.displayCPanel(adminContext);
            return;
        }
        if (string.equals("log out")) {
            AdminLogin.displayLogin(adminContext);
            return;
        }
        AdminMonitor.refresh(adminContext);
    }

    protected static int getInterval(AdminContext adminContext) {
        try {
            Hashtable hashtable = (Hashtable)adminContext.session.getValue("monitor");
            return Integer.parseInt((String)hashtable.get("interval"));
        }
        catch (Exception exception) {
            return AdminServlet.interval;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int monitor(AdminContext adminContext, String[] stringArray) {
        int n = -1;
        long l = System.currentTimeMillis();
        Socket socket = null;
        try {
            try {
                URL uRL = new URL("http://" + stringArray[1] + "/status");
                int n2 = uRL.getPort();
                if (n2 == -1) {
                    n2 = 80;
                }
                String string = uRL.getHost();
                socket = new Socket(string, n2);
                socket.setSoTimeout(60000);
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                dataOutputStream.writeBytes("GET " + uRL.getFile() + "?report=summary HTTP/1.0\n");
                dataOutputStream.writeBytes("Connection: Close\n");
                dataOutputStream.writeBytes("\n");
                dataOutputStream.flush();
                String string2 = dataInputStream.readLine();
                if (string2 != null) {
                    long l2;
                    adminContext.responseTime = l2 = Long.parseLong(string2);
                }
                if ((string2 = dataInputStream.readLine()) != null) {
                    int n3;
                    adminContext.connections = n3 = Integer.parseInt(string2);
                }
                if ((string2 = dataInputStream.readLine()) != null) {
                    int n4;
                    adminContext.maxConnections = n4 = Integer.parseInt(string2);
                }
                if ((string2 = dataInputStream.readLine()) != null) {
                    int n5;
                    adminContext.actualConnections = n5 = Integer.parseInt(string2);
                }
                if ((string2 = dataInputStream.readLine()) != null) {
                    int n6;
                    adminContext.usedConnections = n6 = Integer.parseInt(string2);
                }
                adminContext.actualTime = System.currentTimeMillis() - l;
                n = 0;
            }
            catch (Exception exception) {
            }
            Object var7_16 = null;
            if (socket == null) return n;
        }
        catch (Throwable throwable) {
            Object var7_17 = null;
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            socket.close();
            return n;
        }
        catch (Exception exception) {}
        return n;
    }

    protected static void outputServer(AdminContext adminContext, String[] stringArray) throws IOException {
        ServletOutputStream servletOutputStream = adminContext.response.getOutputStream();
        servletOutputStream.print("<tr valign=top bgcolor=\"#C0C0C0\">");
        servletOutputStream.print("<td>");
        servletOutputStream.print("&nbsp;");
        servletOutputStream.print("</td>");
        if (AdminMonitor.monitor(adminContext, stringArray) == -1) {
            servletOutputStream.print("<td>");
            servletOutputStream.print(stringArray[1]);
            servletOutputStream.print("</td>");
            servletOutputStream.print("<td align=\"center\" bgcolor=\"#ff0000\">");
            servletOutputStream.print("Down");
            servletOutputStream.print("</td>");
            servletOutputStream.print("<td>");
            servletOutputStream.print("&nbsp;");
            servletOutputStream.print("</td>");
            servletOutputStream.print("<td>");
            servletOutputStream.print("&nbsp;");
            servletOutputStream.print("</td>");
        } else {
            String string;
            if (stringArray[0].equals("1")) {
                string = "?form_name=monitor&action=select";
            } else {
                String string2;
                int n;
                string = "?form_name=login&action=ok";
                if (stringArray[2] != null && stringArray[3] == null) {
                    string = String.valueOf(string) + "&id=" + stringArray[2];
                } else if (stringArray[2] == null && stringArray[3] != null) {
                    string = String.valueOf(string) + "pw=" + stringArray[3];
                } else if (stringArray[2] != null && stringArray[3] != null) {
                    string = String.valueOf(string) + "&id=" + stringArray[2] + "&pw=" + stringArray[3];
                }
                String string3 = adminContext.request.getRequestURI();
                int n2 = string3.indexOf(63);
                if (n2 != -1) {
                    string3 = string3.substring(0, n2);
                }
                if ((n = adminContext.request.getServerPort()) == -1) {
                    n = 80;
                }
                string = String.valueOf(string) + "&url=" + ((string2 = "http://" + adminContext.request.getServerName() + ":" + n + string3 + "?form_name=monitor&action=refresh") == null ? null : URLEncoder.encode(string2));
            }
            servletOutputStream.print("<td>");
            servletOutputStream.print("<a href=\"http://" + stringArray[1] + "/admin.html" + string + "\">");
            servletOutputStream.print(stringArray[1]);
            servletOutputStream.print("</a>");
            servletOutputStream.print("</td>");
            servletOutputStream.print("<td align=\"center\" bgcolor=\"#00ff00\">");
            servletOutputStream.print("Up");
            servletOutputStream.print("</td>");
            servletOutputStream.print("<td align=\"right\">");
            servletOutputStream.print("[");
            servletOutputStream.print(adminContext.usedConnections);
            servletOutputStream.print(" - ");
            servletOutputStream.print(adminContext.actualConnections);
            servletOutputStream.print("/");
            servletOutputStream.print(adminContext.maxConnections);
            servletOutputStream.print("]");
            servletOutputStream.print("</td>");
            servletOutputStream.print("<td align=\"right\">");
            servletOutputStream.print(adminContext.responseTime);
            servletOutputStream.print("/");
            servletOutputStream.print(adminContext.actualTime);
            servletOutputStream.print("</td>");
        }
        servletOutputStream.print("<td>");
        servletOutputStream.print("&nbsp;");
        servletOutputStream.print("</td>");
        servletOutputStream.println("</tr>");
        servletOutputStream.flush();
    }

    protected static void refresh(AdminContext adminContext) throws IOException, ServletException {
        String string = adminContext.request.getParameter("interval");
        if (string != null) {
            Object object;
            int n;
            try {
                n = Integer.parseInt(string);
                if (n < 1) {
                    n = AdminServlet.interval;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = AdminServlet.interval;
            }
            Hashtable<String, String> hashtable = (object = adminContext.session.getValue("monitor")) == null ? new Hashtable<String, String>() : (Hashtable<String, String>)object;
            hashtable.put("interval", String.valueOf(n));
            adminContext.session.putValue("monitor", hashtable);
        }
        AdminMonitor.displayMonitor(adminContext);
    }
}

