/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminRealms {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayRealmEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("realm_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("realm");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%realm%", (String)object);
        object = hashtable.get("class_file");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%class_file%", (String)object);
        object = hashtable.get("parameters");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%parameters%", (String)object);
        object = hashtable.get("preload");
        if (object == null) {
            object = "n";
        }
        if ((object = hashtable.get("key")) == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayRealms(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("realms");
        AdminUtils.displayList(adminContext);
    }

    protected static void doRealmEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("realm_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminRealms.verifyRealmEntry(adminContext)) {
                AdminRealms.updateRealmEntry(adminContext);
                adminContext.setForm("realms");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "realms", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminRealms.verifyRealmEntry(adminContext)) {
                    AdminRealms.updateRealmEntry(adminContext);
                    adminContext.setForm("realms");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("realms");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminRealms.displayRealmEntry(adminContext);
    }

    protected static void doRealms(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("realms");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminRealms.displayRealmEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminRealms.parseRealmEntry(adminContext);
                AdminRealms.displayRealmEntry(adminContext);
                return;
            }
        } else {
            if (adminContext.action.equals("load")) {
                String string = adminContext.request.getParameter("key");
                if (string == null) {
                    adminContext.error_message.append("An entry was not selected.");
                } else {
                    String string2 = string;
                    if (string2.length() == 0) {
                        adminContext.error_message.append("An entry was not selected.");
                    } else if (!iws.realms.containsKey(string2)) {
                        adminContext.error_message.append("Unable to find entry: ");
                        adminContext.error_message.append(string2);
                    } else {
                        try {
                            if (iws.servletManager.loadRealm(string2) == null) {
                                adminContext.error_message.append("Realm was not found: ");
                                adminContext.error_message.append(string2);
                            }
                        }
                        catch (Exception exception) {
                            adminContext.error_message.append("Error while loading ");
                            adminContext.error_message.append("Realm: ");
                            adminContext.error_message.append(string2);
                            adminContext.error_message.append(": ");
                            adminContext.error_message.append(exception.toString());
                        }
                    }
                }
                AdminUtils.displayList(adminContext);
                return;
            }
            if (adminContext.action.equals("unload")) {
                String string = adminContext.request.getParameter("key");
                if (string == null) {
                    adminContext.error_message.append("An entry was not selected.");
                } else {
                    String string3 = string;
                    if (string3.length() == 0) {
                        adminContext.error_message.append("An entry was not selected.");
                    } else if (iws.servletManager.realmContexts.containsKey(string3)) {
                        try {
                            iws.servletManager.unloadRealm(string3);
                        }
                        catch (Exception exception) {
                            iws.logger.log(exception);
                            adminContext.error_message.append("Error while unloading");
                            adminContext.error_message.append("Realm: ");
                            adminContext.error_message.append(string3);
                            adminContext.error_message.append(": ");
                            adminContext.error_message.append(exception.toString());
                        }
                    }
                }
                AdminUtils.displayList(adminContext);
                return;
            }
            if (adminContext.action.equals("reload")) {
                String string = adminContext.request.getParameter("key");
                if (string == null) {
                    adminContext.error_message.append("An entry was not selected.");
                } else {
                    String string4 = string;
                    if (string4.length() == 0) {
                        adminContext.error_message.append("An entry was not selected.");
                    } else if (!iws.realms.containsKey(string4)) {
                        adminContext.error_message.append("Unable to find entry: ");
                        adminContext.error_message.append(string4);
                    } else {
                        if (iws.servletManager.realmContexts.containsKey(string4)) {
                            try {
                                iws.servletManager.unloadRealm(string4);
                            }
                            catch (Exception exception) {
                                iws.logger.log(exception);
                                adminContext.error_message.append("Error while unloading");
                                adminContext.error_message.append("Realm: ");
                                adminContext.error_message.append(string4);
                                adminContext.error_message.append(": ");
                                adminContext.error_message.append(exception.toString());
                            }
                        }
                        try {
                            if (iws.servletManager.loadRealm(string4) == null) {
                                adminContext.error_message.append("Realm was not found: ");
                                adminContext.error_message.append(string4);
                            }
                        }
                        catch (Exception exception) {
                            adminContext.error_message.append("Error while loading ");
                            adminContext.error_message.append("Realm: ");
                            adminContext.error_message.append(string4);
                            adminContext.error_message.append(": ");
                            adminContext.error_message.append(exception.toString());
                        }
                    }
                }
                AdminUtils.displayList(adminContext);
                return;
            }
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getRealmEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("realm", string);
        String string2 = (String)hashtable.get("entry");
        int n = string2.indexOf(63);
        if (n == -1) {
            hashtable.put("class_file", string2);
        } else {
            hashtable.put("class_file", string2.substring(0, n));
            String string3 = string2.substring(n + 1);
            string3 = DString.replace(string3, "&", "\n");
            hashtable.put("parameters", string3);
        }
        return hashtable;
    }

    protected static void parseRealmEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminRealms.getRealmEntry(adminContext, hashtable);
    }

    protected static void updateRealmEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = adminContext.data;
        String string2 = (String)hashtable.get("realm");
        String string3 = (String)hashtable.get("class_file");
        Object v = hashtable.get("parameters");
        if (v != null && (string = DString.trim((String)v)).length() > 0) {
            string = DString.replace(string, "\n", "&");
            string = DString.replace(string, "\r", "");
            string3 = String.valueOf(string3) + "?" + string;
        }
        hashtable = AdminUtils.getSessionData(adminContext, "realms");
        hashtable.put(string2, string3);
        AdminUtils.putSessionData(adminContext, "realms", hashtable);
    }

    protected static boolean verifyRealmEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminRealms.getRealmEntry(adminContext, AdminUtils.getFormData(adminContext, "realms"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("realm")) == null) {
            adminContext.error_message.append("Realm is required.<br>");
            string3 = hashtable.get("realm");
            if (string3 != null) {
                hashtable2.put("realm", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Realm is required.<br>");
                string3 = hashtable.get("realm");
                if (string3 != null) {
                    hashtable2.put("realm", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("realm", string);
            } else if (AdminUtils.getFormEntry(adminContext, "realms", string) != null) {
                adminContext.error_message.append("Realm already exists.<br>");
                string3 = hashtable.get("realm");
                if (string3 != null) {
                    hashtable2.put("realm", string3);
                }
            } else if (string.indexOf("&") == -1) {
                hashtable2.put("realm", string);
            } else {
                adminContext.error_message.append("Realm can not contain: ");
                adminContext.error_message.append("&");
                adminContext.error_message.append("<br>");
                string3 = hashtable.get("realm");
                if (string3 != null) {
                    hashtable2.put("realm", string3);
                }
            }
        }
        if ((string3 = adminContext.request.getParameter("class_file")) == null) {
            adminContext.error_message.append("Class File is required.<br>");
            string3 = hashtable.get("class_file");
            if (string3 != null) {
                hashtable2.put("class_file", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Class File is required.<br>");
                string3 = hashtable.get("class_file");
                if (string3 != null) {
                    hashtable2.put("class_file", string3);
                }
            } else {
                hashtable2.put("class_file", string3);
            }
        }
        if ((string3 = adminContext.request.getParameter("parameters")) != null) {
            hashtable2.put("parameters", string3);
        }
        return adminContext.error_message.length() <= 0;
    }
}

