/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import stec.iws.Realm;
import stec.iws.Utils;
import stec.lang.DString;

public class FileRealm
extends Realm {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private Hashtable users;
    private Hashtable groups;
    private Vector acls;

    public int authenticateComputer(String string, String string2, String string3, String string4) throws Exception {
        int n = DString.dcount(string, ",");
        int n2 = 0;
        while (n2 < n) {
            String string5 = DString.trim(DString.extract(string, ",", n2));
            String string6 = this.checkACL(string5, string2, string3);
            if (string6 != null) {
                if (this.canAccess(string6, string4)) {
                    return 1;
                }
                return 0;
            }
            ++n2;
        }
        return -1;
    }

    public boolean authenticateUser(String string, String string2, String string3, String string4) throws Exception {
        if (!this.isValid(string2, string3)) {
            return false;
        }
        int n = DString.dcount(string, ",");
        int n2 = 0;
        while (n2 < n) {
            String string5 = DString.trim(DString.extract(string, ",", n2));
            String string6 = this.checkACL(string5, string2);
            if (string6 != null) {
                return this.canAccess(string6, string4);
            }
            ++n2;
        }
        return false;
    }

    private boolean canAccess(String string, String string2) {
        int n = DString.dcount(string, ",");
        int n2 = 0;
        while (n2 < n) {
            String string3 = DString.trim(DString.extract(string, ",", n2));
            if (string3.equals("*") || string3.equalsIgnoreCase(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String checkACL(String string, String string2) throws Exception {
        int n = string.indexOf(46);
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        int n2 = 0;
        while (n2 < this.acls.size()) {
            ACL aCL = (ACL)this.acls.elementAt(n2);
            if (aCL.key.equals(string)) {
                if (string3.equals("group") ? this.checkGroup(string4, string2) : string3.equals("user") && string4.equals(string2)) {
                    return aCL.rights;
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    public String checkACL(String string, String string2, String string3) throws Exception {
        int n = string.indexOf(46);
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + 1);
        if (string4.equalsIgnoreCase("hostname")) {
            if (!string5.equalsIgnoreCase(string2)) {
                return null;
            }
        } else if (string4.equalsIgnoreCase("ip_address")) {
            if (!string5.equalsIgnoreCase(string3)) {
                return null;
            }
        } else if (string4.equalsIgnoreCase("ip_range")) {
            if (!Realm.checkRange(string5, string3)) {
                return null;
            }
        } else {
            return null;
        }
        int n2 = 0;
        while (n2 < this.acls.size()) {
            ACL aCL = (ACL)this.acls.elementAt(n2);
            if (aCL.key.equals(string)) {
                return aCL.rights;
            }
            ++n2;
        }
        return null;
    }

    private boolean checkGroup(String string, String string2) {
        Object v = this.groups.get(string);
        if (v == null) {
            return false;
        }
        String string3 = (String)v;
        int n = DString.dcount(string3, ",");
        int n2 = 0;
        while (n2 < n) {
            String string4 = DString.trim(DString.extract(string3, ",", n2));
            if (string4.equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void destroy() {
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            super.init(servletConfig);
            this.users = Utils.load("./config/users.ini", false);
            this.groups = Utils.load("./config/groups.ini", false);
            Hashtable hashtable = Utils.load("./config/acl.ini", false);
            Enumeration enumeration = hashtable.keys();
            this.acls = new Vector();
            while (enumeration.hasMoreElements()) {
                ACL aCL = new ACL();
                aCL.key = (String)enumeration.nextElement();
                aCL.rights = (String)hashtable.get(aCL.key);
                this.acls.addElement(aCL);
            }
            return;
        }
        catch (IOException iOException) {
            throw new ServletException(iOException.getMessage());
        }
    }

    private boolean isValid(String string, String string2) {
        Object v = this.users.get(string);
        if (v == null) {
            return false;
        }
        return string2.equals((String)v);
    }

    class ACL {
        String key;
        String rights;

        ACL() {
        }
    }
}

