/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stec.iws.IOManager;
import stec.iws.Logger;
import stec.iws.RequestHandler;
import stec.iws.ServletContextImpl;
import stec.iws.ServletManager;
import stec.iws.SessionContext;
import stec.iws.SessionManager;
import stec.iws.Utils;
import stec.lang.DString;
import stec.sql.ConnectionPoolManager;

public class iws {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private static final String PRODUCT_NAME = "iServer";
    private static final String VERSION = "1.7.0";
    private static final String RELEASE_DATE = "01/09/2000";
    private static final String PREVIEW_RELEASE = "Preview Release";
    private static final String BINARY_RELEASE = "Binary Release";
    private static final String DISTRIBUTION = "Preview Release";
    private static final int EVALUATION_PERIOD = 60;
    private static final int GRACE_PERIOD = 30;
    private static final long DAY = 86400000L;
    private static boolean display_preview = true;
    private static final String LOGO = "Servertec (R) Application/Web Server Version 1.7.0 01/09/2000 Preview Release\nCopyright (C) Servertec 1998-2000. All rights reserved.\n";
    private static final String SYNTAX = "Syntax: iws [<archive>|<path>]";
    public static Hashtable mimetypes;
    public static Hashtable messages;
    public static Hashtable aliases;
    public static Hashtable servlets;
    public static Hashtable hosts;
    public static boolean security;
    public static Hashtable resources;
    public static Hashtable realms;
    public static ServletManager servletManager;
    protected static SessionManager sessionManager;
    protected static Thread sessionManagerThread;
    protected static ThreadGroup threadGroup;
    protected static Vector threads;
    protected static String basedir;
    protected static boolean inArchive;
    protected static String adminID;
    protected static String adminPW;
    protected static int port;
    protected static int connections;
    protected static int maxConnections;
    protected static int actualConnections;
    protected static int usedConnections;
    protected static int timeout;
    protected static int shutdown_delay;
    protected static boolean keepAlive;
    protected static int keepAliveTimeout;
    protected static int keepAliveTimeoutMillis;
    protected static int keepAliveRequests;
    protected static int backlog;
    protected static ServerSocket serverSocket;
    protected static String default_page;
    protected static boolean shell;
    protected static boolean displayDirectory;
    protected static boolean dns_lookup;
    protected static boolean remote_admin;
    protected static boolean servlet_chaining;
    protected static SessionContext sessionContext;
    protected static String[] envs;
    protected static String[] args;
    protected static String preloadServlets;
    protected static String messagesTemplate;
    protected static boolean logErrors;
    protected static boolean logEvents;
    protected static boolean logAccess;
    protected static Logger logger;
    protected static String loggerService;
    protected static long sessionTimeout;
    protected static long sessionManagerInterval;
    protected static int sessionSource;
    protected static String sessionName;
    protected static String sessionComment;
    protected static String sessionDomain;
    protected static String sessionPath;
    protected static int sessionMaxAge;
    protected static boolean sessionSecure;
    protected static boolean shutdown;
    protected static boolean connectionPools;
    protected static String address;
    protected static int returnCode;

    static {
        logErrors = true;
    }

    protected static void _init() throws Exception {
        Hashtable hashtable;
        String string;
        Serializable serializable;
        if (display_preview) {
            serializable = new SimpleDateFormat("MM/dd/yyyy");
            long l = System.currentTimeMillis();
            long l2 = ((DateFormat)serializable).parse(RELEASE_DATE).getTime() + 5184000000L;
            int n = 60 - (int)((l2 - l) / 86400000L);
            if (n < 1) {
                n *= -1;
                ++n;
            }
            if (n > 90) {
                System.err.print("Your ");
                System.err.print(60);
                System.err.print(" day evaluation period is over. If you would like to continue to use\n");
                System.err.print(PRODUCT_NAME);
                System.err.println(", you must purchase the licensed version.");
                System.exit(0);
            } else if (n > 60) {
                n = 90 - n;
                System.err.print("Your ");
                System.err.print(60);
                System.err.print(" day evaluation period is over. After ");
                System.err.print(n);
                System.err.print(" days this software will not\nrun. If you would like to continue to use ");
                System.err.print(PRODUCT_NAME);
                System.err.println(", you must purchase the licensed\nversion.");
            } else {
                System.err.print("This is a ");
                System.err.print(60);
                System.err.print(" day evaluation version of ");
                System.err.print(PRODUCT_NAME);
                System.err.print(". If after ");
                System.err.print(60);
                System.err.println(" day period you\nwould like to continue to use it, you must purchase the licensed version.");
            }
            System.err.println();
            display_preview = false;
        }
        shutdown = false;
        serverSocket = null;
        basedir = args.length == 1 ? args[0] : ".";
        serializable = new File(basedir);
        if (!((File)serializable).exists()) {
            throw new Exception("Base directory does not exist: " + basedir);
        }
        basedir = ((File)serializable).getCanonicalPath();
        String string2 = basedir.toLowerCase();
        inArchive = string2.endsWith(".jar") || string2.endsWith(".zip");
        envs = new String[0];
        servletManager = new ServletManager();
        threads = new Vector();
        sessionContext = new SessionContext();
        iws.loadServerConfig();
        iws.loadSessionConfig();
        iws.loadLoggerConfig();
        mimetypes = Utils.load("./config/mimetypes.ini", false);
        messages = Utils.load("./config/messages.ini", false);
        aliases = Utils.load("./config/aliases.ini", false);
        servlets = Utils.load("./config/servlets.ini", false);
        hosts = Utils.load("./config/hosts.ini", false);
        if (security) {
            resources = Utils.load("./config/resources.ini", false);
            realms = Utils.load("./config/realms.ini", false);
        }
        envs = Utils.loadEnv();
        int n = loggerService.indexOf(63);
        if (n == -1) {
            string = loggerService;
            hashtable = new Hashtable();
        } else {
            string = loggerService.substring(0, n);
            hashtable = Utils.decodeParameters(loggerService.substring(n + 1));
        }
        Class<?> clazz = Class.forName(string);
        Logger logger = (Logger)clazz.newInstance();
        logger.init(hashtable);
        iws.logger = logger;
        Thread thread = new Thread(iws.logger);
        thread.setDaemon(true);
        thread.start();
        messagesTemplate = Utils.getItem(IOManager.getHandler(basedir, "./html/messages.html"));
        actualConnections = connections;
        usedConnections = 0;
        ThreadGroup threadGroup = new ThreadGroup("RequestHandlers");
        int n2 = 0;
        while (n2 < connections) {
            RequestHandler requestHandler = new RequestHandler();
            new Thread(threadGroup, requestHandler).start();
            threads.addElement(requestHandler);
            ++n2;
        }
        serverSocket = address == null ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(address));
        if (connectionPools) {
            iws.initConnectionPools();
        }
        if (sessionManagerInterval != -1L) {
            sessionManager = new SessionManager();
            sessionManagerThread = new Thread(sessionManager);
            sessionManagerThread.setDaemon(true);
            sessionManagerThread.start();
        }
        iws.logger.log("Server was started");
        iws.preload_servlets();
    }

    public static void destroy() {
        Exception exception;
        try {
            iws.shutdown(returnCode);
        }
        catch (Exception exception2) {
            exception = exception2;
            iws.log(exception, "");
        }
        if (threadGroup != null) {
            block24: {
                try {
                    if (shutdown_delay == -1) {
                        while (usedConnections > 0) {
                        }
                        break block24;
                    }
                    long l = System.currentTimeMillis() + (long)(shutdown_delay * 1000);
                    while (System.currentTimeMillis() < l) {
                        if (usedConnections > 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                    iws.log(exception, "");
                }
            }
            try {
                threadGroup.stop();
            }
            catch (Exception exception4) {
                exception = exception4;
                iws.log(exception, "");
            }
            threadGroup = null;
        }
        if (sessionManagerThread != null) {
            try {
                sessionManagerThread.stop();
            }
            catch (Exception exception5) {
                exception = exception5;
                iws.log(exception, "");
            }
            sessionManagerThread = null;
        }
        if (servletManager != null) {
            try {
                servletManager.destroyServlets();
            }
            catch (Exception exception6) {
                exception = exception6;
                iws.log(exception, "");
            }
            try {
                servletManager.destroyRealms();
            }
            catch (Exception exception7) {
                exception = exception7;
                iws.log(exception, "");
            }
            servletManager = null;
        }
        try {
            ConnectionPoolManager.destroyAllConnectionPools();
        }
        catch (Exception exception8) {
            exception = exception8;
            iws.log(exception, "");
        }
        sessionManager = null;
        iws.log("Server was stopped");
        if (logger != null) {
            try {
                logger.destroy();
            }
            catch (Exception exception9) {
                logger = null;
                exception = exception9;
                iws.log(exception, "");
            }
            logger = null;
        }
    }

    public static String getBaseDirectory() {
        return basedir;
    }

    public static String getMimeType(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = (String)mimetypes.get(string.substring(n).toLowerCase());
        }
        if (string2 == null) {
            string2 = (String)mimetypes.get("*");
        }
        return string2;
    }

    public static String getServerVersion() {
        return LOGO;
    }

    public static void init() throws Exception {
        String[] stringArray = new String[]{};
        args = stringArray;
        System.out.println(LOGO);
        iws._init();
    }

    public static void init(String string) throws Exception {
        returnCode = 0;
        String[] stringArray = string.length() == 0 ? new String[]{} : new String[]{string};
        args = stringArray;
        System.out.println(LOGO);
        iws._init();
    }

    public static void init(String[] stringArray) throws Exception {
        args = stringArray;
        System.out.println(LOGO);
        iws._init();
    }

    private static void initConnectionPools() throws Exception {
        Hashtable hashtable = Utils.load("./config/dbpools.ini", false);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                Hashtable hashtable2 = Utils.decodeParameters(string2);
                Object v = hashtable2.get("driver");
                if (v == null) {
                    StringBuffer stringBuffer = new StringBuffer("Invalid connection pool entry: Driver was not specified: ");
                    stringBuffer.append(string);
                    stringBuffer.append(": ");
                    stringBuffer.append(string2);
                    throw new Exception(stringBuffer.toString());
                }
                String string3 = ((String[])v)[0];
                v = hashtable2.get("url");
                if (v == null) {
                    StringBuffer stringBuffer = new StringBuffer("Invalid connection pool entry: URL was not specified: ");
                    stringBuffer.append(string);
                    stringBuffer.append(": ");
                    stringBuffer.append(string2);
                    throw new Exception(stringBuffer.toString());
                }
                String string4 = ((String[])v)[0];
                v = hashtable2.get("username");
                String string5 = v == null ? null : ((String[])v)[0];
                v = hashtable2.get("password");
                String string6 = v == null ? null : ((String[])v)[0];
                v = hashtable2.get("init_size");
                int n = v == null ? 10 : Integer.parseInt(((String[])v)[0]);
                v = hashtable2.get("max_size");
                int n2 = v == null ? n : Integer.parseInt(((String[])v)[0]);
                ConnectionPoolManager.createConnectionPool(string, string3, string4, string5, string6, n, n2);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                iws.log(exception2, "");
            }
        }
    }

    private static void loadLoggerConfig() throws IOException, Exception {
        logger = null;
        logErrors = true;
        logEvents = true;
        logAccess = true;
        loggerService = null;
        Hashtable hashtable = Utils.load("./config/logger.ini", false);
        Object v = hashtable.get("log_errors");
        if (v != null) {
            logErrors = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("log_events")) != null) {
            logEvents = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("log_access")) != null) {
            logAccess = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("service")) == null) {
            loggerService = "stec.iws.ConsoleLogger";
            return;
        }
        loggerService = (String)v;
        if (loggerService.length() == 0) {
            loggerService = "stec.iws.ConsoleLogger";
        }
    }

    private static void loadServerConfig() throws IOException, Exception {
        String string;
        adminID = "";
        adminPW = "";
        preloadServlets = null;
        maxConnections = connections = 25;
        backlog = 50;
        keepAlive = true;
        keepAliveTimeout = 15;
        keepAliveRequests = 5;
        port = 8080;
        timeout = 300000;
        shutdown_delay = 60;
        default_page = null;
        shell = false;
        displayDirectory = false;
        dns_lookup = false;
        remote_admin = true;
        servlet_chaining = false;
        security = false;
        connectionPools = false;
        address = null;
        Hashtable hashtable = Utils.load("./config/iws.ini", false);
        Object v = hashtable.get("default");
        if (v != null && (string = (String)v).length() > 0) {
            default_page = string;
        }
        if ((v = hashtable.get("shell")) != null) {
            shell = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("directory")) != null) {
            displayDirectory = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("dns_lookup")) != null) {
            dns_lookup = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("remote_admin")) != null) {
            remote_admin = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("security")) != null) {
            security = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("connection_pools")) != null) {
            connectionPools = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("servlet_chaining")) != null) {
            servlet_chaining = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("timeout")) != null) {
            timeout = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("port")) != null) {
            port = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("connections")) != null) {
            connections = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("max_connections")) != null) {
            maxConnections = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("backlog")) != null) {
            backlog = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("keep_alive")) != null) {
            keepAlive = ((String)v).equalsIgnoreCase("y");
        }
        if ((v = hashtable.get("keep_alive_timeout")) != null) {
            keepAliveTimeout = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("keep_alive_requests")) != null) {
            keepAliveRequests = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("shutdown_delay")) != null) {
            shutdown_delay = Integer.parseInt((String)v);
        }
        if ((v = hashtable.get("username")) != null) {
            adminID = (String)v;
        }
        if ((v = hashtable.get("password")) != null) {
            adminPW = (String)v;
        }
        if ((v = hashtable.get("address")) != null && (string = ((String)v).trim()).length() > 0 && !string.equals("*")) {
            address = string;
        }
        if (timeout < 1000 && timeout != -1) {
            timeout = 1000;
        }
        if (port == 0) {
            port = 8080;
        }
        if (connections < 5) {
            connections = 5;
        }
        if (maxConnections < connections) {
            maxConnections = connections;
        }
        if (backlog < 0) {
            backlog = 0;
        }
        if (keepAliveTimeout < 15 && keepAliveTimeout != -1) {
            keepAliveTimeout = 15;
        }
        keepAliveTimeoutMillis = keepAliveTimeout == -1 ? -1 : keepAliveTimeout * 1000;
        if (keepAliveRequests < 5 && keepAliveRequests != -1) {
            keepAliveRequests = 5;
        }
        if (shutdown_delay < 1 && shutdown_delay != -1) {
            shutdown_delay = 60;
        }
        if ((v = hashtable.get("preload_servlets")) != null && (string = DString.trim((String)v)).length() > 0) {
            preloadServlets = string;
        }
    }

    private static void loadSessionConfig() throws IOException, Exception {
        String string;
        sessionTimeout = 1800000L;
        sessionManagerInterval = 300000L;
        sessionSource = 2;
        sessionName = "iwsSessionID";
        sessionMaxAge = -1;
        sessionSecure = false;
        Hashtable hashtable = Utils.load("./config/session.ini", false);
        Object v = hashtable.get("timeout");
        if (v != null && (sessionTimeout = (long)Integer.parseInt((String)v)) != -1L) {
            sessionTimeout *= 60000L;
        }
        if ((v = hashtable.get("interval")) != null && (sessionManagerInterval = (long)Integer.parseInt((String)v)) != -1L) {
            sessionManagerInterval *= 60000L;
        }
        if ((v = hashtable.get("source")) != null) {
            sessionSource = ((String)v).equalsIgnoreCase("url") ? 1 : 2;
        }
        if ((v = hashtable.get("name")) != null && (string = (String)v).length() > 0) {
            sessionName = string;
        }
        if ((v = hashtable.get("comment")) != null && (string = (String)v).length() > 0) {
            sessionComment = string;
        }
        if ((v = hashtable.get("domain")) != null && (string = (String)v).length() > 0) {
            sessionDomain = string;
        }
        if ((v = hashtable.get("path")) != null && (string = (String)v).length() > 0) {
            sessionPath = string;
        }
        if ((v = hashtable.get("max_age")) != null) {
            sessionMaxAge = Integer.parseInt((String)v);
        }
        if (sessionTimeout < 1000L && sessionTimeout != -1L) {
            sessionTimeout = 60000L;
        }
        if (sessionManagerInterval < 60000L && sessionManagerInterval != -1L) {
            sessionManagerInterval = 60000L;
        }
        if ((v = hashtable.get("secure")) != null) {
            if (((String)v).equalsIgnoreCase("y")) {
                sessionSecure = true;
                return;
            }
            sessionSecure = false;
        }
    }

    public static void log(String string) {
        try {
            if (logger == null) {
                System.out.println(string);
                return;
            }
            logger.log(string);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return;
        }
    }

    public static void log(Throwable throwable) {
        iws.log(throwable, "");
    }

    public static void log(Throwable throwable, String string) {
        try {
            if (logger == null) {
                while (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                System.err.print(string);
                throwable.printStackTrace(System.err);
                return;
            }
            logger.log(throwable, string);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            try {
                args = stringArray;
                System.out.println(LOGO);
                iws._init();
                iws.run();
            }
            catch (Throwable throwable) {
                iws.log(throwable, "");
            }
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            iws.destroy();
            System.exit(returnCode);
            throw throwable;
        }
        iws.destroy();
        System.exit(returnCode);
    }

    private static void preload_servlets() {
        ServletContextImpl servletContextImpl = null;
        if (preloadServlets != null) {
            String string;
            int n = 0;
            while ((string = DString.extract(preloadServlets, ",", n++)) != null) {
                string = string.trim();
                try {
                    servletContextImpl = servletManager.loadServlet(string);
                }
                catch (Exception exception) {
                    iws.log(exception, "Unable to load Servlet: " + string);
                }
                if (servletContextImpl != null) continue;
                iws.log("Servlet was not found: " + string);
            }
        }
    }

    public static void run() throws Exception {
        SocketException socketException = null;
        while (!shutdown) {
            Socket socket;
            try {
                socket = serverSocket.accept();
            }
            catch (SocketException socketException2) {
                socketException = socketException2;
                break;
            }
            if (shutdown) break;
            Vector vector = threads;
            synchronized (vector) {
                RequestHandler requestHandler;
                if (actualConnections - usedConnections == 0) {
                    if (actualConnections > maxConnections) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                        }
                        Object var4_5 = null;
                        continue;
                    }
                    ++actualConnections;
                    requestHandler = new RequestHandler();
                    requestHandler.setSocket(socket);
                    new Thread(threadGroup, requestHandler).start();
                } else {
                    Vector vector2 = threads;
                    synchronized (vector2) {
                        requestHandler = (RequestHandler)threads.elementAt(0);
                        threads.removeElementAt(0);
                    }
                    requestHandler.setSocket(socket);
                }
                ++usedConnections;
            }
        }
        if (!shutdown) {
            if (socketException != null) {
                throw socketException;
            }
            throw new Exception("Exit without shutdown.");
        }
    }

    public static void shutdown(int n) {
        shutdown = true;
        returnCode = n;
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                iws.log(exception2, "");
            }
            serverSocket = null;
        }
    }
}

