/*
 * @(#)PageCounterServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;

import stec.iws.Utils;
import stec.iws.iws;

public class PageCounterServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        try
        {
            _response.setContentType("text/html");

            ServletOutputStream out = _response.getOutputStream();

            out.println("<html>");
            out.println("<head><title>Page Counter</title></head>");
            out.println("<body>");
            out.println("<h1>Page Counter</h1>");
            out.println("This page was accessed " + pageCounter(_request) + " times.");
            out.println("<p>");
            out.println("[ <a href=\"./pagecounter.html\">refresh</a> ]");
            out.println("</body>");
            out.println("</html>");
            out.close();
        }
        catch(Exception ex)
        {
            throw new ServletException(ex.getMessage());
        }
    }
    
    private int pageCounter(HttpServletRequest _request) throws Exception
    {
        String url = _request.getServletPath();
        if(url == null)
        {
            url = _request.getPathTranslated();
        }

        url = Utils.encodeURL(url);

        Properties props = new Properties();

        int pageCounter;
        
        File fh = new File(iws.getBaseDirectory(), "./samples/servlets/page_counters");
        if(fh.exists())
        {
            FileInputStream is = new FileInputStream(fh);
            props.load(is);
            is.close();

            pageCounter = Integer.parseInt(props.getProperty(url, "0")) + 1;
        }    
        else
        {
            pageCounter = 1;
        }    

        props.put(url, String.valueOf(pageCounter));

        FileOutputStream os = new FileOutputStream(fh);
        props.save(os, "page counters");
        os.close();

        return pageCounter;
    }

    public String getServletInfo()
    {
        return "PageCounterServlet";
    }
}
