package org.phoenix.jtools.jlookup;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

import org.phoenix.datatypes.*;
import org.phoenix.jtools.util.*;
import org.phoenix.util.*;

public class jlookup extends JPanel implements Runnable {
	lookupTableModel model;

	jtextfield name;
	jtextfield server;
	JComboBox type;
	static String dnsServer = "156.46.133.10";

	JLabel status;
	public static void main(String args[]) {
		JFrame f = new JFrame("JLookup");
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent evt) {
				System.exit(0);
			}
		});
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		f.setBounds(0, 0, dim.width, dim.height);
		f.getContentPane().add(new jlookup());
		f.setVisible(true);
	}
	public jlookup() {
		name = new jtextfield("Name", 15);
		server = new jtextfield("Server", 15);
		// A read-only combo box
		String[] items = {"A", "NS", "CNAME", "SOA", "PTR", "HINFO", "MX", "AXFR"};
		type = new JComboBox(items);

		JButton lookup = new JButton("Lookup");
		lookup.addActionListener(new LookupActionListener());
		JButton clear = new JButton("Clear");
		clear.addActionListener(new ClearActionListener());
		
		JPanel bottom = new JPanel();
		bottom.setLayout(new FlowLayout());
		bottom.add(type);
		bottom.add(lookup);
		bottom.add(clear);

		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());
		p.add(name, "North");
		p.add(server, "Center");
		p.add(bottom, "South");

		model = new lookupTableModel();
		TableSorter sorter = new TableSorter(model);
		JTable table = new JTable(sorter);
		String vers = System.getProperty("java.version");
		sorterHeaderRenderer headerRenderer = new sorterHeaderRenderer(sorter);
		headerRenderer.setBackground(Color.lightGray);
		if (vers.compareTo("1.3") >= 0) {
			table.getTableHeader().setDefaultRenderer(headerRenderer);
		} else {
			TableColumnModel cm = table.getColumnModel();
			for (int i = 0; i < cm.getColumnCount(); i++) {
				TableColumn column = table.getColumnModel().getColumn(i);
				column.setHeaderRenderer(headerRenderer);
			}
		}
		sorter.addSorterListener(table);
		JScrollPane jsp = new JScrollPane(table);

		status = new JLabel();
		JPanel p2 = new JPanel();
		p2.add(status);

		setLayout(new BorderLayout());
		add(p, "North");
		add(jsp, "Center");
		add(p2, "South");
	}
	public void setDefaultDNS(String server) {
		dnsServer = server;
		if (server != null) {
			this.server.setText(server);
		}
	}
	class LookupActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			(new Thread((Runnable) jlookup.this)).start();
		}
	}
	class ClearActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			model.clear();
		}
	}
	/*static final char A = 0x0001; // A (address)
	static final char NS = 0x0001; // NS (nameserver)
	static final char CNAME = 0x0001; // CNAME (cononical name)
	static final char SOA = 0x0006; // SOA (start of authority)
	static final char PTR = 0x000c; // PTR (pointer or reverse dns lookup)
	static final char AXFR = 0x00FC; // AXFR (transfer an entire zone)
	static final char ALL = 0x00FF; // ALL (returns all domain records)*/
	public void run() {
		String name = this.name.getText();
		String server = this.server.getText();
		status.setText("Looking up " + name);
		try {
			dnsBean dns = new dnsBean();
			dns.setServer(server);
			dns.setName(name);
			dns.setType(dnsBean.A);
			String selected = (String) type.getSelectedItem();
			if (selected.equals("A")) {
				dns.setType(dnsBean.A);
			} else if (selected.equals("NS")) {
				dns.setType(dnsBean.NS);
			} else if (selected.equals("CNAME")) {
				dns.setType(dnsBean.CNAME);
			} else if (selected.equals("SOA")) {
				dns.setType(dnsBean.SOA);
			} else if (selected.equals("PTR")) {
				dns.setName(dns.reverse(name));
				dns.setType(dnsBean.PTR);
			} else if (selected.equals("HINFO")) {
				dns.setType(dnsBean.HINFO);
			} else if (selected.equals("MX")) {
				dns.setType(dnsBean.MX);
			} else if (selected.equals("AXFR")) {
				dns.setDataConnection(dnsBean.TCP);
				dns.setType(dnsBean.AXFR);
			}
			dns.send();
			if (!selected.equals("AXFR")) {
				dns.getReply();
			}
			Vector c1 = dns.getRNames();
			Vector c2 = dns.getTypes();
			Vector c3 = dns.getAnswers();

			if (c1.size() > 0) {
				for (int i = 0; i < c1.size(); i++) {
					model.add(new domain(c1.elementAt(i).toString()), c2.elementAt(i).toString(), c3.elementAt(i).toString());
				}
			} else {
				JOptionPane.showMessageDialog(this,
					"Nameserver returned 0 records",
					"Query Error",
					JOptionPane.ERROR_MESSAGE);
			}
			status.setText("Done");
		} catch (SocketException e) {
			status.setText(name + ": Error - " + e.toString() + "\n");
		} catch (UnknownHostException e) {
			JOptionPane.showMessageDialog(this,
				"Host is Unknown",
				"Query Error",
				JOptionPane.ERROR_MESSAGE);
			status.setText(name + ": Error - " + e.toString() + "\n");
		} catch (IOException e) {
			JOptionPane.showMessageDialog(this,
				"Nameserver returned an Error",
				"Query Error",
				JOptionPane.ERROR_MESSAGE);
			status.setText(name + ": Error - " + e.toString() + "\n");
		}
	}
}